/*
 * Decompiled with CFR 0.152.
 */
package javax.media.bean.playerbean;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.media.bean.playerbean.MediaPlayerRTPDialog;
import javax.media.bean.playerbean.MediaPlayerResource;

public class MediaPlayerMediaLocationEditor
extends Panel
implements PropertyEditor,
ActionListener,
ItemListener {
    PropertyChangeSupport support = new PropertyChangeSupport(this);
    String mediaLocationString;
    TextField mediaLocationTextField = new TextField(this.mediaLocationString, 60);
    private String browseString = "...";
    private Button browseB = new Button(this.browseString);
    private Choice protocolChooser = new Choice();
    private String httpString = MediaPlayerResource.getString("HTTP");
    private String httpsString = MediaPlayerResource.getString("HTTPS");
    private String fileString = MediaPlayerResource.getString("FILE");
    private String rtpString = MediaPlayerResource.getString("RTP");
    private String ftpString = MediaPlayerResource.getString("FTP");
    private String codeString = MediaPlayerResource.getString("CODEBASE");
    private String chooseOneString = MediaPlayerResource.getString("CHOOSE_ONE");
    private boolean isFile = false;
    Panel editPanel = new Panel();

    public MediaPlayerMediaLocationEditor() {
        this.setLayout(new BorderLayout());
        this.editPanel.setLayout(new BorderLayout());
        this.editPanel.add("Center", this.mediaLocationTextField);
        this.editPanel.add("East", this.browseB);
        this.browseB.addActionListener(this);
        this.browseB.setEnabled(false);
        this.protocolChooser.add(this.chooseOneString);
        this.protocolChooser.add(this.fileString);
        this.protocolChooser.add(this.httpString);
        this.protocolChooser.add(this.httpsString);
        this.protocolChooser.add(this.rtpString);
        this.protocolChooser.add(this.ftpString);
        this.protocolChooser.add(this.codeString);
        this.protocolChooser.addItemListener(this);
        this.editPanel.add("West", this.protocolChooser);
        this.add("Center", this.editPanel);
        KeyAdapter l = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                MediaPlayerMediaLocationEditor.this.mediaLocationString = MediaPlayerMediaLocationEditor.this.mediaLocationTextField.getText();
            }
        };
        this.mediaLocationTextField.addKeyListener(l);
        this.mediaLocationTextField.setEnabled(false);
    }

    public String getJavaInitializationString() {
        String initString = this.mediaLocationString.length() == 0 ? "new java.lang.String(\"\\\")" : "new java.lang.String(\"" + this.mediaLocationString + "\")";
        return initString;
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 100);
    }

    public void setValue(Object o) {
        this.setAsText(o.toString());
    }

    public Object getValue() {
        return this.getAsText();
    }

    public void setAsText(String s) {
        this.mediaLocationString = s;
    }

    public String getAsText() {
        return this.mediaLocationString;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics g, Rectangle area) {
        Color c = g.getColor();
        g.setColor(Color.black);
        g.drawString(this.mediaLocationString, area.x, area.y + area.height - 6);
        g.setColor(c);
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return this.editPanel;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.equals(this.browseString)) {
            if (this.isFile) {
                FileDialog fd = new FileDialog(this.getFrame(this.editPanel), MediaPlayerResource.getString("SET_MEDIA_LOCATION"), 0);
                fd.setDirectory("c:\\");
                fd.setTitle(MediaPlayerResource.getString("SET_MEDIA_LOCATION"));
                fd.show();
                String filename = fd.getFile();
                if (filename != null && fd.getDirectory() != null) {
                    filename = fd.getDirectory() + filename;
                }
                if (filename != null) {
                    filename = filename.replace('\\', '/');
                    String tmp = "file:///" + filename;
                    this.mediaLocationTextField.setText(tmp);
                    this.setAsText(tmp);
                }
            } else {
                MediaPlayerRTPDialog rtpDlg = new MediaPlayerRTPDialog(this.getFrame(this.editPanel));
                rtpDlg.show();
                String filename = rtpDlg.getRTPAdr();
                if (filename != null) {
                    String tmp = "rtp://" + filename;
                    this.mediaLocationTextField.setText(tmp);
                    this.setAsText(tmp);
                }
            }
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        String item = (String)evt.getItem();
        if (!item.equals(this.chooseOneString)) {
            this.mediaLocationTextField.setEnabled(true);
            if (item.equals(this.fileString)) {
                this.browseB.setEnabled(true);
                this.isFile = true;
            } else if (item.equals(this.rtpString)) {
                this.browseB.setEnabled(true);
            } else {
                this.browseB.setEnabled(false);
            }
            if (!item.equals(this.codeString)) {
                this.mediaLocationTextField.setText(item);
            } else {
                this.mediaLocationTextField.setText("");
            }
            this.mediaLocationString = this.mediaLocationTextField.getText();
        } else {
            this.mediaLocationTextField.setEnabled(false);
            this.browseB.setEnabled(false);
        }
    }

    Frame getFrame(Component comp) {
        Point p = comp.getLocationOnScreen();
        Frame f = new Frame();
        f.setLocation(p);
        return f;
    }
}

