/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.plugin.PlugInExecuter;
import ij.plugin.frame.Editor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.OutputStream;
import sun.tools.javac.Main;

public class Compiler
implements PlugIn,
FilenameFilter {
    private static Main javac;
    private static ByteArrayOutputStream output;
    private static String dir;
    private static String name;
    private static Editor errors;

    public void run(String arg) {
        IJ.register(Compiler.class);
        if (arg.equals("edit")) {
            this.edit();
        } else {
            this.compileAndRun(arg);
        }
    }

    void edit() {
        Editor ed;
        if (this.open("", "Open macro or plugin") && (ed = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "")) != null) {
            ed.open(dir, name);
        }
    }

    void compileAndRun(String path) {
        if (!this.isJavac()) {
            return;
        }
        if (!this.open(path, "Compile and Run Plugin...")) {
            return;
        }
        if (this.compile(dir + name)) {
            this.runPlugin(name);
        }
    }

    boolean isJavac() {
        try {
            if (javac == null) {
                output = new ByteArrayOutputStream(4096);
                javac = new Main((OutputStream)output, "javac");
            }
        }
        catch (NoClassDefFoundError e) {
            IJ.error("This JVM does not include the javac compiler. Javac is\nincluded with the Windows, OS X and Linux versions of\nImageJ. Mac OS 9 users must install Apple's Java SDK.");
            return false;
        }
        return true;
    }

    boolean compile(String path) {
        boolean errors;
        IJ.showStatus("compiling: " + path);
        String classpath = System.getProperty("java.class.path");
        output.reset();
        boolean compiled = javac.compile(new String[]{"-deprecation", "-classpath", classpath, path});
        String s = output.toString();
        boolean bl = errors = !compiled || this.areErrors(s);
        if (errors) {
            this.showErrors(s);
        } else {
            IJ.showStatus("done");
        }
        return compiled;
    }

    boolean areErrors(String s) {
        boolean errors;
        boolean bl = errors = s != null && s.length() > 0;
        if (errors && s.startsWith("Note: sun.tools.javac") && s.indexOf("error") == -1) {
            errors = false;
        }
        return errors;
    }

    void showErrors(String s) {
        if (errors == null || !errors.isVisible()) {
            errors = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
        }
        if (errors != null) {
            errors.display("Errors", s);
        }
        IJ.showStatus("done (errors)");
    }

    boolean open(String path, String msg) {
        boolean okay;
        String fileName;
        String directory;
        if (path.equals("")) {
            if (dir == null) {
                dir = Menus.getPlugInsPath();
            }
            OpenDialog od = new OpenDialog(msg, dir, name);
            directory = od.getDirectory();
            fileName = od.getFileName();
            boolean bl = okay = fileName != null;
            if (okay && !fileName.endsWith(".java") && !fileName.endsWith(".txt")) {
                IJ.error("File name must end with \".java\", or \".txt\".");
                okay = false;
            }
        } else {
            int i = path.lastIndexOf(47);
            if (i == -1) {
                i = path.lastIndexOf(92);
            }
            if (i > 0) {
                directory = path.substring(0, i + 1);
                fileName = path.substring(i + 1);
            } else {
                directory = "";
                fileName = path;
            }
            okay = true;
        }
        if (okay) {
            name = fileName;
            dir = directory;
        }
        return okay;
    }

    public boolean accept(File dir, String name) {
        return name.endsWith(".java") || name.endsWith(".macro") || name.endsWith(".txt");
    }

    void runPlugin(String name) {
        name = name.substring(0, name.length() - 5);
        new PlugInExecuter(name);
    }
}

