/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.HistogramWindow;
import ij.gui.Line;
import ij.plugin.JpegWriter;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.process.FloatBlitter;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;

public class Options
implements PlugIn {
    public void run(String arg) {
        IJ.register(Options.class);
        if (arg.equals("misc")) {
            Float f;
            GenericDialog gd = new GenericDialog(IJ.getPluginBundle().getString("OptMiscTitle"), IJ.getInstance());
            gd.addNumericField(IJ.getPluginBundle().getString("OptHistBin"), HistogramWindow.nBins, 0);
            gd.addStringField(IJ.getPluginBundle().getString("OptDivZero"), "" + FloatBlitter.divideByZeroValue, 10);
            gd.addCheckbox(IJ.getPluginBundle().getString("OptCursor"), Prefs.usePointerCursor);
            gd.addCheckbox(IJ.getPluginBundle().getString("OptScale"), ImageConverter.getDoScaling());
            gd.addCheckbox(IJ.getPluginBundle().getString("OptStackDiag"), IJ.hideProcessStackDialog);
            gd.addCheckbox(IJ.getPluginBundle().getString("OptAntialias"), Prefs.antialiasedText);
            gd.addCheckbox(IJ.getPluginBundle().getString("OptInterpolate"), Prefs.interpolateScaledImages);
            gd.addCheckbox(IJ.getPluginBundle().getString("OptOpen"), Prefs.open100Percent);
            gd.addCheckbox(IJ.getPluginBundle().getString("OptDebug"), IJ.debugMode);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            int nBins = (int)gd.getNextNumber();
            if (nBins >= 2 && nBins <= 1000) {
                HistogramWindow.nBins = nBins;
            }
            String divValue = gd.getNextString();
            try {
                f = new Float(divValue);
            }
            catch (NumberFormatException e) {
                f = null;
            }
            if (f != null) {
                FloatBlitter.divideByZeroValue = f.floatValue();
            }
            Prefs.usePointerCursor = gd.getNextBoolean();
            ImageConverter.setDoScaling(gd.getNextBoolean());
            IJ.hideProcessStackDialog = gd.getNextBoolean();
            Prefs.antialiasedText = gd.getNextBoolean();
            boolean interpolate = gd.getNextBoolean();
            Prefs.open100Percent = gd.getNextBoolean();
            IJ.debugMode = gd.getNextBoolean();
            if (interpolate != Prefs.interpolateScaledImages) {
                Prefs.interpolateScaledImages = interpolate;
                ImagePlus imp = WindowManager.getCurrentImage();
                if (imp != null) {
                    imp.draw();
                }
            }
            return;
        }
        if (arg.equals("width")) {
            int width = (int)IJ.getNumber(IJ.getPluginBundle().getString("OptLine"), Line.getWidth());
            if (width == Integer.MIN_VALUE) {
                return;
            }
            Line.setWidth(width);
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp != null && imp.isProcessor()) {
                ImageProcessor ip = imp.getProcessor();
                ip.setLineWidth(Line.getWidth());
            }
            return;
        }
        if (arg.equals("quality")) {
            int quality = (int)IJ.getNumber(IJ.getPluginBundle().getString("OptJpeg"), JpegWriter.getQuality());
            if (quality == Integer.MIN_VALUE) {
                return;
            }
            JpegWriter.setQuality(quality);
            return;
        }
        if (arg.equals("calc")) {
            Float f;
            String value = IJ.getString("Real Divide by Zero Value:", "" + FloatBlitter.divideByZeroValue);
            if (value.equals("")) {
                return;
            }
            try {
                f = new Float(value);
            }
            catch (NumberFormatException e) {
                f = null;
            }
            if (f != null) {
                FloatBlitter.divideByZeroValue = f.floatValue();
            }
            return;
        }
        if (arg.equals("cross")) {
            int width = (int)IJ.getNumber(IJ.getPluginBundle().getString("OptMark"), Analyzer.markWidth);
            if (width == Integer.MIN_VALUE) {
                return;
            }
            Analyzer.markWidth = width;
            return;
        }
    }
}

