/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.LookUpTable;
import ij.WindowManager;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

class ColorTable
extends Canvas {
    private Image img;
    LookUpTable lut;
    long min = -1L;
    long max = -1L;
    long orgmin;
    long orgmax;
    long newmax;
    long newmin;
    double slope;
    long factor;
    double bval;
    boolean magdisp = false;

    public ColorTable() {
        this.setSize(258, 66);
        this.min = 0L;
        this.max = 255L;
    }

    public void paint(Graphics g) {
        int xend;
        double width;
        boolean isGray;
        int isg;
        this.min = this.newmin;
        this.max = this.newmax;
        this.img = this.createImage(256, 64);
        Graphics gr = this.img.getGraphics();
        double step = (double)(this.max - this.min) / 64.0;
        try {
            isg = WindowManager.getCurrentImage().getType();
        }
        catch (Exception ex) {
            return;
        }
        boolean bl = isGray = this.lut.isGrayscale() && isg != 3 && isg != 4;
        if (this.min == this.max) {
            width = 256.0;
            this.slope = 9.223372036854776E18;
        } else {
            width = 4.0;
            this.slope = (double)(this.orgmax - this.orgmin) / (double)(this.max - this.min);
        }
        float org = (float)(this.min - this.orgmin) / (float)(this.orgmax - this.orgmin);
        int xorg = (int)(org * 256.0f);
        if (this.magdisp) {
            xorg = 0;
            this.slope = 1.0;
        }
        gr.setColor(Color.white);
        gr.fillRect(0, 0, 256, 64);
        int mapSize = this.lut.getMapSize();
        ColorModel cm = this.lut.getColorModel();
        IndexColorModel m = (IndexColorModel)cm;
        mapSize = m.getMapSize();
        byte[] reds = new byte[mapSize];
        byte[] greens = new byte[mapSize];
        byte[] blues = new byte[mapSize];
        m.getReds(reds);
        m.getGreens(greens);
        m.getBlues(blues);
        int n = xend = this.slope != 9.223372036854776E18 ? (int)(256.0 / this.slope) + xorg : Integer.MAX_VALUE;
        if (xend != Integer.MAX_VALUE) {
            for (int i = xorg; i < xend; i += (int)width) {
                int j = (int)((double)((i - xorg) * mapSize) / (double)(xend - xorg));
                gr.setColor(new Color(reds[j] & 0xFF, greens[j] & 0xFF, blues[j] & 0xFF));
                gr.fillRect(i, 0, (int)width, 64);
            }
        } else {
            gr.setColor(new Color(reds[mapSize - 1] & 0xFF, greens[mapSize - 1] & 0xFF, blues[mapSize - 1] & 0xFF));
            gr.fillRect(0, 0, 256, 64);
        }
        if (xorg > 0) {
            gr.setColor(new Color(reds[0] & 0xFF, greens[0] & 0xFF, blues[0] & 0xFF));
            gr.fillRect(0, 0, xorg, 64);
        }
        if (xend < 256) {
            gr.setColor(new Color(reds[mapSize - 1] & 0xFF, greens[mapSize - 1] & 0xFF, blues[mapSize - 1] & 0xFF));
            gr.fillRect(xend, 0, 256 - xend, 64);
        }
        g.drawImage(this.img, 0, 0, this);
    }

    public void update(Graphics g) {
        if (this.min == this.newmin && this.max == this.newmax) {
            return;
        }
        this.paint(g);
    }
}

