/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;

public class PasteController
extends PlugInFrame
implements PlugIn,
ItemListener {
    private Panel panel;
    private Choice pasteMode;
    private static Frame instance;

    public PasteController() {
        super(IJ.getPluginBundle().getString("FrameTitle"));
        ResourceBundle blit = ResourceBundle.getBundle("ij/i18n/BlitterBundle", IJ.getLocale());
        if (instance != null) {
            instance.toFront();
            return;
        }
        WindowManager.addWindow(this);
        instance = this;
        IJ.register(PasteController.class);
        this.setLayout(new FlowLayout(1, 2, 5));
        this.add(new Label(IJ.getPluginBundle().getString("TransferMode")));
        this.pasteMode = new Choice();
        this.pasteMode.addItem(blit.getString("Copy"));
        this.pasteMode.addItem(blit.getString("Average"));
        this.pasteMode.addItem(blit.getString("Difference"));
        this.pasteMode.addItem(blit.getString("Transparent"));
        this.pasteMode.addItem(blit.getString("AND"));
        this.pasteMode.addItem(blit.getString("OR"));
        this.pasteMode.addItem(blit.getString("XOR"));
        this.pasteMode.addItem(blit.getString("Add"));
        this.pasteMode.addItem(blit.getString("Subtract"));
        this.pasteMode.addItem(blit.getString("Multiply"));
        this.pasteMode.addItem(blit.getString("Divide"));
        this.pasteMode.addItemListener(this);
        this.add(this.pasteMode);
        Roi.setPasteMode(0);
        this.pack();
        GUI.center(this);
        this.setResizable(false);
        this.show();
    }

    public void itemStateChanged(ItemEvent e) {
        int index = this.pasteMode.getSelectedIndex();
        int mode = 0;
        switch (index) {
            case 0: {
                mode = 0;
                break;
            }
            case 1: {
                mode = 7;
                break;
            }
            case 2: {
                mode = 8;
                break;
            }
            case 3: {
                mode = 2;
                break;
            }
            case 4: {
                mode = 9;
                break;
            }
            case 5: {
                mode = 10;
                break;
            }
            case 6: {
                mode = 11;
                break;
            }
            case 7: {
                mode = 3;
                break;
            }
            case 8: {
                mode = 4;
                break;
            }
            case 9: {
                mode = 5;
                break;
            }
            case 10: {
                mode = 6;
            }
        }
        Roi.setPasteMode(mode);
        if (Recorder.record) {
            Recorder.record("setPasteMode", this.pasteMode.getSelectedItem());
        }
        ImagePlus imp = WindowManager.getCurrentImage();
    }

    public void windowClosing(WindowEvent e) {
        this.close();
    }

    public void close() {
        super.close();
        instance = null;
    }
}

