/*
 * Decompiled with CFR 0.152.
 */
package ij.text;

import ij.IJ;
import ij.ImageJ;
import ij.WindowManager;
import ij.gui.EuHouToolbar;
import ij.gui.GUI;
import ij.io.OpenDialog;
import ij.plugin.filter.Analyzer;
import ij.text.TextPanel;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class TextWindow
extends Frame
implements ActionListener,
FocusListener {
    private TextPanel textPanel;
    private boolean modifListen = false;

    public TextWindow(String title, String data, int width, int height) {
        this(title, "", data, width, height);
    }

    public TextWindow(String title, String headings, String data, int width, int height) {
        super(title);
        Image img;
        ImageJ ij;
        this.enableEvents(80L);
        this.textPanel = new TextPanel(title);
        this.textPanel.setTitle(title);
        this.add("Center", this.textPanel);
        this.textPanel.setColumnHeadings(headings);
        if (data != null) {
            this.textPanel.append(data);
        }
        if ((ij = IJ.getInstance()) != null && (img = ij.getIconImage()) != null) {
            this.setIconImage(img);
        }
        this.addFocusListener(this);
        this.addMenuBar();
        WindowManager.addWindow(this);
        this.setSize(width, height);
        GUI.center(this);
        this.show();
    }

    public TextWindow(String title, String headings, String data, int width, int height, boolean hint) {
        super(title);
        Image img;
        ImageJ ij;
        this.enableEvents(80L);
        this.textPanel = new TextPanel(title, hint);
        this.modifListen = true;
        this.textPanel.setTitle(title);
        this.add("Center", this.textPanel);
        this.textPanel.setColumnHeadings(headings);
        if (data != null) {
            this.textPanel.append(data);
        }
        if ((ij = IJ.getInstance()) != null && (img = ij.getIconImage()) != null) {
            this.setIconImage(img);
        }
        this.addFocusListener(this);
        this.addMenuBar();
        WindowManager.addWindow(this);
        this.setSize(width, height);
        GUI.center(this);
        this.show();
    }

    public TextWindow(String path, int width, int height) {
        super("");
        this.enableEvents(80L);
        this.textPanel = new TextPanel();
        this.add("Center", this.textPanel);
        if (this.openFile(path)) {
            WindowManager.addWindow(this);
            this.setSize(width, height);
            this.show();
        } else {
            this.dispose();
        }
    }

    void addMenuBar() {
        MenuBar mb = new MenuBar();
        Menu m = new Menu(IJ.getBundle().getString("File"));
        m.add(new MenuItem(IJ.getBundle().getString("SaveAs")));
        m.addActionListener(this);
        mb.add(m);
        m = new Menu(IJ.getBundle().getString("Edit"));
        m.add(new MenuItem(IJ.getBundle().getString("Cut")));
        m.add(new MenuItem(IJ.getBundle().getString("Copy")));
        m.add(new MenuItem(IJ.getBundle().getString("CopyAll")));
        m.add(new MenuItem(IJ.getBundle().getString("Clear")));
        m.add(new MenuItem(IJ.getBundle().getString("SelectAll")));
        if (this.getTitle().equals(IJ.getBundle().getString("Results"))) {
            m.addSeparator();
            m.add(new MenuItem(IJ.getBundle().getString("ClearResults")));
            m.add(new MenuItem(IJ.getBundle().getString("Summarize")));
            m.add(new MenuItem(IJ.getBundle().getString("SetMeasurements")));
        }
        m.addActionListener(this);
        mb.add(m);
        this.setMenuBar(mb);
    }

    public void append(String text) {
        this.textPanel.append(text);
    }

    public void setFont(Font font) {
        this.textPanel.setFont(font);
    }

    boolean openFile(String path) {
        OpenDialog od = new OpenDialog(IJ.getBundle().getString("OpenText"), path);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return false;
        }
        path = directory + name;
        IJ.showStatus(IJ.getBundle().getString("Opening") + " " + path);
        try {
            BufferedReader r = new BufferedReader(new FileReader(directory + name));
            this.load(r);
            r.close();
        }
        catch (Exception e) {
            IJ.error(e.getMessage());
            return true;
        }
        this.textPanel.setTitle(name);
        this.setTitle(name);
        IJ.showStatus("");
        return true;
    }

    public TextPanel getTextPanel() {
        return this.textPanel;
    }

    public void load(BufferedReader in) throws IOException {
        String s;
        boolean count = false;
        while ((s = in.readLine()) != null) {
            this.textPanel.appendLine(s);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        this.textPanel.doCommand(cmd);
    }

    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        int id = e.getID();
        if (id == 201) {
            if (this.modifListen) {
                EuHouToolbar.getInstance().photometerButtonAction();
            } else {
                this.close();
            }
        } else if (id == 205) {
            WindowManager.setWindow(this);
        }
    }

    public void close() {
        if (this.getTitle().equals(IJ.getBundle().getString("Results"))) {
            if (!Analyzer.resetCounter()) {
                return;
            }
            IJ.setTextPanel(null);
        }
        if (this.getTitle().equals("Log")) {
            IJ.debugMode = false;
            IJ.log("$Closed");
        }
        if (this.getTitle().equals(IJ.getBundle().getString("GetPosition"))) {
            IJ.setTextPanel(null);
        }
        this.setVisible(false);
        this.dispose();
        WindowManager.removeWindow(this);
        this.textPanel.flush();
    }

    public void focusGained(FocusEvent e) {
        WindowManager.setWindow(this);
    }

    public void focusLost(FocusEvent e) {
    }
}

