/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.bmp;

import com.sun.imageio.plugins.bmp.BMPConstants;
import com.sun.imageio.plugins.bmp.BMPMetadata;
import com.sun.imageio.plugins.common.I18N;
import com.sun.imageio.plugins.common.ImageUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class BMPImageReader
extends ImageReader
implements BMPConstants {
    private static final int VERSION_2_1_BIT = 0;
    private static final int VERSION_2_4_BIT = 1;
    private static final int VERSION_2_8_BIT = 2;
    private static final int VERSION_2_24_BIT = 3;
    private static final int VERSION_3_1_BIT = 4;
    private static final int VERSION_3_4_BIT = 5;
    private static final int VERSION_3_8_BIT = 6;
    private static final int VERSION_3_24_BIT = 7;
    private static final int VERSION_3_NT_16_BIT = 8;
    private static final int VERSION_3_NT_32_BIT = 9;
    private static final int VERSION_4_1_BIT = 10;
    private static final int VERSION_4_4_BIT = 11;
    private static final int VERSION_4_8_BIT = 12;
    private static final int VERSION_4_16_BIT = 13;
    private static final int VERSION_4_24_BIT = 14;
    private static final int VERSION_4_32_BIT = 15;
    private long bitmapFileSize;
    private long bitmapOffset;
    private long compression;
    private long imageSize;
    private byte[] palette;
    private int imageType;
    private int numBands;
    private boolean isBottomUp;
    private int bitsPerPixel;
    private int redMask;
    private int greenMask;
    private int blueMask;
    private int alphaMask;
    private SampleModel sampleModel;
    private SampleModel originalSampleModel;
    private ColorModel colorModel;
    private ColorModel originalColorModel;
    private ImageInputStream iis = null;
    private boolean gotHeader = false;
    private int width;
    private int height;
    private Rectangle destinationRegion;
    private Rectangle sourceRegion;
    private BMPMetadata metadata;
    private BufferedImage bi;
    private boolean noTransform = true;
    private boolean seleBand = false;
    private int scaleX;
    private int scaleY;
    private int[] sourceBands;
    private int[] destBands;

    public BMPImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public void setInput(Object object, boolean bl2, boolean bl3) {
        super.setInput(object, bl2, bl3);
        this.iis = (ImageInputStream)object;
        if (this.iis != null) {
            this.iis.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        }
        this.resetHeaderInfo();
    }

    public int getNumImages(boolean bl2) throws IOException {
        if (this.iis == null) {
            throw new IllegalStateException(I18N.getString("GetNumImages0"));
        }
        if (this.seekForwardOnly && bl2) {
            throw new IllegalStateException(I18N.getString("GetNumImages1"));
        }
        return 1;
    }

    public int getWidth(int n2) throws IOException {
        this.checkIndex(n2);
        this.readHeader();
        return this.width;
    }

    public int getHeight(int n2) throws IOException {
        this.checkIndex(n2);
        this.readHeader();
        return this.height;
    }

    private void checkIndex(int n2) {
        if (n2 != 0) {
            throw new IndexOutOfBoundsException(I18N.getString("BMPImageReader0"));
        }
    }

    public void readHeader() throws IOException {
        if (this.gotHeader) {
            return;
        }
        if (this.iis == null) {
            throw new IllegalStateException("Input source not set!");
        }
        int n2 = 0;
        int n3 = 0;
        this.metadata = new BMPMetadata();
        this.iis.mark();
        byte[] byArray = new byte[2];
        this.iis.read(byArray);
        if (byArray[0] != 66 || byArray[1] != 77) {
            throw new IllegalArgumentException(I18N.getString("BMPImageReader1"));
        }
        this.bitmapFileSize = this.iis.readUnsignedInt();
        this.iis.skipBytes(4);
        this.bitmapOffset = this.iis.readUnsignedInt();
        long l2 = this.iis.readUnsignedInt();
        if (l2 == 12L) {
            this.width = this.iis.readShort();
            this.height = this.iis.readShort();
        } else {
            this.width = this.iis.readInt();
            this.height = this.iis.readInt();
        }
        this.metadata.width = this.width;
        this.metadata.height = this.height;
        int n4 = this.iis.readUnsignedShort();
        this.bitsPerPixel = this.iis.readUnsignedShort();
        this.metadata.bitsPerPixel = (short)this.bitsPerPixel;
        this.numBands = 3;
        if (l2 == 12L) {
            this.metadata.bmpVersion = "BMP v. 2.x";
            if (this.bitsPerPixel == 1) {
                this.imageType = 0;
            } else if (this.bitsPerPixel == 4) {
                this.imageType = 1;
            } else if (this.bitsPerPixel == 8) {
                this.imageType = 2;
            } else if (this.bitsPerPixel == 24) {
                this.imageType = 3;
            }
            int n5 = (int)((this.bitmapOffset - 14L - l2) / 3L);
            int n6 = n5 * 3;
            this.palette = new byte[n6];
            this.iis.readFully(this.palette, 0, n6);
            this.metadata.palette = this.palette;
            this.metadata.paletteSize = n5;
        } else {
            this.compression = this.iis.readUnsignedInt();
            this.imageSize = this.iis.readUnsignedInt();
            long l3 = this.iis.readInt();
            long l4 = this.iis.readInt();
            long l5 = this.iis.readUnsignedInt();
            long l6 = this.iis.readUnsignedInt();
            this.metadata.compression = (int)this.compression;
            this.metadata.xPixelsPerMeter = (int)l3;
            this.metadata.yPixelsPerMeter = (int)l4;
            this.metadata.colorsUsed = (int)l5;
            this.metadata.colorsImportant = (int)l6;
            if (l2 == 40L) {
                switch ((int)this.compression) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        int n7 = (int)((this.bitmapOffset - 14L - l2) / 4L);
                        int n8 = n7 * 4;
                        this.palette = new byte[n8];
                        this.iis.readFully(this.palette, 0, n8);
                        this.metadata.palette = this.palette;
                        this.metadata.paletteSize = n7;
                        if (this.bitsPerPixel == 1) {
                            this.imageType = 4;
                        } else if (this.bitsPerPixel == 4) {
                            this.imageType = 5;
                        } else if (this.bitsPerPixel == 8) {
                            this.imageType = 6;
                        } else if (this.bitsPerPixel == 24) {
                            this.imageType = 7;
                        } else if (this.bitsPerPixel == 16) {
                            this.imageType = 8;
                            this.redMask = 31744;
                            this.greenMask = 992;
                            this.blueMask = 31;
                            this.metadata.redMask = this.redMask;
                            this.metadata.greenMask = this.greenMask;
                            this.metadata.blueMask = this.blueMask;
                        } else if (this.bitsPerPixel == 32) {
                            this.imageType = 9;
                            this.redMask = 0xFF0000;
                            this.greenMask = 65280;
                            this.blueMask = 255;
                            this.metadata.redMask = this.redMask;
                            this.metadata.greenMask = this.greenMask;
                            this.metadata.blueMask = this.blueMask;
                        }
                        this.metadata.bmpVersion = "BMP v. 3.x";
                        break;
                    }
                    case 3: {
                        int n8;
                        if (this.bitsPerPixel == 16) {
                            this.imageType = 8;
                        } else if (this.bitsPerPixel == 32) {
                            this.imageType = 9;
                        }
                        this.redMask = (int)this.iis.readUnsignedInt();
                        this.greenMask = (int)this.iis.readUnsignedInt();
                        this.blueMask = (int)this.iis.readUnsignedInt();
                        this.metadata.redMask = this.redMask;
                        this.metadata.greenMask = this.greenMask;
                        this.metadata.blueMask = this.blueMask;
                        if (l5 != 0L) {
                            n8 = (int)l5 * 4;
                            this.palette = new byte[n8];
                            this.iis.readFully(this.palette, 0, n8);
                            this.metadata.palette = this.palette;
                            this.metadata.paletteSize = (int)l5;
                        }
                        this.metadata.bmpVersion = "BMP v. 3.x NT";
                        break;
                    }
                    default: {
                        throw new RuntimeException(I18N.getString("BMPImageReader2"));
                    }
                }
            } else if (l2 == 108L || l2 == 124L) {
                if (l2 == 108L) {
                    this.metadata.bmpVersion = "BMP v. 4.x";
                } else if (l2 == 124L) {
                    this.metadata.bmpVersion = "BMP v. 5.x";
                }
                this.redMask = (int)this.iis.readUnsignedInt();
                this.greenMask = (int)this.iis.readUnsignedInt();
                this.blueMask = (int)this.iis.readUnsignedInt();
                this.alphaMask = (int)this.iis.readUnsignedInt();
                long l7 = this.iis.readUnsignedInt();
                int n9 = this.iis.readInt();
                int n10 = this.iis.readInt();
                int n11 = this.iis.readInt();
                int n12 = this.iis.readInt();
                int n13 = this.iis.readInt();
                int n14 = this.iis.readInt();
                int n15 = this.iis.readInt();
                int n16 = this.iis.readInt();
                int n17 = this.iis.readInt();
                long l8 = this.iis.readUnsignedInt();
                long l9 = this.iis.readUnsignedInt();
                long l10 = this.iis.readUnsignedInt();
                if (l2 == 124L) {
                    this.metadata.intent = this.iis.readInt();
                    n2 = this.iis.readInt();
                    n3 = this.iis.readInt();
                    this.iis.skipBytes(4);
                }
                this.metadata.colorSpace = (int)l7;
                if (l7 == 0L) {
                    this.metadata.redX = n9;
                    this.metadata.redY = n10;
                    this.metadata.redZ = n11;
                    this.metadata.greenX = n12;
                    this.metadata.greenY = n13;
                    this.metadata.greenZ = n14;
                    this.metadata.blueX = n15;
                    this.metadata.blueY = n16;
                    this.metadata.blueZ = n17;
                    this.metadata.gammaRed = (int)l8;
                    this.metadata.gammaGreen = (int)l9;
                    this.metadata.gammaBlue = (int)l10;
                }
                int n18 = (int)((this.bitmapOffset - 14L - l2) / 4L);
                int n19 = n18 * 4;
                this.palette = new byte[n19];
                this.iis.readFully(this.palette, 0, n19);
                this.metadata.palette = this.palette;
                this.metadata.paletteSize = n18;
                if (this.bitsPerPixel == 1) {
                    this.imageType = 10;
                } else if (this.bitsPerPixel == 4) {
                    this.imageType = 11;
                } else if (this.bitsPerPixel == 8) {
                    this.imageType = 12;
                } else if (this.bitsPerPixel == 16) {
                    this.imageType = 13;
                    if ((int)this.compression == 0) {
                        this.redMask = 31744;
                        this.greenMask = 992;
                        this.blueMask = 31;
                    }
                } else if (this.bitsPerPixel == 24) {
                    this.imageType = 14;
                } else if (this.bitsPerPixel == 32) {
                    this.imageType = 15;
                    if ((int)this.compression == 0) {
                        this.redMask = 0xFF0000;
                        this.greenMask = 65280;
                        this.blueMask = 255;
                    }
                }
                this.metadata.redMask = this.redMask;
                this.metadata.greenMask = this.greenMask;
                this.metadata.blueMask = this.blueMask;
                this.metadata.alphaMask = this.alphaMask;
            } else {
                throw new RuntimeException(I18N.getString("BMPImageReader3"));
            }
        }
        if (this.height > 0) {
            this.isBottomUp = true;
        } else {
            this.isBottomUp = false;
            this.height = Math.abs(this.height);
        }
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        if (this.metadata.colorSpace == 3 || this.metadata.colorSpace == 4) {
            this.iis.mark();
            this.iis.skipBytes((long)n2 - l2);
            byte[] byArray2 = new byte[n3];
            this.iis.readFully(byArray2, 0, n3);
            this.iis.reset();
            try {
                colorSpace = this.metadata.colorSpace == 3 ? new ICC_ColorSpace(ICC_Profile.getInstance(new String(byArray2))) : new ICC_ColorSpace(ICC_Profile.getInstance(byArray2));
            }
            catch (Exception exception) {
                colorSpace = ColorSpace.getInstance(1000);
            }
        }
        if (this.bitsPerPixel == 1 || this.bitsPerPixel == 4 || this.bitsPerPixel == 8) {
            byte[] byArray3;
            byte[] byArray4;
            byte[] byArray5;
            this.numBands = 1;
            if (this.bitsPerPixel == 8) {
                int[] nArray = new int[this.numBands];
                for (int i2 = 0; i2 < this.numBands; ++i2) {
                    nArray[i2] = this.numBands - 1 - i2;
                }
                this.sampleModel = new PixelInterleavedSampleModel(0, this.width, this.height, this.numBands, this.numBands * this.width, nArray);
            } else {
                this.sampleModel = new MultiPixelPackedSampleModel(0, this.width, this.height, this.bitsPerPixel);
            }
            if (this.imageType == 0 || this.imageType == 1 || this.imageType == 2) {
                l2 = this.palette.length / 3;
                if (l2 > 256L) {
                    l2 = 256L;
                }
                byArray5 = new byte[(int)l2];
                byArray4 = new byte[(int)l2];
                byArray3 = new byte[(int)l2];
                for (int i3 = 0; i3 < (int)l2; ++i3) {
                    int n20 = 3 * i3;
                    byArray3[i3] = this.palette[n20];
                    byArray4[i3] = this.palette[n20 + 1];
                    byArray5[i3] = this.palette[n20 + 2];
                }
            } else {
                l2 = this.palette.length / 4;
                if (l2 > 256L) {
                    l2 = 256L;
                }
                byArray5 = new byte[(int)l2];
                byArray4 = new byte[(int)l2];
                byArray3 = new byte[(int)l2];
                int n21 = 0;
                while ((long)n21 < l2) {
                    int n22 = 4 * n21;
                    byArray3[n21] = this.palette[n22];
                    byArray4[n21] = this.palette[n22 + 1];
                    byArray5[n21] = this.palette[n22 + 2];
                    ++n21;
                }
            }
            this.colorModel = ImageUtil.isIndicesForGrayscale(byArray5, byArray4, byArray3) ? ImageUtil.createColorModel(null, this.sampleModel) : new IndexColorModel(this.bitsPerPixel, (int)l2, byArray5, byArray4, byArray3);
        } else if (this.bitsPerPixel == 16) {
            this.numBands = 3;
            this.sampleModel = new SinglePixelPackedSampleModel(1, this.width, this.height, new int[]{this.redMask, this.greenMask, this.blueMask});
            this.colorModel = new DirectColorModel(colorSpace, 16, this.redMask, this.greenMask, this.blueMask, 0, false, 1);
        } else if (this.bitsPerPixel == 32) {
            int[] nArray;
            int n23 = this.numBands = this.alphaMask == 0 ? 3 : 4;
            if (this.numBands == 3) {
                int[] nArray2 = new int[3];
                nArray2[0] = this.redMask;
                nArray2[1] = this.greenMask;
                nArray = nArray2;
                nArray2[2] = this.blueMask;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = this.redMask;
                nArray3[1] = this.greenMask;
                nArray3[2] = this.blueMask;
                nArray = nArray3;
                nArray3[3] = this.alphaMask;
            }
            int[] nArray4 = nArray;
            this.sampleModel = new SinglePixelPackedSampleModel(3, this.width, this.height, nArray4);
            this.colorModel = new DirectColorModel(colorSpace, 32, this.redMask, this.greenMask, this.blueMask, this.alphaMask, false, 3);
        } else {
            this.numBands = 3;
            int[] nArray = new int[this.numBands];
            for (int i4 = 0; i4 < this.numBands; ++i4) {
                nArray[i4] = this.numBands - 1 - i4;
            }
            this.sampleModel = new PixelInterleavedSampleModel(0, this.width, this.height, this.numBands, this.numBands * this.width, nArray);
            this.colorModel = ImageUtil.createColorModel(colorSpace, this.sampleModel);
        }
        this.originalSampleModel = this.sampleModel;
        this.originalColorModel = this.colorModel;
        this.iis.reset();
        this.iis.skipBytes(this.bitmapOffset);
        this.gotHeader = true;
    }

    public Iterator getImageTypes(int n2) throws IOException {
        this.checkIndex(n2);
        this.readHeader();
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        arrayList.add(new ImageTypeSpecifier(this.originalColorModel, this.originalSampleModel));
        return arrayList.iterator();
    }

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    public IIOMetadata getImageMetadata(int n2) throws IOException {
        this.checkIndex(n2);
        if (this.metadata == null) {
            this.readHeader();
        }
        return this.metadata;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public boolean isRandomAccessEasy(int n2) throws IOException {
        this.checkIndex(n2);
        this.readHeader();
        return this.metadata.compression == 0;
    }

    public BufferedImage read(int n2, ImageReadParam imageReadParam) throws IOException {
        if (this.iis == null) {
            throw new IllegalStateException(I18N.getString("BMPImageReader5"));
        }
        this.checkIndex(n2);
        this.clearAbortRequest();
        this.processImageStarted(n2);
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        this.readHeader();
        this.sourceRegion = new Rectangle(0, 0, 0, 0);
        this.destinationRegion = new Rectangle(0, 0, 0, 0);
        BMPImageReader.computeRegions(imageReadParam, this.width, this.height, imageReadParam.getDestination(), this.sourceRegion, this.destinationRegion);
        this.scaleX = imageReadParam.getSourceXSubsampling();
        this.scaleY = imageReadParam.getSourceYSubsampling();
        this.sourceBands = imageReadParam.getSourceBands();
        this.destBands = imageReadParam.getDestinationBands();
        this.seleBand = this.sourceBands != null && this.destBands != null;
        boolean bl2 = this.noTransform = this.destinationRegion.equals(new Rectangle(0, 0, this.width, this.height)) || this.seleBand;
        if (!this.seleBand) {
            this.sourceBands = new int[this.numBands];
            this.destBands = new int[this.numBands];
            for (int i2 = 0; i2 < this.numBands; ++i2) {
                this.destBands[i2] = this.sourceBands[i2] = i2;
            }
        }
        this.bi = imageReadParam.getDestination();
        WritableRaster writableRaster = null;
        if (this.bi == null) {
            this.sampleModel = this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height);
            if (this.seleBand) {
                this.sampleModel = this.sampleModel.createSubsetSampleModel(this.sourceBands);
            }
            writableRaster = Raster.createWritableRaster(this.sampleModel, new Point());
            this.bi = new BufferedImage(this.colorModel, writableRaster, false, null);
        } else {
            writableRaster = this.bi.getWritableTile(0, 0);
            this.sampleModel = this.bi.getSampleModel();
            this.colorModel = this.bi.getColorModel();
            this.noTransform &= this.destinationRegion.equals(writableRaster.getBounds());
        }
        byte[] byArray = null;
        short[] sArray = null;
        int[] nArray = null;
        if (this.sampleModel.getDataType() == 0) {
            byArray = ((DataBufferByte)writableRaster.getDataBuffer()).getData();
        } else if (this.sampleModel.getDataType() == 1) {
            sArray = ((DataBufferUShort)writableRaster.getDataBuffer()).getData();
        } else if (this.sampleModel.getDataType() == 3) {
            nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        }
        block0 : switch (this.imageType) {
            case 0: {
                this.read1Bit(byArray);
                break;
            }
            case 1: {
                this.read4Bit(byArray);
                break;
            }
            case 2: {
                this.read8Bit(byArray);
                break;
            }
            case 3: {
                this.read24Bit(byArray);
                break;
            }
            case 4: {
                this.read1Bit(byArray);
                break;
            }
            case 5: {
                switch ((int)this.compression) {
                    case 0: {
                        this.read4Bit(byArray);
                        break block0;
                    }
                    case 2: {
                        this.readRLE4(byArray);
                        break block0;
                    }
                    case 4: {
                        this.readEmbedded("JPEG", this.bi, imageReadParam);
                        break block0;
                    }
                    case 5: {
                        this.readEmbedded("PNG", this.bi, imageReadParam);
                        break block0;
                    }
                }
                throw new RuntimeException(I18N.getString("BMPImageReader1"));
            }
            case 6: {
                switch ((int)this.compression) {
                    case 0: {
                        this.read8Bit(byArray);
                        break block0;
                    }
                    case 1: {
                        this.readRLE8(byArray);
                        break block0;
                    }
                    case 4: {
                        this.readEmbedded("JPEG", this.bi, imageReadParam);
                        break block0;
                    }
                    case 5: {
                        this.readEmbedded("PNG", this.bi, imageReadParam);
                        break block0;
                    }
                }
                throw new RuntimeException(I18N.getString("BMPImageReader1"));
            }
            case 7: {
                this.read24Bit(byArray);
                break;
            }
            case 8: {
                this.read16Bit(sArray);
                break;
            }
            case 9: {
                switch ((int)this.compression) {
                    case 4: {
                        this.iis.seek(54L);
                        this.readEmbedded("JPEG", this.bi, imageReadParam);
                        break block0;
                    }
                    case 5: {
                        this.readEmbedded("PNG", this.bi, imageReadParam);
                        break block0;
                    }
                }
                this.read32Bit(nArray);
                break;
            }
            case 10: {
                this.read1Bit(byArray);
                break;
            }
            case 11: {
                switch ((int)this.compression) {
                    case 0: {
                        this.read4Bit(byArray);
                        break;
                    }
                    case 2: {
                        this.readRLE4(byArray);
                        break;
                    }
                    case 4: {
                        this.readEmbedded("JPEG", this.bi, imageReadParam);
                        break;
                    }
                    case 5: {
                        this.readEmbedded("PNG", this.bi, imageReadParam);
                        break;
                    }
                    default: {
                        throw new RuntimeException(I18N.getString("BMPImageReader1"));
                    }
                }
            }
            case 12: {
                switch ((int)this.compression) {
                    case 0: {
                        this.read8Bit(byArray);
                        break block0;
                    }
                    case 1: {
                        this.readRLE8(byArray);
                        break block0;
                    }
                    case 4: {
                        this.readEmbedded("JPEG", this.bi, imageReadParam);
                        break block0;
                    }
                    case 5: {
                        this.readEmbedded("PNG", this.bi, imageReadParam);
                        break block0;
                    }
                }
                throw new RuntimeException(I18N.getString("BMPImageReader1"));
            }
            case 13: {
                this.read16Bit(sArray);
                break;
            }
            case 14: {
                this.read24Bit(byArray);
                break;
            }
            case 15: {
                this.read32Bit(nArray);
            }
        }
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return this.bi;
    }

    public boolean canReadRaster() {
        return true;
    }

    public Raster readRaster(int n2, ImageReadParam imageReadParam) throws IOException {
        BufferedImage bufferedImage = this.read(n2, imageReadParam);
        return bufferedImage.getData();
    }

    private void resetHeaderInfo() {
        this.gotHeader = false;
        this.bi = null;
        this.originalSampleModel = null;
        this.sampleModel = null;
        this.originalColorModel = null;
        this.colorModel = null;
    }

    public void reset() {
        super.reset();
        this.iis = null;
        this.resetHeaderInfo();
    }

    private void read1Bit(byte[] byArray) throws IOException {
        int n2 = (this.width + 7) / 8;
        int n3 = n2 % 4;
        if (n3 != 0) {
            n3 = 4 - n3;
        }
        int n4 = n2 + n3;
        if (this.noTransform) {
            int n5 = this.isBottomUp ? (this.height - 1) * n2 : 0;
            for (int i2 = 0; i2 < this.height && !this.abortRequested(); ++i2) {
                this.iis.readFully(byArray, n5, n2);
                this.iis.skipBytes(n3);
                n5 += this.isBottomUp ? -n2 : n2;
                this.processImageUpdate(this.bi, 0, i2, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)i2 / (float)this.destinationRegion.height);
            }
        } else {
            int n6;
            byte[] byArray2 = new byte[n4];
            int n7 = ((MultiPixelPackedSampleModel)this.sampleModel).getScanlineStride();
            if (this.isBottomUp) {
                n6 = this.sourceRegion.y + (this.destinationRegion.height - 1) * this.scaleY;
                this.iis.skipBytes(n4 * (this.height - 1 - n6));
            } else {
                this.iis.skipBytes(n4 * this.sourceRegion.y);
            }
            n6 = n4 * (this.scaleY - 1);
            int[] nArray = new int[this.destinationRegion.width];
            int[] nArray2 = new int[this.destinationRegion.width];
            int[] nArray3 = new int[this.destinationRegion.width];
            int[] nArray4 = new int[this.destinationRegion.width];
            int n8 = this.destinationRegion.x;
            int n9 = this.sourceRegion.x;
            int n10 = 0;
            while (n8 < this.destinationRegion.x + this.destinationRegion.width) {
                nArray3[n10] = n9 >> 3;
                nArray[n10] = 7 - (n9 & 7);
                nArray4[n10] = n8 >> 3;
                nArray2[n10] = 7 - (n8 & 7);
                ++n8;
                ++n10;
                n9 += this.scaleX;
            }
            n8 = this.destinationRegion.y * n7;
            if (this.isBottomUp) {
                n8 += (this.destinationRegion.height - 1) * n7;
            }
            n9 = 0;
            n10 = this.sourceRegion.y;
            while (n9 < this.destinationRegion.height && !this.abortRequested()) {
                this.iis.read(byArray2, 0, n4);
                for (int i3 = 0; i3 < this.destinationRegion.width; ++i3) {
                    int n11 = byArray2[nArray3[i3]] >> nArray[i3] & 1;
                    int n12 = n8 + nArray4[i3];
                    byArray[n12] = (byte)(byArray[n12] | n11 << nArray2[i3]);
                }
                n8 += this.isBottomUp ? -n7 : n7;
                this.iis.skipBytes(n6);
                this.processImageUpdate(this.bi, 0, n9, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)n9 / (float)this.destinationRegion.height);
                ++n9;
                n10 += this.scaleY;
            }
        }
    }

    private void read4Bit(byte[] byArray) throws IOException {
        int n2 = (this.width + 1) / 2;
        int n3 = n2 % 4;
        if (n3 != 0) {
            n3 = 4 - n3;
        }
        int n4 = n2 + n3;
        if (this.noTransform) {
            int n5 = this.isBottomUp ? (this.height - 1) * n2 : 0;
            for (int i2 = 0; i2 < this.height && !this.abortRequested(); ++i2) {
                this.iis.readFully(byArray, n5, n2);
                this.iis.skipBytes(n3);
                n5 += this.isBottomUp ? -n2 : n2;
                this.processImageUpdate(this.bi, 0, i2, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)i2 / (float)this.destinationRegion.height);
            }
        } else {
            int n6;
            byte[] byArray2 = new byte[n4];
            int n7 = ((MultiPixelPackedSampleModel)this.sampleModel).getScanlineStride();
            if (this.isBottomUp) {
                n6 = this.sourceRegion.y + (this.destinationRegion.height - 1) * this.scaleY;
                this.iis.skipBytes(n4 * (this.height - 1 - n6));
            } else {
                this.iis.skipBytes(n4 * this.sourceRegion.y);
            }
            n6 = n4 * (this.scaleY - 1);
            int[] nArray = new int[this.destinationRegion.width];
            int[] nArray2 = new int[this.destinationRegion.width];
            int[] nArray3 = new int[this.destinationRegion.width];
            int[] nArray4 = new int[this.destinationRegion.width];
            int n8 = this.destinationRegion.x;
            int n9 = this.sourceRegion.x;
            int n10 = 0;
            while (n8 < this.destinationRegion.x + this.destinationRegion.width) {
                nArray3[n10] = n9 >> 1;
                nArray[n10] = 1 - (n9 & 1) << 2;
                nArray4[n10] = n8 >> 1;
                nArray2[n10] = 1 - (n8 & 1) << 2;
                ++n8;
                ++n10;
                n9 += this.scaleX;
            }
            n8 = this.destinationRegion.y * n7;
            if (this.isBottomUp) {
                n8 += (this.destinationRegion.height - 1) * n7;
            }
            n9 = 0;
            n10 = this.sourceRegion.y;
            while (n9 < this.destinationRegion.height && !this.abortRequested()) {
                this.iis.read(byArray2, 0, n4);
                for (int i3 = 0; i3 < this.destinationRegion.width; ++i3) {
                    int n11 = byArray2[nArray3[i3]] >> nArray[i3] & 0xF;
                    int n12 = n8 + nArray4[i3];
                    byArray[n12] = (byte)(byArray[n12] | n11 << nArray2[i3]);
                }
                n8 += this.isBottomUp ? -n7 : n7;
                this.iis.skipBytes(n6);
                this.processImageUpdate(this.bi, 0, n9, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)n9 / (float)this.destinationRegion.height);
                ++n9;
                n10 += this.scaleY;
            }
        }
    }

    private void read8Bit(byte[] byArray) throws IOException {
        int n2 = this.width % 4;
        if (n2 != 0) {
            n2 = 4 - n2;
        }
        int n3 = this.width + n2;
        if (this.noTransform) {
            int n4 = this.isBottomUp ? (this.height - 1) * this.width : 0;
            for (int i2 = 0; i2 < this.height && !this.abortRequested(); ++i2) {
                this.iis.readFully(byArray, n4, this.width);
                this.iis.skipBytes(n2);
                n4 += this.isBottomUp ? -this.width : this.width;
                this.processImageUpdate(this.bi, 0, i2, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)i2 / (float)this.destinationRegion.height);
            }
        } else {
            int n5;
            byte[] byArray2 = new byte[n3];
            int n6 = ((ComponentSampleModel)this.sampleModel).getScanlineStride();
            if (this.isBottomUp) {
                n5 = this.sourceRegion.y + (this.destinationRegion.height - 1) * this.scaleY;
                this.iis.skipBytes(n3 * (this.height - 1 - n5));
            } else {
                this.iis.skipBytes(n3 * this.sourceRegion.y);
            }
            n5 = n3 * (this.scaleY - 1);
            int n7 = this.destinationRegion.y * n6;
            if (this.isBottomUp) {
                n7 += (this.destinationRegion.height - 1) * n6;
            }
            n7 += this.destinationRegion.x;
            int n8 = 0;
            int n9 = this.sourceRegion.y;
            while (n8 < this.destinationRegion.height && !this.abortRequested()) {
                this.iis.read(byArray2, 0, n3);
                int n10 = 0;
                int n11 = this.sourceRegion.x;
                while (n10 < this.destinationRegion.width) {
                    byArray[n7 + n10] = byArray2[n11];
                    ++n10;
                    n11 += this.scaleX;
                }
                n7 += this.isBottomUp ? -n6 : n6;
                this.iis.skipBytes(n5);
                this.processImageUpdate(this.bi, 0, n8, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)n8 / (float)this.destinationRegion.height);
                ++n8;
                n9 += this.scaleY;
            }
        }
    }

    private void read24Bit(byte[] byArray) throws IOException {
        int n2 = this.width * 3 % 4;
        if (n2 != 0) {
            n2 = 4 - n2;
        }
        int n3 = this.width * 3;
        int n4 = n3 + n2;
        if (this.noTransform) {
            int n5 = this.isBottomUp ? (this.height - 1) * this.width * 3 : 0;
            for (int i2 = 0; i2 < this.height && !this.abortRequested(); ++i2) {
                this.iis.readFully(byArray, n5, n3);
                this.iis.skipBytes(n2);
                n5 += this.isBottomUp ? -n3 : n3;
                this.processImageUpdate(this.bi, 0, i2, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)i2 / (float)this.destinationRegion.height);
            }
        } else {
            int n6;
            byte[] byArray2 = new byte[n4];
            n3 = ((ComponentSampleModel)this.sampleModel).getScanlineStride();
            if (this.isBottomUp) {
                n6 = this.sourceRegion.y + (this.destinationRegion.height - 1) * this.scaleY;
                this.iis.skipBytes(n4 * (this.height - 1 - n6));
            } else {
                this.iis.skipBytes(n4 * this.sourceRegion.y);
            }
            n6 = n4 * (this.scaleY - 1);
            int n7 = this.destinationRegion.y * n3;
            if (this.isBottomUp) {
                n7 += (this.destinationRegion.height - 1) * n3;
            }
            n7 += this.destinationRegion.x * 3;
            int n8 = 0;
            int n9 = this.sourceRegion.y;
            while (n8 < this.destinationRegion.height && !this.abortRequested()) {
                this.iis.read(byArray2, 0, n4);
                int n10 = 0;
                int n11 = 3 * this.sourceRegion.x;
                while (n10 < this.destinationRegion.width) {
                    int n12 = 3 * n10 + n7;
                    for (int i3 = 0; i3 < this.destBands.length; ++i3) {
                        byArray[n12 + this.destBands[i3]] = byArray2[n11 + this.sourceBands[i3]];
                    }
                    ++n10;
                    n11 += 3 * this.scaleX;
                }
                n7 += this.isBottomUp ? -n3 : n3;
                this.iis.skipBytes(n6);
                this.processImageUpdate(this.bi, 0, n8, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)n8 / (float)this.destinationRegion.height);
                ++n8;
                n9 += this.scaleY;
            }
        }
    }

    private void read16Bit(short[] sArray) throws IOException {
        int n2 = this.width * 2 % 4;
        if (n2 != 0) {
            n2 = 4 - n2;
        }
        int n3 = this.width + n2 / 2;
        if (this.noTransform) {
            int n4 = this.isBottomUp ? (this.height - 1) * this.width : 0;
            for (int i2 = 0; i2 < this.height && !this.abortRequested(); ++i2) {
                this.iis.readFully(sArray, n4, this.width);
                this.iis.skipBytes(n2);
                n4 += this.isBottomUp ? -this.width : this.width;
                this.processImageUpdate(this.bi, 0, i2, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)i2 / (float)this.destinationRegion.height);
            }
        } else {
            int n5;
            short[] sArray2 = new short[n3];
            int n6 = ((SinglePixelPackedSampleModel)this.sampleModel).getScanlineStride();
            if (this.isBottomUp) {
                n5 = this.sourceRegion.y + (this.destinationRegion.height - 1) * this.scaleY;
                this.iis.skipBytes(n3 * (this.height - 1 - n5) << 1);
            } else {
                this.iis.skipBytes(n3 * this.sourceRegion.y << 1);
            }
            n5 = n3 * (this.scaleY - 1) << 1;
            int n7 = this.destinationRegion.y * n6;
            if (this.isBottomUp) {
                n7 += (this.destinationRegion.height - 1) * n6;
            }
            n7 += this.destinationRegion.x;
            int n8 = 0;
            int n9 = this.sourceRegion.y;
            while (n8 < this.destinationRegion.height && !this.abortRequested()) {
                this.iis.readFully(sArray2, 0, n3);
                int n10 = 0;
                int n11 = this.sourceRegion.x;
                while (n10 < this.destinationRegion.width) {
                    sArray[n7 + n10] = sArray2[n11];
                    ++n10;
                    n11 += this.scaleX;
                }
                n7 += this.isBottomUp ? -n6 : n6;
                this.iis.skipBytes(n5);
                this.processImageUpdate(this.bi, 0, n8, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)n8 / (float)this.destinationRegion.height);
                ++n8;
                n9 += this.scaleY;
            }
        }
    }

    private void read32Bit(int[] nArray) throws IOException {
        if (this.noTransform) {
            int n2 = this.isBottomUp ? (this.height - 1) * this.width : 0;
            for (int i2 = 0; i2 < this.height && !this.abortRequested(); ++i2) {
                this.iis.readFully(nArray, n2, this.width);
                n2 += this.isBottomUp ? -this.width : this.width;
                this.processImageUpdate(this.bi, 0, i2, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)i2 / (float)this.destinationRegion.height);
            }
        } else {
            int n3;
            int[] nArray2 = new int[this.width];
            int n4 = ((SinglePixelPackedSampleModel)this.sampleModel).getScanlineStride();
            if (this.isBottomUp) {
                n3 = this.sourceRegion.y + (this.destinationRegion.height - 1) * this.scaleY;
                this.iis.skipBytes(this.width * (this.height - 1 - n3) << 2);
            } else {
                this.iis.skipBytes(this.width * this.sourceRegion.y << 2);
            }
            n3 = this.width * (this.scaleY - 1) << 2;
            int n5 = this.destinationRegion.y * n4;
            if (this.isBottomUp) {
                n5 += (this.destinationRegion.height - 1) * n4;
            }
            n5 += this.destinationRegion.x;
            int n6 = 0;
            int n7 = this.sourceRegion.y;
            while (n6 < this.destinationRegion.height && !this.abortRequested()) {
                this.iis.readFully(nArray2, 0, this.width);
                int n8 = 0;
                int n9 = this.sourceRegion.x;
                while (n8 < this.destinationRegion.width) {
                    nArray[n5 + n8] = nArray2[n9];
                    ++n8;
                    n9 += this.scaleX;
                }
                n5 += this.isBottomUp ? -n4 : n4;
                this.iis.skipBytes(n3);
                this.processImageUpdate(this.bi, 0, n6, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)n6 / (float)this.destinationRegion.height);
                ++n6;
                n7 += this.scaleY;
            }
        }
    }

    private void readRLE8(byte[] byArray) throws IOException {
        int n2 = (int)this.imageSize;
        if (n2 == 0) {
            n2 = (int)(this.bitmapFileSize - this.bitmapOffset);
        }
        int n3 = 0;
        int n4 = this.width % 4;
        if (n4 != 0) {
            n3 = 4 - n4;
        }
        byte[] byArray2 = new byte[n2];
        boolean bl2 = false;
        this.iis.readFully(byArray2, 0, n2);
        this.decodeRLE8(n2, n3, byArray2, byArray);
    }

    private void decodeRLE8(int n2, int n3, byte[] byArray, byte[] byArray2) throws IOException {
        byte[] byArray3 = new byte[this.width * this.height];
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        int n6 = this.isBottomUp ? this.height - 1 : 0;
        int n7 = ((ComponentSampleModel)this.sampleModel).getScanlineStride();
        int n8 = 0;
        while (n4 != n2) {
            block17: {
                int n9;
                int n10;
                block16: {
                    if ((n10 = byArray[n4++] & 0xFF) != 0) break block16;
                    switch (byArray[n4++] & 0xFF) {
                        case 0: {
                            int n11;
                            int n12;
                            if (n6 >= this.sourceRegion.y && n6 < this.sourceRegion.y + this.sourceRegion.width) {
                                if (this.noTransform) {
                                    n9 = n6 * this.width;
                                    for (n12 = 0; n12 < this.width; ++n12) {
                                        byArray2[n9++] = byArray3[n12];
                                    }
                                    this.processImageUpdate(this.bi, 0, n6, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                                    ++n8;
                                } else if ((n6 - this.sourceRegion.y) % this.scaleY == 0) {
                                    n9 = (n6 - this.sourceRegion.y) / this.scaleY + this.destinationRegion.y;
                                    n12 = n9 * n7;
                                    n12 += this.destinationRegion.x;
                                    for (n11 = this.sourceRegion.x; n11 < this.sourceRegion.x + this.sourceRegion.width; n11 += this.scaleX) {
                                        byArray2[n12++] = byArray3[n11];
                                    }
                                    this.processImageUpdate(this.bi, 0, n9, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                                    ++n8;
                                }
                            }
                            this.processImageProgress(100.0f * (float)n8 / (float)this.destinationRegion.height);
                            n6 += this.isBottomUp ? -1 : 1;
                            n5 = 0;
                            if (this.abortRequested()) {
                                bl2 = true;
                                break;
                            }
                            break block17;
                        }
                        case 1: {
                            bl2 = true;
                            break;
                        }
                        case 2: {
                            n9 = byArray[n4++] & 0xFF;
                            int n12 = byArray[n4] & 0xFF;
                            n5 += n9 + n12 * this.width;
                            break;
                        }
                        default: {
                            int n11 = byArray[n4 - 1] & 0xFF;
                            for (int i2 = 0; i2 < n11; ++i2) {
                                byArray3[n5++] = (byte)(byArray[n4++] & 0xFF);
                            }
                            if ((n11 & 1) == 1) {
                                ++n4;
                                break;
                            }
                            break block17;
                        }
                    }
                    break block17;
                }
                for (n9 = 0; n9 < n10; ++n9) {
                    byArray3[n5++] = (byte)(byArray[n4] & 0xFF);
                }
                ++n4;
            }
            if (!bl2) continue;
            break;
        }
    }

    private void readRLE4(byte[] byArray) throws IOException {
        int n2 = (int)this.imageSize;
        if (n2 == 0) {
            n2 = (int)(this.bitmapFileSize - this.bitmapOffset);
        }
        int n3 = 0;
        int n4 = this.width % 4;
        if (n4 != 0) {
            n3 = 4 - n4;
        }
        byte[] byArray2 = new byte[n2];
        this.iis.readFully(byArray2, 0, n2);
        this.decodeRLE4(n2, n3, byArray2, byArray);
    }

    private void decodeRLE4(int n2, int n3, byte[] byArray, byte[] byArray2) throws IOException {
        byte[] byArray3 = new byte[this.width];
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        int n6 = this.isBottomUp ? this.height - 1 : 0;
        int n7 = ((MultiPixelPackedSampleModel)this.sampleModel).getScanlineStride();
        int n8 = 0;
        while (n4 != n2) {
            block20: {
                int n9;
                int n10;
                block19: {
                    if ((n10 = byArray[n4++] & 0xFF) != 0) break block19;
                    switch (byArray[n4++] & 0xFF) {
                        case 0: {
                            int n11;
                            int n12;
                            if (n6 >= this.sourceRegion.y && n6 < this.sourceRegion.y + this.sourceRegion.width) {
                                if (this.noTransform) {
                                    int n13 = n6 * (this.width + 1 >> 1);
                                    n12 = 0;
                                    for (n9 = 0; n9 < this.width >> 1; ++n9) {
                                        byArray2[n13++] = (byte)(byArray3[n12++] << 4 | byArray3[n12++]);
                                    }
                                    if ((this.width & 1) == 1) {
                                        int n14 = n13;
                                        byArray2[n14] = (byte)(byArray2[n14] | byArray3[this.width - 1] << 4);
                                    }
                                    this.processImageUpdate(this.bi, 0, n6, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                                    ++n8;
                                } else if ((n6 - this.sourceRegion.y) % this.scaleY == 0) {
                                    int n15 = (n6 - this.sourceRegion.y) / this.scaleY + this.destinationRegion.y;
                                    n9 = n15 * n7;
                                    n9 += this.destinationRegion.x >> 1;
                                    n12 = 1 - (this.destinationRegion.x & 1) << 2;
                                    for (n11 = this.sourceRegion.x; n11 < this.sourceRegion.x + this.sourceRegion.width; n11 += this.scaleX) {
                                        int n16 = n9++;
                                        byArray2[n16] = (byte)(byArray2[n16] | byArray3[n11] << n12);
                                        if ((n12 += 4) == 4) {
                                            // empty if block
                                        }
                                        n12 &= 7;
                                    }
                                    this.processImageUpdate(this.bi, 0, n15, this.destinationRegion.width, 1, 1, 1, new int[]{0});
                                    ++n8;
                                }
                            }
                            this.processImageProgress(100.0f * (float)n8 / (float)this.destinationRegion.height);
                            n6 += this.isBottomUp ? -1 : 1;
                            n5 = 0;
                            if (this.abortRequested()) {
                                bl2 = true;
                                break;
                            }
                            break block20;
                        }
                        case 1: {
                            bl2 = true;
                            break;
                        }
                        case 2: {
                            int n17 = byArray[n4++] & 0xFF;
                            n9 = byArray[n4] & 0xFF;
                            n5 += n17 + n9 * this.width;
                            break;
                        }
                        default: {
                            int n11;
                            int n12 = byArray[n4 - 1] & 0xFF;
                            for (n11 = 0; n11 < n12; ++n11) {
                                byArray3[n5++] = (byte)((n11 & 1) == 0 ? (byArray[n4] & 0xF0) >> 4 : byArray[n4++] & 0xF);
                            }
                            if ((n12 & 1) == 1) {
                                ++n4;
                            }
                            if (((int)Math.ceil(n12 / 2) & 1) == 1) {
                                ++n4;
                                break;
                            }
                            break block20;
                        }
                    }
                    break block20;
                }
                int[] nArray = new int[]{(byArray[n4] & 0xF0) >> 4, byArray[n4] & 0xF};
                for (n9 = 0; n9 < n10 && n5 < this.width; ++n9) {
                    byArray3[n5++] = (byte)nArray[n9 & 1];
                }
                ++n4;
            }
            if (!bl2) continue;
            break;
        }
    }

    private void readEmbedded(String string, BufferedImage bufferedImage, ImageReadParam imageReadParam) throws IOException {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
        ImageReader imageReader = null;
        if (iterator.hasNext()) {
            imageReader = iterator.next();
        }
        if (imageReader == null) {
            throw new RuntimeException(I18N.getString("BMPImageReader4") + " " + string);
        }
        byte[] byArray = new byte[(int)this.imageSize];
        this.iis.read(byArray);
        imageReader.setInput(ImageIO.createImageInputStream(new ByteArrayInputStream(byArray)));
        imageReader.addIIOReadProgressListener(new EmbeddedProgressAdapter(){

            public void imageProgress(ImageReader imageReader, float f2) {
                BMPImageReader.this.processImageProgress(f2);
            }
        });
        imageReader.addIIOReadUpdateListener(new IIOReadUpdateListener(){

            public void imageUpdate(ImageReader imageReader, BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
                BMPImageReader.this.processImageUpdate(bufferedImage, n2, n3, n4, n5, n6, n7, nArray);
            }

            public void passComplete(ImageReader imageReader, BufferedImage bufferedImage) {
                BMPImageReader.this.processPassComplete(bufferedImage);
            }

            public void passStarted(ImageReader imageReader, BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray) {
                BMPImageReader.this.processPassStarted(bufferedImage, n2, n3, n4, n5, n6, n7, n8, nArray);
            }

            public void thumbnailPassComplete(ImageReader imageReader, BufferedImage bufferedImage) {
            }

            public void thumbnailPassStarted(ImageReader imageReader, BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray) {
            }

            public void thumbnailUpdate(ImageReader imageReader, BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
            }
        });
        imageReader.addIIOReadWarningListener(new IIOReadWarningListener(){

            public void warningOccurred(ImageReader imageReader, String string) {
                BMPImageReader.this.processWarningOccurred(string);
            }
        });
        ImageReadParam imageReadParam2 = imageReader.getDefaultReadParam();
        imageReadParam2.setDestination(bufferedImage);
        imageReadParam2.setDestinationBands(imageReadParam.getDestinationBands());
        imageReadParam2.setDestinationOffset(imageReadParam.getDestinationOffset());
        imageReadParam2.setSourceBands(imageReadParam.getSourceBands());
        imageReadParam2.setSourceRegion(imageReadParam.getSourceRegion());
        imageReadParam2.setSourceSubsampling(imageReadParam.getSourceXSubsampling(), imageReadParam.getSourceYSubsampling(), imageReadParam.getSubsamplingXOffset(), imageReadParam.getSubsamplingYOffset());
        imageReader.read(0, imageReadParam2);
    }

    private class EmbeddedProgressAdapter
    implements IIOReadProgressListener {
        private EmbeddedProgressAdapter() {
        }

        public void imageComplete(ImageReader imageReader) {
        }

        public void imageProgress(ImageReader imageReader, float f2) {
        }

        public void imageStarted(ImageReader imageReader, int n2) {
        }

        public void thumbnailComplete(ImageReader imageReader) {
        }

        public void thumbnailProgress(ImageReader imageReader, float f2) {
        }

        public void thumbnailStarted(ImageReader imageReader, int n2, int n3) {
        }

        public void sequenceComplete(ImageReader imageReader) {
        }

        public void sequenceStarted(ImageReader imageReader, int n2) {
        }

        public void readAborted(ImageReader imageReader) {
        }
    }
}

