/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import java.util.Enumeration;
import java.util.Vector;

final class SnmpMibTree {
    private SnmpMibAgent defaultAgent = null;
    private TreeNode root = new TreeNode(-1L, null, null);

    public void setDefaultAgent(SnmpMibAgent snmpMibAgent) {
        this.defaultAgent = snmpMibAgent;
        this.root.agent = snmpMibAgent;
    }

    public SnmpMibAgent getDefaultAgent() {
        return this.defaultAgent;
    }

    public void register(SnmpMibAgent snmpMibAgent) {
        this.root.registerNode(snmpMibAgent);
    }

    public void register(SnmpMibAgent snmpMibAgent, long[] lArray) {
        this.root.registerNode(lArray, 0, snmpMibAgent);
    }

    public SnmpMibAgent getAgentMib(SnmpOid snmpOid) {
        TreeNode treeNode = this.root.retrieveMatchingBranch(snmpOid.longValue(), 0);
        if (treeNode == null) {
            return this.defaultAgent;
        }
        if (treeNode.getAgentMib() == null) {
            return this.defaultAgent;
        }
        return treeNode.getAgentMib();
    }

    public void unregister(SnmpMibAgent snmpMibAgent, SnmpOid[] snmpOidArray) {
        for (int i2 = 0; i2 < snmpOidArray.length; ++i2) {
            long[] lArray = snmpOidArray[i2].longValue();
            TreeNode treeNode = this.root.retrieveMatchingBranch(lArray, 0);
            if (treeNode == null) continue;
            treeNode.removeAgent(snmpMibAgent);
        }
    }

    public void unregister(SnmpMibAgent snmpMibAgent) {
        this.root.removeAgentFully(snmpMibAgent);
    }

    public void printTree() {
        this.root.printTree(">");
    }

    final class TreeNode {
        private Vector children = new Vector();
        private Vector agents = new Vector();
        private long nodeValue;
        protected SnmpMibAgent agent;
        private TreeNode parent;

        void registerNode(SnmpMibAgent snmpMibAgent) {
            long[] lArray = snmpMibAgent.getRootOid();
            this.registerNode(lArray, 0, snmpMibAgent);
        }

        TreeNode retrieveMatchingBranch(long[] lArray, int n2) {
            TreeNode treeNode = this.retrieveChild(lArray, n2);
            if (treeNode == null) {
                return this;
            }
            if (this.children.size() == 0) {
                return treeNode;
            }
            if (n2 + 1 == lArray.length) {
                return treeNode;
            }
            TreeNode treeNode2 = treeNode.retrieveMatchingBranch(lArray, n2 + 1);
            return treeNode2.agent == null ? this : treeNode2;
        }

        SnmpMibAgent getAgentMib() {
            return this.agent;
        }

        public void printTree(String string) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.agents == null) {
                return;
            }
            Enumeration enumeration = this.agents.elements();
            while (enumeration.hasMoreElements()) {
                object = (SnmpMibAgent)enumeration.nextElement();
                if (object == null) {
                    stringBuffer.append("empty ");
                    continue;
                }
                stringBuffer.append(((SnmpMibAgent)object).getMibName() + " ");
            }
            string = string + " ";
            if (this.children == null) {
                return;
            }
            enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                object = (TreeNode)enumeration.nextElement();
                ((TreeNode)object).printTree(string);
            }
        }

        private TreeNode(long l2, SnmpMibAgent snmpMibAgent, TreeNode treeNode) {
            this.nodeValue = l2;
            this.parent = treeNode;
            this.agents.addElement(snmpMibAgent);
        }

        private void removeAgentFully(SnmpMibAgent snmpMibAgent) {
            Vector<TreeNode> vector = new Vector<TreeNode>();
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = (TreeNode)enumeration.nextElement();
                treeNode.removeAgentFully(snmpMibAgent);
                if (!treeNode.agents.isEmpty()) continue;
                vector.add(treeNode);
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.children.removeElement(enumeration.nextElement());
            }
            this.removeAgent(snmpMibAgent);
        }

        private void removeAgent(SnmpMibAgent snmpMibAgent) {
            if (!this.agents.contains(snmpMibAgent)) {
                return;
            }
            this.agents.removeElement(snmpMibAgent);
            if (!this.agents.isEmpty()) {
                this.agent = (SnmpMibAgent)this.agents.firstElement();
            }
        }

        private void setAgent(SnmpMibAgent snmpMibAgent) {
            this.agent = snmpMibAgent;
        }

        private void registerNode(long[] lArray, int n2, SnmpMibAgent snmpMibAgent) {
            if (n2 >= lArray.length) {
                return;
            }
            TreeNode treeNode = this.retrieveChild(lArray, n2);
            if (treeNode == null) {
                long l2 = lArray[n2];
                treeNode = new TreeNode(l2, snmpMibAgent, this);
                this.children.addElement(treeNode);
            } else if (!this.agents.contains(snmpMibAgent)) {
                this.agents.addElement(snmpMibAgent);
            }
            if (n2 == lArray.length - 1) {
                treeNode.setAgent(snmpMibAgent);
            } else {
                treeNode.registerNode(lArray, n2 + 1, snmpMibAgent);
            }
        }

        private TreeNode retrieveChild(long[] lArray, int n2) {
            long l2 = lArray[n2];
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = (TreeNode)enumeration.nextElement();
                if (!treeNode.match(l2)) continue;
                return treeNode;
            }
            return null;
        }

        private final boolean match(long l2) {
            return this.nodeValue == l2;
        }
    }
}

