/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public abstract class ImageWriterSpi
extends ImageReaderWriterSpi {
    public static final Class[] STANDARD_OUTPUT_TYPE = new Class[]{ImageOutputStream.class};
    protected Class[] outputTypes = null;
    protected String[] readerSpiNames = null;
    private Class writerClass = null;

    protected ImageWriterSpi() {
    }

    public ImageWriterSpi(String string, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, String string3, Class[] classArray, String[] stringArray4, boolean bl2, String string4, String string5, String[] stringArray5, String[] stringArray6, boolean bl3, String string6, String string7, String[] stringArray7, String[] stringArray8) {
        super(string, string2, stringArray, stringArray2, stringArray3, string3, bl2, string4, string5, stringArray5, stringArray6, bl3, string6, string7, stringArray7, stringArray8);
        if (classArray == null) {
            throw new IllegalArgumentException("outputTypes == null!");
        }
        if (classArray.length == 0) {
            throw new IllegalArgumentException("outputTypes.length == 0!");
        }
        this.outputTypes = (Class[])classArray.clone();
        if (stringArray4 != null && stringArray4.length > 0) {
            this.readerSpiNames = (String[])stringArray4.clone();
        }
    }

    public boolean isFormatLossless() {
        return true;
    }

    public Class[] getOutputTypes() {
        return (Class[])this.outputTypes.clone();
    }

    public abstract boolean canEncodeImage(ImageTypeSpecifier var1);

    public boolean canEncodeImage(RenderedImage renderedImage) {
        return this.canEncodeImage(ImageTypeSpecifier.createFromRenderedImage(renderedImage));
    }

    public ImageWriter createWriterInstance() throws IOException {
        return this.createWriterInstance(null);
    }

    public abstract ImageWriter createWriterInstance(Object var1) throws IOException;

    public boolean isOwnWriter(ImageWriter imageWriter) {
        if (imageWriter == null) {
            throw new IllegalArgumentException("writer == null!");
        }
        String string = imageWriter.getClass().getName();
        return string.equals(this.pluginClassName);
    }

    public String[] getImageReaderSpiNames() {
        return this.readerSpiNames == null ? null : (String[])this.readerSpiNames.clone();
    }
}

