/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.Rfc2253Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rdn
implements Serializable,
Comparable<Object> {
    private transient ArrayList entries;
    private static final int DEFAULT_SIZE = 1;
    private static final long serialVersionUID = -5994465067210009656L;
    private static final String escapees = ",=+<>#;\"\\";

    public Rdn(Attributes attributes) throws InvalidNameException {
        if (attributes.size() == 0) {
            throw new InvalidNameException("Attributes cannot be empty");
        }
        this.entries = new ArrayList(attributes.size());
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        try {
            int n2 = 0;
            while (namingEnumeration.hasMore()) {
                RdnEntry rdnEntry = new RdnEntry();
                Attribute attribute = namingEnumeration.next();
                rdnEntry.type = attribute.getID();
                rdnEntry.value = attribute.get();
                this.entries.add(n2, rdnEntry);
                ++n2;
            }
        }
        catch (NamingException namingException) {
            InvalidNameException invalidNameException = new InvalidNameException(namingException.getMessage());
            invalidNameException.initCause(namingException);
            throw invalidNameException;
        }
        this.sort();
    }

    public Rdn(String string) throws InvalidNameException {
        this.entries = new ArrayList(1);
        new Rfc2253Parser(string).parseRdn(this);
    }

    public Rdn(Rdn rdn) {
        this.entries = new ArrayList(rdn.entries.size());
        this.entries.addAll(rdn.entries);
    }

    public Rdn(String string, Object object) throws InvalidNameException {
        if (object == null) {
            throw new NullPointerException("Cannot set value to null");
        }
        if (string.equals("") || this.isEmptyValue(object)) {
            throw new InvalidNameException("type or value cannot be empty, type:" + string + " value:" + object);
        }
        this.entries = new ArrayList(1);
        this.put(string, object);
    }

    private boolean isEmptyValue(Object object) {
        return object instanceof String && object.equals("") || object instanceof byte[] && ((byte[])object).length == 0;
    }

    Rdn() {
        this.entries = new ArrayList(1);
    }

    Rdn put(String string, Object object) {
        RdnEntry rdnEntry = new RdnEntry();
        rdnEntry.type = string;
        if (object instanceof byte[]) {
            rdnEntry.value = ((byte[])object).clone();
        } else {
            rdnEntry.value = object;
        }
        this.entries.add(rdnEntry);
        return this;
    }

    void sort() {
        if (this.entries.size() > 1) {
            Collections.sort(this.entries);
        }
    }

    public Object getValue() {
        return ((RdnEntry)this.entries.get(0)).getValue();
    }

    public String getType() {
        return ((RdnEntry)this.entries.get(0)).getType();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.entries.size();
        if (n2 > 0) {
            stringBuilder.append(this.entries.get(0));
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            stringBuilder.append('+');
            stringBuilder.append(this.entries.get(i2));
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(Object object) {
        if (!(object instanceof Rdn)) {
            throw new ClassCastException("The obj is not a Rdn");
        }
        if (object == this) {
            return 0;
        }
        Rdn rdn = (Rdn)object;
        int n2 = Math.min(this.entries.size(), rdn.entries.size());
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = ((RdnEntry)this.entries.get(i2)).compareTo(rdn.entries.get(i2));
            if (n3 == 0) continue;
            return n3;
        }
        return this.entries.size() - rdn.entries.size();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Rdn)) {
            return false;
        }
        Rdn rdn = (Rdn)object;
        if (this.entries.size() != rdn.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.entries.size(); ++i2) {
            if (this.entries.get(i2).equals(rdn.entries.get(i2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.entries.size(); ++i2) {
            n2 += this.entries.get(i2).hashCode();
        }
        return n2;
    }

    public Attributes toAttributes() {
        BasicAttributes basicAttributes = new BasicAttributes(true);
        for (int i2 = 0; i2 < this.entries.size(); ++i2) {
            RdnEntry rdnEntry = (RdnEntry)this.entries.get(i2);
            Attribute attribute = basicAttributes.put(rdnEntry.getType(), rdnEntry.getValue());
            if (attribute == null) continue;
            attribute.add(rdnEntry.getValue());
            basicAttributes.put(rdnEntry.getType(), attribute);
        }
        return basicAttributes;
    }

    public int size() {
        return this.entries.size();
    }

    public static String escapeValue(Object object) {
        return object instanceof byte[] ? Rdn.escapeBinaryValue((byte[])object) : Rdn.escapeStringValue((String)object);
    }

    private static String escapeStringValue(String string) {
        int n2;
        int n3;
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder(2 * string.length());
        for (n3 = 0; n3 < cArray.length && Rdn.isWhitespace(cArray[n3]); ++n3) {
        }
        for (n2 = cArray.length - 1; n2 >= 0 && Rdn.isWhitespace(cArray[n2]); --n2) {
        }
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (i2 < n3 || i2 > n2 || escapees.indexOf(c2) >= 0) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private static String escapeBinaryValue(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(1 + 2 * byArray.length);
        stringBuilder.append("#");
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by = byArray[i2];
            stringBuilder.append(Character.forDigit(0xF & by >>> 4, 16));
            stringBuilder.append(Character.forDigit(0xF & by, 16));
        }
        return stringBuilder.toString();
    }

    public static Object unescapeValue(String string) {
        int n2;
        int n3;
        char[] cArray = string.toCharArray();
        int n4 = cArray.length;
        for (n3 = 0; n3 < n4 && Rdn.isWhitespace(cArray[n3]); ++n3) {
        }
        while (n3 < n4 && Rdn.isWhitespace(cArray[n4 - 1])) {
            --n4;
        }
        if (n4 != cArray.length && n3 < n4 && cArray[n4 - 1] == '\\') {
            ++n4;
        }
        if (n3 >= n4) {
            return "";
        }
        if (cArray[n3] == '#') {
            return Rdn.decodeHexPairs(cArray, ++n3, n4);
        }
        if (cArray[n3] == '\"' && cArray[n4 - 1] == '\"') {
            ++n3;
            --n4;
        }
        StringBuilder stringBuilder = new StringBuilder(n4 - n3);
        int n5 = -1;
        for (n2 = n3; n2 < n4; ++n2) {
            if (cArray[n2] == '\\' && n2 + 1 < n4) {
                if (!Character.isLetterOrDigit(cArray[n2 + 1])) {
                    stringBuilder.append(cArray[++n2]);
                    n5 = n2;
                    continue;
                }
                byte[] byArray = Rdn.getUtf8Octets(cArray, n2, n4);
                if (byArray.length > 0) {
                    try {
                        stringBuilder.append(new String(byArray, "UTF8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    n2 += byArray.length * 3 - 1;
                    continue;
                }
                throw new IllegalArgumentException("Not a valid attribute string value:" + string + ",improper usage of backslash");
            }
            stringBuilder.append(cArray[n2]);
        }
        n2 = stringBuilder.length();
        if (Rdn.isWhitespace(stringBuilder.charAt(n2 - 1)) && n5 != n4 - 1) {
            stringBuilder.setLength(n2 - 1);
        }
        return stringBuilder.toString();
    }

    private static byte[] decodeHexPairs(char[] cArray, int n2, int n3) {
        byte[] byArray = new byte[(n3 - n2) / 2];
        int n4 = 0;
        while (n2 + 1 < n3) {
            int n5 = Character.digit(cArray[n2], 16);
            int n6 = Character.digit(cArray[n2 + 1], 16);
            if (n5 < 0 || n6 < 0) break;
            byArray[n4] = (byte)((n5 << 4) + n6);
            n2 += 2;
            ++n4;
        }
        if (n2 != n3) {
            throw new IllegalArgumentException("Illegal attribute value: " + new String(cArray));
        }
        return byArray;
    }

    private static byte[] getUtf8Octets(char[] cArray, int n2, int n3) {
        byte[] byArray = new byte[(n3 - n2) / 3];
        int n4 = 0;
        while (n2 + 2 < n3 && cArray[n2++] == '\\') {
            int n5 = Character.digit(cArray[n2++], 16);
            int n6 = Character.digit(cArray[n2++], 16);
            if (n5 < 0 || n6 < 0) break;
            byArray[n4++] = (byte)((n5 << 4) + n6);
        }
        if (n4 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, 0, byArray2, 0, n4);
        return byArray2;
    }

    private static boolean isWhitespace(char c2) {
        return c2 == ' ' || c2 == '\r';
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.entries = new ArrayList(1);
        String string = (String)objectInputStream.readObject();
        try {
            new Rfc2253Parser(string).parseRdn(this);
        }
        catch (InvalidNameException invalidNameException) {
            throw new StreamCorruptedException("Invalid name: " + string);
        }
    }

    private static class RdnEntry
    implements Comparable {
        private String type;
        private Object value;
        private String comparable = null;

        private RdnEntry() {
        }

        String getType() {
            return this.type;
        }

        Object getValue() {
            return this.value;
        }

        public int compareTo(Object object) {
            RdnEntry rdnEntry = (RdnEntry)object;
            int n2 = this.type.toUpperCase().compareTo(rdnEntry.type.toUpperCase());
            if (n2 != 0) {
                return n2;
            }
            if (this.value.equals(rdnEntry.value)) {
                return 0;
            }
            return this.getValueComparable().compareTo(rdnEntry.getValueComparable());
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof RdnEntry)) {
                return false;
            }
            RdnEntry rdnEntry = (RdnEntry)object;
            return this.type.equalsIgnoreCase(rdnEntry.type) && this.getValueComparable().equals(rdnEntry.getValueComparable());
        }

        public int hashCode() {
            return this.type.toUpperCase().hashCode() + this.getValueComparable().hashCode();
        }

        public String toString() {
            return this.type + "=" + Rdn.escapeValue(this.value);
        }

        private String getValueComparable() {
            if (this.comparable != null) {
                return this.comparable;
            }
            this.comparable = this.value instanceof byte[] ? Rdn.escapeBinaryValue((byte[])this.value) : ((String)this.value).toUpperCase();
            return this.comparable;
        }
    }
}

