/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.ScrollPaneConstants;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.basic.LazyActionMap;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicScrollPaneUI
extends ScrollPaneUI
implements ScrollPaneConstants {
    protected JScrollPane scrollpane;
    protected ChangeListener vsbChangeListener;
    protected ChangeListener hsbChangeListener;
    protected ChangeListener viewportChangeListener;
    protected PropertyChangeListener spPropertyChangeListener;
    private MouseWheelListener mouseScrollListener;
    private PropertyChangeListener vsbPropertyChangeListener;
    private PropertyChangeListener hsbPropertyChangeListener;
    private Handler handler;
    private boolean setValueCalled = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicScrollPaneUI();
    }

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("scrollUp"));
        lazyActionMap.put(new Actions("scrollDown"));
        lazyActionMap.put(new Actions("scrollHome"));
        lazyActionMap.put(new Actions("scrollEnd"));
        lazyActionMap.put(new Actions("unitScrollUp"));
        lazyActionMap.put(new Actions("unitScrollDown"));
        lazyActionMap.put(new Actions("scrollLeft"));
        lazyActionMap.put(new Actions("scrollRight"));
        lazyActionMap.put(new Actions("unitScrollRight"));
        lazyActionMap.put(new Actions("unitScrollLeft"));
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Border border = this.scrollpane.getViewportBorder();
        if (border != null) {
            Rectangle rectangle = this.scrollpane.getViewportBorderBounds();
            border.paintBorder(this.scrollpane, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    protected void installDefaults(JScrollPane jScrollPane) {
        LookAndFeel.installBorder(jScrollPane, "ScrollPane.border");
        LookAndFeel.installColorsAndFont(jScrollPane, "ScrollPane.background", "ScrollPane.foreground", "ScrollPane.font");
        Border border = jScrollPane.getViewportBorder();
        if (border == null || border instanceof UIResource) {
            border = UIManager.getBorder("ScrollPane.viewportBorder");
            jScrollPane.setViewportBorder(border);
        }
        LookAndFeel.installProperty(jScrollPane, "opaque", Boolean.TRUE);
    }

    protected void installListeners(JScrollPane jScrollPane) {
        this.vsbChangeListener = this.createVSBChangeListener();
        this.vsbPropertyChangeListener = this.createVSBPropertyChangeListener();
        this.hsbChangeListener = this.createHSBChangeListener();
        this.hsbPropertyChangeListener = this.createHSBPropertyChangeListener();
        this.viewportChangeListener = this.createViewportChangeListener();
        this.spPropertyChangeListener = this.createPropertyChangeListener();
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        if (jViewport != null) {
            jViewport.addChangeListener(this.viewportChangeListener);
        }
        if (jScrollBar != null) {
            jScrollBar.getModel().addChangeListener(this.vsbChangeListener);
            jScrollBar.addPropertyChangeListener(this.vsbPropertyChangeListener);
        }
        if (jScrollBar2 != null) {
            jScrollBar2.getModel().addChangeListener(this.hsbChangeListener);
            jScrollBar2.addPropertyChangeListener(this.hsbPropertyChangeListener);
        }
        this.scrollpane.addPropertyChangeListener(this.spPropertyChangeListener);
        this.mouseScrollListener = this.createMouseWheelListener();
        this.scrollpane.addMouseWheelListener(this.mouseScrollListener);
    }

    protected void installKeyboardActions(JScrollPane jScrollPane) {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(jScrollPane, 1, inputMap);
        LazyActionMap.installLazyActionMap(jScrollPane, BasicScrollPaneUI.class, "ScrollPane.actionMap");
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            InputMap inputMap;
            InputMap inputMap2 = (InputMap)DefaultLookup.get(this.scrollpane, this, "ScrollPane.ancestorInputMap");
            if (this.scrollpane.getComponentOrientation().isLeftToRight() || (inputMap = (InputMap)DefaultLookup.get(this.scrollpane, this, "ScrollPane.ancestorInputMap.RightToLeft")) == null) {
                return inputMap2;
            }
            inputMap.setParent(inputMap2);
            return inputMap;
        }
        return null;
    }

    public void installUI(JComponent jComponent) {
        this.scrollpane = (JScrollPane)jComponent;
        this.installDefaults(this.scrollpane);
        this.installListeners(this.scrollpane);
        this.installKeyboardActions(this.scrollpane);
    }

    protected void uninstallDefaults(JScrollPane jScrollPane) {
        LookAndFeel.uninstallBorder(this.scrollpane);
        if (this.scrollpane.getViewportBorder() instanceof UIResource) {
            this.scrollpane.setViewportBorder(null);
        }
    }

    protected void uninstallListeners(JComponent jComponent) {
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        if (jViewport != null) {
            jViewport.removeChangeListener(this.viewportChangeListener);
        }
        if (jScrollBar != null) {
            jScrollBar.getModel().removeChangeListener(this.vsbChangeListener);
            jScrollBar.removePropertyChangeListener(this.vsbPropertyChangeListener);
        }
        if (jScrollBar2 != null) {
            jScrollBar2.getModel().removeChangeListener(this.hsbChangeListener);
            jScrollBar2.removePropertyChangeListener(this.hsbPropertyChangeListener);
        }
        this.scrollpane.removePropertyChangeListener(this.spPropertyChangeListener);
        if (this.mouseScrollListener != null) {
            this.scrollpane.removeMouseWheelListener(this.mouseScrollListener);
        }
        this.vsbChangeListener = null;
        this.hsbChangeListener = null;
        this.viewportChangeListener = null;
        this.spPropertyChangeListener = null;
        this.mouseScrollListener = null;
        this.handler = null;
    }

    protected void uninstallKeyboardActions(JScrollPane jScrollPane) {
        SwingUtilities.replaceUIActionMap(jScrollPane, null);
        SwingUtilities.replaceUIInputMap(jScrollPane, 1, null);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults(this.scrollpane);
        this.uninstallListeners(this.scrollpane);
        this.uninstallKeyboardActions(this.scrollpane);
        this.scrollpane = null;
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void syncScrollPaneWithViewport() {
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        JViewport jViewport2 = this.scrollpane.getRowHeader();
        JViewport jViewport3 = this.scrollpane.getColumnHeader();
        boolean bl2 = this.scrollpane.getComponentOrientation().isLeftToRight();
        if (jViewport != null) {
            int n2;
            int n3;
            int n4;
            Dimension dimension = jViewport.getExtentSize();
            Dimension dimension2 = jViewport.getViewSize();
            Point point = jViewport.getViewPosition();
            if (jScrollBar != null) {
                n4 = dimension.height;
                n3 = dimension2.height;
                n2 = Math.max(0, Math.min(point.y, n3 - n4));
                jScrollBar.setValues(n2, n4, 0, n3);
            }
            if (jScrollBar2 != null) {
                n4 = dimension.width;
                n3 = dimension2.width;
                if (bl2) {
                    n2 = Math.max(0, Math.min(point.x, n3 - n4));
                } else {
                    int n5 = jScrollBar2.getValue();
                    if (this.setValueCalled && n3 - n5 == point.x) {
                        n2 = Math.max(0, Math.min(n3 - n4, n5));
                        if (n4 != 0) {
                            this.setValueCalled = false;
                        }
                    } else if (n4 > n3) {
                        point.x = n3 - n4;
                        jViewport.setViewPosition(point);
                        n2 = 0;
                    } else {
                        n2 = Math.max(0, Math.min(n3 - n4, n3 - n4 - point.x));
                    }
                }
                jScrollBar2.setValues(n2, n4, 0, n3);
            }
            if (jViewport2 != null) {
                Point point2 = jViewport2.getViewPosition();
                point2.y = jViewport.getViewPosition().y;
                point2.x = 0;
                jViewport2.setViewPosition(point2);
            }
            if (jViewport3 != null) {
                Point point3 = jViewport3.getViewPosition();
                point3.x = bl2 ? jViewport.getViewPosition().x : Math.max(0, jViewport.getViewPosition().x);
                point3.y = 0;
                jViewport3.setViewPosition(point3);
            }
        }
    }

    protected ChangeListener createViewportChangeListener() {
        return this.getHandler();
    }

    private PropertyChangeListener createHSBPropertyChangeListener() {
        return this.getHandler();
    }

    protected ChangeListener createHSBChangeListener() {
        return this.getHandler();
    }

    private PropertyChangeListener createVSBPropertyChangeListener() {
        return this.getHandler();
    }

    protected ChangeListener createVSBChangeListener() {
        return this.getHandler();
    }

    protected MouseWheelListener createMouseWheelListener() {
        return this.getHandler();
    }

    protected void updateScrollBarDisplayPolicy(PropertyChangeEvent propertyChangeEvent) {
        this.scrollpane.revalidate();
        this.scrollpane.repaint();
    }

    protected void updateViewport(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getOldValue();
        JViewport jViewport2 = (JViewport)propertyChangeEvent.getNewValue();
        if (jViewport != null) {
            jViewport.removeChangeListener(this.viewportChangeListener);
        }
        if (jViewport2 != null) {
            int n2;
            int n3;
            Point point = jViewport2.getViewPosition();
            point.x = this.scrollpane.getComponentOrientation().isLeftToRight() ? Math.max(point.x, 0) : ((n3 = jViewport2.getExtentSize().width) > (n2 = jViewport2.getViewSize().width) ? n2 - n3 : Math.max(0, Math.min(n2 - n3, point.x)));
            point.y = Math.max(point.y, 0);
            jViewport2.setViewPosition(point);
            jViewport2.addChangeListener(this.viewportChangeListener);
        }
    }

    protected void updateRowHeader(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getNewValue();
        if (jViewport != null) {
            JViewport jViewport2 = this.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            point.y = jViewport2 != null ? jViewport2.getViewPosition().y : 0;
            jViewport.setViewPosition(point);
        }
    }

    protected void updateColumnHeader(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getNewValue();
        if (jViewport != null) {
            JViewport jViewport2 = this.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            point.x = jViewport2 == null ? 0 : (this.scrollpane.getComponentOrientation().isLeftToRight() ? jViewport2.getViewPosition().x : Math.max(0, jViewport2.getViewPosition().x));
            jViewport.setViewPosition(point);
            this.scrollpane.add((Component)jViewport, "COLUMN_HEADER");
        }
    }

    private void updateHorizontalScrollBar(PropertyChangeEvent propertyChangeEvent) {
        this.updateScrollBar(propertyChangeEvent, this.hsbChangeListener, this.hsbPropertyChangeListener);
    }

    private void updateVerticalScrollBar(PropertyChangeEvent propertyChangeEvent) {
        this.updateScrollBar(propertyChangeEvent, this.vsbChangeListener, this.vsbPropertyChangeListener);
    }

    private void updateScrollBar(PropertyChangeEvent propertyChangeEvent, ChangeListener changeListener, PropertyChangeListener propertyChangeListener) {
        JScrollBar jScrollBar = (JScrollBar)propertyChangeEvent.getOldValue();
        if (jScrollBar != null) {
            if (changeListener != null) {
                jScrollBar.getModel().removeChangeListener(changeListener);
            }
            if (propertyChangeListener != null) {
                jScrollBar.removePropertyChangeListener(propertyChangeListener);
            }
        }
        if ((jScrollBar = (JScrollBar)propertyChangeEvent.getNewValue()) != null) {
            if (changeListener != null) {
                jScrollBar.getModel().addChangeListener(changeListener);
            }
            if (propertyChangeListener != null) {
                jScrollBar.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private static class Actions
    extends UIAction {
        private static final String SCROLL_UP = "scrollUp";
        private static final String SCROLL_DOWN = "scrollDown";
        private static final String SCROLL_HOME = "scrollHome";
        private static final String SCROLL_END = "scrollEnd";
        private static final String UNIT_SCROLL_UP = "unitScrollUp";
        private static final String UNIT_SCROLL_DOWN = "unitScrollDown";
        private static final String SCROLL_LEFT = "scrollLeft";
        private static final String SCROLL_RIGHT = "scrollRight";
        private static final String UNIT_SCROLL_LEFT = "unitScrollLeft";
        private static final String UNIT_SCROLL_RIGHT = "unitScrollRight";

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
            boolean bl2 = jScrollPane.getComponentOrientation().isLeftToRight();
            String string = this.getName();
            if (string == SCROLL_UP) {
                this.scroll(jScrollPane, 1, -1, true);
            } else if (string == SCROLL_DOWN) {
                this.scroll(jScrollPane, 1, 1, true);
            } else if (string == SCROLL_HOME) {
                this.scrollHome(jScrollPane);
            } else if (string == SCROLL_END) {
                this.scrollEnd(jScrollPane);
            } else if (string == UNIT_SCROLL_UP) {
                this.scroll(jScrollPane, 1, -1, false);
            } else if (string == UNIT_SCROLL_DOWN) {
                this.scroll(jScrollPane, 1, 1, false);
            } else if (string == SCROLL_LEFT) {
                this.scroll(jScrollPane, 0, bl2 ? -1 : 1, true);
            } else if (string == SCROLL_RIGHT) {
                this.scroll(jScrollPane, 0, bl2 ? 1 : -1, true);
            } else if (string == UNIT_SCROLL_LEFT) {
                this.scroll(jScrollPane, 0, bl2 ? -1 : 1, false);
            } else if (string == UNIT_SCROLL_RIGHT) {
                this.scroll(jScrollPane, 0, bl2 ? 1 : -1, false);
            }
        }

        private void scrollEnd(JScrollPane jScrollPane) {
            Component component;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                Rectangle rectangle = jViewport.getViewRect();
                Rectangle rectangle2 = component.getBounds();
                if (jScrollPane.getComponentOrientation().isLeftToRight()) {
                    jViewport.setViewPosition(new Point(rectangle2.width - rectangle.width, rectangle2.height - rectangle.height));
                } else {
                    jViewport.setViewPosition(new Point(0, rectangle2.height - rectangle.height));
                }
            }
        }

        private void scrollHome(JScrollPane jScrollPane) {
            Component component;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                if (jScrollPane.getComponentOrientation().isLeftToRight()) {
                    jViewport.setViewPosition(new Point(0, 0));
                } else {
                    Rectangle rectangle = jViewport.getViewRect();
                    Rectangle rectangle2 = component.getBounds();
                    jViewport.setViewPosition(new Point(rectangle2.width - rectangle.width, 0));
                }
            }
        }

        private void scroll(JScrollPane jScrollPane, int n2, int n3, boolean bl2) {
            Component component;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                Rectangle rectangle = jViewport.getViewRect();
                Dimension dimension = component.getSize();
                int n4 = component instanceof Scrollable ? (bl2 ? ((Scrollable)((Object)component)).getScrollableBlockIncrement(rectangle, n2, n3) : ((Scrollable)((Object)component)).getScrollableUnitIncrement(rectangle, n2, n3)) : (bl2 ? (n2 == 1 ? rectangle.height : rectangle.width) : 10);
                if (n2 == 1) {
                    rectangle.y += n4 * n3;
                    if (rectangle.y + rectangle.height > dimension.height) {
                        rectangle.y = Math.max(0, dimension.height - rectangle.height);
                    } else if (rectangle.y < 0) {
                        rectangle.y = 0;
                    }
                } else if (jScrollPane.getComponentOrientation().isLeftToRight()) {
                    rectangle.x += n4 * n3;
                    if (rectangle.x + rectangle.width > dimension.width) {
                        rectangle.x = Math.max(0, dimension.width - rectangle.width);
                    } else if (rectangle.x < 0) {
                        rectangle.x = 0;
                    }
                } else {
                    rectangle.x -= n4 * n3;
                    rectangle.x = rectangle.width > dimension.width ? dimension.width - rectangle.width : Math.max(0, Math.min(dimension.width - rectangle.width, rectangle.x));
                }
                jViewport.setViewPosition(rectangle.getLocation());
            }
        }
    }

    public class HSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicScrollPaneUI.this.getHandler().stateChanged(changeEvent);
        }
    }

    class Handler
    implements ChangeListener,
    PropertyChangeListener,
    MouseWheelListener {
        Handler() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (BasicScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && mouseWheelEvent.getScrollAmount() != 0) {
                JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                int n2 = 0;
                if (!(jScrollBar != null && jScrollBar.isVisible() || (jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) != null && jScrollBar.isVisible())) {
                    return;
                }
                int n3 = n2 = mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1;
                if (mouseWheelEvent.getScrollType() == 0) {
                    BasicScrollBarUI.scrollByUnits(jScrollBar, n2, mouseWheelEvent.getScrollAmount());
                } else if (mouseWheelEvent.getScrollType() == 1) {
                    BasicScrollBarUI.scrollByBlock(jScrollBar, n2);
                }
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
            if (jViewport != null) {
                if (changeEvent.getSource() == jViewport) {
                    this.viewportStateChanged(changeEvent);
                } else {
                    JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    if (jScrollBar != null && changeEvent.getSource() == jScrollBar.getModel()) {
                        this.hsbStateChanged(jViewport, changeEvent);
                    } else {
                        JScrollBar jScrollBar2 = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                        if (jScrollBar2 != null && changeEvent.getSource() == jScrollBar2.getModel()) {
                            this.vsbStateChanged(jViewport, changeEvent);
                        }
                    }
                }
            }
        }

        private void vsbStateChanged(JViewport jViewport, ChangeEvent changeEvent) {
            BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
            Point point = jViewport.getViewPosition();
            point.y = boundedRangeModel.getValue();
            jViewport.setViewPosition(point);
        }

        private void hsbStateChanged(JViewport jViewport, ChangeEvent changeEvent) {
            BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
            Point point = jViewport.getViewPosition();
            int n2 = boundedRangeModel.getValue();
            if (BasicScrollPaneUI.this.scrollpane.getComponentOrientation().isLeftToRight()) {
                point.x = n2;
            } else {
                int n3 = jViewport.getViewSize().width;
                int n4 = jViewport.getExtentSize().width;
                int n5 = point.x;
                point.x = n3 - n4 - n2;
                if (n4 == 0 && n2 != 0 && n5 == n3) {
                    BasicScrollPaneUI.this.setValueCalled = true;
                } else if (n4 != 0 && n5 < 0 && point.x == 0) {
                    point.x += n2;
                }
            }
            jViewport.setViewPosition(point);
        }

        private void viewportStateChanged(ChangeEvent changeEvent) {
            BasicScrollPaneUI.this.syncScrollPaneWithViewport();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == BasicScrollPaneUI.this.scrollpane) {
                this.scrollPanePropertyChange(propertyChangeEvent);
            } else {
                this.sbPropertyChange(propertyChangeEvent);
            }
        }

        private void scrollPanePropertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "verticalScrollBarDisplayPolicy") {
                BasicScrollPaneUI.this.updateScrollBarDisplayPolicy(propertyChangeEvent);
            } else if (string == "horizontalScrollBarDisplayPolicy") {
                BasicScrollPaneUI.this.updateScrollBarDisplayPolicy(propertyChangeEvent);
            } else if (string == "viewport") {
                BasicScrollPaneUI.this.updateViewport(propertyChangeEvent);
            } else if (string == "rowHeader") {
                BasicScrollPaneUI.this.updateRowHeader(propertyChangeEvent);
            } else if (string == "columnHeader") {
                BasicScrollPaneUI.this.updateColumnHeader(propertyChangeEvent);
            } else if (string == "verticalScrollBar") {
                BasicScrollPaneUI.this.updateVerticalScrollBar(propertyChangeEvent);
            } else if (string == "horizontalScrollBar") {
                BasicScrollPaneUI.this.updateHorizontalScrollBar(propertyChangeEvent);
            } else if (string == "componentOrientation") {
                BasicScrollPaneUI.this.scrollpane.revalidate();
                BasicScrollPaneUI.this.scrollpane.repaint();
            }
        }

        private void sbPropertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getSource();
            if ("model" == string) {
                JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)propertyChangeEvent.getOldValue();
                ChangeListener changeListener = null;
                if (object == jScrollBar) {
                    changeListener = BasicScrollPaneUI.this.vsbChangeListener;
                } else if (object == BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) {
                    jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    changeListener = BasicScrollPaneUI.this.hsbChangeListener;
                }
                if (changeListener != null) {
                    if (boundedRangeModel != null) {
                        boundedRangeModel.removeChangeListener(changeListener);
                    }
                    if (jScrollBar.getModel() != null) {
                        jScrollBar.getModel().addChangeListener(changeListener);
                    }
                }
            } else if ("componentOrientation" == string && object == BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) {
                JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
                Point point = jViewport.getViewPosition();
                point.x = BasicScrollPaneUI.this.scrollpane.getComponentOrientation().isLeftToRight() ? jScrollBar.getValue() : jViewport.getViewSize().width - jViewport.getExtentSize().width - jScrollBar.getValue();
                jViewport.setViewPosition(point);
            }
        }
    }

    protected class MouseWheelHandler
    implements MouseWheelListener {
        protected MouseWheelHandler() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            BasicScrollPaneUI.this.getHandler().mouseWheelMoved(mouseWheelEvent);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicScrollPaneUI.this.getHandler().propertyChange(propertyChangeEvent);
        }
    }

    public class VSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicScrollPaneUI.this.getHandler().stateChanged(changeEvent);
        }
    }

    public class ViewportChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicScrollPaneUI.this.getHandler().stateChanged(changeEvent);
        }
    }
}

