/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Map;
import sun.text.CodePointIterator;

public final class FontResolver {
    private Font[] allFonts;
    private static final float DEFAULT_SIZE = 12.0f;
    private static final int SHIFT = 9;
    private static final int BLOCKSIZE = 128;
    private static final int MASK = 127;
    private int[][] blocks = new int[512][];
    private static FontResolver INSTANCE;

    private FontResolver() {
        this.allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i2 = 0; i2 < this.allFonts.length; ++i2) {
            this.allFonts[i2] = this.allFonts[i2].deriveFont(12.0f);
        }
    }

    private int getIndexFor(char c2) {
        for (int i2 = 0; i2 < this.allFonts.length; ++i2) {
            if (!this.allFonts[i2].canDisplay(c2)) continue;
            return i2 + 1;
        }
        return 1;
    }

    private int getIndexFor(int n2) {
        if (n2 < 65536) {
            return this.getIndexFor((char)n2);
        }
        for (int i2 = 0; i2 < this.allFonts.length; ++i2) {
            if (!this.allFonts[i2].canDisplay(n2)) continue;
            return i2 + 1;
        }
        return 1;
    }

    public int getFontIndex(char c2) {
        int n2;
        int n3 = c2 >> 9;
        int[] nArray = this.blocks[n3];
        if (nArray == null) {
            nArray = new int[128];
            this.blocks[n3] = nArray;
        }
        if (nArray[n2 = c2 & 0x7F] == 0) {
            nArray[n2] = this.getIndexFor(c2);
        }
        return nArray[n2];
    }

    public int getFontIndex(int n2) {
        if (n2 < 65536) {
            return this.getFontIndex((char)n2);
        }
        return this.getIndexFor(n2);
    }

    public int nextFontRunIndex(CodePointIterator codePointIterator) {
        int n2 = codePointIterator.next();
        int n3 = 1;
        if (n2 != -1) {
            n3 = this.getFontIndex(n2);
            while ((n2 = codePointIterator.next()) != -1) {
                if (this.getFontIndex(n2) == n3) continue;
                codePointIterator.prev();
                break;
            }
        }
        return n3;
    }

    public Font getFont(int n2, Map map) {
        Font font = this.allFonts[n2 - 1];
        return font.deriveFont(map);
    }

    public static FontResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FontResolver();
        }
        return INSTANCE;
    }
}

