/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.config.Config;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.cache.Cache;
import com.sun.javaws.cache.CacheUtilities;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.LaunchDesc;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;

public class IcoEncoder {
    private static final int IMAGE_TYPE = 1;
    private static final int IMAGE_KIND = 0;
    private OutputStream outputS;
    private static byte ICON_SIZE = (byte)32;
    private static byte NUM_COLORS = 0;
    private static int BYTE_SIZE = 8;
    private Image awtImage;

    private IcoEncoder(OutputStream outputStream, Image image) {
        this.outputS = outputStream;
        this.awtImage = image;
    }

    public static String getIconPath(LaunchDesc launchDesc) {
        IconDesc iconDesc = launchDesc.getInformation().getIconLocation(1, 0);
        if (iconDesc != null) {
            return IcoEncoder.getIconPath(iconDesc.getLocation(), iconDesc.getVersion());
        }
        return null;
    }

    public static String getIconPath(URL uRL, String string) {
        Trace.println((String)"Getting icon path", (TraceLevel)TraceLevel.BASIC);
        File file = null;
        try {
            DiskCacheEntry diskCacheEntry = DownloadProtocol.getResource(uRL, string, 2, true, null);
            File file2 = diskCacheEntry.getMappedBitmap();
            if (file2 == null || !file2.exists()) {
                file2 = null;
                Image image = CacheUtilities.getSharedInstance().loadImage(diskCacheEntry.getFile().getPath());
                file = IcoEncoder.saveICOfile(image);
                Trace.println((String)("updating ICO: " + file), (TraceLevel)TraceLevel.BASIC);
                if (file != null) {
                    file2 = Cache.putMappedImage(uRL, string, file);
                    file = null;
                }
            }
            if (file2 != null) {
                return file2.getPath();
            }
        }
        catch (IOException iOException) {
            Trace.println((String)("exception creating BMP: " + iOException), (TraceLevel)TraceLevel.BASIC);
        }
        catch (JNLPException jNLPException) {
            Trace.println((String)("exception creating BMP: " + jNLPException), (TraceLevel)TraceLevel.BASIC);
        }
        if (file != null) {
            file.delete();
        }
        return null;
    }

    private static File saveICOfile(Image image) {
        FileOutputStream fileOutputStream = null;
        File file = null;
        File file2 = new File(Config.getJavawsCacheDir());
        try {
            file = File.createTempFile("javaws", ".ico", file2);
            fileOutputStream = new FileOutputStream(file);
            IcoEncoder icoEncoder = new IcoEncoder(fileOutputStream, image);
            icoEncoder.encode();
            fileOutputStream.close();
            return file;
        }
        catch (Throwable throwable) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (file != null) {
                file.delete();
            }
            return null;
        }
    }

    private void createBitmap() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 32;
        int n7 = 32;
        int n8 = 0;
        int[] nArray = new int[n6 * n7];
        byte[] byArray = new byte[n6 * n7 * 3];
        byte[] byArray2 = new byte[n6 * n7 * 3];
        byte[] byArray3 = new byte[n6 * 4];
        byte[] byArray4 = new byte[n6 * 4];
        PixelGrabber pixelGrabber = new PixelGrabber(this.awtImage.getScaledInstance(32, 32, 1), 0, 0, n6, n7, nArray, 0, n6);
        try {
            if (pixelGrabber.grabPixels()) {
                Trace.println((String)"pixels grabbed successfully", (TraceLevel)TraceLevel.BASIC);
            } else {
                Trace.println((String)"cannot grab pixels!", (TraceLevel)TraceLevel.BASIC);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        for (n5 = 0; n5 < n6 * n7; ++n5) {
            n4 = nArray[n5] >> 24 & 0xFF;
            n3 = nArray[n5] >> 16 & 0xFF;
            n2 = nArray[n5] >> 8 & 0xFF;
            n = nArray[n5] & 0xFF;
            if (n4 != 0) {
                Trace.print((String)" 1", (TraceLevel)TraceLevel.BASIC);
            } else {
                Trace.print((String)(" " + n4), (TraceLevel)TraceLevel.BASIC);
            }
            if (++n12 == 32) {
                Trace.println((String)" ", (TraceLevel)TraceLevel.BASIC);
                n12 = 0;
            }
            if (n4 == 0) {
                n9 = (byte)(n9 | 128 >> n11);
            }
            if (++n11 == 8) {
                byArray3[n10++] = n9;
                n9 = 0;
                n11 = 0;
            }
            byArray[n8++] = (byte)n;
            byArray[n8++] = (byte)n2;
            byArray[n8++] = (byte)n3;
        }
        n5 = 0;
        Trace.println((String)"andPxiels bitmap", (TraceLevel)TraceLevel.BASIC);
        for (n4 = 0; n4 < 128; ++n4) {
            for (n3 = 0; n3 < 8; n3 = (int)((byte)(n3 + 1))) {
                if ((byArray3[n4] & 128 >> n3) != 0) {
                    Trace.print((String)" 1", (TraceLevel)TraceLevel.BASIC);
                    continue;
                }
                Trace.print((String)" 0", (TraceLevel)TraceLevel.BASIC);
            }
            if (++n5 != 4) continue;
            Trace.println((String)" ", (TraceLevel)TraceLevel.BASIC);
            n5 = 0;
        }
        for (n2 = 0; n2 < n7; ++n2) {
            n3 = n2 * n6 * 3;
            n4 = (n7 - n2 - 1) * n6 * 3;
            for (n = 0; n < n6 * 3; ++n) {
                byArray2[n3 + n] = byArray[n4 + n];
            }
            n3 = n2 * (n6 / 8);
            n4 = (n7 - n2 - 1) * (n6 / 8);
            for (n = 0; n < n6 / 8; ++n) {
                byArray4[n3 + n] = byArray3[n4 + n];
            }
        }
        this.outputS.write(byArray2);
        this.outputS.write(byArray4);
    }

    public void encode() {
        this.writeIcoHeader();
        this.writeIconDirEntry();
        try {
            this.writeInfoHeader(40, 24);
            this.createBitmap();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeInfoHeader(int n, int n2) throws IOException {
        this.writeDWord(n);
        this.writeDWord(32);
        this.writeDWord(64);
        this.writeWord(1);
        this.writeWord(n2);
        this.writeDWord(0);
        this.writeDWord(0);
        this.writeDWord(0);
        this.writeDWord(0);
        this.writeDWord(0);
        this.writeDWord(0);
    }

    private void writeIconDirEntry() {
        try {
            int n = ICON_SIZE;
            this.outputS.write(n);
            this.outputS.write(n);
            n = NUM_COLORS;
            this.outputS.write(n);
            n = 0;
            this.outputS.write(n);
            n = 1;
            this.writeWord(n);
            n = 24;
            this.writeWord(n);
            int n2 = 3240;
            this.writeDWord(n2);
            int n3 = 22;
            this.writeDWord(n3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeIcoHeader() {
        try {
            int n = 0;
            this.writeWord(n);
            n = 1;
            this.writeWord(n);
            this.writeWord(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeWord(int n) throws IOException {
        this.outputS.write(n & 0xFF);
        this.outputS.write((n & 0xFF00) >> 8);
    }

    public void writeDWord(int n) throws IOException {
        this.outputS.write(n & 0xFF);
        this.outputS.write((n & 0xFF00) >> 8);
        this.outputS.write((n & 0xFF0000) >> 16);
        this.outputS.write((n & 0xFF000000) >> 24);
    }
}

