/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.main;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.tools.apt.comp.Apt;
import com.sun.tools.apt.util.Bark;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Flow;
import com.sun.tools.javac.comp.Lower;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.jvm.Gen;
import com.sun.tools.javac.parser.Parser;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.tree.Tree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.FileEntry;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCompiler
implements ClassReader.SourceCompleter {
    protected static final Context.Key<JavaCompiler> compilerKey = new Context.Key();
    Set<String> genSourceFileNames;
    Set<String> genClassFileNames;
    Set<File> aggregateGenFiles = Collections.emptySet();
    Bark bark;
    Log log;
    TreeMaker make;
    ClassReader reader;
    ClassWriter writer;
    Enter enter;
    Symtab syms;
    Source source;
    Gen gen;
    Name.Table names;
    Apt apt;
    Check chk;
    Flow flow;
    TransTypes transTypes;
    Lower lower;
    Annotate annotate;
    final Name completionFailureName;
    Types types;
    Scanner.Factory scannerFactory;
    Parser.Factory parserFactory;
    public boolean verbose;
    public boolean sourceOutput;
    public boolean stubOutput;
    public boolean attrParseOnly;
    public boolean classOutput;
    boolean relax;
    public boolean printFlat;
    public boolean deprecation;
    public boolean warnunchecked;
    public String encoding;
    public boolean print;
    public boolean nocompile;
    public boolean classesAsDecls;
    private Todo todo;
    Set<File> inputFiles = new HashSet<File>();
    private boolean hasBeenUsed = false;

    public static JavaCompiler instance(Context context) {
        JavaCompiler javaCompiler = context.get(compilerKey);
        if (javaCompiler == null) {
            javaCompiler = new JavaCompiler(context);
        }
        return javaCompiler;
    }

    public static String version() {
        return System.getProperty("java.version");
    }

    public Set<String> getSourceFileNames() {
        return this.genSourceFileNames;
    }

    public Set<String> getClassFileNames() {
        return this.genClassFileNames;
    }

    public Set<File> getAggregateGenFiles() {
        return this.aggregateGenFiles;
    }

    public JavaCompiler(Context context) {
        context.put(compilerKey, this);
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.bark = Bark.instance(context);
        this.reader = AptClassReader.instance0(context);
        this.make = TreeMaker.instance(context);
        this.writer = ClassWriter.instance(context);
        this.enter = Enter.instance(context);
        this.todo = Todo.instance(context);
        this.parserFactory = Parser.Factory.instance(context);
        this.scannerFactory = Scanner.Factory.instance(context);
        try {
            this.syms = Symtab.instance(context);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.bark.error(0, completionFailure.getMessage(), new Object[0]);
        }
        this.source = Source.instance(context);
        this.apt = Apt.instance(context);
        this.chk = Check.instance(context);
        this.gen = Gen.instance(context);
        this.flow = Flow.instance(context);
        this.transTypes = TransTypes.instance(context);
        this.lower = Lower.instance(context);
        this.annotate = Annotate.instance(context);
        this.types = Types.instance(context);
        this.reader.sourceCompleter = this;
        Options options = Options.instance(context);
        this.verbose = options.get("-verbose") != null;
        this.sourceOutput = options.get("-s") != null;
        this.stubOutput = options.get("-stubs") != null;
        this.classOutput = options.get("-retrofit") == null;
        this.relax = options.get("-relax") != null;
        this.printFlat = options.get("-printflat") != null;
        this.deprecation = options.lint("deprecation");
        this.warnunchecked = options.lint("unchecked");
        this.attrParseOnly = options.get("-attrparseonly") != null;
        this.encoding = (String)options.get("-encoding");
        this.nocompile = options.get("-nocompile") != null;
        this.print = options.get("-print") != null;
        this.classesAsDecls = options.get("-XclassesAsDecls") != null;
        this.completionFailureName = options.get("failcomplete") != null ? this.names.fromString((String)options.get("failcomplete")) : null;
        this.genSourceFileNames = new LinkedHashSet<String>();
        this.genClassFileNames = new LinkedHashSet<String>();
    }

    public int errorCount() {
        return this.bark.nerrors;
    }

    public int warningCount() {
        return this.bark.nwarnings;
    }

    public InputStream openSource(String string) {
        try {
            File file = new File(string);
            this.inputFiles.add(file);
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            this.bark.error(0, "cant.read.file", string);
            return null;
        }
    }

    public Tree.TopLevel parse(String string, InputStream inputStream) {
        long l = System.currentTimeMillis();
        Name name = this.log.useSource(this.names.fromString(string));
        Name name2 = this.bark.useSource(this.names.fromString(string));
        Tree.TopLevel topLevel = this.make.TopLevel(Tree.Annotation.emptyList, null, Tree.emptyList);
        if (inputStream != null) {
            if (this.verbose) {
                this.printVerbose("parsing.started", string);
            }
            try {
                Scanner scanner = this.scannerFactory.newScanner(inputStream, this.encoding);
                inputStream.close();
                Parser parser = this.parserFactory.newParser(scanner, this.keepComments());
                topLevel = parser.compilationUnit();
                if (this.verbose) {
                    this.printVerbose("parsing.done", Long.toString(System.currentTimeMillis() - l));
                }
            }
            catch (IOException iOException) {
                this.bark.error(0, "error.reading.file", string, iOException);
            }
        }
        this.bark.useSource(name2);
        this.log.useSource(name);
        topLevel.sourcefile = this.names.fromString(string);
        return topLevel;
    }

    protected boolean keepComments() {
        return true;
    }

    public Tree.TopLevel parse(String string) {
        return this.parse(string, this.openSource(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printSource(Env<AttrContext> env, Tree.ClassDef classDef) throws IOException {
        File file = this.writer.outputFile(classDef.sym, ".java");
        if (this.inputFiles.contains(file)) {
            this.bark.error(classDef.pos, "source.cant.overwrite.input.file", file);
        } else {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))));
            try {
                new Pretty(printWriter, true).printUnit(env.toplevel, classDef);
                if (this.verbose) {
                    this.printVerbose("wrote.file", file.getPath());
                }
            }
            finally {
                printWriter.close();
            }
        }
    }

    void genCode(Env<AttrContext> env, Tree.ClassDef classDef) throws IOException {
        try {
            if (this.gen.genClass(env, classDef)) {
                this.writer.writeClass(classDef.sym);
            }
        }
        catch (ClassWriter.PoolOverflow poolOverflow) {
            this.bark.error(classDef.pos, "limit.pool", new Object[0]);
        }
        catch (ClassWriter.StringOverflow stringOverflow) {
            this.bark.error(classDef.pos, "limit.string.overflow", stringOverflow.value.substring(0, 20));
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.bark.error(0, completionFailure.getMessage(), new Object[0]);
        }
    }

    @Override
    public void complete(Symbol.ClassSymbol classSymbol, String string, InputStream inputStream) throws Symbol.CompletionFailure {
        if (this.completionFailureName == classSymbol.fullname) {
            throw new Symbol.CompletionFailure(classSymbol, "user-selected completion failure by class name");
        }
        Tree.TopLevel topLevel = this.parse(string, inputStream);
        this.enter.complete(List.make(topLevel), classSymbol);
        if (this.enter.getEnv(classSymbol) == null) {
            throw new ClassReader.BadClassFile(classSymbol, string, Bark.getLocalizedString("file.doesnt.contain.class", classSymbol.fullname));
        }
    }

    public List<Symbol.ClassSymbol> compile(List<String> list, Map<String, String> map, ClassLoader classLoader, AnnotationProcessorFactory annotationProcessorFactory, Set<Class<? extends AnnotationProcessorFactory>> set, Set<File> set2) throws Throwable {
        int n;
        assert (!this.hasBeenUsed) : "attempt to reuse JavaCompiler";
        this.hasBeenUsed = true;
        this.aggregateGenFiles = set2;
        long l = System.currentTimeMillis();
        ListBuffer<Symbol.ClassSymbol> listBuffer = new ListBuffer<Symbol.ClassSymbol>();
        try {
            ListBuffer<Tree.TopLevel> listBuffer2 = new ListBuffer<Tree.TopLevel>();
            List<String> list2 = list;
            while (list2.nonEmpty()) {
                block17: {
                    if (this.classesAsDecls && !((String)list2.head).endsWith(".java")) {
                        Symbol.ClassSymbol classSymbol = this.reader.enterClass(this.names.fromString((String)list2.head));
                        try {
                            classSymbol.complete();
                        }
                        catch (Symbol.CompletionFailure completionFailure) {
                            this.bark.error(0, "CantFindClass", list2);
                            break block17;
                        }
                        listBuffer.append(classSymbol);
                    } else {
                        listBuffer2.append(this.parse((String)list2.head));
                    }
                }
                list2 = list2.tail;
            }
            list2 = listBuffer2.toList();
            if (this.errorCount() == 0) {
                this.enter.main(list2);
            }
            if (this.errorCount() == 0) {
                this.apt.main(list2, listBuffer, map, classLoader, annotationProcessorFactory, set);
                this.genSourceFileNames.addAll(this.apt.getSourceFileNames());
                this.genClassFileNames.addAll(this.apt.getClassFileNames());
            }
        }
        catch (Abort abort) {
            // empty catch block
        }
        if (this.verbose) {
            this.printVerbose("total", Long.toString(System.currentTimeMillis() - l));
        }
        if (this.chk.deprecatedSource != null && !this.deprecation) {
            this.noteDeprecated(this.chk.deprecatedSource);
        }
        if (this.chk.uncheckedSource != null && !this.warnunchecked) {
            this.makeNotes(this.chk.uncheckedSource.toString());
        }
        if ((n = this.errorCount()) == 1) {
            this.printCount("error", n);
        } else {
            this.printCount("error.plural", n);
        }
        if (this.bark.nwarnings == 1) {
            this.printCount("warn", this.bark.nwarnings);
        } else {
            this.printCount("warn.plural", this.bark.nwarnings);
        }
        return listBuffer.toList();
    }

    Tree.ClassDef removeMethodBodies(Tree.ClassDef classDef) {
        final boolean bl = (classDef.mods.flags & 0x200L) != 0L;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MethodBodyRemover
        extends TreeTranslator {
            MethodBodyRemover() {
            }

            @Override
            public void visitMethodDef(Tree.MethodDef methodDef) {
                methodDef.mods.flags &= 0xFFFFFFFFFFFFFFDFL;
                for (Tree.VarDef varDef : methodDef.params) {
                    varDef.mods.flags &= 0xFFFFFFFFFFFFFFEFL;
                }
                methodDef.body = null;
                super.visitMethodDef(methodDef);
            }

            @Override
            public void visitVarDef(Tree.VarDef varDef) {
                if (varDef.init != null && varDef.init.type.constValue == null) {
                    varDef.init = null;
                }
                super.visitVarDef(varDef);
            }

            @Override
            public void visitClassDef(Tree.ClassDef classDef) {
                ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
                List<Tree> list = classDef.defs;
                while (list.tail != null) {
                    Tree tree = (Tree)list.head;
                    switch (tree.tag) {
                        case 3: {
                            if (!bl && (((Tree.ClassDef)tree).mods.flags & 5L) == 0L && ((((Tree.ClassDef)tree).mods.flags & 2L) != 0L || ((Tree.ClassDef)tree).sym.packge().fullName() != JavaCompiler.this.names.java_lang)) break;
                            listBuffer.append(tree);
                            break;
                        }
                        case 4: {
                            if (!bl && (((Tree.MethodDef)tree).mods.flags & 5L) == 0L && ((Tree.MethodDef)tree).sym.name != JavaCompiler.this.names.init && ((((Tree.MethodDef)tree).mods.flags & 2L) != 0L || ((Tree.MethodDef)tree).sym.packge().fullName() != JavaCompiler.this.names.java_lang)) break;
                            listBuffer.append(tree);
                            break;
                        }
                        case 5: {
                            if (!bl && (((Tree.VarDef)tree).mods.flags & 5L) == 0L && ((((Tree.VarDef)tree).mods.flags & 2L) != 0L || ((Tree.VarDef)tree).sym.packge().fullName() != JavaCompiler.this.names.java_lang)) break;
                            listBuffer.append(tree);
                            break;
                        }
                    }
                    list = list.tail;
                }
                classDef.defs = listBuffer.toList();
                super.visitClassDef(classDef);
            }
        }
        MethodBodyRemover methodBodyRemover = new MethodBodyRemover();
        return (Tree.ClassDef)methodBodyRemover.translate(classDef);
    }

    public void close() {
        this.log.flush();
        this.bark.flush();
        this.reader.close();
        this.names.dispose();
    }

    private void printVerbose(String string, Object object) {
        Bark.printLines(this.bark.noticeWriter, Bark.getLocalizedString("verbose." + string, object));
    }

    private void noteDeprecated(Object object) {
        if (object.equals("*")) {
            this.bark.note("deprecated.plural", new Object[0]);
        } else {
            this.bark.note("deprecated.filename", object);
        }
        this.bark.note("deprecated.recompile", new Object[0]);
    }

    void makeNotes(Object object) {
        if (object.toString().equals("*")) {
            this.bark.note("unchecked.plural", new Object[0]);
        } else {
            this.bark.note("unchecked.filename", object);
        }
        this.bark.note("unchecked.recompile", new Object[0]);
    }

    void printCount(String string, int n) {
        if (n != 0) {
            Bark.printLines(this.bark.errWriter, Bark.getLocalizedString("count." + string, Integer.toString(n)));
            this.bark.errWriter.flush();
        }
    }

    static class AptClassReader
    extends ClassReader {
        public static AptClassReader instance0(Context context) {
            ClassReader classReader = (ClassReader)context.get(classReaderKey);
            if (classReader == null) {
                classReader = new AptClassReader(context);
            }
            return (AptClassReader)classReader;
        }

        public static void preRegister(final Context context) {
            context.put(classReaderKey, new Context.Factory<ClassReader>(){

                @Override
                public ClassReader make() {
                    return new AptClassReader(context);
                }
            });
        }

        private AptClassReader(Context context) {
            super(context, true);
        }

        protected FileEntry preferredFileEntry(FileEntry fileEntry, FileEntry fileEntry2) {
            return fileEntry;
        }
    }
}

