/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.mpa;

import com.sun.media.codec.audio.mpa.MPAHeader;

public class MPAParse {
    private static int MPA_MAX_BYTES_IN_FRAME = 2024;
    private static int MPA_MIN_BYTES_IN_FRAME = 21;
    private static int MPA_NSAMP = 1152;
    private static int MPA_LAYER1 = 3;
    private static int MPA_LAYER2 = 2;
    private static int MPA_LAYER3 = 1;
    private static int MPA_MPEG1 = 1;
    private static int MPA_MPEG2 = 0;
    private static int MPA_MONO = 3;
    public static int[][] SAMPLE_TABLE = new int[][]{{22050, 24000, 16000, 0}, {44100, 48000, 32000, 0}};
    public static int[][] BITRATE_TABLE1 = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, -1}, {0, 32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384, -1}, {0, 32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448, -1}};
    public static int[][] BITRATE_TABLE2 = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1}, {0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256, -1}};
    private static int[] MAX_FREE_BITS = new int[]{0, 11520, 13824, 5376};
    public static int[] SLOT_BITS_MASK = new int[]{0, 7, 7, 31};
    public static int[][] SAMPLES_PER_FRAME = new int[][]{{0, 576, 1152, 384}, {0, 1152, 1152, 384}};
    public static int MPA_OK = 0;
    public static int MPA_HDR_DOUBTED = 1;
    public static int MPA_ERR_LOWBUFFER = -1;
    public static int MPA_ERR_NULLPTR = -2;
    public static int MPA_ERR_NOHDR = -3;
    private boolean firstFound = false;
    private int firstId = 0;
    private int firstLayer = 0;
    private int firstSamplingRate = 0;

    public String getName() {
        return "MPEG Audio Parser";
    }

    public void reset() {
        this.firstFound = false;
        this.firstId = 0;
        this.firstLayer = 0;
        this.firstSamplingRate = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getHeader(MPAHeader mPAHeader, byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        block28: {
            n15 = MPA_ERR_NOHDR;
            boolean bl = false;
            n14 = n2;
            n13 = 0;
            if (n3 < 4) {
                return n15;
            }
            n12 = n14 + n3;
            block2: while (true) {
                if ((byArray[n14] & 0xFF) != 255 || (byArray[n14 + 1] & 0xF6) <= 240 || (byArray[n14 + 2] & 0xF0) == 240 || (byArray[n14 + 2] & 0xC) == 12 || (byArray[n14 + 3] & 3) == 2) {
                    if (++n14 + 3 < n12) continue;
                    if (!bl) {
                        return n15;
                    }
                    break block28;
                }
                n11 = byArray[n14 + 1] >> 3 & 1;
                n10 = byArray[n14 + 1] >> 1 & 3;
                n9 = byArray[n14 + 1] & 1;
                n8 = byArray[n14 + 2] >> 4 & 0xF;
                n7 = byArray[n14 + 2] >> 2 & 3;
                n6 = byArray[n14 + 2] >> 1 & 1;
                n5 = byArray[n14 + 3] >> 6 & 3;
                int n16 = SAMPLES_PER_FRAME[n11][n10];
                int n17 = SAMPLE_TABLE[n11][n7];
                if (n8 != 0) {
                    n4 = (n11 == MPA_MPEG1 ? BITRATE_TABLE1[n10][n8] : BITRATE_TABLE2[n10][n8]) * 1000 * n16 / n17 & ~SLOT_BITS_MASK[n10];
                    if (n6 != 0) {
                        n4 += SLOT_BITS_MASK[n10] + 1;
                    }
                    if ((n13 = n14 + (n4 >> 3)) + 1 < n12) {
                        if ((byArray[n13] & 0xFF) == 255 && (byArray[n13 + 1] & 0xFE) == (byArray[n14 + 1] & 0xFE)) {
                            if (this.firstFound) {
                                if (n11 == this.firstId && n10 == this.firstLayer && n17 == this.firstSamplingRate) {
                                    mPAHeader.headerOffset = n14;
                                    bl = true;
                                    n15 = MPA_OK;
                                    break block28;
                                } else {
                                    ++n14;
                                    continue;
                                }
                            }
                            mPAHeader.headerOffset = n14;
                            bl = true;
                            n15 = MPA_OK;
                            break block28;
                        }
                        if (n14 == n2 && this.firstFound && n11 == this.firstId && n10 == this.firstLayer && n17 == this.firstSamplingRate) {
                            if (!bl) {
                                mPAHeader.headerOffset = n14;
                            }
                            bl = true;
                            n15 = MPA_HDR_DOUBTED;
                            break block28;
                        } else {
                            ++n14;
                            continue;
                        }
                    }
                    if (!bl) {
                        mPAHeader.headerOffset = n14;
                    }
                    bl = true;
                    n15 = MPA_HDR_DOUBTED;
                    ++n14;
                    continue;
                }
                n4 = MAX_FREE_BITS[n10] >> 3;
                n13 = 48;
                if (n14 + n13 + 3 >= n12) {
                    if (!bl) {
                        mPAHeader.headerOffset = n14;
                    }
                    bl = true;
                    n15 = MPA_HDR_DOUBTED;
                    ++n14;
                    continue;
                }
                try {
                    while ((byArray[n14 + n13] & 0xFF) != 255 || (byArray[n14 + n13 + 1] & 0xFE) != (byArray[n14 + 1] & 0xFE) || (byArray[n14 + n13 + 2] & 0xFC) != (byArray[n14 + 2] & 0xFC) || (byArray[n14 + n13 + 3] & 3) != 2) {
                        if (++n13 > n4) {
                            ++n14;
                            continue block2;
                        }
                        if (n14 + n13 + 3 < n12) continue;
                        if (!bl) {
                            mPAHeader.headerOffset = n14;
                        }
                        bl = true;
                        n15 = MPA_HDR_DOUBTED;
                        ++n14;
                        continue block2;
                    }
                    break;
                }
                catch (Exception exception) {
                    System.err.println("Exception: off " + n14 + " off2 " + n13 + " bufend " + n12);
                    exception.printStackTrace();
                    return MPA_ERR_NOHDR;
                }
            }
            mPAHeader.headerOffset = n14;
            bl = true;
            n15 = MPA_OK;
        }
        n14 = mPAHeader.headerOffset;
        n11 = byArray[n14 + 1] >> 3 & 1;
        n10 = byArray[n14 + 1] >> 1 & 3;
        n9 = byArray[n14 + 1] & 1;
        n8 = byArray[n14 + 2] >> 4 & 0xF;
        n7 = byArray[n14 + 2] >> 2 & 3;
        n6 = byArray[n14 + 2] >> 1 & 1;
        n5 = byArray[n14 + 3] >> 6 & 3;
        mPAHeader.layer = 4 - n10;
        mPAHeader.nSamples = SAMPLES_PER_FRAME[n11][n10];
        mPAHeader.samplingRate = SAMPLE_TABLE[n11][n7];
        mPAHeader.bitRate = n11 == MPA_MPEG1 ? BITRATE_TABLE1[n10][n8] : BITRATE_TABLE2[n10][n8];
        int n18 = mPAHeader.nChannels = n5 == MPA_MONO ? 1 : 2;
        if (mPAHeader.bitRate > 0) {
            mPAHeader.bitsInFrame = mPAHeader.bitRate * 1000 * mPAHeader.nSamples / mPAHeader.samplingRate & ~SLOT_BITS_MASK[n10];
            if (n6 != 0) {
                mPAHeader.bitsInFrame += SLOT_BITS_MASK[n10] + 1;
            }
        } else {
            mPAHeader.bitsInFrame = n15 == MPA_OK ? n13 << 3 : n12 - n14 << 3;
        }
        if (n10 == MPA_LAYER3) {
            int n19 = n4 = n9 == 1 ? 4 : 6;
            mPAHeader.negOffset = n11 == MPA_MPEG1 ? (byArray[n14 + n4] & 0xFF) << 1 | byArray[n14 + n4 + 1] >> 7 & 1 : byArray[n14 + n4] & 0xFF;
        } else {
            mPAHeader.negOffset = 0;
        }
        if (!this.firstFound && n15 == MPA_OK) {
            this.firstFound = true;
            this.firstId = n11;
            this.firstLayer = n10;
            this.firstSamplingRate = mPAHeader.samplingRate;
        }
        return n15;
    }
}

