/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser;

import com.sun.media.BasicPlugIn;
import com.sun.media.CircularBuffer;
import com.sun.media.parser.RawStreamParser;
import com.sun.media.protocol.DelegateDataSource;
import com.sun.media.rtp.Depacketizer;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.PlugInManager;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.SourceStream;

public class RawBufferParser
extends RawStreamParser {
    static final String NAMEBUFFER = "Raw video/audio buffer stream parser";
    private boolean started = false;
    static AudioFormat mpegAudio;
    static VideoFormat mpegVideo;
    static VideoFormat jpegVideo;
    static VideoFormat h261Video;
    static VideoFormat h263Video;
    static VideoFormat h263_1998Video;
    final int[] h261Widths = new int[]{176, 352};
    final int[] h261Heights = new int[]{144, 288};
    final int[] h263Widths = new int[]{0, 128, 176, 352, 704, 1408, 0, 0};
    final int[] h263Heights = new int[]{0, 96, 144, 288, 576, 1152, 0, 0};
    final float[] MPEGRateTbl = new float[]{0.0f, 23.976f, 24.0f, 25.0f, 29.97f, 30.0f, 50.0f, 59.94f, 60.0f};
    public static int[][] MPASampleTbl;

    public String getName() {
        return NAMEBUFFER;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PushBufferDataSource)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        this.streams = ((PushBufferDataSource)source).getStreams();
        if (this.streams == null) {
            throw new IOException("Got a null stream from the DataSource");
        }
        if (this.streams.length == 0) {
            throw new IOException("Got a empty stream array from the DataSource");
        }
        if (!this.supports(this.streams)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        this.source = source;
        this.streams = this.streams;
    }

    protected boolean supports(SourceStream[] streams) {
        return streams[0] != null && streams[0] instanceof PushBufferStream;
    }

    public void open() {
        if (this.tracks != null) {
            return;
        }
        this.tracks = new Track[this.streams.length];
        int i2 = 0;
        while (i2 < this.streams.length) {
            this.tracks[i2] = new FrameTrack(this, (PushBufferStream)this.streams[i2], 1);
            ++i2;
        }
    }

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                int i2 = 0;
                while (i2 < this.tracks.length) {
                    ((FrameTrack)this.tracks[i2]).stop();
                    ((FrameTrack)this.tracks[i2]).close();
                    ++i2;
                }
                this.source.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.source = null;
        }
        this.started = false;
    }

    public Track[] getTracks() {
        int i2 = 0;
        while (i2 < this.tracks.length) {
            ((FrameTrack)this.tracks[i2]).parse();
            ++i2;
        }
        return this.tracks;
    }

    public void start() throws IOException {
        int i2 = 0;
        while (i2 < this.tracks.length) {
            ((FrameTrack)this.tracks[i2]).start();
            ++i2;
        }
        this.source.start();
        this.started = true;
    }

    public void stop() {
        try {
            this.source.stop();
            int i2 = 0;
            while (i2 < this.tracks.length) {
                ((FrameTrack)this.tracks[i2]).stop();
                ++i2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.started = false;
    }

    public void reset() {
        int i2 = 0;
        while (i2 < this.tracks.length) {
            ((FrameTrack)this.tracks[i2]).reset();
            ++i2;
        }
    }

    boolean isRTPFormat(Format fmt) {
        return fmt != null && fmt.getEncoding() != null && (fmt.getEncoding().endsWith("rtp") || fmt.getEncoding().endsWith("RTP"));
    }

    static {
        NAMEBUFFER = NAMEBUFFER;
        mpegAudio = new AudioFormat("mpegaudio/rtp");
        mpegVideo = new VideoFormat("mpeg/rtp");
        jpegVideo = new VideoFormat("jpeg/rtp");
        h261Video = new VideoFormat("h261/rtp");
        h263Video = new VideoFormat("h263/rtp");
        h263_1998Video = new VideoFormat("h263-1998/rtp");
        MPASampleTbl = new int[][]{{22050, 24000, 16000, 0}, {44100, 48000, 32000, 0}};
    }

    class FrameTrack
    implements Track,
    BufferTransferHandler {
        Demultiplexer parser;
        PushBufferStream pbs;
        boolean enabled = true;
        CircularBuffer bufferQ;
        Format format = null;
        TrackListener listener;
        boolean stopped = true;
        boolean closed = false;
        boolean keyFrameFound = false;
        boolean checkDepacketizer = false;
        Depacketizer depacketizer = null;
        Object keyFrameLock = new Object();

        public FrameTrack(Demultiplexer parser, PushBufferStream pbs, int numOfBufs) {
            this.pbs = pbs;
            this.format = pbs.getFormat();
            if (RawBufferParser.this.source instanceof DelegateDataSource || !RawBufferParser.this.isRTPFormat(this.format)) {
                this.keyFrameFound = true;
            }
            this.bufferQ = new CircularBuffer(numOfBufs);
            pbs.setTransferHandler(this);
        }

        public Format getFormat() {
            return this.format;
        }

        public void setEnabled(boolean t) {
            if (t) {
                this.pbs.setTransferHandler(this);
            } else {
                this.pbs.setTransferHandler(null);
            }
            this.enabled = t;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time getDuration() {
            return this.parser.getDuration();
        }

        public Time getStartTime() {
            return new Time(0L);
        }

        public void setTrackListener(TrackListener l2) {
            this.listener = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse() {
            try {
                Object object = this.keyFrameLock;
                synchronized (object) {
                    while (!this.keyFrameFound) {
                        this.keyFrameLock.wait();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private Depacketizer findDepacketizer(String name, Format input) {
            try {
                Class cls = BasicPlugIn.getClassForName(name);
                Object obj = cls.newInstance();
                if (!(obj instanceof Depacketizer)) {
                    return null;
                }
                Depacketizer dpktizer = (Depacketizer)obj;
                if (dpktizer.setInputFormat(input) == null) {
                    return null;
                }
                dpktizer.open();
                return dpktizer;
            }
            catch (Exception e2) {
            }
            catch (Error e3) {
                // empty catch block
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean findKeyFrame(Buffer buf) {
            Format fmt;
            if (!this.checkDepacketizer) {
                Vector pnames = PlugInManager.getPlugInList(buf.getFormat(), null, 6);
                if (pnames.size() != 0) {
                    this.depacketizer = this.findDepacketizer((String)pnames.elementAt(0), buf.getFormat());
                }
                this.checkDepacketizer = true;
            }
            if ((fmt = buf.getFormat()) == null) {
                return false;
            }
            if (fmt.getEncoding() == null) {
                Object object = this.keyFrameLock;
                synchronized (object) {
                    this.keyFrameFound = true;
                    this.keyFrameLock.notifyAll();
                }
                return true;
            }
            boolean rtn = true;
            if (jpegVideo.matches(fmt)) {
                rtn = this.findJPEGKey(buf);
            } else if (h261Video.matches(fmt)) {
                rtn = this.findH261Key(buf);
            } else if (h263Video.matches(fmt)) {
                rtn = this.findH263Key(buf);
            } else if (h263_1998Video.matches(fmt)) {
                rtn = this.findH263_1998Key(buf);
            } else if (mpegVideo.matches(fmt)) {
                rtn = this.findMPEGKey(buf);
            } else if (mpegAudio.matches(fmt)) {
                rtn = this.findMPAKey(buf);
            } else if (this.depacketizer != null) {
                fmt = this.depacketizer.parse(buf);
                if (fmt != null) {
                    this.format = fmt;
                    buf.setFormat(this.format);
                    this.depacketizer.close();
                    this.depacketizer = null;
                } else {
                    rtn = false;
                }
            }
            if (rtn) {
                Object object = this.keyFrameLock;
                synchronized (object) {
                    this.keyFrameFound = true;
                    this.keyFrameLock.notifyAll();
                }
            }
            return this.keyFrameFound;
        }

        public boolean findJPEGKey(Buffer b2) {
            if ((b2.getFlags() & 0x800) == 0) {
                return false;
            }
            byte[] data = (byte[])b2.getData();
            int width = (data[b2.getOffset() + 6] & 0xFF) * 8;
            int height = (data[b2.getOffset() + 7] & 0xFF) * 8;
            this.format = new VideoFormat("jpeg/rtp", new Dimension(width, height), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
            b2.setFormat(this.format);
            return true;
        }

        public boolean findH261Key(Buffer b2) {
            int skipBytes;
            byte[] data = (byte[])b2.getData();
            if (data == null) {
                return false;
            }
            int offset = b2.getOffset();
            if (data[offset + (skipBytes = 4)] != 0 || data[offset + skipBytes + 1] != 1 || (data[offset + skipBytes + 2] & 0xFC) != 0) {
                return false;
            }
            int s = data[offset + skipBytes + 3] >> 3 & 1;
            int width = RawBufferParser.this.h261Widths[s];
            int height = RawBufferParser.this.h261Heights[s];
            this.format = new VideoFormat("h261/rtp", new Dimension(width, height), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
            b2.setFormat(this.format);
            return true;
        }

        public boolean findH263Key(Buffer b2) {
            byte[] data = (byte[])b2.getData();
            if (data == null) {
                return false;
            }
            int payloadLen = this.getH263PayloadHeaderLength(data, b2.getOffset());
            int offset = b2.getOffset();
            if (data[offset + payloadLen] != 0 || data[offset + payloadLen + 1] != 0 || (data[offset + payloadLen + 2] & 0xFC) != 128) {
                return false;
            }
            int s = data[offset + payloadLen + 4] >> 2 & 7;
            int width = RawBufferParser.this.h263Widths[s];
            int height = RawBufferParser.this.h263Heights[s];
            this.format = new VideoFormat("h263/rtp", new Dimension(width, height), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
            b2.setFormat(this.format);
            return true;
        }

        int getH263PayloadHeaderLength(byte[] input, int offset) {
            int l2 = 0;
            byte b2 = input[offset];
            l2 = (b2 & 0x80) != 0 ? ((b2 & 0x40) != 0 ? 12 : 8) : 4;
            return l2;
        }

        public boolean findH263_1998Key(Buffer b2) {
            int s = -1;
            int picOffset = -1;
            byte[] data = (byte[])b2.getData();
            if (data == null) {
                return false;
            }
            int offset = b2.getOffset();
            int payloadLen = 2 + ((data[offset] & 1) << 5 | (data[offset + 1] & 0xF8) >> 3);
            if ((data[offset] & 2) != 0) {
                ++payloadLen;
            }
            picOffset = -1;
            if (payloadLen > 5) {
                if ((data[offset] & 2) == 2 && (data[offset + 3] & 0xFC) == 128) {
                    picOffset = offset + 3;
                } else if ((data[offset + 2] & 0xFC) == 128) {
                    picOffset = offset + 2;
                }
            } else if ((data[offset] & 4) == 4 && (data[offset + payloadLen] & 0xFC) == 128) {
                picOffset = offset + payloadLen;
            }
            if (picOffset < 0) {
                return false;
            }
            s = data[picOffset + 2] >> 2 & 7;
            if (s == 7) {
                if ((data[picOffset + 3] >> 1 & 7) == 1) {
                    s = data[picOffset + 3] << 2 & 4 | data[picOffset + 4] >> 6 & 3;
                } else {
                    return false;
                }
            }
            if (s < 0) {
                return false;
            }
            int width = RawBufferParser.this.h263Widths[s];
            int height = RawBufferParser.this.h263Heights[s];
            this.format = new VideoFormat("h263-1998/rtp", new Dimension(width, height), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
            b2.setFormat(this.format);
            return true;
        }

        public boolean findMPEGKey(Buffer b2) {
            byte[] data = (byte[])b2.getData();
            if (data == null) {
                return false;
            }
            int off = b2.getOffset();
            if (b2.getLength() < 12) {
                return false;
            }
            if ((data[off + 2] & 0x20) != 32) {
                return false;
            }
            if (data[off + 4] != 0 || data[off + 5] != 0 || data[off + 6] != 1 || (data[off + 7] & 0xFF) != 179) {
                return false;
            }
            int frix = data[off + 11] & 0xF;
            if (frix == 0 || frix > 8) {
                return false;
            }
            int width = (data[off + 8] & 0xFF) << 4 | (data[off + 9] & 0xF0) >> 4;
            int height = (data[off + 9] & 0xF) << 8 | data[off + 10] & 0xFF;
            float frameRate = RawBufferParser.this.MPEGRateTbl[frix];
            this.format = new VideoFormat("mpeg/rtp", new Dimension(width, height), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), frameRate);
            b2.setFormat(this.format);
            return true;
        }

        public boolean findMPAKey(Buffer b2) {
            byte[] data = (byte[])b2.getData();
            if (data == null) {
                return false;
            }
            int off = b2.getOffset();
            if (b2.getLength() < 8) {
                return false;
            }
            if (data[off + 2] != 0 || data[off + 3] != 0) {
                return false;
            }
            if ((data[off += 4] & 0xFF) != 255 || (data[off + 1] & 0xF6) <= 240 || (data[off + 2] & 0xF0) == 240 || (data[off + 2] & 0xC) == 12 || (data[off + 3] & 3) == 2) {
                return false;
            }
            int id = data[off + 1] >> 3 & 1;
            int six = data[off + 2] >> 2 & 3;
            int channels = (data[off + 3] >> 6 & 3) == 3 ? 1 : 2;
            double sampleRate = MPASampleTbl[id][six];
            this.format = new AudioFormat("mpegaudio/rtp", sampleRate, 16, channels, 0, 1);
            b2.setFormat(this.format);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.stopped = true;
                this.bufferQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.stopped = false;
                if (RawBufferParser.this.source instanceof CaptureDevice) {
                    while (this.bufferQ.canRead()) {
                        this.bufferQ.read();
                        this.bufferQ.readReport();
                    }
                }
                this.bufferQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.setEnabled(false);
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.closed = true;
                this.bufferQ.notifyAll();
            }
        }

        public void reset() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void readFrame(Buffer buffer) {
            Buffer filled;
            if (this.stopped) {
                buffer.setDiscard(true);
                buffer.setFormat(this.format);
                return;
            }
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                while (!this.bufferQ.canRead()) {
                    try {
                        this.bufferQ.wait();
                        if (!this.stopped) continue;
                        buffer.setDiscard(true);
                        buffer.setFormat(this.format);
                        return;
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                filled = this.bufferQ.read();
            }
            Object hdr = buffer.getHeader();
            buffer.copy(filled, true);
            filled.setHeader(hdr);
            this.format = filled.getFormat();
            CircularBuffer circularBuffer2 = this.bufferQ;
            synchronized (circularBuffer2) {
                this.bufferQ.readReport();
                this.bufferQ.notifyAll();
                return;
            }
        }

        public int mapTimeToFrame(Time t) {
            return -1;
        }

        public Time mapFrameToTime(int frameNumber) {
            return new Time(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void transferData(PushBufferStream pbs) {
            CircularBuffer circularBuffer;
            Buffer buffer;
            CircularBuffer circularBuffer2 = this.bufferQ;
            synchronized (circularBuffer2) {
                while (!this.bufferQ.canWrite() && !this.closed) {
                    try {
                        this.bufferQ.wait();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                if (this.closed) {
                    return;
                }
                buffer = this.bufferQ.getEmptyBuffer();
            }
            try {
                pbs.read(buffer);
            }
            catch (IOException e3) {
                buffer.setDiscard(true);
            }
            if (!this.keyFrameFound && !this.findKeyFrame(buffer)) {
                circularBuffer = this.bufferQ;
                synchronized (circularBuffer) {
                    this.bufferQ.writeReport();
                    this.bufferQ.read();
                    this.bufferQ.readReport();
                    return;
                }
            }
            circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.bufferQ.writeReport();
                this.bufferQ.notifyAll();
                return;
            }
        }
    }
}

