/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPPacket;
import com.sun.media.rtp.RTCPReportBlock;
import java.io.DataOutputStream;
import java.io.IOException;

public class RTCPRRPacket
extends RTCPPacket {
    int ssrc;
    RTCPReportBlock[] reports;

    RTCPRRPacket(RTCPPacket rTCPPacket) {
        super(rTCPPacket);
        this.type = 201;
    }

    RTCPRRPacket(int n2, RTCPReportBlock[] rTCPReportBlockArray) {
        this.ssrc = n2;
        this.reports = rTCPReportBlockArray;
        if (rTCPReportBlockArray.length > 31) {
            throw new IllegalArgumentException("Too many reports");
        }
    }

    public String toString() {
        return "\tRTCP RR (receiver report) packet for sync source " + this.ssrc + ":\n" + RTCPReportBlock.toString(this.reports);
    }

    public int calcLength() {
        return 8 + this.reports.length * 24;
    }

    void assemble(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(128 + this.reports.length);
        dataOutputStream.writeByte(201);
        dataOutputStream.writeShort(1 + this.reports.length * 6);
        dataOutputStream.writeInt(this.ssrc);
        int n2 = 0;
        while (n2 < this.reports.length) {
            dataOutputStream.writeInt(this.reports[n2].ssrc);
            dataOutputStream.writeInt((this.reports[n2].packetslost & 0xFFFFFF) + (this.reports[n2].fractionlost << 24));
            dataOutputStream.writeInt((int)this.reports[n2].lastseq);
            dataOutputStream.writeInt(this.reports[n2].jitter);
            dataOutputStream.writeInt((int)this.reports[n2].lsr);
            dataOutputStream.writeInt((int)this.reports[n2].dlsr);
            ++n2;
        }
    }
}

