/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.ColumnData;
import com.sun.media.ui.RowData;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class ColumnList
extends Canvas
implements MouseListener,
FocusListener,
KeyListener,
ComponentListener {
    public static final int TYPE_INTEGER = 1;
    public static final int TYPE_DOUBLE = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_DATE = 4;
    private static final int MARGIN_VERT = 2;
    private static final int MARGIN_HORZ = 6;
    private static final Color COLOR_HEADER_BG;
    private static final Color COLOR_HEADER_FG;
    private static final Color COLOR_SHADOW_TOP;
    private static final Color COLOR_SHADOW_BOTTOM;
    private static final Color COLOR_SEL_BG;
    private static final Color COLOR_SEL_FG;
    private Vector vectorColumns = new Vector();
    private Vector vectorRows = new Vector();
    private boolean boolFocus = false;
    private boolean boolSetColumnWidthAsPreferred = false;
    private int nScrollPosHorz = 0;
    private int nScrollPosVert = 0;
    private int nCurrentIndex = 0;
    private int nVisibleRows = 1;
    private Font fontHeader = new Font("Dialog", 0, 12);
    private Font fontItem = new Font("Dialog", 0, 12);
    private int nHeightHeader;
    private int nHeightRow;

    public ColumnList(String[] arrColumnNames) {
        int nCount = arrColumnNames.length;
        int i2 = 0;
        while (i2 < nCount) {
            ColumnData column = new ColumnData(arrColumnNames[i2], 3);
            this.vectorColumns.addElement(column);
            ++i2;
        }
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void addRow(Object[] arrValues) {
        RowData rowData = new RowData(arrValues);
        this.vectorRows.addElement(rowData);
        this.repaint();
    }

    public void removeRow(int nRowIndex) {
        this.vectorRows.removeElementAt(nRowIndex);
        this.repaint();
    }

    public void setCellValue(Object value, int nRowIndex, int nColumnIndex) {
        RowData rowData = (RowData)this.vectorRows.elementAt(nRowIndex);
        rowData.setValue(value, nColumnIndex);
        this.repaint();
    }

    public void setColumnWidth(int nWidth, int nColumnIndex) {
        ColumnData columnData = (ColumnData)this.vectorColumns.elementAt(nColumnIndex);
        columnData.nWidth = nWidth;
        this.repaint();
    }

    public void setColumnWidth(int nWidth) {
        int nCount = this.vectorColumns.size();
        int i2 = 0;
        while (i2 < nCount) {
            ColumnData columnData = (ColumnData)this.vectorColumns.elementAt(i2);
            columnData.nWidth = nWidth;
            ++i2;
        }
        this.repaint();
    }

    public void setColumnWidthAsPreferred(int nColumnIndex) {
        int nWidth;
        ColumnData columnData = (ColumnData)this.vectorColumns.elementAt(nColumnIndex);
        columnData.nWidth = nWidth = this.getPreferredColumnWidth(nColumnIndex);
        this.repaint();
    }

    public void setColumnWidthAsPreferred() {
        ColumnData columnData;
        int nCount = this.vectorColumns.size();
        int nWidthTotal = 0;
        int i2 = 0;
        while (i2 < nCount) {
            int nWidth;
            columnData = (ColumnData)this.vectorColumns.elementAt(i2);
            columnData.nWidth = nWidth = this.getPreferredColumnWidth(i2);
            nWidthTotal += nWidth;
            ++i2;
        }
        Rectangle rect = this.getBounds();
        if (rect.width < 1) {
            this.boolSetColumnWidthAsPreferred = true;
        }
        rect.width -= 2;
        if (rect.width > nWidthTotal) {
            int nWidthExtra = (rect.width - nWidthTotal) / nCount;
            nWidthTotal = rect.width;
            i2 = 0;
            while (i2 < nCount) {
                columnData = (ColumnData)this.vectorColumns.elementAt(i2);
                columnData.nWidth = i2 < nCount - 1 ? (columnData.nWidth += nWidthExtra) : nWidthTotal;
                nWidthTotal -= columnData.nWidth;
                ++i2;
            }
        }
        this.repaint();
    }

    public Dimension getPreferredSize() {
        Dimension dim = new Dimension();
        dim.height += this.nHeightHeader;
        int nHeight = this.nHeightRow;
        dim.height += (nHeight *= this.vectorRows.size());
        int nCount = this.vectorColumns.size();
        int i2 = 0;
        while (i2 < nCount) {
            int nWidth = this.getPreferredColumnWidth(i2);
            dim.width += nWidth;
            ++i2;
        }
        dim.width += 3;
        dim.height += 3;
        return dim;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void update(Graphics g2) {
        Rectangle rectClient = this.getBounds();
        Image image = this.createImage(rectClient.width, rectClient.height);
        Graphics graphics = image != null ? image.getGraphics() : g2;
        this.paint(graphics);
        if (image != null) {
            g2.drawImage(image, 0, 0, this);
        }
    }

    public void paint(Graphics graphics) {
        int nY;
        int nX;
        int nWidth;
        int nLength;
        String strValue;
        ColumnData columnData;
        Rectangle rectClient = this.getBounds();
        rectClient.x = 0;
        rectClient.y = 0;
        Rectangle rect = new Rectangle(rectClient);
        super.paint(graphics);
        graphics.setColor(COLOR_SHADOW_BOTTOM);
        graphics.drawRect(rect.x, rect.y, rect.width - 2, rect.height - 2);
        graphics.setColor(COLOR_SHADOW_TOP);
        graphics.drawLine(rect.x + rect.width - 1, rect.y + 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
        graphics.drawLine(rect.x + 1, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
        int nColCount = this.vectorColumns.size();
        int nRowCount = this.vectorRows.size();
        ++rect.x;
        ++rect.y;
        int nStartX = rect.x;
        FontMetrics fontMetrics = this.getFontMetrics(this.fontHeader);
        graphics.setFont(this.fontHeader);
        int nHeight = fontMetrics.getHeight();
        rect.height = this.nHeightHeader;
        int i2 = this.nScrollPosHorz;
        while (i2 < nColCount) {
            columnData = (ColumnData)this.vectorColumns.elementAt(i2);
            rect.width = columnData.nWidth;
            if (rect.x + rect.width > rectClient.x + rectClient.width - 1) {
                rect.width = rectClient.x + rectClient.width - 1 - rect.x;
            }
            graphics.setColor(COLOR_HEADER_BG);
            graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
            graphics.setColor(COLOR_SHADOW_TOP);
            graphics.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 2);
            graphics.drawLine(rect.x, rect.y, rect.x + rect.width - 2, rect.y);
            graphics.setColor(COLOR_SHADOW_BOTTOM);
            graphics.drawLine(rect.x + rect.width - 1, rect.y + 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
            graphics.drawLine(rect.x + 1, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
            strValue = columnData.strName;
            nLength = strValue.length();
            nWidth = fontMetrics.stringWidth(strValue);
            while (nWidth > rect.width - 12 && nLength > 0) {
                strValue = strValue.substring(0, --nLength) + "...";
                nWidth = fontMetrics.stringWidth(strValue);
            }
            nX = rect.x + (rect.width - nWidth) / 2;
            nY = rect.y + rect.height - (rect.height - nHeight) / 2 - fontMetrics.getMaxDescent();
            graphics.setColor(this.getForeground());
            graphics.drawString(strValue, nX, nY);
            rect.x += rect.width;
            ++i2;
        }
        Font font = this.getFont();
        fontMetrics = this.getFontMetrics(font);
        graphics.setFont(font);
        nHeight = fontMetrics.getHeight();
        rect.y += rect.height;
        rect.height = this.nHeightRow;
        int j2 = this.nScrollPosVert;
        while (j2 < nRowCount) {
            rect.x = nStartX;
            if (j2 == this.nCurrentIndex) {
                rect.width = rectClient.width - 3;
                graphics.setColor(COLOR_SEL_BG);
                graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
                graphics.setColor(COLOR_SEL_FG);
                if (this.boolFocus) {
                    this.drawDottedLine(graphics, rect.x, rect.y, rect.x + rect.width - 1, rect.y);
                    this.drawDottedLine(graphics, rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
                }
            } else {
                graphics.setColor(this.getForeground());
            }
            RowData rowData = (RowData)this.vectorRows.elementAt(j2);
            i2 = this.nScrollPosHorz;
            while (i2 < nColCount) {
                columnData = (ColumnData)this.vectorColumns.elementAt(i2);
                rect.width = columnData.nWidth;
                if (rect.x + rect.width > rectClient.x + rectClient.width - 1) {
                    rect.width = rectClient.x + rectClient.width - 1 - rect.x;
                }
                strValue = rowData.getValue(i2).toString();
                nLength = strValue.length();
                nWidth = fontMetrics.stringWidth(strValue);
                while (nWidth > rect.width - 12 && nLength > 0) {
                    strValue = strValue.substring(0, --nLength) + "...";
                    nWidth = fontMetrics.stringWidth(strValue);
                }
                nX = rect.x + 6;
                nY = rect.y + rect.height - (rect.height - nHeight) / 2 - fontMetrics.getMaxDescent();
                graphics.drawString(strValue, nX, nY);
                rect.x += rect.width;
                ++i2;
            }
            rect.y += rect.height;
            ++j2;
        }
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        int nIndex;
        int x = event.getX();
        int y = event.getY();
        if ((y -= 1 + this.nHeightHeader) >= 0 && (nIndex = y / this.nHeightRow) >= 0 && nIndex < this.vectorRows.size() - this.nScrollPosVert) {
            this.nCurrentIndex = nIndex + this.nScrollPosVert;
        }
        this.requestFocus();
        this.repaint();
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        int nKeyCode = event.getKeyCode();
        int nIndex = this.nCurrentIndex;
        if (nKeyCode == 40) {
            ++nIndex;
        } else if (nKeyCode == 38) {
            --nIndex;
        } else if (nKeyCode == 36) {
            nIndex = 0;
        } else if (nKeyCode == 35) {
            nIndex = this.vectorRows.size() - 1;
        } else if (nKeyCode == 33) {
            nIndex -= this.nVisibleRows;
        } else if (nKeyCode == 34) {
            nIndex += this.nVisibleRows;
        }
        if (nIndex > this.vectorRows.size() - 1) {
            nIndex = this.vectorRows.size() - 1;
        }
        if (nIndex < 0) {
            nIndex = 0;
        }
        if (nIndex != this.nCurrentIndex) {
            this.nCurrentIndex = nIndex;
            if (this.nScrollPosVert + this.nVisibleRows < this.nCurrentIndex) {
                this.nScrollPosVert = this.nCurrentIndex - this.nVisibleRows + 1;
            }
            if (this.nScrollPosVert > this.nCurrentIndex) {
                this.nScrollPosVert = this.nCurrentIndex;
            }
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void focusGained(FocusEvent event) {
        if (this.boolFocus) {
            return;
        }
        this.boolFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent event) {
        if (!this.boolFocus) {
            return;
        }
        this.boolFocus = false;
        this.repaint();
    }

    public void componentResized(ComponentEvent event) {
        if (this.boolSetColumnWidthAsPreferred) {
            this.boolSetColumnWidthAsPreferred = false;
            this.setColumnWidthAsPreferred();
        }
        Rectangle rect = this.getBounds();
        rect.height -= 3 + this.nHeightHeader;
        this.nVisibleRows = rect.height / this.nHeightRow;
        if (this.nVisibleRows < 1) {
            this.nVisibleRows = 1;
        }
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void componentShown(ComponentEvent event) {
    }

    public void componentHidden(ComponentEvent event) {
    }

    private void init() throws Exception {
        this.setFont(this.fontItem);
        this.computeHeights();
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addComponentListener(this);
    }

    private int getPreferredColumnWidth(int nColumnIndex) {
        ColumnData columnData = (ColumnData)this.vectorColumns.elementAt(nColumnIndex);
        FontMetrics fontMetrics = this.getFontMetrics(this.fontHeader);
        String strValue = columnData.strName;
        int nWidthMax = fontMetrics.stringWidth(strValue) + 12 + 2;
        Font font = this.getFont();
        fontMetrics = this.getFontMetrics(font);
        int nCount = this.vectorRows.size();
        int i2 = 0;
        while (i2 < nCount) {
            RowData rowData = (RowData)this.vectorRows.elementAt(i2);
            strValue = rowData.getValue(nColumnIndex).toString();
            int nWidth = fontMetrics.stringWidth(strValue) + 12;
            nWidthMax = Math.max(nWidthMax, nWidth);
            ++i2;
        }
        return nWidthMax;
    }

    private void computeHeights() {
        FontMetrics fontMetrics = this.getFontMetrics(this.fontHeader);
        this.nHeightHeader = fontMetrics.getHeight();
        this.nHeightHeader += 2;
        this.nHeightHeader += 4;
        Font font = this.getFont();
        fontMetrics = this.getFontMetrics(font);
        this.nHeightRow = fontMetrics.getHeight();
        this.nHeightRow += 4;
    }

    private void drawDottedLine(Graphics graphics, int nX1, int nY1, int nX2, int nY2) {
        int nY;
        int nX;
        if (nX1 == nX2 && nY1 == nY2) {
            this.drawDot(graphics, nX1, nY1);
            return;
        }
        if (nX1 > nX2) {
            nX = nX1;
            nX1 = nX2;
            nX2 = nX;
        }
        if (nY1 > nY2) {
            nY = nY1;
            nY1 = nY2;
            nY2 = nY;
        }
        if (nX2 - nX1 > nY2 - nY1) {
            double dDiv = (double)(nY2 - nY1) / (double)(nX2 - nX1);
            nX = nX1;
            while (nX <= nX2) {
                nY = (int)Math.rint((double)nY1 + (double)(nX - nX1) * dDiv);
                this.drawDot(graphics, nX, nY);
                ++nX;
            }
        } else {
            double dDiv = (nX2 - nX1) / (nY2 - nY1);
            nY = nY1;
            while (nY <= nY2) {
                nX = (int)Math.rint((double)nX1 + (double)(nY - nY1) * dDiv);
                this.drawDot(graphics, nX, nY);
                ++nY;
            }
        }
    }

    private void drawDot(Graphics graphics, int nX, int nY) {
        if ((nX + nY) % 2 == 0) {
            graphics.drawLine(nX, nY, nX, nY);
        }
    }

    static {
        TYPE_INTEGER = 1;
        TYPE_DOUBLE = 2;
        TYPE_STRING = 3;
        TYPE_DATE = 4;
        MARGIN_VERT = 2;
        MARGIN_HORZ = 6;
        COLOR_HEADER_BG = Color.lightGray;
        COLOR_HEADER_FG = Color.black;
        COLOR_SHADOW_TOP = Color.white;
        COLOR_SHADOW_BOTTOM = Color.darkGray;
        COLOR_SEL_BG = Color.white;
        COLOR_SEL_FG = Color.black;
    }
}

