/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Constants;

class Instruction
implements Constants {
    protected byte[] bytes;
    protected int pc;
    protected int bc;
    protected int w;
    protected int length;
    protected boolean special;
    private static final byte[][] BC_LENGTH;
    private static final byte[][] BC_INDEX;
    private static final byte[][] BC_TAG;
    private static final byte[][] BC_BRANCH;
    private static final byte[][] BC_SLOT;
    private static final byte[][] BC_CON;
    private static final String[] BC_NAME;
    private static final String[][] BC_FORMAT;
    private static int BW;

    protected Instruction(byte[] byArray, int n2, int n3, int n4, int n5) {
        this.reset(byArray, n2, n3, n4, n5);
    }

    private void reset(byte[] byArray, int n2, int n3, int n4, int n5) {
        this.bytes = byArray;
        this.pc = n2;
        this.bc = n3;
        this.w = n4;
        this.length = n5;
    }

    public int getBC() {
        return this.bc;
    }

    public boolean isWide() {
        return this.w != 0;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getPC() {
        return this.pc;
    }

    public int getLength() {
        return this.length;
    }

    public int getNextPC() {
        return this.pc + this.length;
    }

    public Instruction next() {
        int n2 = this.pc + this.length;
        if (n2 == this.bytes.length) {
            return null;
        }
        return Instruction.at(this.bytes, n2, this);
    }

    public Instruction forceNextPC(int n2) {
        int n3 = n2 - this.pc;
        return new Instruction(this.bytes, this.pc, -1, -1, n3);
    }

    public static Instruction at(byte[] byArray, int n2) {
        return Instruction.at(byArray, n2, null);
    }

    public static Instruction at(byte[] byArray, int n2, Instruction instruction) {
        int n3 = Instruction.getByte(byArray, n2);
        int n4 = -1;
        int n5 = 0;
        byte by = BC_LENGTH[n5][n3];
        if (by == 0) {
            switch (n3) {
                case 196: {
                    n3 = Instruction.getByte(byArray, n2 + 1);
                    n5 = 1;
                    by = BC_LENGTH[n5][n3];
                    if (by != 0) break;
                    by = 1;
                    break;
                }
                case 170: {
                    return new TableSwitch(byArray, n2);
                }
                case 171: {
                    return new LookupSwitch(byArray, n2);
                }
                default: {
                    by = 1;
                }
            }
        }
        assert (by > 0);
        assert (n2 + by <= byArray.length);
        if (instruction != null && !instruction.special) {
            instruction.reset(byArray, n2, n3, n5, by);
            return instruction;
        }
        return new Instruction(byArray, n2, n3, n5, by);
    }

    public byte getCPTag() {
        return BC_TAG[this.w][this.bc];
    }

    public int getCPIndex() {
        byte by = BC_INDEX[this.w][this.bc];
        if (by == 0) {
            return -1;
        }
        assert (this.w == 0);
        if (this.length == 2) {
            return Instruction.getByte(this.bytes, this.pc + by);
        }
        return Instruction.getShort(this.bytes, this.pc + by);
    }

    public void setCPIndex(int n2) {
        byte by = BC_INDEX[this.w][this.bc];
        assert (by != 0);
        if (this.length == 2) {
            Instruction.setByte(this.bytes, this.pc + by, n2);
        } else {
            Instruction.setShort(this.bytes, this.pc + by, n2);
        }
        assert (this.getCPIndex() == n2);
    }

    public ConstantPool.Entry getCPRef(ConstantPool.Entry[] entryArray) {
        int n2 = this.getCPIndex();
        return n2 < 0 ? null : entryArray[n2];
    }

    public int getLocalSlot() {
        byte by = BC_SLOT[this.w][this.bc];
        if (by == 0) {
            return -1;
        }
        if (this.w == 0) {
            return Instruction.getByte(this.bytes, this.pc + by);
        }
        return Instruction.getShort(this.bytes, this.pc + by);
    }

    public int getBranchLabel() {
        byte by = BC_BRANCH[this.w][this.bc];
        if (by == 0) {
            return -1;
        }
        assert (this.w == 0);
        assert (this.length == 3 || this.length == 5);
        int n2 = this.length == 3 ? (int)((short)Instruction.getShort(this.bytes, this.pc + by)) : Instruction.getInt(this.bytes, this.pc + by);
        assert (n2 + this.pc >= 0);
        assert (n2 + this.pc <= this.bytes.length);
        return n2 + this.pc;
    }

    public void setBranchLabel(int n2) {
        byte by = BC_BRANCH[this.w][this.bc];
        assert (by != 0);
        if (this.length == 3) {
            Instruction.setShort(this.bytes, this.pc + by, n2 - this.pc);
        } else {
            Instruction.setInt(this.bytes, this.pc + by, n2 - this.pc);
        }
        assert (n2 == this.getBranchLabel());
    }

    public int getConstant() {
        byte by = BC_CON[this.w][this.bc];
        if (by == 0) {
            return 0;
        }
        switch (this.length - by) {
            case 1: {
                return (byte)Instruction.getByte(this.bytes, this.pc + by);
            }
            case 2: {
                return (short)Instruction.getShort(this.bytes, this.pc + by);
            }
        }
        assert (false);
        return 0;
    }

    public void setConstant(int n2) {
        byte by = BC_CON[this.w][this.bc];
        assert (by != 0);
        switch (this.length - by) {
            case 1: {
                Instruction.setByte(this.bytes, this.pc + by, n2);
                break;
            }
            case 2: {
                Instruction.setShort(this.bytes, this.pc + by, n2);
            }
        }
        assert (n2 == this.getConstant());
    }

    public boolean equals(Object object) {
        return object instanceof Instruction && this.equals((Instruction)object);
    }

    public boolean equals(Instruction instruction) {
        if (this.bc != instruction.bc) {
            return false;
        }
        if (this.w != instruction.w) {
            return false;
        }
        if (this.length != instruction.length) {
            return false;
        }
        for (int i2 = 1; i2 < this.length; ++i2) {
            if (this.bytes[this.pc + i2] == instruction.bytes[instruction.pc + i2]) continue;
            return false;
        }
        return true;
    }

    static String labstr(int n2) {
        if (n2 >= 0 && n2 < 100000) {
            return (100000 + n2 + "").substring(1);
        }
        return n2 + "";
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(ConstantPool.Entry[] entryArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        String string = Instruction.labstr(this.pc) + ": ";
        if (this.bc >= 202) {
            string = string + Integer.toHexString(this.bc);
            return string;
        }
        if (this.w == 1) {
            string = string + " wide";
        }
        string = string + BC_NAME[this.bc];
        byte by = this.getCPTag();
        if (by != 0) {
            string = string + " " + ConstantPool.tagName(by) + ":";
        }
        if ((n5 = this.getCPIndex()) >= 0) {
            string = string + (entryArray == null ? "" + n5 : "=" + entryArray[n5].stringValue());
        }
        if ((n4 = this.getLocalSlot()) >= 0) {
            string = string + " Local:" + n4;
        }
        if ((n3 = this.getBranchLabel()) >= 0) {
            string = string + " To:" + Instruction.labstr(n3);
        }
        if ((n2 = this.getConstant()) != 0) {
            string = string + " Con:" + n2;
        }
        return string;
    }

    public static int getInt(byte[] byArray, int n2) {
        return (Instruction.getShort(byArray, n2 + 0) << 16) + (Instruction.getShort(byArray, n2 + 2) << 0);
    }

    public static int getShort(byte[] byArray, int n2) {
        return (Instruction.getByte(byArray, n2 + 0) << 8) + (Instruction.getByte(byArray, n2 + 1) << 0);
    }

    public static int getByte(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF;
    }

    public static void setInt(byte[] byArray, int n2, int n3) {
        Instruction.setShort(byArray, n2 + 0, n3 >> 16);
        Instruction.setShort(byArray, n2 + 2, n3 >> 0);
    }

    public static void setShort(byte[] byArray, int n2, int n3) {
        Instruction.setByte(byArray, n2 + 0, n3 >> 8);
        Instruction.setByte(byArray, n2 + 1, n3 >> 0);
    }

    public static void setByte(byte[] byArray, int n2, int n3) {
        byArray[n2] = (byte)n3;
    }

    public static int opLength(int n2) {
        byte by = BC_LENGTH[0][n2];
        assert (by > 0);
        return by;
    }

    public static int opWideLength(int n2) {
        byte by = BC_LENGTH[1][n2];
        assert (by > 0);
        return by;
    }

    public static boolean isLocalSlotOp(int n2) {
        return n2 < BC_SLOT[0].length && BC_SLOT[0][n2] > 0;
    }

    public static boolean isBranchOp(int n2) {
        return n2 < BC_BRANCH[0].length && BC_BRANCH[0][n2] > 0;
    }

    public static boolean isCPRefOp(int n2) {
        if (n2 < BC_INDEX[0].length && BC_INDEX[0][n2] > 0) {
            return true;
        }
        return n2 >= 233 && n2 < 240;
    }

    public static byte getCPRefOpTag(int n2) {
        if (n2 < BC_INDEX[0].length && BC_INDEX[0][n2] > 0) {
            return BC_TAG[0][n2];
        }
        if (n2 >= 233 && n2 < 240) {
            return 20;
        }
        return 0;
    }

    public static boolean isFieldOp(int n2) {
        return n2 >= 178 && n2 <= 181;
    }

    public static boolean isInvokeInitOp(int n2) {
        return n2 >= 230 && n2 < 233;
    }

    public static boolean isSelfLinkerOp(int n2) {
        return n2 >= 202 && n2 < 230;
    }

    public static String byteName(int n2) {
        String string;
        if (n2 < BC_NAME.length && BC_NAME[n2] != null) {
            string = BC_NAME[n2];
        } else if (Instruction.isSelfLinkerOp(n2)) {
            boolean bl2;
            boolean bl3;
            int n3 = n2 - 202;
            boolean bl4 = bl3 = n3 >= 14;
            if (bl3) {
                n3 -= 14;
            }
            boolean bl5 = bl2 = n3 >= 7;
            if (bl2) {
                n3 -= 7;
            }
            int n4 = 178 + n3;
            assert (n4 >= 178 && n4 <= 184);
            string = BC_NAME[n4];
            string = string + (bl3 ? "_super" : "_this");
            if (bl2) {
                string = "aload_0&" + string;
            }
            string = "*" + string;
        } else if (Instruction.isInvokeInitOp(n2)) {
            int n5 = n2 - 230;
            switch (n5) {
                case 0: {
                    string = "*invokespecial_init_this";
                    break;
                }
                case 1: {
                    string = "*invokespecial_init_super";
                    break;
                }
                default: {
                    assert (n5 == 2);
                    string = "*invokespecial_init_new";
                    break;
                }
            }
        } else {
            switch (n2) {
                case 234: {
                    string = "*ildc";
                    break;
                }
                case 235: {
                    string = "*fldc";
                    break;
                }
                case 237: {
                    string = "*ildc_w";
                    break;
                }
                case 238: {
                    string = "*fldc_w";
                    break;
                }
                case 239: {
                    string = "*dldc2_w";
                    break;
                }
                case 233: {
                    string = "*cldc";
                    break;
                }
                case 236: {
                    string = "*cldc_w";
                    break;
                }
                case 254: {
                    string = "*byte_escape";
                    break;
                }
                case 253: {
                    string = "*ref_escape";
                    break;
                }
                case 255: {
                    string = "*end";
                    break;
                }
                default: {
                    string = "*bc#" + n2;
                }
            }
        }
        return string;
    }

    private static void def(String string, int n2) {
        Instruction.def(string, n2, n2);
    }

    private static void def(String string, int n2, int n3) {
        String[] stringArray = new String[]{string, null};
        if (string.indexOf(119) > 0) {
            stringArray[1] = string.substring(string.indexOf(119));
            stringArray[0] = string.substring(0, string.indexOf(119));
        }
        for (int i2 = 0; i2 <= 1; ++i2) {
            string = stringArray[i2];
            if (string == null) continue;
            int n4 = string.length();
            int n5 = Math.max(0, string.indexOf(107));
            int n6 = 0;
            int n7 = Math.max(0, string.indexOf(111));
            int n8 = Math.max(0, string.indexOf(108));
            int n9 = Math.max(0, string.indexOf(120));
            if (n5 > 0 && n5 + 1 < n4) {
                switch (string.charAt(n5 + 1)) {
                    case 'c': {
                        n6 = 7;
                        break;
                    }
                    case 'k': {
                        n6 = 20;
                        break;
                    }
                    case 'f': {
                        n6 = 9;
                        break;
                    }
                    case 'm': {
                        n6 = 10;
                        break;
                    }
                    case 'i': {
                        n6 = 11;
                    }
                }
                assert (n6 != 0);
            } else if (n5 > 0 && n4 == 2) {
                assert (n2 == 18);
                n6 = 20;
            }
            for (int i3 = n2; i3 <= n3; ++i3) {
                Instruction.BC_FORMAT[i2][i3] = string;
                assert (BC_LENGTH[i2][i3] == -1);
                Instruction.BC_LENGTH[i2][i3] = (byte)n4;
                Instruction.BC_INDEX[i2][i3] = (byte)n5;
                Instruction.BC_TAG[i2][i3] = (byte)n6;
                assert (n5 != 0 || n6 == 0);
                Instruction.BC_BRANCH[i2][i3] = (byte)n7;
                Instruction.BC_SLOT[i2][i3] = (byte)n8;
                assert (n7 == 0 || n8 == 0);
                assert (n7 == 0 || n5 == 0);
                assert (n8 == 0 || n5 == 0);
                Instruction.BC_CON[i2][i3] = (byte)n9;
            }
        }
    }

    static {
        int n2;
        BC_LENGTH = new byte[2][256];
        BC_INDEX = new byte[2][256];
        BC_TAG = new byte[2][256];
        BC_BRANCH = new byte[2][256];
        BC_SLOT = new byte[2][256];
        BC_CON = new byte[2][256];
        BC_NAME = new String[256];
        BC_FORMAT = new String[2][202];
        for (n2 = 0; n2 < 202; ++n2) {
            Instruction.BC_LENGTH[0][n2] = -1;
            Instruction.BC_LENGTH[1][n2] = -1;
        }
        Instruction.def("b", 0, 15);
        Instruction.def("bx", 16);
        Instruction.def("bxx", 17);
        Instruction.def("bk", 18);
        Instruction.def("bkk", 19, 20);
        Instruction.def("blwbll", 21, 25);
        Instruction.def("b", 26, 53);
        Instruction.def("blwbll", 54, 58);
        Instruction.def("b", 59, 131);
        Instruction.def("blxwbllxx", 132);
        Instruction.def("b", 133, 152);
        Instruction.def("boo", 153, 168);
        Instruction.def("blwbll", 169);
        Instruction.def("", 170, 171);
        Instruction.def("b", 172, 177);
        Instruction.def("bkf", 178, 181);
        Instruction.def("bkm", 182, 184);
        Instruction.def("bkixx", 185);
        Instruction.def("", 186);
        Instruction.def("bkc", 187);
        Instruction.def("bx", 188);
        Instruction.def("bkc", 189);
        Instruction.def("b", 190, 191);
        Instruction.def("bkc", 192, 193);
        Instruction.def("b", 194, 195);
        Instruction.def("", 196);
        Instruction.def("bkcx", 197);
        Instruction.def("boo", 198, 199);
        Instruction.def("boooo", 200, 201);
        for (n2 = 0; n2 < 202; ++n2) {
            assert (BC_LENGTH[0][n2] != -1);
            if (BC_LENGTH[1][n2] != -1) continue;
            Instruction.BC_LENGTH[1][n2] = (byte)(1 + BC_LENGTH[0][n2]);
        }
        String string = "nop aconst_null iconst_m1 iconst_0 iconst_1 iconst_2 iconst_3 iconst_4 iconst_5 lconst_0 lconst_1 fconst_0 fconst_1 fconst_2 dconst_0 dconst_1 bipush sipush ldc ldc_w ldc2_w iload lload fload dload aload iload_0 iload_1 iload_2 iload_3 lload_0 lload_1 lload_2 lload_3 fload_0 fload_1 fload_2 fload_3 dload_0 dload_1 dload_2 dload_3 aload_0 aload_1 aload_2 aload_3 iaload laload faload daload aaload baload caload saload istore lstore fstore dstore astore istore_0 istore_1 istore_2 istore_3 lstore_0 lstore_1 lstore_2 lstore_3 fstore_0 fstore_1 fstore_2 fstore_3 dstore_0 dstore_1 dstore_2 dstore_3 astore_0 astore_1 astore_2 astore_3 iastore lastore fastore dastore aastore bastore castore sastore pop pop2 dup dup_x1 dup_x2 dup2 dup2_x1 dup2_x2 swap iadd ladd fadd dadd isub lsub fsub dsub imul lmul fmul dmul idiv ldiv fdiv ddiv irem lrem frem drem ineg lneg fneg dneg ishl lshl ishr lshr iushr lushr iand land ior lor ixor lxor iinc i2l i2f i2d l2i l2f l2d f2i f2l f2d d2i d2l d2f i2b i2c i2s lcmp fcmpl fcmpg dcmpl dcmpg ifeq ifne iflt ifge ifgt ifle if_icmpeq if_icmpne if_icmplt if_icmpge if_icmpgt if_icmple if_acmpeq if_acmpne goto jsr ret tableswitch lookupswitch ireturn lreturn freturn dreturn areturn return getstatic putstatic getfield putfield invokevirtual invokespecial invokestatic invokeinterface xxxunusedxxx new newarray anewarray arraylength athrow checkcast instanceof monitorenter monitorexit wide multianewarray ifnull ifnonnull goto_w jsr_w ";
        int n3 = 0;
        while (string.length() > 0) {
            int n4 = string.indexOf(32);
            Instruction.BC_NAME[n3] = string.substring(0, n4);
            string = string.substring(n4 + 1);
            ++n3;
        }
        BW = 4;
    }

    public static class LookupSwitch
    extends Switch {
        public int getCaseCount() {
            return this.intAt(1);
        }

        public int getCaseValue(int n2) {
            return this.intAt(2 + n2 * 2 + 0);
        }

        public int getCaseLabel(int n2) {
            return this.intAt(2 + n2 * 2 + 1) + this.pc;
        }

        public void setCaseCount(int n2) {
            this.setIntAt(1, n2);
            this.length = this.getLength(n2);
        }

        public void setCaseValue(int n2, int n3) {
            this.setIntAt(2 + n2 * 2 + 0, n3);
        }

        public void setCaseLabel(int n2, int n3) {
            this.setIntAt(2 + n2 * 2 + 1, n3 - this.pc);
        }

        LookupSwitch(byte[] byArray, int n2) {
            super(byArray, n2, 171);
        }

        protected int getLength(int n2) {
            return this.apc - this.pc + (2 + n2 * 2) * 4;
        }
    }

    public static abstract class Switch
    extends Instruction {
        protected int apc;

        public abstract int getCaseCount();

        public abstract int getCaseValue(int var1);

        public abstract int getCaseLabel(int var1);

        public abstract void setCaseCount(int var1);

        public abstract void setCaseValue(int var1, int var2);

        public abstract void setCaseLabel(int var1, int var2);

        protected abstract int getLength(int var1);

        public int getDefaultLabel() {
            return this.intAt(0) + this.pc;
        }

        public void setDefaultLabel(int n2) {
            this.setIntAt(0, n2 - this.pc);
        }

        protected int intAt(int n2) {
            return Switch.getInt(this.bytes, this.apc + n2 * 4);
        }

        protected void setIntAt(int n2, int n3) {
            Switch.setInt(this.bytes, this.apc + n2 * 4, n3);
        }

        protected Switch(byte[] byArray, int n2, int n3) {
            super(byArray, n2, n3, 0, 0);
            this.apc = Switch.alignPC(n2 + 1);
            this.special = true;
            this.length = this.getLength(this.getCaseCount());
        }

        public int getAlignedPC() {
            return this.apc;
        }

        public String toString() {
            String string = super.toString();
            string = string + " Default:" + Switch.labstr(this.getDefaultLabel());
            int n2 = this.getCaseCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                string = string + "\n\tCase " + this.getCaseValue(i2) + ":" + Switch.labstr(this.getCaseLabel(i2));
            }
            return string;
        }

        public static int alignPC(int n2) {
            while (n2 % 4 != 0) {
                ++n2;
            }
            return n2;
        }
    }

    public static class TableSwitch
    extends Switch {
        public int getLowCase() {
            return this.intAt(1);
        }

        public int getHighCase() {
            return this.intAt(2);
        }

        public int getCaseCount() {
            return this.intAt(2) - this.intAt(1) + 1;
        }

        public int getCaseValue(int n2) {
            return this.getLowCase() + n2;
        }

        public int getCaseLabel(int n2) {
            return this.intAt(3 + n2) + this.pc;
        }

        public void setLowCase(int n2) {
            this.setIntAt(1, n2);
        }

        public void setHighCase(int n2) {
            this.setIntAt(2, n2);
        }

        public void setCaseLabel(int n2, int n3) {
            this.setIntAt(3 + n2, n3 - this.pc);
        }

        public void setCaseCount(int n2) {
            this.setHighCase(this.getLowCase() + n2 - 1);
            this.length = this.getLength(n2);
        }

        public void setCaseValue(int n2, int n3) {
            if (n2 != 0) {
                throw new UnsupportedOperationException();
            }
            int n4 = this.getCaseCount();
            this.setLowCase(n3);
            this.setCaseCount(n4);
        }

        TableSwitch(byte[] byArray, int n2) {
            super(byArray, n2, 170);
        }

        protected int getLength(int n2) {
            return this.apc - this.pc + (3 + n2) * 4;
        }
    }
}

