/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.xinclude;

import com.sun.org.apache.xerces.internal.impl.XMLEntityManager;
import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.impl.io.ASCIIReader;
import com.sun.org.apache.xerces.internal.impl.io.UTF8Reader;
import com.sun.org.apache.xerces.internal.util.EncodingMap;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xerces.internal.util.XMLStringBuffer;
import com.sun.org.apache.xerces.internal.xinclude.XIncludeHandler;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;

public class XIncludeTextReader {
    private Reader fReader;
    private XIncludeHandler fHandler;
    private XMLInputSource fSource;
    private XMLErrorReporter fErrorReporter;
    private String fAccept;
    private String fAcceptLanguage;

    public XIncludeTextReader(XMLInputSource xMLInputSource, XIncludeHandler xIncludeHandler) throws IOException {
        this.fHandler = xIncludeHandler;
        this.fSource = xMLInputSource;
    }

    public void setErrorReporter(XMLErrorReporter xMLErrorReporter) {
        this.fErrorReporter = xMLErrorReporter;
    }

    public void setHttpProperties(String string, String string2) {
        this.fAccept = string;
        this.fAcceptLanguage = string2;
    }

    protected Reader getReader(XMLInputSource xMLInputSource) throws IOException {
        Object object;
        Object object2;
        String string;
        if (xMLInputSource.getCharacterStream() != null) {
            return xMLInputSource.getCharacterStream();
        }
        InputStream inputStream = null;
        String string2 = xMLInputSource.getEncoding();
        if (string2 == null) {
            string2 = "UTF-8";
        }
        if (xMLInputSource.getByteStream() != null) {
            inputStream = xMLInputSource.getByteStream();
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
        } else {
            string = XMLEntityManager.expandSystemId(xMLInputSource.getSystemId(), xMLInputSource.getBaseSystemId(), false);
            object2 = new URL(string);
            object = ((URL)object2).openConnection();
            if (object instanceof HttpURLConnection) {
                if (this.fAccept != null && this.fAccept.length() > 0) {
                    ((URLConnection)object).setRequestProperty("Accept", this.fAccept);
                }
                if (this.fAcceptLanguage != null && this.fAcceptLanguage.length() > 0) {
                    ((URLConnection)object).setRequestProperty("Accept-Language", this.fAcceptLanguage);
                }
            }
            inputStream = new BufferedInputStream(((URLConnection)object).getInputStream());
            String string3 = ((URLConnection)object).getContentType();
            int n2 = string3 != null ? string3.indexOf(59) : -1;
            String string4 = null;
            String string5 = null;
            if (n2 != -1) {
                string4 = string3.substring(0, n2).trim();
                string5 = string3.substring(n2 + 1).trim();
                if (string5.startsWith("charset=")) {
                    if ((string5 = string5.substring(8).trim()).charAt(0) == '\"' && string5.charAt(string5.length() - 1) == '\"' || string5.charAt(0) == '\'' && string5.charAt(string5.length() - 1) == '\'') {
                        string5 = string5.substring(1, string5.length() - 1);
                    }
                } else {
                    string5 = null;
                }
            } else {
                string4 = string3.trim();
            }
            String string6 = null;
            if (string4.equals("text/xml")) {
                string6 = string5 != null ? string5 : "US-ASCII";
            } else if (string4.equals("application/xml")) {
                string6 = string5 != null ? string5 : this.getEncodingName(inputStream);
            } else if (string4.endsWith("+xml")) {
                string6 = this.getEncodingName(inputStream);
            }
            if (string6 != null) {
                string2 = string6;
            }
        }
        string2 = string2.toUpperCase(Locale.ENGLISH);
        this.consumeBOM(inputStream, string2);
        if (string2.equals("UTF-8")) {
            return new UTF8Reader(inputStream, 2048, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        string = EncodingMap.getIANA2JavaMapping(string2);
        if (string == null) {
            object2 = this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210");
            object = this.fErrorReporter.getLocale();
            throw new IOException(object2.formatMessage((Locale)object, "EncodingDeclInvalid", new Object[]{string2}));
        }
        if (string.equals("ASCII")) {
            return new ASCIIReader(inputStream, 2048, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        return new InputStreamReader(inputStream, string);
    }

    protected String getEncodingName(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        String string = null;
        inputStream.mark(4);
        int n2 = inputStream.read(byArray, 0, 4);
        inputStream.reset();
        if (n2 == 4) {
            string = this.getEncodingName(byArray);
        }
        return string;
    }

    protected void consumeBOM(InputStream inputStream, String string) throws IOException {
        byte[] byArray = new byte[3];
        int n2 = 0;
        inputStream.mark(3);
        if (string.equals("UTF-8")) {
            n2 = inputStream.read(byArray, 0, 3);
            if (n2 == 3) {
                int n3 = byArray[0] & 0xFF;
                int n4 = byArray[1] & 0xFF;
                int n5 = byArray[2] & 0xFF;
                if (n3 != 239 || n4 != 187 || n5 != 191) {
                    inputStream.reset();
                }
            } else {
                inputStream.reset();
            }
        } else if (string.startsWith("UTF-16")) {
            n2 = inputStream.read(byArray, 0, 2);
            if (n2 == 2) {
                int n6 = byArray[0] & 0xFF;
                int n7 = byArray[1] & 0xFF;
                if (!(n6 == 254 && n7 == 255 || n6 == 255 && n7 == 254)) {
                    inputStream.reset();
                }
            } else {
                inputStream.reset();
            }
        }
    }

    protected String getEncodingName(byte[] byArray) {
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray[1] & 0xFF;
        if (n2 == 254 && n3 == 255) {
            return "UTF-16BE";
        }
        if (n2 == 255 && n3 == 254) {
            return "UTF-16LE";
        }
        int n4 = byArray[2] & 0xFF;
        if (n2 == 239 && n3 == 187 && n4 == 191) {
            return "UTF-8";
        }
        int n5 = byArray[3] & 0xFF;
        if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 60) {
            return "ISO-10646-UCS-4";
        }
        if (n2 == 60 && n3 == 0 && n4 == 0 && n5 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (n2 == 0 && n3 == 0 && n4 == 60 && n5 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 63) {
            return "UTF-16BE";
        }
        if (n2 == 60 && n3 == 0 && n4 == 63 && n5 == 0) {
            return "UTF-16LE";
        }
        if (n2 == 76 && n3 == 111 && n4 == 167 && n5 == 148) {
            return "CP037";
        }
        return null;
    }

    public void parse() throws IOException {
        int n2;
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
        this.fReader = this.getReader(this.fSource);
        while ((n2 = this.fReader.read()) != -1) {
            if (this.isValid(n2)) {
                xMLStringBuffer.append((char)n2);
                continue;
            }
            if (XMLChar.isHighSurrogate(n2)) {
                int n3 = this.fReader.read();
                if (XMLChar.isLowSurrogate(n3)) {
                    int n4 = XMLChar.supplemental((char)n2, (char)n3);
                    if (!this.isValid(n4)) {
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInContent", new Object[]{Integer.toString(n4, 16)}, (short)2);
                        continue;
                    }
                    xMLStringBuffer.append((char)n2);
                    xMLStringBuffer.append((char)n3);
                    continue;
                }
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInContent", new Object[]{Integer.toString(n2, 16)}, (short)2);
                continue;
            }
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInContent", new Object[]{Integer.toString(n2, 16)}, (short)2);
        }
        if (this.fHandler != null && xMLStringBuffer.length > 0) {
            this.fHandler.characters(xMLStringBuffer, this.fHandler.modifyAugmentations(null, true));
        }
    }

    public void close() throws IOException {
        if (this.fReader != null) {
            this.fReader.close();
        }
    }

    protected boolean isValid(int n2) {
        return XMLChar.isValid(n2);
    }
}

