/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.rmi.runtime.Log;
import sun.rmi.transport.proxy.RMIMasterSocketFactory;

class HttpInputStream
extends FilterInputStream {
    protected int bytesLeft;
    protected int bytesLeftAtMark;

    public HttpInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        String string;
        if (inputStream.markSupported()) {
            inputStream.mark(0);
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        String string2 = "Content-length:".toLowerCase();
        boolean bl2 = false;
        do {
            string = dataInputStream.readLine();
            if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.VERBOSE)) {
                RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "received header line: \"" + string + "\"");
            }
            if (string == null) {
                throw new EOFException();
            }
            if (!string.toLowerCase().startsWith(string2)) continue;
            if (bl2) {
                // empty if block
            }
            this.bytesLeft = Integer.parseInt(string.substring(string2.length()).trim());
            bl2 = true;
        } while (string.length() != 0 && string.charAt(0) != '\r' && string.charAt(0) != '\n');
        if (!bl2 || this.bytesLeft < 0) {
            this.bytesLeft = Integer.MAX_VALUE;
        }
        this.bytesLeftAtMark = this.bytesLeft;
        if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.VERBOSE)) {
            RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "content length: " + this.bytesLeft);
        }
    }

    public int available() throws IOException {
        int n2 = this.in.available();
        if (n2 > this.bytesLeft) {
            n2 = this.bytesLeft;
        }
        return n2;
    }

    public int read() throws IOException {
        if (this.bytesLeft > 0) {
            int n2 = this.in.read();
            if (n2 != -1) {
                --this.bytesLeft;
            }
            if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.VERBOSE)) {
                RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "received byte: '" + ((n2 & 0x7F) < 32 ? " " : String.valueOf((char)n2)) + "' " + n2);
            }
            return n2;
        }
        RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "read past content length");
        return -1;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.bytesLeft == 0 && n3 > 0) {
            RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "read past content length");
            return -1;
        }
        if (n3 > this.bytesLeft) {
            n3 = this.bytesLeft;
        }
        int n4 = this.in.read(byArray, n2, n3);
        this.bytesLeft -= n4;
        if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.VERBOSE)) {
            RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "read " + n4 + " bytes, " + this.bytesLeft + " remaining");
        }
        return n4;
    }

    public void mark(int n2) {
        this.in.mark(n2);
        if (this.in.markSupported()) {
            this.bytesLeftAtMark = this.bytesLeft;
        }
    }

    public void reset() throws IOException {
        this.in.reset();
        this.bytesLeft = this.bytesLeftAtMark;
    }

    public long skip(long l2) throws IOException {
        if (l2 > (long)this.bytesLeft) {
            l2 = this.bytesLeft;
        }
        long l3 = this.in.skip(l2);
        this.bytesLeft = (int)((long)this.bytesLeft - l3);
        return l3;
    }
}

