/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.Prefs;
import java.awt.Menu;
import java.awt.MenuItem;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;

public class History {
    private static ImageJ ij;
    public static final String HIST_FILES = "HistoryFiles.txt";
    public static final String KEY_NB_FILES_OPENED = "NumberOfFilesOpened";
    public static final int INSERT_MENU = 11;
    public static int DEFAULT_HISTORY;
    public static int max_nb_files_history;
    public static int nb_total_files;
    private static int current_index;
    public static String[] precedents_files;
    public static int to_clear;
    static Properties list_files;

    public History(ImageJ ijInstance) {
        new History(DEFAULT_HISTORY, ijInstance);
    }

    public History(int m, ImageJ ijInstance) {
        int i;
        ij = ijInstance;
        max_nb_files_history = m < 0 ? DEFAULT_HISTORY : m;
        precedents_files = new String[max_nb_files_history];
        for (i = 0; i < max_nb_files_history; ++i) {
            History.precedents_files[i] = null;
        }
        History.loadHistoryOfFiles();
        current_index = nb_total_files = History.getInt(KEY_NB_FILES_OPENED, DEFAULT_HISTORY);
        for (i = 0; i < nb_total_files; ++i) {
            History.precedents_files[--History.current_index] = list_files.getProperty("File" + Integer.toString(i));
        }
        current_index = nb_total_files == max_nb_files_history ? 0 : nb_total_files;
    }

    public static void changeHistory(int m) {
        int i;
        if (m == max_nb_files_history) {
            return;
        }
        String[] old_precedents_files = new String[precedents_files.length];
        for (i = 0; i < precedents_files.length; ++i) {
            old_precedents_files[i] = i < nb_total_files ? History.getFileHistoryCurrent(i + 1) : null;
        }
        precedents_files = null;
        precedents_files = new String[m];
        max_nb_files_history = m;
        if (nb_total_files < max_nb_files_history) {
            m = nb_total_files;
        }
        current_index = 0;
        nb_total_files = 0;
        for (i = 0; i < m; ++i) {
            History.precedents_files[i] = null;
        }
        if (m < old_precedents_files.length) {
            for (i = m - 1; i >= 0; --i) {
                History.addFiletoHistory(old_precedents_files[i]);
            }
        } else {
            for (i = old_precedents_files.length - 1; i >= 0; --i) {
                History.addFiletoHistory(old_precedents_files[i]);
            }
        }
    }

    public static String getFileOfMenu(int item) {
        int i = item - 11 - 1;
        return History.getFileHistoryCurrent(i);
    }

    public static boolean isExist(String file) {
        int j = current_index;
        for (int i = 0; i < nb_total_files; ++i) {
            if (precedents_files[j = History.subModNbFiles(j)].compareTo(file) != 0) continue;
            return true;
        }
        return false;
    }

    public static int addModNbFiles(int i) {
        int j = i;
        if (++j == max_nb_files_history) {
            j = 0;
        }
        return j;
    }

    public static int subModNbFiles(int i) {
        int j = i;
        if (j == 0) {
            j = max_nb_files_history;
        }
        return --j;
    }

    public static boolean addFiletoHistory(String file) {
        if (History.isExist(file)) {
            int index = 0;
            int j = current_index;
            for (int i = 0; i < nb_total_files; ++i) {
                if (precedents_files[j = History.subModNbFiles(j)].compareTo(file) != 0) continue;
                index = j;
            }
            j = History.subModNbFiles(current_index);
            while (j != index) {
                String tmp = precedents_files[index];
                History.precedents_files[index] = precedents_files[j];
                History.precedents_files[j] = tmp;
                j = History.subModNbFiles(j);
            }
            return false;
        }
        History.precedents_files[History.current_index] = file;
        if ((current_index = History.addModNbFiles(current_index)) == 0) {
            nb_total_files = max_nb_files_history;
            return true;
        }
        if (max_nb_files_history == nb_total_files) {
            return true;
        }
        nb_total_files = current_index;
        return true;
    }

    public static String getFileHistoryCurrent(int i) {
        int tmp = current_index;
        for (int j = 0; j < i; ++j) {
            tmp = History.subModNbFiles(tmp);
        }
        return precedents_files[tmp];
    }

    public static int getNumberOfFilesInHistory() {
        return max_nb_files_history;
    }

    public static void setNumberOfFilesInHistory(int i) {
        max_nb_files_history = i;
    }

    public void savePreferences(Properties prefs) {
        prefs.put("files_history", Integer.toString(max_nb_files_history));
    }

    public static void loadHistoryOfFiles() {
        String path = Prefs.homeDir + Prefs.separator + HIST_FILES;
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(path));
            list_files.load(is);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            return;
        }
    }

    public static void saveHistoryOfFiles() {
        try {
            Properties hist = new Properties();
            hist.put(KEY_NB_FILES_OPENED, Integer.toString(nb_total_files));
            int j = current_index;
            for (int i = 0; i < nb_total_files; ++i) {
                j = History.subModNbFiles(j);
                hist.put("File" + Integer.toString(i), precedents_files[j]);
            }
            String path = Prefs.prefsDir + Prefs.separator + HIST_FILES;
            History.saveHistory(hist, path);
        }
        catch (Exception e) {
            IJ.write("<<Unable to save histories>>");
            IJ.wait(2000);
        }
    }

    static void saveHistory(Properties hist, String path) throws IOException {
        FileOutputStream fos = new FileOutputStream(path);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        PrintWriter pw = new PrintWriter(bos);
        Enumeration<Object> e = hist.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            pw.print(key);
            pw.write(61);
            pw.println(Prefs.escapeBackSlashes((String)hist.get(key)));
        }
        pw.close();
    }

    public static int getInt(String key, int defaultValue) {
        if (list_files == null) {
            return defaultValue;
        }
        String s = list_files.getProperty(key);
        if (s != null) {
            try {
                return Integer.decode(s);
            }
            catch (NumberFormatException e) {
                IJ.write("" + e);
            }
        }
        return defaultValue;
    }

    public static boolean isHistoryMenuItem(MenuItem item_selected) {
        int max = nb_total_files;
        if (max == 0) {
            return false;
        }
        max += 12;
        Menu file = IJ.getInstance().getMenuBar().getMenu(0);
        for (int i = 12; i < max; ++i) {
            if (file.getItem(i) != item_selected) continue;
            return true;
        }
        return false;
    }

    public static int whichHistoryMenuItem(MenuItem item_selected) {
        int max = nb_total_files;
        if (max == 0) {
            return -1;
        }
        max += 12;
        Menu file = IJ.getInstance().getMenuBar().getMenu(0);
        for (int i = 12; i < max; ++i) {
            if (file.getItem(i) != item_selected) continue;
            return i - 11;
        }
        return -1;
    }

    public static void synchronizeHistory(Menu file, boolean first_time) {
        if (!first_time) {
            for (int i = 0; i < to_clear; ++i) {
                file.remove(11);
            }
        }
        to_clear = 0;
        for (int i = nb_total_files; i > 0; --i) {
            MenuItem mi = new MenuItem(History.treatString(History.getFileHistoryCurrent(i)));
            file.insert(mi, 11);
            mi.addActionListener(ij);
            ++to_clear;
        }
        ij.getHistory();
        if (nb_total_files != 0) {
            file.insertSeparator(11);
            ++to_clear;
        }
    }

    private static String treatString(String path) {
        String directories;
        String file;
        if (path == null) {
            return "";
        }
        String suspension = "...";
        String sep = File.separator;
        String to_find = "" + sep;
        if (IJ.isWindows()) {
            int i = path.lastIndexOf(to_find);
            file = path.substring(i, path.length());
            i = path.lastIndexOf(to_find, i);
            String tmp = path.substring(i, path.length() - file.length());
            int j = path.indexOf(to_find);
            directories = path.substring(0, j) + to_find + suspension + tmp;
        } else {
            int i = path.lastIndexOf("/");
            file = path.substring(i, path.length());
            i = path.lastIndexOf("/", i);
            String tmp = path.substring(i, path.length() - file.length());
            int j = path.indexOf("/");
            directories = path.substring(0, j) + suspension + tmp;
        }
        String to_post = directories + file;
        return to_post;
    }

    static {
        DEFAULT_HISTORY = 0;
        current_index = 0;
        list_files = new Properties();
    }
}

