/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PluginClassLoader
extends ClassLoader {
    protected String path;
    protected Hashtable cache = new Hashtable();
    protected Vector jarFiles;

    public PluginClassLoader(String path) {
        this.path = path;
        this.jarFiles = new Vector();
        File f = new File(path);
        String[] list = f.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                f = new File(path, list[i]);
                if (f.isDirectory()) {
                    String[] innerlist = f.list();
                    for (int j = 0; j < innerlist.length; ++j) {
                        File g = new File(f, innerlist[j]);
                        if (!g.isFile()) continue;
                        this.addJAR(g);
                    }
                    continue;
                }
                this.addJAR(f);
            }
        }
        this.jarFiles.trimToSize();
    }

    private void addJAR(File f) {
        if (f.getName().endsWith(".jar") || f.getName().endsWith(".zip")) {
            this.jarFiles.addElement(f);
        }
    }

    public URL getResource(String name) {
        File resFile;
        URL res = ClassLoader.getSystemResource(name);
        if (res != null) {
            return res;
        }
        try {
            resFile = new File(this.path, name);
            if (resFile.exists()) {
                res = this.makeURL(resFile);
                return res;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        resFile = new File(this.path);
        String[] list = resFile.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                resFile = new File(this.path, list[i]);
                if (!resFile.isDirectory()) continue;
                try {
                    File f = new File(this.path + list[i], name);
                    if (f.exists()) {
                        res = this.makeURL(f);
                        return res;
                    }
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        for (int i = 0; i < this.jarFiles.size(); ++i) {
            try {
                File jf = (File)this.jarFiles.elementAt(i);
                byte[] resourceBytes = this.loadFromJar(jf.getPath(), name);
                if (resourceBytes == null) continue;
                res = this.makeURL(name, jf);
                return res;
            }
            catch (MalformedURLException e) {
                IJ.error(e.toString());
                continue;
            }
            catch (IOException e) {
                IJ.error(e.toString());
            }
        }
        return null;
    }

    private URL makeURL(File fil) throws MalformedURLException {
        URL url = new URL("file", "", fil.toString());
        return url;
    }

    private URL makeURL(String name, File jar) throws MalformedURLException {
        StringBuffer filename = new StringBuffer("file:/");
        filename.append(jar.toString());
        filename.append("!/");
        filename.append(name);
        String sf = filename.toString();
        String sfu = sf.replace('\\', '/');
        URL url = new URL("jar", "", sfu);
        return url;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream is = ClassLoader.getSystemResourceAsStream(name);
        if (is != null) {
            return is;
        }
        File resFile = new File(this.path, name);
        try {
            is = new FileInputStream(resFile);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (is != null) {
            return is;
        }
        resFile = new File(this.path);
        String[] list = resFile.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                resFile = new File(this.path, list[i]);
                if (!resFile.isDirectory()) continue;
                try {
                    File f = new File(this.path + list[i], name);
                    is = new FileInputStream(f);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (is == null) continue;
                return is;
            }
        }
        for (int i = 0; i < this.jarFiles.size(); ++i) {
            try {
                File jf = (File)this.jarFiles.elementAt(i);
                byte[] resourceBytes = this.loadFromJar(jf.getPath(), name);
                if (resourceBytes == null) continue;
                is = new ByteArrayInputStream(resourceBytes);
                return is;
            }
            catch (Exception e) {
                IJ.error(e.toString());
            }
        }
        return null;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    public synchronized Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        Class<?> result = (Class<?>)this.cache.get(className);
        if (result != null) {
            return result;
        }
        try {
            result = super.findSystemClass(className);
            return result;
        }
        catch (Exception e) {
            byte[] classBytes = this.loadClassBytes(className);
            if (classBytes == null) {
                throw new ClassNotFoundException(className);
            }
            result = this.defineClass(className, classBytes, 0, classBytes.length);
            if (result == null) {
                throw new ClassFormatError();
            }
            if (resolveIt) {
                this.resolveClass(result);
            }
            this.cache.put(className, result);
            return result;
        }
    }

    protected byte[] loadClassBytes(String name) {
        byte[] classBytes = null;
        classBytes = this.loadIt(this.path, name);
        if (classBytes == null && (classBytes = this.loadFromSubdirectory(this.path, name)) == null) {
            for (int i = 0; i < this.jarFiles.size(); ++i) {
                try {
                    File jf = (File)this.jarFiles.elementAt(i);
                    classBytes = this.loadClassFromJar(jf.getPath(), name);
                    if (classBytes != null) {
                        return classBytes;
                    }
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return classBytes;
    }

    private byte[] loadIt(String path, String classname) {
        String filename = classname.replace('.', '/');
        filename = filename + ".class";
        File fullname = new File(path, filename);
        try {
            FileInputStream is = new FileInputStream(fullname);
            int bufsize = (int)fullname.length();
            byte[] buf = new byte[bufsize];
            ((InputStream)is).read(buf, 0, bufsize);
            ((InputStream)is).close();
            return buf;
        }
        catch (Exception e) {
            return null;
        }
    }

    private byte[] loadFromSubdirectory(String path, String name) {
        File f = new File(path);
        String[] list = f.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                byte[] buf;
                f = new File(path, list[i]);
                if (!f.isDirectory() || (buf = this.loadIt(path + list[i], name)) == null) continue;
                return buf;
            }
        }
        return null;
    }

    byte[] loadClassFromJar(String jar, String className) {
        String name = className.replace('.', '/');
        name = name + ".class";
        return this.loadFromJar(jar, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] loadFromJar(String jar, String name) {
        BufferedInputStream bis = null;
        try {
            ZipFile jarFile = new ZipFile(jar);
            Enumeration<? extends ZipEntry> entries = jarFile.entries();
            while (true) {
                if (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().equals(name)) continue;
                    bis = new BufferedInputStream(jarFile.getInputStream(entry));
                    int size = (int)entry.getSize();
                    byte[] data = new byte[size];
                    int b = 0;
                    int eofFlag = 0;
                    while (size - b > 0 && (eofFlag = bis.read(data, b, size - b)) != -1) {
                        b += eofFlag;
                    }
                    byte[] byArray = data;
                    return byArray;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {}
        }
        return null;
    }
}

