/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import ij.measure.Calibration;
import ij.plugin.PlugIn;

public class Animator
implements PlugIn {
    private static double animationSpeed = Prefs.getDouble("fps", 7.0);
    private static boolean oscillate;
    private ImagePlus imp;
    private StackWindow swin;
    private int slice;
    private int nSlices;

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        this.nSlices = this.imp.getStackSize();
        if (this.nSlices < 2) {
            IJ.error(IJ.getBundle().getString("StackReqErr"));
            return;
        }
        ImageWindow win = this.imp.getWindow();
        if (!(win instanceof StackWindow)) {
            return;
        }
        this.swin = (StackWindow)win;
        ImageStack stack = this.imp.getStack();
        this.slice = this.imp.getCurrentSlice();
        IJ.register(Animator.class);
        if (arg.equals("options")) {
            this.doOptions();
            return;
        }
        if (arg.equals("start")) {
            this.startAnimation();
            return;
        }
        if (this.swin.running) {
            this.stopAnimation();
        }
        if (arg.equals("stop")) {
            return;
        }
        if (arg.equals("next")) {
            this.nextSlice();
            return;
        }
        if (arg.equals("previous")) {
            this.previousSlice();
            return;
        }
        if (arg.equals("set")) {
            this.setSlice();
            return;
        }
    }

    void stopAnimation() {
        this.swin.running = false;
        IJ.wait(500 + (int)(1000.0 / animationSpeed));
        this.imp.unlock();
    }

    void startAnimation() {
        if (this.swin.running) {
            this.stopAnimation();
            return;
        }
        this.imp.unlock();
        this.swin.running = true;
        long nextTime = System.currentTimeMillis();
        Thread.currentThread().setPriority(1);
        int sliceIncrement = 1;
        Calibration cal = this.imp.getCalibration();
        if (cal.frameInterval != 0.0) {
            animationSpeed = 1.0 / cal.frameInterval;
        }
        while (this.swin.running) {
            long time = System.currentTimeMillis();
            if (time < nextTime) {
                IJ.wait((int)(nextTime - time));
            } else {
                Thread.yield();
            }
            nextTime += (long)(1000.0 / animationSpeed);
            this.slice += sliceIncrement;
            if (this.slice < 1) {
                this.slice = 2;
                sliceIncrement = 1;
            }
            if (this.slice > this.nSlices) {
                if (oscillate) {
                    this.slice = this.nSlices - 1;
                    sliceIncrement = -1;
                } else {
                    this.slice = 1;
                    sliceIncrement = 1;
                }
            }
            this.swin.showSlice(this.slice);
        }
    }

    void doOptions() {
        boolean start = !this.swin.running;
        boolean saveOscillate = oscillate;
        Calibration cal = this.imp.getCalibration();
        if (cal.frameInterval != 0.0) {
            animationSpeed = 1.0 / cal.frameInterval;
        }
        GenericDialog gd = new GenericDialog(IJ.getPluginBundle().getString("AnimOptTitle"));
        gd.addNumericField(IJ.getPluginBundle().getString("AnimOptSpeed"), animationSpeed, 0);
        gd.addCheckbox(IJ.getPluginBundle().getString("AnimOptLoop"), oscillate);
        gd.addCheckbox(IJ.getPluginBundle().getString("AnimOptStart"), start);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        double speed = gd.getNextNumber();
        oscillate = gd.getNextBoolean();
        start = gd.getNextBoolean();
        if (speed > 100.0) {
            speed = 100.0;
        }
        if (speed < 1.0) {
            speed = 1.0;
        }
        if ((animationSpeed = speed) != 0.0) {
            cal.frameInterval = 1.0 / animationSpeed;
        }
        if (start && !this.swin.running) {
            this.startAnimation();
        }
    }

    void nextSlice() {
        if (!this.imp.lock()) {
            return;
        }
        this.slice = IJ.altKeyDown() ? (this.slice += 10) : ++this.slice;
        if (this.slice > this.nSlices) {
            this.slice = this.nSlices;
        }
        this.swin.showSlice(this.slice);
        this.imp.updateStatusbarValue();
        this.imp.unlock();
    }

    void previousSlice() {
        if (!this.imp.lock()) {
            return;
        }
        this.slice = IJ.altKeyDown() ? (this.slice -= 10) : --this.slice;
        if (this.slice < 1) {
            this.slice = 1;
        }
        this.swin.showSlice(this.slice);
        this.imp.updateStatusbarValue();
        this.imp.unlock();
    }

    void setSlice() {
        GenericDialog gd = new GenericDialog(IJ.getPluginBundle().getString("AnimSlice"));
        gd.addNumericField(IJ.getPluginBundle().getString("AnimNb") + " (1-" + this.nSlices + "):", this.slice, 0);
        gd.showDialog();
        if (!gd.wasCanceled()) {
            this.imp.setSlice((int)gd.getNextNumber());
        }
    }

    public static double getFrameRate() {
        return animationSpeed;
    }
}

