/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.EuHouToolbar;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.OvalRoi;
import ij.gui.PhotometerParams;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.process.FloatProcessor;
import ij.process.ImageStatistics;
import ij.text.TextWindow;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Photometer
implements MouseListener {
    public static final short STAR_RAD = 1;
    public static final short SKY_RAD = 2;
    public static final short SKY_VAL = 4;
    public static final short SKY_STAR = 8;
    public static final short COORD = 256;
    private short exec = 0;
    private int x;
    private int y;
    private int slic = -1;
    private ImageStatistics stat;
    private ImageStatistics istat;
    private int width;
    private int iwidth;
    private OvalRoi out;
    private OvalRoi in;
    private float skyval;
    private static Hashtable results;
    private static TextWindow res;
    private static Photometer instance;
    private static int phindex;
    public int setX;
    public int setY;
    private ImagePlus imp;

    public Photometer() {
        if (instance != null) {
            Photometer.activate();
            return;
        }
        instance = this;
        res = new TextWindow(IJ.getBundle().getString("Photometer"), IJ.getBundle().getString("PhotometerLabels"), null, 400, 200, false);
        results = new Hashtable();
        IJ.register(Photometer.class);
    }

    public static Photometer getInstance() {
        return instance;
    }

    public static void activate() {
        if (res == null) {
            StringBuffer sb;
            if (results.size() > 0) {
                Enumeration keys = results.keys();
                sb = new StringBuffer();
                int i = 1;
                int m = 0;
                while (keys.hasMoreElements()) {
                    ++i;
                    int n = Integer.parseInt((String)keys.nextElement());
                    if (n <= m) continue;
                    m = n;
                }
                for (int j = 1; j <= m; ++j) {
                    IPhot res = (IPhot)results.get(String.valueOf(j));
                    if (res == null) continue;
                    sb.append(j + "\t" + res.toString() + "\n");
                }
            } else {
                sb = null;
            }
            res = new TextWindow(IJ.getBundle().getString("Photometer"), IJ.getBundle().getString("PhotometerLabels"), sb == null ? null : new String(sb), 400, 200, false);
        }
        WindowManager.activateWindow(IJ.getBundle().getString("Photometer"));
    }

    public void mousePressed(MouseEvent e) {
        int jj;
        int ii;
        int maxind;
        int[] itab;
        float[] tab;
        short op = 0;
        PhotometerParams pp = PhotometerParams.getInstance();
        if (pp != null) {
            op = pp.getStatus();
        }
        int tool = Toolbar.getToolId();
        if ((e.getModifiers() & 0x10) == 0 || tool == 11 || tool == 12 || tool == 13) {
            return;
        }
        this.stat = null;
        this.istat = null;
        this.x = e.getX();
        this.y = e.getY();
        try {
            ImageCanvas canvas = (ImageCanvas)e.getSource();
            this.x = canvas.offScreenX(this.x);
            this.y = canvas.offScreenY(this.y);
            this.imp = canvas.getImage();
            if (this.imp.getType() != 0 && this.imp.getType() != 1 && this.imp.getType() != 2) {
                IJ.error(IJ.getBundle().getString("TypeReqErr") + IJ.getBundle().getString("Grayscale"));
                return;
            }
        }
        catch (Exception ex) {
            return;
        }
        if (this.imp.getStackSize() > 1) {
            this.slic = this.imp.getCurrentSlice();
        }
        Calibration cal = this.imp.getCalibration();
        int anul_rad = 10;
        if ((op & 0x100) == 0) {
            tab = new float[anul_rad * 2];
            itab = new int[anul_rad * 2];
            float maxtab = -1.0E12f;
            maxind = -1;
            for (ii = 0; ii < anul_rad * 2; ++ii) {
                tab[ii] = -1.0E12f;
                int xx = this.x - anul_rad + ii;
                for (int jj2 = this.y - anul_rad; jj2 < this.y + anul_rad * 2; ++jj2) {
                    float pix = (float)cal.getCValue(this.imp.getPixel(xx, jj2)[0]);
                    if (!(pix > tab[ii])) continue;
                    itab[ii] = jj2;
                    tab[ii] = pix;
                }
                if (!(tab[ii] > maxtab)) continue;
                maxtab = tab[ii];
                maxind = ii;
            }
            this.y = itab[maxind];
            this.x = this.x - anul_rad + maxind;
        } else {
            try {
                int[] t = PhotometerParams.getInstance().getCoord();
                this.x = t[0];
                this.y = t[1];
            }
            catch (NumberFormatException exc) {
                IJ.error("CoordFmt");
                return;
            }
        }
        anul_rad = 20;
        int imwidth = this.imp.getProcessor().getWidth();
        int imheight = this.imp.getProcessor().getHeight();
        tab = new float[4 * anul_rad];
        if (this.imp.getType() != 2) {
            for (ii = 0; ii < anul_rad; ++ii) {
                for (jj = 0; jj < anul_rad; ++jj) {
                    int x1 = this.x - anul_rad + ii;
                    int y1 = this.y - anul_rad + jj;
                    tab[ii] = x1 >= 0 && y1 >= 0 ? (float)this.imp.getPixel(x1, y1)[0] : Float.MIN_VALUE;
                    int x2 = this.x + anul_rad + ii;
                    tab[anul_rad + ii] = x2 < imwidth && y1 >= 0 ? (float)this.imp.getPixel(x2, y1)[0] : Float.MIN_VALUE;
                    int y2 = this.y + anul_rad + jj;
                    tab[2 * anul_rad + ii] = x2 < this.iwidth && y2 < imheight ? (float)this.imp.getPixel(x2, y2)[0] : Float.MIN_VALUE;
                    tab[3 * anul_rad + ii] = x1 >= 0 && y2 < imheight ? (float)this.imp.getPixel(x1, y2)[0] : Float.MIN_VALUE;
                }
            }
        } else {
            FloatProcessor ip = (FloatProcessor)this.imp.getProcessor();
            for (ii = 0; ii < anul_rad; ++ii) {
                for (jj = 0; jj < anul_rad; ++jj) {
                    int x1 = this.x - anul_rad + ii;
                    int y1 = this.y - anul_rad + jj;
                    tab[ii] = x1 >= 0 && y1 >= 0 ? Float.intBitsToFloat(ip.getPixel(x1, y1)) : Float.MIN_VALUE;
                    int x2 = this.x + anul_rad + ii;
                    tab[anul_rad + ii] = x2 < imwidth && y1 >= 0 ? Float.intBitsToFloat(ip.getPixel(x2, y1)) : Float.MIN_VALUE;
                    int y2 = this.y + anul_rad + jj;
                    tab[2 * anul_rad + ii] = x2 < this.iwidth && y2 < imheight ? Float.intBitsToFloat(ip.getPixel(x2, y2)) : Float.MIN_VALUE;
                    tab[3 * anul_rad + ii] = x1 >= 0 && y2 < imheight ? Float.intBitsToFloat(ip.getPixel(x1, y2)) : Float.MIN_VALUE;
                }
            }
        }
        Arrays.sort(tab);
        itab = new int[4 * anul_rad];
        ii = 0;
        while (tab[ii] == Float.MIN_VALUE) {
            ++ii;
        }
        long mv = (long)tab[ii];
        ++mv;
        for (jj = ii; jj < 4 * anul_rad; ++jj) {
            if ((long)tab[jj] < mv) {
                ii = jj;
                mv = (long)tab[ii];
                ++mv;
            }
            int n = ii;
            itab[n] = itab[n] + 1;
        }
        maxind = 0;
        for (jj = 0; jj <= ii; ++jj) {
            if (itab[jj] <= itab[maxind]) continue;
            maxind = jj;
        }
        itab = new int[5];
        if (this.imp.getType() != 2) {
            this.skyval = (float)cal.getCValue(tab[maxind]);
            float cval = (float)((cal.getCValue(this.imp.getPixel(this.x, this.y)[0]) - (double)this.skyval) / 2.0);
            float sval = cval + this.skyval;
            for (ii = this.x; ii < imwidth && (float)cal.getCValue(this.imp.getPixel(ii, this.y)[0]) > sval; ++ii) {
            }
            if (ii != imwidth) {
                itab[0] = ii - this.x - 1;
                itab[4] = itab[4] + 1;
                tab[0] = itab[0];
                if (cal.getCValue(this.imp.getPixel(ii - 1, this.y)[0]) != cal.getCValue(this.imp.getPixel(ii, this.y)[0])) {
                    tab[0] = tab[0] + ((float)cal.getCValue(this.imp.getPixel(ii - 1, this.y)[0]) - this.skyval - cval) / ((float)cal.getCValue(this.imp.getPixel(ii - 1, this.y)[0]) - (float)cal.getCValue(this.imp.getPixel(ii, this.y)[0]));
                }
            }
            for (ii = this.x; ii >= 0 && (float)cal.getCValue(this.imp.getPixel(ii, this.y)[0]) > sval; --ii) {
            }
            if (ii != -1) {
                itab[1] = this.x - ii - 1;
                itab[4] = itab[4] + 1;
                tab[1] = itab[1];
                if (cal.getCValue(this.imp.getPixel(ii + 1, this.y)[0]) != cal.getCValue(this.imp.getPixel(ii + 1, this.y)[0])) {
                    tab[1] = tab[1] + ((float)cal.getCValue(this.imp.getPixel(ii + 1, this.y)[0]) - this.skyval - cval) / ((float)cal.getCValue(this.imp.getPixel(ii + 1, this.y)[0]) - (float)cal.getCValue(this.imp.getPixel(ii, this.y)[0]));
                }
            }
            if (itab[4] == 2) {
                tab[0] = (tab[0] + tab[1]) / 2.0f;
                itab[1] = 1;
            } else {
                tab[0] = 0.0f;
                itab[1] = 0;
            }
            itab[4] = 0;
            for (jj = this.y; jj < imheight && (float)cal.getCValue(this.imp.getPixel(this.x, jj)[0]) > sval; ++jj) {
            }
            if (jj != imheight) {
                itab[2] = jj - this.y - 1;
                itab[4] = itab[4] + 1;
                tab[2] = itab[2];
                if (cal.getCValue(this.imp.getPixel(this.x, jj - 1)[0]) != cal.getCValue(this.imp.getPixel(this.x, jj)[0])) {
                    tab[2] = tab[2] + ((float)cal.getCValue(this.imp.getPixel(this.x, jj - 1)[0]) - this.skyval - cval) / ((float)cal.getCValue(this.imp.getPixel(this.x, jj - 1)[0]) - (float)cal.getCValue(this.imp.getPixel(this.x, jj)[0]));
                }
            }
            for (jj = this.y; jj >= 0 && (float)cal.getCValue(this.imp.getPixel(this.x, jj)[0]) > sval; --jj) {
            }
            if (jj != -1) {
                itab[3] = this.y - jj - 1;
                itab[4] = itab[4] + 1;
                tab[3] = itab[3];
                if (cal.getCValue(this.imp.getPixel(this.x, jj + 1)[0]) != cal.getCValue(this.imp.getPixel(this.x, jj)[0])) {
                    tab[3] = tab[3] + ((float)cal.getCValue(this.imp.getPixel(this.x, jj + 1)[0]) - this.skyval - cval) / ((float)cal.getCValue(this.imp.getPixel(this.x, jj + 1)[0]) - (float)cal.getCValue(this.imp.getPixel(this.x, jj)[0]));
                }
            }
            if (itab[4] == 2) {
                tab[0] = tab[0] + (tab[2] + tab[3]) / 2.0f;
                itab[3] = 1;
            } else {
                itab[3] = 0;
            }
        } else {
            FloatProcessor ip = (FloatProcessor)this.imp.getProcessor();
            this.skyval = tab[maxind];
            float cval = (Float.intBitsToFloat(ip.getPixel(this.x, this.y)) - this.skyval) / 2.0f;
            float sval = cval + this.skyval;
            for (ii = this.x; ii < imwidth && Float.intBitsToFloat(ip.getPixel(ii, this.y)) > sval; ++ii) {
            }
            if (ii != imwidth) {
                itab[0] = ii - this.x - 1;
                itab[4] = itab[4] + 1;
                tab[0] = itab[0];
                if (ip.getPixel(ii - 1, this.y) != ip.getPixel(ii, this.y)) {
                    tab[0] = tab[0] + (Float.intBitsToFloat(ip.getPixel(ii - 1, this.y)) - this.skyval - cval) / (Float.intBitsToFloat(ip.getPixel(ii - 1, this.y)) - Float.intBitsToFloat(ip.getPixel(ii, this.y)));
                }
            }
            for (ii = this.x; ii >= 0 && Float.intBitsToFloat(ip.getPixel(ii, this.y)) > sval; --ii) {
            }
            if (ii != -1) {
                itab[1] = this.x - ii - 1;
                itab[4] = itab[4] + 1;
                tab[1] = itab[1];
                if (ip.getPixel(ii + 1, this.y) != ip.getPixel(ii, this.y)) {
                    tab[1] = tab[1] + (Float.intBitsToFloat(ip.getPixel(ii + 1, this.y)) - this.skyval - cval) / (Float.intBitsToFloat(ip.getPixel(ii + 1, this.y)) - Float.intBitsToFloat(ip.getPixel(ii, this.y)));
                }
            }
            if (itab[4] == 2) {
                tab[0] = (tab[0] + tab[1]) / 2.0f;
                itab[1] = 1;
            } else {
                tab[0] = 0.0f;
                itab[1] = 0;
            }
            itab[4] = 0;
            for (jj = this.y; jj < imheight && Float.intBitsToFloat(ip.getPixel(this.x, jj)) - this.skyval > sval; ++jj) {
            }
            if (jj != imheight) {
                itab[2] = jj - this.y - 1;
                itab[4] = itab[4] + 1;
                tab[2] = itab[2];
                if (ip.getPixel(this.x, jj - 1) != ip.getPixel(this.x, jj)) {
                    tab[2] = tab[2] + (Float.intBitsToFloat(ip.getPixel(this.x, jj - 1)) - this.skyval - cval) / (Float.intBitsToFloat(ip.getPixel(this.x, jj - 1)) - Float.intBitsToFloat(ip.getPixel(this.x, jj)));
                }
            }
            for (jj = this.y; jj >= 0 && Float.intBitsToFloat(ip.getPixel(this.x, jj)) > sval; --jj) {
            }
            if (jj != -1) {
                itab[3] = this.y - jj - 1;
                itab[4] = itab[4] + 1;
                tab[3] = itab[3];
                if (ip.getPixel(this.x, jj + 1) != ip.getPixel(this.x, jj)) {
                    tab[3] = tab[3] + (Float.intBitsToFloat(ip.getPixel(this.x, jj + 1)) - this.skyval - cval) / (Float.intBitsToFloat(ip.getPixel(this.x, jj + 1)) - Float.intBitsToFloat(ip.getPixel(this.x, jj)));
                }
            }
            if (itab[4] == 2) {
                tab[0] = tab[0] + (tab[2] + tab[3]) / 2.0f;
                itab[3] = 1;
            } else {
                itab[3] = 0;
            }
        }
        if (itab[3] == 0 && itab[1] == 0) {
            return;
        }
        if ((op & 1) == 0) {
            itab[0] = (int)((double)tab[0] * 1.5 + 0.5);
        } else {
            try {
                itab[0] = (int)PhotometerParams.getInstance().getVal((short)1);
            }
            catch (NumberFormatException nfe) {
                IJ.error("StarRadFmt");
                itab[0] = (int)((double)tab[0] * 1.5 + 0.5);
            }
        }
        if ((op & 2) == 0) {
            itab[1] = (op & 8) == 0 ? (int)((double)(tab[0] * 3.0f) + 0.5) : 2 * itab[0];
        } else {
            try {
                itab[1] = (int)PhotometerParams.getInstance().getVal((short)2);
            }
            catch (NumberFormatException nfe) {
                IJ.error("SkyRadFmt");
                itab[1] = (int)((double)(tab[0] * 3.0f) + 0.5);
            }
        }
        this.out = new OvalRoi(this.x - itab[1], this.y - itab[1], 2 * itab[1], 2 * itab[1]);
        this.in = new OvalRoi(this.x - itab[0], this.y - itab[0], 2 * itab[0], 2 * itab[0]);
        this.imp.setRoi(this.out);
        this.stat = this.imp.getStatistics();
        this.imp.setRoi(this.in);
        this.istat = this.imp.getStatistics();
        if ((op & 4) == 0) {
            this.stat.mean = (this.stat.mean * (double)this.stat.pixelCount - this.istat.mean * (double)this.istat.pixelCount) / (double)(this.stat.pixelCount - this.istat.pixelCount);
        } else {
            try {
                this.stat.mean = PhotometerParams.getInstance().getVal((short)4);
            }
            catch (NumberFormatException nfe) {
                IJ.error("SkyValFmt");
                this.stat.mean = (this.stat.mean * (double)this.stat.pixelCount - this.istat.mean * (double)this.istat.pixelCount) / (double)(this.stat.pixelCount - this.istat.pixelCount);
            }
        }
        this.istat.mean = (this.istat.mean - this.stat.mean) * (double)this.istat.pixelCount;
    }

    public void set(String s) {
        StringTokenizer st = new StringTokenizer(s, "\t");
        int index = Integer.parseInt(st.nextToken());
        IPhot resu = (IPhot)results.get(String.valueOf(index));
        WindowManager.setCurrentWindow(resu.win, false);
        if (resu.s != -1) {
            resu.win.getImagePlus().setSlice(resu.s);
        }
        resu.win.getImagePlus().setRoi(new OvalRoi(resu.r.x(), resu.r.y(), resu.r.width(), resu.r.height()));
    }

    public boolean affectedImage(String n) {
        Enumeration keys = results.keys();
        boolean found = false;
        while (!found && keys.hasMoreElements()) {
            IPhot r = (IPhot)results.get(keys.nextElement());
            if (!r.win.getTitle().equals(n)) continue;
            found = true;
            break;
        }
        return found;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        String t;
        int tool = Toolbar.getToolId();
        if ((e.getModifiers() & 0x10) == 0 || tool == 11 || tool == 12 || tool == 13) {
            return;
        }
        try {
            t = ((ImageCanvas)e.getSource()).getImage().getTitle();
        }
        catch (Exception ex) {
            return;
        }
        if (this.stat == null || this.istat == null) {
            IJ.error(IJ.getBundle().getString("PhotometryError"));
            return;
        }
        res.append(new String(phindex + "\t" + t + "\t" + (this.slic == -1 ? "-" : this.slic + "") + "\t" + this.x + "\t" + (this.imp.getHeight() - 1 - this.y) + "\t" + IJ.d2s(this.istat.mean) + "\t" + this.in.width() / 2 + "\t" + IJ.d2s(this.stat.mean)));
        res.getTextPanel().resetSelection();
        results.put(String.valueOf(phindex), new IPhot(t, this.slic, this.x, this.y, this.in, this.istat.mean, this.stat.mean));
        ++phindex;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public static void clear() {
        if (results == null) {
            return;
        }
        results.clear();
        phindex = 1;
        if (res != null) {
            res.getTextPanel().selectAll();
            res.getTextPanel().clearSelection();
        }
        if (EuHouToolbar.photometerSelected()) {
            Enumeration en = WindowManager.getImageWindows().elements();
            while (en.hasMoreElements()) {
                ((ImageWindow)en.nextElement()).getImagePlus().killRoi();
            }
        }
    }

    public static void clear(String s) {
        StringTokenizer st1 = new StringTokenizer(s, "\n");
        while (st1.hasMoreTokens()) {
            String s1 = st1.nextToken();
            StringTokenizer st = new StringTokenizer(s1, "\t");
            try {
                int index = Integer.parseInt(st.nextToken());
                String img = st.nextToken();
                if (EuHouToolbar.photometerSelected()) {
                    WindowManager.activateWindow(img);
                    WindowManager.getCurrentWindow().getImagePlus().killRoi();
                }
                results.remove(String.valueOf(index));
            }
            catch (Exception e) {}
        }
    }

    public void close() {
        if (res != null) {
            res.close();
            res = null;
        }
    }

    public void setOp(short op) {
        this.exec = op;
    }

    static {
        instance = null;
        phindex = 1;
    }

    class IPhot {
        ImageWindow win = null;
        String title;
        Roi r;
        int s;
        int x;
        int y;
        double inten;
        double sky;

        public IPhot(String i, int s, int x, int y, Roi r, double inten, double sky) {
            this.title = new String(i);
            this.r = new OvalRoi(r.x(), r.y(), r.width(), r.height());
            this.x = x;
            this.y = y;
            this.s = s;
            this.inten = inten;
            this.sky = sky;
            this.win = WindowManager.getCurrentWindow();
        }

        public String toString() {
            return new String(this.title + "\t" + (this.s == -1 ? "-\t" : this.s + "\t") + this.x + "\t" + this.y + "\t" + IJ.d2s(this.inten) + "\t" + this.r.width() / 2 + "\t" + IJ.d2s(this.sky));
        }
    }
}

