/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.amovie;

import com.sun.media.amovie.AMController;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class ActiveMovie
implements Runnable {
    private int pGraph = 0;
    private int aStream = 0;
    private int filterPin = 0;
    private byte[] jbuffer;
    private boolean paused = false;
    private boolean donePaused = true;
    private Thread spinner = null;
    private Integer semaphore = new Integer(0);
    private boolean realized = false;
    private int streamType = 3;
    private AMController controller;
    private PullSourceStream stream = null;
    private boolean seekable;
    private boolean randomAccess;
    private long readLocation = 0L;
    private long streamLocation = 0L;
    private boolean controllerRealized = false;
    private int cacheBuffer = 0;
    private int cacheTotalSize = 0;
    private int cacheAllocated = 0;
    private boolean deallocated = false;
    public static final int MIN_VOLUME = -10000;
    public static final int MAX_VOLUME = 0;

    ActiveMovie(AMController controller, String file) {
        this.controller = controller;
        this.realized = this.openFile(file);
    }

    ActiveMovie(AMController controller, PullSourceStream source, boolean randomAccess, long contentLength) {
        this.controller = controller;
        this.stream = source;
        this.seekable = source instanceof Seekable;
        this.randomAccess = randomAccess;
        this.jbuffer = new byte[65536];
        this.initiateSpin();
        if (this.seekable) {
            this.seek(0L);
        }
        controller.canRead(65536);
        int size = controller.read(this.jbuffer, 0, 65536);
        if (!randomAccess && size > 0) {
            this.addToCache(this.jbuffer, 0, size);
        }
        if (size > 0) {
            if (!randomAccess && contentLength > 0L) {
                contentLength += 614400L;
            }
            this.streamType = this.getStreamType(this.jbuffer, size);
            this.streamLocation += (long)size;
            this.seek(0L);
            this.realized = this.openStream(this.seekable, randomAccess, this.streamType, contentLength);
        } else {
            this.realized = false;
        }
    }

    public void setSeekable(boolean seekable) {
        if (seekable) {
            this.randomAccess = seekable;
            this.seekable = seekable;
        }
        this.setNSeekable(seekable);
    }

    native void setNSeekable(boolean var1);

    private void initiateSpin() {
        this.spinner = new Thread(this);
        this.spinner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            ActiveMovie activeMovie = this;
            synchronized (activeMovie) {
                while (this.paused) {
                    if (!this.donePaused) {
                        this.donePaused = true;
                        this.notifyAll();
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                }
            }
            this.doNRequest(this.jbuffer);
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (Exception e3) {
                System.err.println("Exception in run()" + e3);
                continue;
            }
            break;
        }
    }

    void doneRealize() {
        this.controllerRealized = true;
    }

    boolean isRealized() {
        return this.realized;
    }

    boolean hasVideo() {
        return (this.streamType & 2) == 2;
    }

    boolean hasAudio() {
        return (this.streamType & 1) == 1;
    }

    native void amRun();

    native void amPause();

    native void amStop();

    native void amStopWhenReady();

    void stopDataFlow(boolean stop) {
        if (this.filterPin != 0) {
            this.stopDataFlow(this.filterPin, stop);
        }
    }

    native void stopDataFlow(int var1, boolean var2);

    native double getDuration();

    native double getCurrentPosition();

    native void setCurrentPosition(double var1);

    native void setStopTime(double var1);

    native int getBitRate();

    native double getFrameRate();

    native int getVideoWidth();

    native int getVideoHeight();

    native void setOwner(int var1);

    native void setVisible(int var1);

    native void setWindowPosition(int var1, int var2, int var3, int var4);

    native int getVolume();

    native void setVolume(int var1);

    native void setRate(double var1);

    native double getRate();

    native long getTime();

    native boolean waitForCompletion();

    native int getStreamType(byte[] var1, int var2);

    native void doNRequest(byte[] var1);

    public int canRead(int nBytes) {
        return this.controller.canRead(nBytes);
    }

    public long canSeek(long seekTo) {
        return this.controller.canSeek(seekTo);
    }

    public int read(byte[] array, int offset, int length) {
        int totalRead = 0;
        if (this.deallocated) {
            return -1;
        }
        if (this.cacheTotalSize > 0 && !this.randomAccess && this.readLocation < (long)this.cacheTotalSize && this.streamLocation == (long)this.cacheTotalSize) {
            totalRead = (int)((long)this.cacheTotalSize - this.readLocation);
            if (totalRead > length) {
                totalRead = length;
            }
            this.getFromCache((int)this.readLocation, array, offset, totalRead);
            this.readLocation += (long)totalRead;
            if (totalRead == length) {
                return totalRead;
            }
            length -= totalRead;
            offset += totalRead;
        }
        int actualRead = 0;
        int remaining = length;
        while (totalRead < length) {
            actualRead = this.canRead(remaining) > 0 ? this.controller.read(array, offset, remaining) : -1;
            if (actualRead == -1) {
                if (totalRead > 0) {
                    return totalRead;
                }
                return -1;
            }
            if (actualRead == -2) {
                return -2;
            }
            if (actualRead <= 0) continue;
            remaining -= actualRead;
            totalRead += actualRead;
            if (!this.controllerRealized && !this.randomAccess && this.streamLocation == (long)this.cacheTotalSize) {
                this.addToCache(array, offset, actualRead);
            }
            offset += actualRead;
            this.streamLocation += (long)actualRead;
            this.readLocation = this.streamLocation;
            if (this.streamLocation <= (long)this.cacheTotalSize || !this.controllerRealized) continue;
            this.cacheTotalSize = 0;
        }
        if (actualRead > 0) {
            return totalRead;
        }
        return actualRead;
    }

    public long seek(long seekTo) {
        if (this.deallocated) {
            return 0L;
        }
        if (seekTo < (long)this.cacheTotalSize && !this.randomAccess) {
            this.readLocation = seekTo;
            return seekTo;
        }
        if (this.seekable && (this.randomAccess || seekTo == 0L)) {
            long seeked = this.controller.seek(seekTo);
            this.streamLocation = seekTo;
            return seeked;
        }
        return -1L;
    }

    private void addToCache(byte[] buffer, int offset, int size) {
        if (this.cacheBuffer == 0) {
            this.cacheBuffer = this.nCreateCache(393216);
            this.cacheAllocated = 393216;
        }
        if (this.cacheTotalSize + size > this.cacheAllocated) {
            return;
        }
        this.nAddToCache(this.cacheBuffer, this.cacheTotalSize, buffer, offset, size);
        this.cacheTotalSize += size;
    }

    private void getFromCache(int location, byte[] buffer, int offset, int size) {
        this.nGetFromCache(this.cacheBuffer, location, buffer, offset, size);
    }

    private native int nCreateCache(int var1);

    private native void nAddToCache(int var1, int var2, byte[] var3, int var4, int var5);

    private native void nGetFromCache(int var1, int var2, byte[] var3, int var4, int var5);

    private native void nFreeCache(int var1);

    void dispose() {
        if (this.spinner != null) {
            this.spinner.stop();
            this.spinner = null;
        }
        this.dispose0();
        if (this.cacheBuffer != 0) {
            this.nFreeCache(this.cacheBuffer);
            this.cacheBuffer = 0;
        }
    }

    protected void finalize() {
        this.dispose();
    }

    public synchronized void pause() {
        if (this.paused) {
            return;
        }
        this.donePaused = false;
        this.paused = true;
        if (!this.donePaused) {
            try {
                this.wait(250L);
                this.donePaused = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void restart() {
        this.deallocated = false;
        this.stopDataFlow(false);
        this.unPause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unPause() {
        if (!this.paused) {
            return;
        }
        ActiveMovie activeMovie = this;
        synchronized (activeMovie) {
            this.donePaused = true;
            this.paused = false;
            this.notifyAll();
        }
    }

    public void kill() {
        this.deallocated = true;
        this.unPause();
        this.stopDataFlow(true);
        this.amStop();
    }

    native void dispose0();

    native boolean openFile(String var1);

    native boolean openStream(boolean var1, boolean var2, int var3, long var4);

    static native int findWindow(String var0);

    static {
        MIN_VOLUME = -10000;
        MAX_VOLUME = 0;
    }
}

