/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.vh263;

import com.ibm.media.codec.video.VideoCodec;
import com.sun.media.JMFSecurityManager;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class NativeDecoder
extends VideoCodec {
    private int nativeData;
    private int pictureDesc;
    private int PBFrameCap = 1;
    private int bsStart;
    private int nextGOB;
    private int pendingFrame = 0;
    private static int MAX_SEQ = 65535;
    private long prevSeq = -1L;
    private static final boolean debug = false;
    static final int[] widths;
    static final int[] heights;
    private int videoWidth = 176;
    private int videoHeight = 144;
    private boolean FormatSizeInitFlag = false;
    private int payloadLength = 4;

    private static native boolean initNativeDecoderClass();

    private native boolean initNativeDecoder(int var1, int var2);

    private native boolean decodeFrameNative(Buffer var1, Buffer var2);

    private native boolean decodePacketNative(byte[] var1, int var2, int var3, byte[] var4, byte[] var5, int var6, int var7, int var8);

    private native boolean closeNativeDecoder();

    public NativeDecoder() {
        this.supportedInputFormats = new VideoFormat[]{new VideoFormat("h263"), new VideoFormat("h263/rtp"), new VideoFormat("h263-1998/rtp")};
        this.defaultOutputFormats = new VideoFormat[]{new YUVFormat()};
        this.PLUGIN_NAME = "H.263 Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        VideoFormat ivf = (VideoFormat)in;
        Dimension inSize = ivf.getSize();
        int inMaxDataLength = ivf.getMaxDataLength();
        if (ivf.getEncoding().equals("h263/rtp") || ivf.getEncoding().equals("h263-1998/rtp")) {
            int outNumOfPixels;
            if (inSize == null) {
                outNumOfPixels = this.videoWidth * this.videoHeight;
            } else {
                outNumOfPixels = inSize.width * inSize.height;
                this.videoWidth = inSize.width;
                this.videoHeight = inSize.height;
            }
            outNumOfPixels = this.videoWidth * this.videoHeight;
            this.supportedOutputFormats = new VideoFormat[]{new YUVFormat(new Dimension(this.videoWidth, this.videoHeight), outNumOfPixels + (outNumOfPixels >> 1), Format.byteArray, ivf.getFrameRate(), 2, this.videoWidth, this.videoWidth >> 1, 0, outNumOfPixels, outNumOfPixels + (outNumOfPixels >> 2))};
        } else {
            Dimension outSize = this.movieSizeTo263Size(inSize);
            int outNumOfPixels = outSize.width * outSize.height;
            this.videoWidth = outSize.width;
            this.videoHeight = outSize.height;
            this.supportedOutputFormats = new VideoFormat[]{new YUVFormat(inSize, outNumOfPixels + (outNumOfPixels >> 1), Format.byteArray, ivf.getFrameRate(), 2, outSize.width, outSize.width >> 1, 0, outNumOfPixels, outNumOfPixels + (outNumOfPixels >> 2))};
        }
        return this.supportedOutputFormats;
    }

    public Format setInputFormat(Format input) {
        Format ret = super.setInputFormat(input);
        if (ret == null) {
            return null;
        }
        if (this.opened) {
            this.close();
            try {
                this.setOutputFormat(this.getMatchingOutputFormats(input)[0]);
                this.open();
            }
            catch (Exception e2) {
                return null;
            }
        }
        return ret;
    }

    public void open() throws ResourceUnavailableException {
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmvh263");
            NativeDecoder.initNativeDecoderClass();
            this.initDecoder();
            super.open();
            return;
        }
        catch (Throwable throwable) {
            throw new ResourceUnavailableException("could not load jmvh263");
        }
    }

    public void close() {
        this.closeNativeDecoder();
        super.close();
    }

    public void reset() {
    }

    protected void videoResized() {
        this.initDecoder();
    }

    protected void initDecoder() {
        this.closeNativeDecoder();
        this.initNativeDecoder(this.videoWidth, this.videoHeight);
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        int marker;
        int s;
        boolean rtpData = false;
        boolean rtp1998Data = false;
        boolean ret = false;
        Object rtpHeader = null;
        int newWidth = this.videoWidth;
        int newHeight = this.videoHeight;
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        VideoFormat ivf = (VideoFormat)inputBuffer.getFormat();
        int inLength = inputBuffer.getLength();
        int inMaxLength = ivf.getMaxDataLength();
        int outMaxLength = this.outputFormat.getMaxDataLength();
        int inputOffset = inputBuffer.getOffset();
        byte[] inData = (byte[])inputBuffer.getData();
        if (ivf.getEncoding().equals("h263/rtp")) {
            rtpData = true;
            this.payloadLength = this.getPayloadHeaderLength(inData, inputOffset);
            if (inData[inputOffset + this.payloadLength] == 0 && inData[inputOffset + this.payloadLength + 1] == 0 && (inData[inputOffset + this.payloadLength + 2] & 0xFC) == 128) {
                s = inData[inputOffset + this.payloadLength + 4] >> 2 & 7;
                newWidth = widths[s];
                newHeight = heights[s];
                this.FormatSizeInitFlag = true;
            }
        } else if (ivf.getEncoding().equals("h263-1998/rtp")) {
            rtp1998Data = true;
            s = -1;
            int picOffset = -1;
            if (this.getSequenceDiff(this.prevSeq, inputBuffer.getSequenceNumber()) != 1) {
                boolean discard;
                boolean bl = discard = (inData[inputOffset] & 4) == 0;
                if (discard) {
                    return 4;
                }
            }
            this.prevSeq = inputBuffer.getSequenceNumber();
            this.payloadLength = NativeDecoder.get1998PayloadHeaderLength(inData, inputOffset);
            if (this.payloadLength > 5) {
                if ((inData[inputOffset] & 2) == 2 && (inData[inputOffset + 3] & 0xFC) == 128) {
                    picOffset = inputOffset + 3;
                } else if ((inData[inputOffset + 2] & 0xFC) == 128) {
                    picOffset = inputOffset + 2;
                }
            } else if ((inData[inputOffset] & 4) == 4 && (inData[inputOffset + this.payloadLength] & 0xFC) == 128) {
                picOffset = inputOffset + this.payloadLength;
            }
            if (picOffset >= 0 && (s = inData[picOffset + 2] >> 2 & 7) == 7) {
                s = (inData[picOffset + 3] >> 1 & 7) == 1 ? inData[picOffset + 3] << 2 & 4 | inData[picOffset + 4] >> 6 & 3 : -1;
            }
            if (s >= 0) {
                newWidth = widths[s];
                newHeight = heights[s];
                this.FormatSizeInitFlag = true;
            }
        }
        if (this.videoWidth != newWidth || this.videoHeight != newHeight) {
            this.videoWidth = newWidth;
            this.videoHeight = newHeight;
            int outNumOfPixels = this.videoWidth * this.videoHeight;
            this.outputFormat = new YUVFormat(new Dimension(this.videoWidth, this.videoHeight), outNumOfPixels + (outNumOfPixels >> 1), Format.byteArray, ivf.getFrameRate(), 2, this.videoWidth, this.videoWidth >> 1, 0, outNumOfPixels, outNumOfPixels + (outNumOfPixels >> 2));
            outMaxLength = this.outputFormat.getMaxDataLength();
            this.videoResized();
            this.FormatSizeInitFlag = true;
        }
        if ((rtpData || rtp1998Data) && !this.FormatSizeInitFlag) {
            return 1;
        }
        byte[] outData = this.validateByteArraySize(outputBuffer, outMaxLength);
        if (inLength + 8 + inputOffset > inData.length) {
            int newLength = inLength > inMaxLength ? inLength : inMaxLength;
            byte[] tempArray = new byte[inputOffset + newLength + 8];
            System.arraycopy(inData, 0, tempArray, 0, inLength + inputOffset);
            inData = tempArray;
            inputBuffer.setData(tempArray);
        }
        inData[inputOffset + inLength] = 0;
        inData[inputOffset + inLength + 1] = 0;
        inData[inputOffset + inLength + 2] = -4;
        inputBuffer.setLength(inLength += 3);
        if (rtpData) {
            inLength -= this.payloadLength;
            marker = 0;
            if ((inputBuffer.getFlags() & 0x800) != 0) {
                marker = 1;
            }
            ret = this.decodePacketNative(inData, inputOffset + this.payloadLength, inLength, outData, inData, inputOffset, marker, 0);
        } else if (rtp1998Data) {
            inLength -= this.payloadLength;
            marker = 0;
            if ((inputBuffer.getFlags() & 0x800) != 0) {
                marker = 1;
            } else {
                inLength -= 3;
            }
            ret = this.decodePacketNative(inData, inputOffset + this.payloadLength, inLength, outData, inData, inputOffset, marker, 1);
        } else {
            ret = this.decodeFrameNative(inputBuffer, outputBuffer);
        }
        if (ret) {
            this.updateOutput(outputBuffer, this.outputFormat, outMaxLength, 0);
            outputBuffer.setFormat(this.outputFormat);
            return 0;
        }
        return 4;
    }

    private Dimension movieSizeTo263Size(Dimension movieSize) {
        int width = movieSize.width + 15 & 0xFFFFFFF0;
        int height = movieSize.height + 15 & 0xFFFFFFF0;
        int formatCap = width * height >> 8;
        if (formatCap <= 48) {
            return new Dimension(128, 96);
        }
        if (formatCap <= 99) {
            return new Dimension(176, 144);
        }
        if (formatCap <= 396) {
            return new Dimension(352, 288);
        }
        if (formatCap <= 1584) {
            return new Dimension(704, 576);
        }
        if (formatCap <= 6336) {
            return new Dimension(1408, 1152);
        }
        return new Dimension(0, 0);
    }

    private int getPayloadHeaderLength(byte[] input, int offset) {
        int l2 = 0;
        byte b2 = input[offset];
        l2 = (b2 & 0x80) != 0 ? ((b2 & 0x40) != 0 ? 12 : 8) : 4;
        return l2;
    }

    public static int get1998PayloadHeaderLength(byte[] input, int offset) {
        int l2 = 2 + ((input[offset] & 1) << 5) | (input[offset + 1] & 0xF8) >> 3;
        if ((input[offset] & 2) != 0) {
            ++l2;
        }
        return l2;
    }

    public boolean checkFormat(Format format) {
        if (format.getEncoding().equals("h263/rtp")) {
            return true;
        }
        if (format.getEncoding().equals("h263-1998/rtp")) {
            return true;
        }
        return super.checkFormat(format);
    }

    private int getSequenceDiff(long p, long c2) {
        if (c2 > p) {
            return (int)(c2 - p);
        }
        if (c2 == p) {
            return 0;
        }
        if (p > (long)(MAX_SEQ - 100) && c2 < 100L) {
            return (int)((long)MAX_SEQ - p + c2 + 1L);
        }
        return (int)(c2 - p);
    }

    static {
        debug = false;
        widths = new int[]{0, 128, 176, 352, 704, 1408, 0, 0};
        heights = new int[]{0, 96, 144, 288, 576, 1152, 0, 0};
    }
}

