/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser;

import com.sun.media.CircularBuffer;
import com.sun.media.parser.RawParser;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceStream;
import javax.media.protocol.SourceTransferHandler;

public class RawStreamParser
extends RawParser {
    protected SourceStream[] streams;
    protected Track[] tracks = null;
    static final String NAME = "Raw stream parser";

    public String getName() {
        return NAME;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PushDataSource)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        this.streams = ((PushDataSource)source).getStreams();
        if (this.streams == null) {
            throw new IOException("Got a null stream from the DataSource");
        }
        if (this.streams.length == 0) {
            throw new IOException("Got a empty stream array from the DataSource");
        }
        if (!this.supports(this.streams)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        this.source = source;
        this.streams = this.streams;
    }

    protected boolean supports(SourceStream[] streams) {
        return streams[0] != null && streams[0] instanceof PushSourceStream;
    }

    public Track[] getTracks() {
        return this.tracks;
    }

    public void open() {
        if (this.tracks != null) {
            return;
        }
        this.tracks = new Track[this.streams.length];
        int i2 = 0;
        while (i2 < this.streams.length) {
            this.tracks[i2] = new FrameTrack(this, (PushSourceStream)this.streams[i2], 5);
            ++i2;
        }
    }

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                int i2 = 0;
                while (i2 < this.tracks.length) {
                    ((FrameTrack)this.tracks[i2]).stop();
                    ++i2;
                }
                this.source.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.source = null;
        }
    }

    public void start() throws IOException {
        this.source.start();
        int i2 = 0;
        while (i2 < this.tracks.length) {
            ((FrameTrack)this.tracks[i2]).start();
            ++i2;
        }
    }

    public void stop() {
        try {
            this.source.stop();
            int i2 = 0;
            while (i2 < this.tracks.length) {
                ((FrameTrack)this.tracks[i2]).stop();
                ++i2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        NAME = NAME;
    }

    class FrameTrack
    implements Track,
    SourceTransferHandler {
        Demultiplexer parser;
        PushSourceStream pss;
        boolean enabled = true;
        CircularBuffer bufferQ;
        Format format = null;
        TrackListener listener;
        Integer stateReq = new Integer(0);
        boolean stopped = true;

        public FrameTrack(Demultiplexer parser, PushSourceStream pss, int numOfBufs) {
            this.pss = pss;
            pss.setTransferHandler(this);
            this.bufferQ = new CircularBuffer(numOfBufs);
        }

        public Format getFormat() {
            return this.format;
        }

        public void setEnabled(boolean t) {
            if (t) {
                this.pss.setTransferHandler(this);
            } else {
                this.pss.setTransferHandler(null);
            }
            this.enabled = t;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time getDuration() {
            return this.parser.getDuration();
        }

        public Time getStartTime() {
            return new Time(0L);
        }

        public void setTrackListener(TrackListener l2) {
            this.listener = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void readFrame(Buffer buffer) {
            Buffer filled;
            Integer n2 = this.stateReq;
            synchronized (n2) {
                if (this.stopped) {
                    buffer.setDiscard(true);
                    buffer.setFormat(this.format);
                    return;
                }
            }
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                while (!this.bufferQ.canRead()) {
                    try {
                        this.bufferQ.wait();
                        Integer n3 = this.stateReq;
                        synchronized (n3) {
                            if (this.stopped) {
                                buffer.setDiscard(true);
                                buffer.setFormat(this.format);
                                return;
                            }
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                filled = this.bufferQ.read();
                this.bufferQ.notifyAll();
            }
            byte[] data = (byte[])filled.getData();
            filled.setData(buffer.getData());
            buffer.setData(data);
            buffer.setLength(filled.getLength());
            buffer.setFormat(this.format);
            buffer.setTimeStamp(-1L);
            CircularBuffer circularBuffer2 = this.bufferQ;
            synchronized (circularBuffer2) {
                this.bufferQ.readReport();
                this.bufferQ.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Integer n2 = this.stateReq;
            synchronized (n2) {
                this.stopped = true;
            }
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.bufferQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Integer n2 = this.stateReq;
            synchronized (n2) {
                this.stopped = false;
            }
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.bufferQ.notifyAll();
            }
        }

        public int mapTimeToFrame(Time t) {
            return -1;
        }

        public Time mapFrameToTime(int frameNumber) {
            return new Time(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void transferData(PushSourceStream pss) {
            Buffer buffer;
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                while (!this.bufferQ.canWrite()) {
                    try {
                        this.bufferQ.wait();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                buffer = this.bufferQ.getEmptyBuffer();
                this.bufferQ.notifyAll();
            }
            int size = pss.getMinimumTransferSize();
            byte[] data = (byte[])buffer.getData();
            if (data == null || data.length < size) {
                data = new byte[size];
                buffer.setData(data);
            }
            try {
                int len = pss.read(data, 0, size);
                buffer.setLength(len);
            }
            catch (IOException e3) {
                buffer.setDiscard(true);
            }
            CircularBuffer circularBuffer2 = this.bufferQ;
            synchronized (circularBuffer2) {
                this.bufferQ.writeReport();
                this.bufferQ.notifyAll();
                return;
            }
        }
    }
}

