/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.Log;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketConsumer;
import com.sun.media.rtp.util.PacketFilter;
import com.sun.media.rtp.util.RTPPacket;
import com.sun.media.rtp.util.RTPPacketSender;
import com.sun.media.rtp.util.UDPPacket;
import com.sun.media.rtp.util.UDPPacketSender;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.SessionAddress;

public class RTPRawSender
extends PacketFilter {
    private InetAddress destaddr;
    private int destport;
    private DatagramSocket socket = null;
    private RTPConnector rtpConnector = null;

    public String filtername() {
        return "RTP Raw Packet Sender";
    }

    public RTPRawSender(int n2, String string) throws UnknownHostException, IOException {
        this.destaddr = InetAddress.getByName(string);
        this.destport = n2;
        this.destAddressList = null;
    }

    public RTPRawSender(int n2, String string, UDPPacketSender uDPPacketSender) throws UnknownHostException, IOException {
        this(n2, string);
        this.socket = uDPPacketSender.getSocket();
        this.setConsumer(uDPPacketSender);
        this.destAddressList = null;
    }

    public RTPRawSender(RTPPacketSender rTPPacketSender) {
        this.rtpConnector = rTPPacketSender.getConnector();
        this.setConsumer(rTPPacketSender);
    }

    public InetAddress getRemoteAddr() {
        return this.destaddr;
    }

    public void setSendBufSize(int n2) {
        try {
            if (this.socket != null) {
                Class<?> clazz = this.socket.getClass();
                Method method = clazz.getMethod("setSendBufferSize", Integer.TYPE);
                method.invoke((Object)this.socket, new Integer(n2));
            } else if (this.rtpConnector != null) {
                this.rtpConnector.setSendBufferSize(n2);
            }
        }
        catch (Exception exception) {
            Log.comment("Cannot set send buffer size: " + exception);
        }
    }

    public int getSendBufSize() {
        try {
            if (this.socket != null) {
                Class<?> clazz = this.socket.getClass();
                Method method = clazz.getMethod("getSendBufferSize", null);
                Integer n2 = (Integer)method.invoke((Object)this.socket, null);
                return n2;
            }
            if (this.rtpConnector != null) {
                return this.rtpConnector.getSendBufferSize();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public Packet handlePacket(Packet packet, int n2) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionAddress) {
        this.assemble((RTPPacket)packet);
        PacketConsumer packetConsumer = this.getConsumer();
        if (packetConsumer instanceof RTPPacketSender) {
            return packet;
        }
        UDPPacket uDPPacket = new UDPPacket();
        uDPPacket.received = false;
        uDPPacket.data = packet.data;
        uDPPacket.offset = packet.offset;
        uDPPacket.length = packet.length;
        uDPPacket.remoteAddress = sessionAddress.getDataAddress();
        uDPPacket.remotePort = sessionAddress.getDataPort();
        return uDPPacket;
    }

    public Packet handlePacket(Packet packet) {
        this.assemble((RTPPacket)packet);
        PacketConsumer packetConsumer = this.getConsumer();
        if (packetConsumer instanceof RTPPacketSender) {
            return packet;
        }
        UDPPacket uDPPacket = new UDPPacket();
        uDPPacket.received = false;
        uDPPacket.data = packet.data;
        uDPPacket.offset = packet.offset;
        uDPPacket.length = packet.length;
        uDPPacket.remoteAddress = this.destaddr;
        uDPPacket.remotePort = this.destport;
        return uDPPacket;
    }

    public void assemble(RTPPacket rTPPacket) {
        int n2 = rTPPacket.calcLength();
        rTPPacket.assemble(n2, false);
    }

    public void setDestAddresses(Vector vector) {
        this.destAddressList = vector;
    }
}

