/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.customizer;

import com.sun.media.customizer.I18N;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GeneralPane
extends JPanel
implements ActionListener {
    public static final int MFILE = 0;
    public static final int RTPREC = 1;
    public static final int CAPTURE = 2;
    public static final int PLAY = 3;
    public static final int RTPTRANS = 4;
    public static final int TRANSCODE = 5;
    public static final int GUI = 6;
    public static final int STUDIO = 7;
    public static final int BEAN = 8;
    JFrame parent;
    String srcJARname = "jmf.jar";
    String dstJARname = "custom.jar";
    JButton bsrc;
    JButton bdst;
    JTextField srcFile;
    JTextField dstFile;
    JCheckBox[] funcs = new JCheckBox[9];
    JCheckBox twoJar;
    boolean[] resultFuncs = new boolean[9];
    int release = 0;

    public GeneralPane(JFrame parent) {
        this.parent = parent;
        this.bsrc = new JButton(I18N.getResource("GeneralPane.Browse"));
        this.bdst = new JButton(I18N.getResource("GeneralPane.Browse"));
        this.bsrc.addActionListener(this);
        this.bdst.addActionListener(this);
        this.srcFile = new JTextField(this.srcJARname, 20);
        this.dstFile = new JTextField(this.dstJARname, 20);
        JPanel srcPane = new JPanel();
        JPanel dstPane = new JPanel();
        JPanel twoJarPane = new JPanel();
        srcPane.add(new JLabel(I18N.getResource("GeneralPane.SrcJar")));
        srcPane.add(this.srcFile);
        srcPane.add(this.bsrc);
        dstPane.add(new JLabel(I18N.getResource("GeneralPane.DstJar")));
        dstPane.add(this.dstFile);
        dstPane.add(this.bdst);
        this.twoJar = new JCheckBox(I18N.getResource("GeneralPane.twoJar"), false);
        twoJarPane.add(this.twoJar);
        JPanel jarPane = new JPanel(new GridLayout(3, 1));
        jarPane.add(srcPane);
        jarPane.add(dstPane);
        jarPane.add(twoJarPane);
        JPanel funcPane = this.createFuncPane();
        this.setLayout(new BorderLayout());
        this.add("South", jarPane);
        this.add("Center", funcPane);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.bsrc) {
            JFileChooser fd = new JFileChooser();
            fd.setCurrentDirectory(new File("."));
            fd.setSelectedFile(new File(this.srcJARname));
            int result = fd.showOpenDialog(this.parent);
            if (result == 0) {
                this.srcJARname = fd.getSelectedFile() != null ? fd.getSelectedFile().getAbsolutePath() : "nothing";
                this.srcFile.setText(this.srcJARname);
            }
        } else if (evt.getSource() == this.bdst) {
            JFileChooser fd = new JFileChooser();
            fd.setCurrentDirectory(new File("."));
            fd.setSelectedFile(new File(this.dstJARname));
            int result = fd.showSaveDialog(this.parent);
            if (result == 0) {
                this.dstJARname = fd.getSelectedFile() != null ? fd.getSelectedFile().getAbsolutePath() : "nothing";
                this.dstFile.setText(this.dstJARname);
            }
        }
    }

    public String getSrcJARName() {
        this.srcJARname = this.srcFile.getText();
        return this.srcJARname;
    }

    public String getDstJARName() {
        this.dstJARname = this.dstFile.getText();
        return this.dstJARname;
    }

    private JPanel createFuncPane() {
        this.funcs[0] = new JCheckBox(I18N.getResource("GeneralPane.MFILES"), true);
        this.funcs[1] = new JCheckBox(I18N.getResource("GeneralPane.RTPRECV"), false);
        this.funcs[2] = new JCheckBox(I18N.getResource("GeneralPane.CAPTURE"), false);
        this.funcs[3] = new JCheckBox(I18N.getResource("GeneralPane.PLAY"), true);
        this.funcs[4] = new JCheckBox(I18N.getResource("GeneralPane.RTPTRANS"), false);
        this.funcs[5] = new JCheckBox(I18N.getResource("GeneralPane.TRANSCODE"), false);
        this.funcs[6] = new JCheckBox(I18N.getResource("GeneralPane.GUI"), true);
        this.funcs[7] = new JCheckBox(I18N.getResource("GeneralPane.DEMO"), false);
        this.funcs[8] = new JCheckBox(I18N.getResource("GeneralPane.BEAN"), false);
        JPanel srcpanel = new JPanel(new GridLayout(3, 1));
        srcpanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), I18N.getResource("GeneralPane.MSOURCE")));
        int i = 0;
        while (i < 3) {
            srcpanel.add(this.funcs[i]);
            ++i;
        }
        JPanel snkpanel = new JPanel(new GridLayout(3, 1));
        snkpanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), I18N.getResource("GeneralPane.MSINK")));
        int i2 = 3;
        while (i2 < 6) {
            snkpanel.add(this.funcs[i2]);
            ++i2;
        }
        JPanel optpanel = new JPanel(new GridLayout(3, 1));
        optpanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), I18N.getResource("GeneralPane.OPTCOMP")));
        int i3 = 7;
        while (i3 < 9) {
            optpanel.add(this.funcs[i3]);
            ++i3;
        }
        JPanel panel = new JPanel(new GridLayout(1, 3));
        panel.add(srcpanel);
        panel.add(snkpanel);
        panel.add(optpanel);
        return panel;
    }

    public boolean[] getState() {
        int i = 0;
        while (i < 9) {
            this.resultFuncs[i] = this.funcs[i].isEnabled() && this.funcs[i].isSelected();
            ++i;
        }
        return this.resultFuncs;
    }

    public boolean checking(boolean[] func, JFrame parent) {
        boolean vv = func[0] || func[1] || func[2];
        boolean bl = func[3] || func[4] || func[5];
        this.srcJARname = this.srcFile.getText();
        this.dstJARname = this.dstFile.getText();
        if (!(vv &= bl)) {
            JOptionPane.showMessageDialog(parent, I18N.getResource("GeneralPane.s1s1"), I18N.getResource("GeneralPane.WRONGSEL"), 0);
            return false;
        }
        if (this.srcJARname == null || this.srcJARname.length() <= 0) {
            JOptionPane.showMessageDialog(parent, I18N.getResource("GeneralPane.INPUTSRCJAR"), I18N.getResource("GeneralPane.BADSRCJAR"), 0);
            return false;
        }
        File srcFileHandle = new File(this.srcJARname);
        if (!srcFileHandle.exists() || srcFileHandle.length() == 0L) {
            JOptionPane.showMessageDialog(parent, I18N.getResource("GeneralPane.SRCJARNOTEXIST"), I18N.getResource("GeneralPane.BADSRCJAR"), 0);
            return false;
        }
        try {
            ZipFile zp = new ZipFile(srcFileHandle);
            this.release = zp.getEntry("com/sun/media/codec/video/cinepakpro/NativeEncoder$DC.class") != null ? 2 : (zp.getEntry("com/ibm/media/codec/audio/ACMCodec.class") != null ? 3 : 1);
            zp.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.dstJARname == null || this.dstJARname.length() <= 0) {
            JOptionPane.showMessageDialog(parent, I18N.getResource("GeneralPane.INPUTDSTJAR"), I18N.getResource("GeneralPane.BADTARJAR"), 0);
            return false;
        }
        if (this.srcJARname.equalsIgnoreCase(this.dstJARname)) {
            JOptionPane.showMessageDialog(parent, I18N.getResource("GeneralPane.SRCDSTJAR"), I18N.getResource("GeneralPane.BADTARJAR"), 0);
            return false;
        }
        return true;
    }

    public int getRelease() {
        return this.release;
    }

    public boolean genTwoJars() {
        return this.twoJar.isEnabled() && this.twoJar.isSelected();
    }

    static {
        MFILE = 0;
        RTPREC = 1;
        CAPTURE = 2;
        PLAY = 3;
        RTPTRANS = 4;
        TRANSCODE = 5;
        GUI = 6;
        STUDIO = 7;
        BEAN = 8;
    }
}

