/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicConnector;
import com.sun.media.CircularBuffer;
import com.sun.media.InputConnector;
import com.sun.media.OutputConnector;
import javax.media.Buffer;

public class BasicInputConnector
extends BasicConnector
implements InputConnector {
    protected OutputConnector outputConnector = null;
    private boolean reset = false;

    public OutputConnector getOutputConnector() {
        return this.outputConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        CircularBuffer circularBuffer = this.circularBuffer;
        synchronized (circularBuffer) {
            this.reset = true;
            super.reset();
            this.circularBuffer.notifyAll();
        }
    }

    public boolean isValidBufferAvailable() {
        return this.circularBuffer.canRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Buffer getValidBuffer() {
        switch (this.protocol) {
            case 0: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    if (!this.isValidBufferAvailable() && this.reset) {
                        return null;
                    }
                    this.reset = false;
                    return this.circularBuffer.read();
                }
            }
            case 1: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    this.reset = false;
                    while (true) {
                        if (this.reset || this.isValidBufferAvailable()) {
                            if (!this.reset) break;
                            return null;
                        }
                        try {
                            this.circularBuffer.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    Buffer buffer = this.circularBuffer.read();
                    this.circularBuffer.notifyAll();
                    return buffer;
                }
            }
        }
        throw new RuntimeException();
    }

    public void setOutputConnector(OutputConnector outputConnector) {
        this.outputConnector = outputConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readReport() {
        switch (this.protocol) {
            case 0: 
            case 1: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    if (this.reset) {
                        return;
                    }
                    this.circularBuffer.readReport();
                    this.circularBuffer.notifyAll();
                    return;
                }
            }
        }
        throw new RuntimeException();
    }
}

