/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.javasound;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.CircularBuffer;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.protocol.BasicSourceStream;
import com.sun.media.protocol.javasound.DataSource;
import com.sun.media.protocol.javasound.PushThread;
import com.sun.media.protocol.javasound.jdk12CreateThreadAction;
import com.sun.media.renderer.audio.device.JavaSoundOutput;
import com.sun.media.ui.AudioFormatChooser;
import com.sun.media.util.Arch;
import com.sun.media.util.jdk12;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.Control;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.Owned;
import javax.media.control.BufferControl;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;

public class JavaSoundSourceStream
extends BasicSourceStream
implements PushBufferStream {
    DataSource dsource;
    TargetDataLine dataLine = null;
    AudioFormat format;
    AudioFormat devFormat;
    boolean reconnect = false;
    int bufSize;
    BufferTransferHandler transferHandler;
    boolean started = false;
    AudioFormatChooser afc;
    BufferControl bc;
    CircularBuffer cb = new CircularBuffer(1);
    PushThread pushThread = null;
    static int DefRate = 44100;
    static int DefBits = 16;
    static int DefChannels = 2;
    static int DefSigned = 1;
    static int DefEndian = Arch.isBigEndian() ? 1 : 0;
    static int OtherEndian = Arch.isBigEndian() ? 1 : 0;
    static Format[] supported;
    protected static CaptureDeviceInfo[] deviceList;
    private static JMFSecurity jmfSecurity;
    private static boolean securityPrivelege;
    private Method[] mSecurity = new Method[1];
    private Class[] clSecurity = new Class[1];
    private Object[][] argsSecurity = new Object[1][0];
    static int DefaultMinBufferSize;
    static int DefaultMaxBufferSize;
    long bufLenReq = 125L;
    static /* synthetic */ Class class$com$sun$media$protocol$javasound$PushThread;
    static /* synthetic */ Class class$javax$sound$sampled$TargetDataLine;

    public JavaSoundSourceStream(DataSource ds) {
        super(new ContentDescriptor("raw"), -1L);
        this.dsource = ds;
        this.bc = new BC(this);
        this.controls = new Control[2];
        this.controls[0] = new FC(this);
        this.controls[1] = this.bc;
    }

    public static Format parseLocator(MediaLocator ml) {
        String rateStr = null;
        String bitsStr = null;
        String channelsStr = null;
        String endianStr = null;
        String signedStr = null;
        String remainder = ml.getRemainder();
        if (remainder != null && remainder.length() > 0) {
            while (remainder.length() > 1 && remainder.charAt(0) == '/') {
                remainder = remainder.substring(1);
            }
            int off = remainder.indexOf(47);
            if (off == -1) {
                if (!remainder.equals("")) {
                    rateStr = remainder;
                }
            } else {
                rateStr = remainder.substring(0, off);
                if ((off = (remainder = remainder.substring(off + 1)).indexOf(47)) == -1) {
                    if (!remainder.equals("")) {
                        bitsStr = remainder;
                    }
                } else {
                    bitsStr = remainder.substring(0, off);
                    if ((off = (remainder = remainder.substring(off + 1)).indexOf(47)) == -1) {
                        if (!remainder.equals("")) {
                            channelsStr = remainder;
                        }
                    } else {
                        channelsStr = remainder.substring(0, off);
                        if ((off = (remainder = remainder.substring(off + 1)).indexOf(47)) == -1) {
                            if (!remainder.equals("")) {
                                endianStr = remainder;
                            }
                        } else {
                            endianStr = remainder.substring(0, off);
                            if (!remainder.equals("")) {
                                signedStr = remainder.substring(off + 1);
                            }
                        }
                    }
                }
            }
        }
        int rate = DefRate;
        if (rateStr != null) {
            try {
                Integer integer = Integer.valueOf(rateStr);
                if (integer != null) {
                    rate = integer;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (rate <= 0 || rate > 96000) {
                Log.warning("JavaSound capture: unsupported sample rate: " + rate);
                rate = DefRate;
                Log.warning("        defaults to: " + rate);
            }
        }
        int bits = DefBits;
        if (bitsStr != null) {
            try {
                Integer integer = Integer.valueOf(bitsStr);
                if (integer != null) {
                    bits = integer;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (bits != 8 && bits != 16) {
                Log.warning("JavaSound capture: unsupported sample size: " + bits);
                bits = DefBits;
                Log.warning("        defaults to: " + bits);
            }
        }
        int channels = DefChannels;
        if (channelsStr != null) {
            try {
                Integer integer = Integer.valueOf(channelsStr);
                if (integer != null) {
                    channels = integer;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (channels != 1 && channels != 2) {
                Log.warning("JavaSound capture: unsupported # of channels: " + channels);
                channels = DefChannels;
                Log.warning("        defaults to: " + channels);
            }
        }
        int endian = DefEndian;
        if (endianStr != null) {
            if (endianStr.equalsIgnoreCase("big")) {
                endian = 1;
            } else if (endianStr.equalsIgnoreCase("little")) {
                endian = 0;
            } else {
                Log.warning("JavaSound capture: unsupported endianess: " + endianStr);
                Log.warning("        defaults to: big endian");
            }
        }
        int signed = DefSigned;
        if (signedStr != null) {
            if (signedStr.equalsIgnoreCase("signed")) {
                signed = 1;
            } else if (signedStr.equalsIgnoreCase("unsigned")) {
                signed = 0;
            } else {
                Log.warning("JavaSound capture: unsupported signedness: " + signedStr);
                Log.warning("        defaults to: signed");
            }
        }
        AudioFormat fmt = new AudioFormat("LINEAR", rate, bits, channels, endian, signed);
        return fmt;
    }

    public Format setFormat(Format fmt) {
        if (this.started) {
            Log.warning("Cannot change audio capture format after started.");
            return this.format;
        }
        if (fmt == null) {
            return this.format;
        }
        Format f2 = null;
        int i2 = 0;
        while (i2 < supported.length) {
            if (fmt.matches(supported[i2]) && (f2 = fmt.intersects(supported[i2])) != null) break;
            ++i2;
        }
        if (f2 == null) {
            return this.format;
        }
        try {
            if (this.devFormat != null) {
                if (!this.devFormat.matches(f2) && !JavaSoundOutput.isOpen()) {
                    this.format = (AudioFormat)f2;
                    this.disconnect();
                    this.connect();
                }
            } else {
                this.format = (AudioFormat)f2;
                this.connect();
            }
        }
        catch (IOException e2) {
            return null;
        }
        if (this.afc != null) {
            this.afc.setCurrentFormat(this.format);
        }
        return this.format;
    }

    public boolean isConnected() {
        return this.devFormat != null;
    }

    public void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        if (JavaSoundOutput.isOpen()) {
            Log.warning("JavaSound is already opened for rendering.  Will capture at the default format.");
            this.format = null;
        }
        this.openDev();
        if (this.pushThread == null) {
            if (jmfSecurity != null) {
                String permission = null;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        permission = "thread";
                        jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 16);
                        this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                        permission = "thread group";
                        jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 32);
                        this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                    }
                }
                catch (Throwable e2) {
                    securityPrivelege = false;
                }
            }
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                try {
                    Constructor cons = jdk12CreateThreadAction.cons;
                    this.pushThread = (PushThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$protocol$javasound$PushThread == null ? (class$com$sun$media$protocol$javasound$PushThread = JavaSoundSourceStream.class$("com.sun.media.protocol.javasound.PushThread")) : class$com$sun$media$protocol$javasound$PushThread));
                }
                catch (Exception exception) {}
            } else {
                this.pushThread = new PushThread();
            }
            this.pushThread.setSourceStream(this);
        }
        if (this.reconnect) {
            Log.comment("Capture buffer size: " + this.bufSize);
        }
        this.devFormat = this.format;
        this.reconnect = false;
    }

    void openDev() throws IOException {
        DataLine.Info info;
        javax.sound.sampled.AudioFormat afmt = null;
        if (this.format != null) {
            afmt = JavaSoundOutput.convertFormat(this.format);
            int chnls = this.format.getChannels() == -1 ? 1 : this.format.getChannels();
            int size = this.format.getSampleSizeInBits() == -1 ? 16 : this.format.getSampleSizeInBits();
            int frameSize = size * chnls / 8;
            if (frameSize == 0) {
                frameSize = 1;
            }
            this.bufSize = (int)(this.format.getSampleRate() * (double)frameSize * (double)this.bc.getBufferLength() / 1000.0);
            info = new DataLine.Info(class$javax$sound$sampled$TargetDataLine == null ? (class$javax$sound$sampled$TargetDataLine = JavaSoundSourceStream.class$("javax.sound.sampled.TargetDataLine")) : class$javax$sound$sampled$TargetDataLine, afmt, this.bufSize);
        } else {
            info = new DataLine.Info(class$javax$sound$sampled$TargetDataLine == null ? (class$javax$sound$sampled$TargetDataLine = JavaSoundSourceStream.class$("javax.sound.sampled.TargetDataLine")) : class$javax$sound$sampled$TargetDataLine, null, -1);
        }
        if (!AudioSystem.isLineSupported(info)) {
            Log.error("Audio not supported: " + info + "\n");
            throw new IOException("Cannot open audio device for input.");
        }
        try {
            this.dataLine = (TargetDataLine)AudioSystem.getLine(info);
            if (this.format != null) {
                this.dataLine.open(afmt, this.bufSize);
            } else {
                this.dataLine.open();
                this.format = JavaSoundOutput.convertFormat(this.dataLine.getFormat());
            }
            this.bufSize = this.dataLine.getBufferSize();
        }
        catch (Exception e2) {
            Log.error("Cannot open audio device for input: " + e2);
            throw new IOException(e2.getMessage());
        }
    }

    public void disconnect() {
        if (this.dataLine == null) {
            return;
        }
        this.dataLine.stop();
        this.dataLine.close();
        this.dataLine = null;
        this.devFormat = null;
        if (this.pushThread != null) {
            this.pushThread.kill();
            this.pushThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        if (this.dataLine == null) {
            throw new IOException("A JavaSound input channel cannot be opened.");
        }
        if (this.started) {
            return;
        }
        if (this.afc != null) {
            Format f2 = this.afc.getFormat();
            if (f2 == null || f2.matches(this.format) || this.setFormat(f2) == null) {
                // empty if block
            }
            this.afc.setEnabled(false);
        }
        if (this.reconnect) {
            this.disconnect();
        }
        if (!this.isConnected()) {
            this.connect();
        }
        CircularBuffer circularBuffer = this.cb;
        synchronized (circularBuffer) {
            while (this.cb.canRead()) {
                this.cb.read();
                this.cb.readReport();
            }
            this.cb.notifyAll();
        }
        this.pushThread.start();
        this.dataLine.flush();
        this.dataLine.start();
        this.started = true;
    }

    public void stop() throws IOException {
        if (!this.started) {
            return;
        }
        this.pushThread.pause();
        if (this.dataLine != null) {
            this.dataLine.stop();
        }
        this.started = false;
        if (this.afc != null && !JavaSoundOutput.isOpen()) {
            this.afc.setEnabled(true);
        }
    }

    public Format getFormat() {
        return this.format;
    }

    public Object[] getControls() {
        return this.controls;
    }

    public static Format[] getSupportedFormats() {
        return supported;
    }

    public static CaptureDeviceInfo[] listCaptureDeviceInfo() {
        return deviceList;
    }

    public void setTransferHandler(BufferTransferHandler th) {
        this.transferHandler = th;
    }

    public boolean willReadBlock() {
        return !this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(Buffer in) {
        Buffer buffer;
        CircularBuffer circularBuffer = this.cb;
        synchronized (circularBuffer) {
            while (!this.cb.canRead()) {
                try {
                    this.cb.wait();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            buffer = this.cb.read();
        }
        Object data = in.getData();
        in.copy(buffer);
        buffer.setData(data);
        CircularBuffer circularBuffer2 = this.cb;
        synchronized (circularBuffer2) {
            this.cb.readReport();
            this.cb.notify();
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        jmfSecurity = null;
        securityPrivelege = false;
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        supported = new Format[]{new AudioFormat("LINEAR", 44100.0, 16, 2, DefEndian, DefSigned), new AudioFormat("LINEAR", 44100.0, 16, 1, DefEndian, DefSigned), new AudioFormat("LINEAR", 22050.0, 16, 2, DefEndian, DefSigned), new AudioFormat("LINEAR", 22050.0, 16, 1, DefEndian, DefSigned), new AudioFormat("LINEAR", 11025.0, 16, 2, DefEndian, DefSigned), new AudioFormat("LINEAR", 11025.0, 16, 1, DefEndian, DefSigned), new AudioFormat("LINEAR", 8000.0, 16, 2, DefEndian, DefSigned), new AudioFormat("LINEAR", 8000.0, 16, 1, DefEndian, DefSigned)};
        deviceList = new CaptureDeviceInfo[]{new CaptureDeviceInfo("JavaSound audio capture", new MediaLocator("javasound://44100"), supported)};
        DefaultMinBufferSize = 16;
        DefaultMaxBufferSize = 4000;
    }

    class BC
    implements BufferControl,
    Owned {
        JavaSoundSourceStream jsss;

        BC(JavaSoundSourceStream js) {
            this.jsss = js;
        }

        public long getBufferLength() {
            return JavaSoundSourceStream.this.bufLenReq;
        }

        public long setBufferLength(long time) {
            JavaSoundSourceStream.this.bufLenReq = time < (long)DefaultMinBufferSize ? (long)DefaultMinBufferSize : (time > (long)DefaultMaxBufferSize ? (long)DefaultMaxBufferSize : time);
            Log.comment("Capture buffer length set: " + JavaSoundSourceStream.this.bufLenReq);
            JavaSoundSourceStream.this.reconnect = true;
            return JavaSoundSourceStream.this.bufLenReq;
        }

        public long getMinimumThreshold() {
            return 0L;
        }

        public long setMinimumThreshold(long time) {
            return 0L;
        }

        public void setEnabledThreshold(boolean b2) {
        }

        public boolean getEnabledThreshold() {
            return false;
        }

        public Component getControlComponent() {
            return null;
        }

        public Object getOwner() {
            return JavaSoundSourceStream.this.dsource;
        }
    }

    class FC
    implements FormatControl,
    Owned {
        JavaSoundSourceStream jsss;

        public FC(JavaSoundSourceStream jsss) {
            this.jsss = jsss;
        }

        public Object getOwner() {
            return JavaSoundSourceStream.this.dsource;
        }

        public Format getFormat() {
            return JavaSoundSourceStream.this.format;
        }

        public Format setFormat(Format fmt) {
            return this.jsss.setFormat(fmt);
        }

        public Format[] getSupportedFormats() {
            return supported;
        }

        public boolean isEnabled() {
            return true;
        }

        public void setEnabled(boolean enabled) {
        }

        public Component getControlComponent() {
            if (JavaSoundSourceStream.this.afc == null) {
                JavaSoundSourceStream.this.afc = new AudioFormatChooser(supported, JavaSoundSourceStream.this.format);
                JavaSoundSourceStream.this.afc.setName("JavaSound");
                if (JavaSoundSourceStream.this.started || JavaSoundSourceStream.this.dataLine == null || JavaSoundOutput.isOpen()) {
                    JavaSoundSourceStream.this.afc.setEnabled(false);
                }
            }
            return JavaSoundSourceStream.this.afc;
        }
    }
}

