/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class SSRCTable {
    static final int INCR = 16;
    int[] ssrcList = new int[16];
    Object[] objList = new Object[16];
    int total = 0;

    public synchronized void put(int n2, Object object) {
        if (this.total == 0) {
            this.ssrcList[0] = n2;
            this.objList[0] = object;
            this.total = 1;
            return;
        }
        int n3 = 0;
        while (n3 < this.total) {
            if (this.ssrcList[n3] >= n2) {
                if (this.ssrcList[n3] != n2) break;
                this.objList[n3] = object;
                return;
            }
            ++n3;
        }
        if (this.total == this.ssrcList.length) {
            int[] nArray = new int[this.ssrcList.length + 16];
            Object[] objectArray = new Object[this.objList.length + 16];
            if (n3 > 0) {
                System.arraycopy(this.ssrcList, 0, nArray, 0, this.total);
                System.arraycopy(this.objList, 0, objectArray, 0, this.total);
            }
            this.ssrcList = nArray;
            this.objList = objectArray;
        }
        int n4 = this.total - 1;
        while (n4 >= n3) {
            this.ssrcList[n4 + 1] = this.ssrcList[n4];
            this.objList[n4 + 1] = this.objList[n4];
            --n4;
        }
        this.ssrcList[n3] = n2;
        this.objList[n3] = object;
        ++this.total;
    }

    private int indexOf(int n2) {
        if (this.total <= 3) {
            if (this.total > 0 && this.ssrcList[0] == n2) {
                return 0;
            }
            if (this.total > 1 && this.ssrcList[1] == n2) {
                return 1;
            }
            if (this.total > 2 && this.ssrcList[2] == n2) {
                return 2;
            }
            return -1;
        }
        if (this.ssrcList[0] == n2) {
            return 0;
        }
        if (this.ssrcList[this.total - 1] == n2) {
            return this.total - 1;
        }
        int n3 = 0;
        int n4 = this.total - 1;
        do {
            int n5;
            if (this.ssrcList[n5 = (n4 - n3) / 2 + n3] == n2) {
                return n5;
            }
            if (n2 > this.ssrcList[n5]) {
                n3 = n5 + 1;
                continue;
            }
            if (n2 >= this.ssrcList[n5]) continue;
            n4 = n5;
        } while (n3 < n4);
        return -1;
    }

    public synchronized Object remove(int n2) {
        int n3 = this.indexOf(n2);
        if (n3 < 0) {
            return null;
        }
        Object object = this.objList[n3];
        while (n3 < this.total - 1) {
            this.ssrcList[n3] = this.ssrcList[n3 + 1];
            this.objList[n3] = this.objList[n3 + 1];
            ++n3;
        }
        this.ssrcList[this.total - 1] = 0;
        this.objList[this.total - 1] = null;
        --this.total;
        return object;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void removeObj(Object var1_1) {
        if (var1_1 == null) {
            return;
        }
        var2_2 = 0;
        while (var2_2 < this.total) {
            if (this.objList[var2_2] == var1_1) break;
            ++var2_2;
        }
        if (var2_2 < this.total) ** GOTO lbl13
        return;
lbl-1000:
        // 1 sources

        {
            this.ssrcList[var2_2] = this.ssrcList[var2_2 + 1];
            this.objList[var2_2] = this.objList[var2_2 + 1];
            ++var2_2;
lbl13:
            // 2 sources

            ** while (var2_2 < this.total - 1)
        }
lbl14:
        // 1 sources

        this.ssrcList[this.total - 1] = 0;
        this.objList[this.total - 1] = null;
        --this.total;
    }

    public synchronized void removeAll() {
        int n2 = 0;
        while (n2 < this.total) {
            this.ssrcList[n2] = 0;
            this.objList[n2] = null;
            ++n2;
        }
        this.total = 0;
    }

    public int size() {
        return this.total;
    }

    public synchronized Object get(int n2) {
        int n3 = this.indexOf(n2);
        if (n3 < 0) {
            return null;
        }
        return this.objList[n3];
    }

    public synchronized int getSSRC(Object object) {
        int n2 = 0;
        while (n2 < this.total) {
            if (this.objList[n2] == object) {
                return this.ssrcList[n2];
            }
            ++n2;
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.total == 0;
    }

    public synchronized Enumeration elements() {
        return new Enumeration(){
            int next = 0;

            public boolean hasMoreElements() {
                return this.next < SSRCTable.this.total;
            }

            public Object nextElement() {
                SSRCTable sSRCTable = SSRCTable.this;
                synchronized (sSRCTable) {
                    if (this.next < SSRCTable.this.total) {
                        Object object = SSRCTable.this.objList[this.next++];
                        return object;
                    }
                }
                throw new NoSuchElementException("SSRCTable Enumeration");
            }
        };
    }
}

