/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import javax.media.Format;

public class Buffer {
    protected long timeStamp = -1L;
    protected long duration = -1L;
    protected Format format = null;
    protected int flags = 0;
    protected Object data = null;
    protected Object header = null;
    protected int length = 0;
    protected int offset = 0;
    protected long sequenceNumber = 0x7FFFFFFFFFFFFFFEL;
    public static final int FLAG_EOM = 1;
    public static final int FLAG_DISCARD = 2;
    public static final int FLAG_SILENCE = 4;
    public static final int FLAG_SID = 8;
    public static final int FLAG_KEY_FRAME = 16;
    public static final int FLAG_NO_DROP = 32;
    public static final int FLAG_NO_WAIT = 64;
    public static final int FLAG_NO_SYNC = 96;
    public static final int FLAG_SYSTEM_TIME = 128;
    public static final int FLAG_RELATIVE_TIME = 256;
    public static final int FLAG_FLUSH = 512;
    public static final int FLAG_SYSTEM_MARKER = 1024;
    public static final int FLAG_RTP_MARKER = 2048;
    public static final int FLAG_RTP_TIME = 4096;
    public static final int FLAG_BUF_OVERFLOWN = 8192;
    public static final int FLAG_BUF_UNDERFLOWN = 16384;
    public static final int FLAG_LIVE_DATA = 32768;
    public static final long TIME_UNKNOWN = -1L;
    public static final long SEQUENCE_UNKNOWN = 0x7FFFFFFFFFFFFFFEL;

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean isEOM() {
        return (this.flags & 1) != 0;
    }

    public void setEOM(boolean eom) {
        this.flags = eom ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public boolean isDiscard() {
        return (this.flags & 2) != 0;
    }

    public void setDiscard(boolean discard) {
        this.flags = discard ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getHeader() {
        return this.header;
    }

    public void setHeader(Object header) {
        this.header = header;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setSequenceNumber(long number) {
        this.sequenceNumber = number;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void copy(Buffer buffer) {
        this.copy(buffer, false);
    }

    public void copy(Buffer buffer, boolean swapData) {
        if (swapData) {
            Object temp = this.data;
            this.data = buffer.data;
            buffer.data = temp;
        } else {
            this.data = buffer.data;
        }
        this.header = buffer.header;
        this.format = buffer.format;
        this.length = buffer.length;
        this.offset = buffer.offset;
        this.timeStamp = buffer.timeStamp;
        this.duration = buffer.duration;
        this.sequenceNumber = buffer.sequenceNumber;
        this.flags = buffer.flags;
    }

    public Object clone() {
        Buffer buf = new Buffer();
        Object data = this.getData();
        if (data != null) {
            buf.data = data instanceof byte[] ? ((byte[])data).clone() : (data instanceof int[] ? ((int[])data).clone() : (data instanceof short[] ? ((short[])data).clone() : data));
        }
        if (this.header != null) {
            buf.header = this.header instanceof byte[] ? ((byte[])this.header).clone() : (this.header instanceof int[] ? ((int[])this.header).clone() : (this.header instanceof short[] ? ((short[])this.header).clone() : this.header));
        }
        buf.format = this.format;
        buf.length = this.length;
        buf.offset = this.offset;
        buf.timeStamp = this.timeStamp;
        buf.duration = this.duration;
        buf.sequenceNumber = this.sequenceNumber;
        buf.flags = this.flags;
        return buf;
    }

    static {
        FLAG_EOM = 1;
        FLAG_DISCARD = 2;
        FLAG_SILENCE = 4;
        FLAG_SID = 8;
        FLAG_KEY_FRAME = 16;
        FLAG_NO_DROP = 32;
        FLAG_NO_WAIT = 64;
        FLAG_NO_SYNC = 96;
        FLAG_SYSTEM_TIME = 128;
        FLAG_RELATIVE_TIME = 256;
        FLAG_FLUSH = 512;
        FLAG_SYSTEM_MARKER = 1024;
        FLAG_RTP_MARKER = 2048;
        FLAG_RTP_TIME = 4096;
        FLAG_BUF_OVERFLOWN = 8192;
        FLAG_BUF_UNDERFLOWN = 16384;
        FLAG_LIVE_DATA = 32768;
        TIME_UNKNOWN = -1L;
        SEQUENCE_UNKNOWN = 0x7FFFFFFFFFFFFFFEL;
    }
}

