/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;

public class TextView
extends Canvas {
    private String strText;
    private Insets insetsBorder = new Insets(4, 12, 4, 12);
    private int nPreferredWidth = 0;
    private static Image imageBuffer = null;

    public TextView(String strText) {
        this.strText = strText;
    }

    public void setText(String strText) {
        this.strText = strText;
        this.repaint();
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    public void update(Graphics graphics) {
        Graphics graphicsNew;
        int nWidth = 0;
        int nHeight = 0;
        Dimension dim = this.getSize();
        if (imageBuffer != null) {
            nWidth = imageBuffer.getWidth(this);
            nHeight = imageBuffer.getHeight(this);
        }
        if (imageBuffer == null || nWidth < dim.width || nHeight < dim.height) {
            nWidth = Math.max(nWidth, dim.width);
            nHeight = Math.max(nHeight, dim.height);
            imageBuffer = this.createImage(nWidth, nHeight);
        }
        if ((graphicsNew = imageBuffer.getGraphics()) == null) {
            graphicsNew = graphics;
        }
        super.update(graphicsNew);
        if (graphicsNew != graphics) {
            graphics.drawImage(imageBuffer, 0, 0, dim.width, dim.height, this);
        }
    }

    public void paint(Graphics g2) {
        Dimension dim = this.getSize();
        int nPreferredWidth = dim.width - (this.insetsBorder.left + this.insetsBorder.right);
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int nLineHeight = fontMetrics.getHeight();
        int nOffsetY = this.insetsBorder.top + fontMetrics.getMaxAscent();
        int nLength = this.strText.length();
        int nEnd = 0;
        int i2 = 0;
        while (i2 < nLength) {
            String strLine;
            char character;
            int nLineWidth;
            int nBegin = nEnd;
            do {
                nEnd = i2;
                do {
                    character = this.strText.charAt(++i2);
                } while (i2 < nLength - 2 && Character.isLetterOrDigit(character));
                strLine = this.strText.substring(nBegin, i2);
                nLineWidth = fontMetrics.stringWidth(strLine);
                if (i2 >= nLength - 1 && nLineWidth < nPreferredWidth) {
                    nEnd = i2 - 1;
                }
                if (character != '\n' && character != '\r') continue;
                nEnd = i2;
            } while (i2 < nLength - 1 && nLineWidth < nPreferredWidth && character != '\n' && character != '\r');
            do {
                character = this.strText.charAt(++nEnd);
            } while (nEnd < nLength - 1 && Character.isSpaceChar(character));
            i2 = nEnd;
            if (i2 == nLength - 1) {
                ++i2;
            }
            strLine = (character = this.strText.charAt(i2 - 1)) == '\n' || character == '\r' ? this.strText.substring(nBegin, i2 - 1) : this.strText.substring(nBegin, i2);
            g2.drawString(strLine, this.insetsBorder.left, nOffsetY);
            nOffsetY += nLineHeight;
            ++i2;
        }
    }

    public Dimension getPreferredSize() {
        Dimension dim = new Dimension(this.nPreferredWidth, 0);
        dim.width += this.insetsBorder.left + this.insetsBorder.right;
        if (this.nPreferredWidth > 0) {
            dim = this.getPreferredSize(dim.width);
        }
        return dim;
    }

    public void setPreferredWidth(int nPreferredWidth) {
        this.nPreferredWidth = nPreferredWidth;
    }

    public Dimension getPreferredSize(int nPreferredWidth) {
        Dimension dim = new Dimension(0, 0);
        nPreferredWidth -= this.insetsBorder.left + this.insetsBorder.right;
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int nLength = this.strText.length();
        int nEnd = 0;
        int nLineCount = 0;
        int i2 = 0;
        while (i2 < nLength) {
            String strLine;
            char character;
            int nLineWidth;
            int nBegin = nEnd;
            do {
                nEnd = i2;
                do {
                    character = this.strText.charAt(++i2);
                } while (i2 < nLength - 1 && Character.isLetterOrDigit(character));
                strLine = this.strText.substring(nBegin, i2);
                nLineWidth = fontMetrics.stringWidth(strLine);
                if (i2 >= nLength - 1 && nLineWidth < nPreferredWidth) {
                    nEnd = i2 - 1;
                }
                if (character != '\n' && character != '\r') continue;
                nEnd = i2;
            } while (i2 < nLength - 1 && nLineWidth < nPreferredWidth && character != '\n' && character != '\r');
            strLine = this.strText.substring(nBegin, nEnd);
            nLineWidth = fontMetrics.stringWidth(strLine);
            dim.width = Math.max(dim.width, nLineWidth);
            ++nLineCount;
            do {
                character = this.strText.charAt(++nEnd);
            } while (nEnd < nLength - 1 && Character.isSpaceChar(character));
            i2 = nEnd;
            ++i2;
        }
        dim.height = nLineCount * fontMetrics.getHeight();
        dim.height += this.insetsBorder.top + this.insetsBorder.bottom;
        dim.width += this.insetsBorder.left + this.insetsBorder.right + 2;
        return dim;
    }
}

