/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import jmapps.ui.ImageArea;

public class TreeNode
extends Vector {
    public static final int MARGIN_HORZ = 6;
    public static final int MARGIN_VERT = 2;
    public static final int BOXSIZE = 8;
    public static final String ACTION_NODE_ADDED = "Node Added";
    public static final String ACTION_NODE_REMOVED = "Node Removed";
    public static final String ACTION_NODE_EXPANDED = "Node Expanded";
    public static final String ACTION_NODE_COLLAPSED = "Node Collapsed";
    public static final String ACTION_NODE_SETCURRENT = "Node Set Current";
    public static final String ACTION_NODE_RESETCURRENT = "Node Reset Current";
    public static final Color colorBg;
    public static final Color colorCurBg;
    public static final Color colorFg;
    public static final Color colorCurFg;
    public static final Color colorLines;
    private Component componentOwner;
    private Vector vectorActionListeners = new Vector();
    private boolean boolExpanded = false;
    private boolean boolCurrent = false;
    private boolean boolVisible = true;
    private Image imageTreeElement = null;
    private Image imageTreeElementCur = null;
    private int nWidthImage = 0;
    private int nHeightImage = 0;
    private Rectangle rectElement = null;
    private Rectangle rectElementFull = null;
    private String strName;
    private Object objUserData = null;
    private TreeNode nodeOwner;

    public TreeNode(String stringName, Component clWindowOwner) {
        this.strName = new String(stringName);
        this.componentOwner = clWindowOwner;
        this.rectElement = new Rectangle(0, 0, 0, 0);
        this.rectElementFull = new Rectangle(0, 0, 0, 0);
        this.setImage(ImageArea.loadImage("treeNode.gif", clWindowOwner, true));
        this.setImageCur(ImageArea.loadImage("treeNodeCur.gif", clWindowOwner, true));
    }

    public void addActionListener(ActionListener listener) {
        if (listener == null) {
            return;
        }
        this.vectorActionListeners.addElement(listener);
    }

    public void rewmoveActionListener(ActionListener listener) {
        if (listener == null) {
            return;
        }
        this.vectorActionListeners.removeElement(listener);
    }

    public String getName() {
        return this.strName;
    }

    public String getFullPathName() {
        String stringName = this.nodeOwner != null ? this.nodeOwner.getFullPathName() : new String();
        stringName = stringName + "/" + this.strName;
        return stringName;
    }

    public TreeNode getOwner() {
        return this.nodeOwner;
    }

    public TreeNode getRoot() {
        TreeNode nodeRoot = this;
        while (nodeRoot.getOwner() != null) {
            nodeRoot = nodeRoot.getOwner();
        }
        return nodeRoot;
    }

    public Object getUserData() {
        return this.objUserData;
    }

    public TreeNode getSubElement(int nIndex) {
        int nSize = this.size();
        if (nIndex >= nSize || nIndex < 0) {
            return null;
        }
        TreeNode node = (TreeNode)this.elementAt(nIndex);
        return node;
    }

    public TreeNode getSubElement(String stringName) {
        String stringElementName = null;
        int nSize = this.size();
        int i2 = 0;
        while (i2 < nSize) {
            TreeNode node = (TreeNode)this.elementAt(i2);
            stringElementName = node.getName();
            if (stringElementName.equals(stringName)) {
                return node;
            }
            ++i2;
        }
        return null;
    }

    public boolean isSubElement(String stringName) {
        String stringElementName = null;
        int nSize = this.size();
        int i2 = 0;
        while (i2 < nSize) {
            TreeNode node = (TreeNode)this.elementAt(i2);
            stringElementName = node.getName();
            if (stringElementName.equals(stringName)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public TreeNode findElement(String stringFullPath) {
        TreeNode node = null;
        if (stringFullPath.equals("/" + this.strName)) {
            return this;
        }
        if (!stringFullPath.startsWith("/" + this.strName)) {
            return null;
        }
        stringFullPath = stringFullPath.substring(this.strName.length() + 1);
        int nSize = this.size();
        int i2 = 0;
        while (i2 < nSize && node == null) {
            node = (TreeNode)this.elementAt(i2);
            node = node.findElement(stringFullPath);
            ++i2;
        }
        return node;
    }

    public TreeNode addSubElement(TreeNode node) {
        if (node.nodeOwner != null) {
            node.nodeOwner.removeSubElement(node);
        }
        this.addElement(node);
        node.nodeOwner = this;
        ActionEvent event = new ActionEvent(this, 1001, ACTION_NODE_ADDED);
        this.fireActionEvent(event);
        return node;
    }

    public TreeNode addSubElement(String stringName) {
        TreeNode node = new TreeNode(stringName, this.componentOwner);
        this.addSubElement(node);
        return node;
    }

    public TreeNode insertSubElement(int nIndex, TreeNode node) {
        if (node.nodeOwner != null) {
            node.nodeOwner.removeSubElement(node);
        }
        int nSize = this.size();
        if (nIndex < 0) {
            nIndex = 0;
        }
        if (nIndex > nSize) {
            nIndex = nSize;
        }
        this.insertElementAt(node, nIndex);
        node.nodeOwner = this;
        return node;
    }

    public TreeNode insertSubElement(int nIndex, String stringName) {
        TreeNode node = new TreeNode(stringName, this.componentOwner);
        this.insertSubElement(nIndex, node);
        return node;
    }

    public void removeSubElement(TreeNode node) {
        boolean boolResult = this.removeElement(node);
        if (boolResult) {
            node.nodeOwner = null;
            ActionEvent event = new ActionEvent(this, 1001, ACTION_NODE_REMOVED);
            this.fireActionEvent(event);
        }
    }

    public void destroySubElement(TreeNode node) {
        node.destroyAllSubElements();
        node.nodeOwner = null;
        this.removeSubElement(node);
    }

    public void destroySubElement(int nIndex) {
        int nSize = this.size();
        if (nIndex >= nSize || nIndex < 0) {
            return;
        }
        TreeNode node = (TreeNode)this.elementAt(nIndex);
        this.destroySubElement(node);
    }

    public void destroyAllSubElements() {
        int nSize = this.size();
        while (nSize > 0) {
            this.destroySubElement(--nSize);
        }
    }

    public void sortSubElements() {
        int nSize = this.size();
        int i2 = 0;
        while (i2 < nSize) {
            TreeNode node1 = (TreeNode)this.elementAt(i2);
            String stringName1 = node1.getName();
            this.removeElementAt(i2);
            int j2 = 0;
            while (j2 < i2) {
                TreeNode node2 = (TreeNode)this.elementAt(j2);
                String stringName2 = node2.getName();
                int nResult = stringName1.compareTo(stringName2);
                if (nResult < 0) break;
                ++j2;
            }
            this.insertElementAt(node1, j2);
            node1.sortSubElements();
            ++i2;
        }
    }

    public int getImmediateSubElementsCount() {
        int nSize = this.size();
        return nSize;
    }

    public int getRecursiveSubElementsCount() {
        int nSize;
        int nCount = nSize = this.size();
        int i2 = 0;
        while (i2 < nSize) {
            Object object = this.elementAt(i2);
            if (object != null && object instanceof TreeNode) {
                nCount += ((TreeNode)object).getRecursiveSubElementsCount();
            }
            ++i2;
        }
        return nCount;
    }

    public int getExpandedSubElementsCount() {
        int nSize;
        int nCount = nSize = this.size();
        int i2 = 0;
        while (i2 < nSize) {
            Object object = this.elementAt(i2);
            if (object != null && object instanceof TreeNode && ((TreeNode)object).isExpanded()) {
                nCount += ((TreeNode)object).getExpandedSubElementsCount();
            }
            ++i2;
        }
        return nCount;
    }

    public boolean isRecursiveSubElement(Object object) {
        boolean boolResult = false;
        if (object == this) {
            return true;
        }
        int nSize = this.size();
        int i2 = 0;
        while (i2 < nSize && !boolResult) {
            Object objectSub = this.elementAt(i2);
            if (object == objectSub) {
                return true;
            }
            if (objectSub != null && objectSub instanceof TreeNode) {
                boolResult = ((TreeNode)objectSub).isRecursiveSubElement(object);
            }
            ++i2;
        }
        return boolResult;
    }

    public void setUserData(Object objectData) {
        this.objUserData = objectData;
    }

    public boolean isVisible() {
        return this.boolVisible;
    }

    public void setVisible(boolean boolVisible) {
        if (this.boolVisible == boolVisible) {
            return;
        }
        this.boolVisible = boolVisible;
        if (!boolVisible && !this.boolExpanded) {
            this.switchExpanded();
        }
    }

    public boolean isExpanded() {
        return this.boolExpanded;
    }

    public void setExpanded(boolean boolExpanded) {
        if (this.boolExpanded != boolExpanded) {
            this.switchExpanded();
        }
    }

    public boolean switchExpanded() {
        ActionEvent event;
        if (this.boolExpanded) {
            this.boolExpanded = false;
            event = new ActionEvent(this, 1001, ACTION_NODE_COLLAPSED);
        } else {
            this.boolExpanded = true;
            event = new ActionEvent(this, 1001, ACTION_NODE_EXPANDED);
        }
        this.fireActionEvent(event);
        return this.boolExpanded;
    }

    public void setCurrent(boolean boolCurrent) {
        ActionEvent event;
        if (this.boolCurrent == boolCurrent) {
            return;
        }
        if (boolCurrent) {
            TreeNode node = this.getRoot();
            if ((node = node.getCurrent()) != null) {
                node.setCurrent(false);
            }
            node = this.nodeOwner;
            while (node != null && node instanceof TreeNode) {
                if (!node.isExpanded()) {
                    node.setExpanded(true);
                }
                node = node.nodeOwner;
            }
            event = new ActionEvent(this, 1001, ACTION_NODE_SETCURRENT);
        } else {
            event = new ActionEvent(this, 1001, ACTION_NODE_RESETCURRENT);
        }
        this.boolCurrent = boolCurrent;
        this.computeImageSize();
        this.fireActionEvent(event);
    }

    public TreeNode getCurrent() {
        TreeNode nodeCurrent = null;
        if (this.boolCurrent) {
            return this;
        }
        int nSize = this.getImmediateSubElementsCount();
        int i2 = 0;
        while (i2 < nSize && nodeCurrent == null) {
            TreeNode node = this.getSubElement(i2);
            nodeCurrent = node.getCurrent();
            ++i2;
        }
        return nodeCurrent;
    }

    public void setImage(Image imageNew) {
        this.imageTreeElement = imageNew;
        this.computeImageSize();
    }

    public void setImageCur(Image imageNew) {
        this.imageTreeElementCur = imageNew;
        this.computeImageSize();
    }

    public Rectangle getNodeBounds() {
        return new Rectangle(this.rectElement);
    }

    public Rectangle getNodeBoundsFull() {
        return new Rectangle(this.rectElementFull);
    }

    public void onMouseDoubleclick(Point pointMouse) {
        int nSize = this.getImmediateSubElementsCount();
        if (!this.rectElementFull.contains(pointMouse)) {
            return;
        }
        if (this.rectElement.contains(pointMouse) && pointMouse.x >= this.rectElement.x + 12 + 8 && nSize > 0) {
            this.switchExpanded();
            return;
        }
        if (!this.boolExpanded) {
            return;
        }
        int i2 = 0;
        while (i2 < nSize) {
            TreeNode node = this.getSubElement(i2);
            node.onMouseDoubleclick(pointMouse);
            ++i2;
        }
    }

    public void onMousePressedLeft(Point pointMouse, boolean boolShift, boolean boolCtrl, boolean boolAlt) {
        int nSize = this.getImmediateSubElementsCount();
        if (!this.rectElementFull.contains(pointMouse)) {
            return;
        }
        if (this.rectElement.contains(pointMouse)) {
            if (pointMouse.x >= this.rectElement.x + 12 + 8) {
                this.setCurrent(true);
            } else if (nSize > 0) {
                this.switchExpanded();
            }
            return;
        }
        if (!this.boolExpanded) {
            return;
        }
        int i2 = 0;
        while (i2 < nSize) {
            TreeNode node = this.getSubElement(i2);
            node.onMousePressedLeft(pointMouse, boolShift, boolCtrl, boolAlt);
            ++i2;
        }
    }

    public void onMousePressedRight(Point pointMouse, boolean boolShift, boolean boolCtrl, boolean boolAlt) {
    }

    public void drawElement(Graphics graphics, int nOffsetX, int nOffsetY) {
        int nHeight;
        int nWidth;
        int nY;
        int nX;
        int nSize = this.getImmediateSubElementsCount();
        Rectangle rect = new Rectangle(this.rectElement);
        rect.x -= nOffsetX;
        rect.y -= nOffsetY;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(colorLines);
        if (nSize > 0) {
            nX = rect.x + 6;
            nY = rect.y + (rect.height - 8) / 2;
            nWidth = 8;
            nHeight = 8;
            graphics.setColor(colorBg);
            graphics.fillRect(nX, nY, nWidth, nHeight);
            graphics.setColor(colorLines);
            graphics.drawRect(nX, nY, nWidth, nHeight);
            nX = rect.x + 6 + 8;
            nY = rect.y + rect.height / 2;
            this.drawDottedLine(graphics, nX, nY, nX + 6, nY);
        } else {
            nX = rect.x + 6 + 4;
            nY = rect.y + rect.height / 2;
            this.drawDottedLine(graphics, nX, nY, nX + 6, nY);
        }
        if (nSize > 0 && this.boolExpanded) {
            TreeNode node = this.getSubElement(nSize - 1);
            Rectangle rectLastSubElement = node.getNodeBounds();
            nX = rect.x + 12 + 8 + this.nWidthImage / 2;
            nY = rect.y + (rect.height - this.nHeightImage) / 2 + this.nHeightImage + 1;
            nHeight = rectLastSubElement.y - nOffsetY - nY + rectLastSubElement.height / 2;
            this.drawDottedLine(graphics, nX, nY, nX, nY + nHeight);
        }
        graphics.setColor(colorFg);
        if (nSize > 0) {
            nX = rect.x + 6 + 2;
            nY = rect.y + rect.height / 2;
            nWidth = 4;
            graphics.drawLine(nX, nY, nX + nWidth, nY);
            if (!this.boolExpanded) {
                nX = rect.x + 6 + 4;
                nY = rect.y + (rect.height - 8) / 2 + 2;
                nHeight = 4;
                graphics.drawLine(nX, nY, nX, nY + nHeight);
            }
        }
        nX = rect.x + 12 + 8;
        nY = rect.y + (rect.height - this.nHeightImage) / 2;
        Image imageDraw = this.boolCurrent ? this.imageTreeElementCur : this.imageTreeElement;
        if (imageDraw != null) {
            graphics.drawImage(imageDraw, nX, nY, colorBg, this.componentOwner);
        }
        if (this.nWidthImage < 0 || this.nHeightImage < 0) {
            this.nWidthImage = imageDraw.getWidth(this.componentOwner);
            this.nHeightImage = imageDraw.getHeight(this.componentOwner);
        }
        nX = rect.x + 18 + 8 + this.nWidthImage - 3;
        nY = rect.y + 2;
        nWidth = fontMetrics.stringWidth(this.strName) + 6;
        nHeight = rect.height - 3;
        if (this.boolCurrent) {
            graphics.setColor(colorCurBg);
            graphics.fillRect(nX, nY, nWidth, nHeight);
            graphics.setColor(colorCurFg);
        } else {
            graphics.setColor(colorFg);
        }
        if (this.boolCurrent && this.hasOwnerFocus()) {
            this.drawDottedRectangle(graphics, nX, nY, nWidth, nHeight);
        }
        nHeight = fontMetrics.getAscent();
        nX = rect.x + 18 + 8 + this.nWidthImage;
        nY = rect.y + (rect.height - nHeight) / 2 + nHeight;
        graphics.drawString(this.strName, nX, nY);
    }

    public void drawDottedRectangle(Graphics graphics, int nX, int nY, int nWidth, int nHeight) {
        this.drawDottedLine(graphics, nX, nY, nX + nWidth - 1, nY);
        this.drawDottedLine(graphics, nX + nWidth - 1, nY, nX + nWidth - 1, nY + nHeight - 1);
        this.drawDottedLine(graphics, nX + nWidth - 1, nY + nHeight - 1, nX, nY + nHeight - 1);
        this.drawDottedLine(graphics, nX, nY + nHeight - 1, nX, nY);
    }

    public void drawDottedLine(Graphics graphics, int nX1, int nY1, int nX2, int nY2) {
        int nY;
        int nX;
        if (nX1 == nX2 && nY1 == nY2) {
            this.drawDot(graphics, nX1, nY1);
            return;
        }
        if (nX1 > nX2) {
            nX = nX1;
            nX1 = nX2;
            nX2 = nX;
        }
        if (nY1 > nY2) {
            nY = nY1;
            nY1 = nY2;
            nY2 = nY;
        }
        if (nX2 - nX1 > nY2 - nY1) {
            double dDiv = (double)(nY2 - nY1) / (double)(nX2 - nX1);
            nX = nX1;
            while (nX <= nX2) {
                nY = (int)Math.rint((double)nY1 + (double)(nX - nX1) * dDiv);
                this.drawDot(graphics, nX, nY);
                ++nX;
            }
        } else {
            double dDiv = (nX2 - nX1) / (nY2 - nY1);
            nY = nY1;
            while (nY <= nY2) {
                nX = (int)Math.rint((double)nX1 + (double)(nY - nY1) * dDiv);
                this.drawDot(graphics, nX, nY);
                ++nY;
            }
        }
    }

    public void drawDot(Graphics graphics, int nX, int nY) {
        if ((nX + nY) % 2 == 0) {
            graphics.drawLine(nX, nY, nX, nY);
        }
    }

    public void computeImageSize() {
        if (!this.boolCurrent && this.imageTreeElement != null) {
            this.nWidthImage = this.imageTreeElement.getWidth(this.componentOwner);
            this.nHeightImage = this.imageTreeElement.getHeight(this.componentOwner);
        } else if (this.boolCurrent && this.imageTreeElementCur != null) {
            this.nWidthImage = this.imageTreeElementCur.getWidth(this.componentOwner);
            this.nHeightImage = this.imageTreeElementCur.getHeight(this.componentOwner);
        } else {
            this.nWidthImage = 0;
            this.nHeightImage = 0;
        }
    }

    public Rectangle recomputeLayout(Rectangle rect, FontMetrics fontMetrics) {
        this.computeImageSize();
        this.rectElement.x = rect.x;
        this.rectElement.y = rect.y;
        if (this.boolVisible) {
            this.rectElement.height = Math.max(fontMetrics.getHeight(), 12);
            this.rectElement.height = Math.max(this.rectElement.height, this.nHeightImage + 4);
            this.rectElement.width = 8 + this.nWidthImage + fontMetrics.stringWidth(this.strName) + 24;
        } else {
            this.rectElement.height = 0;
            this.rectElement.width = 0;
        }
        this.rectElementFull.setBounds(this.rectElement);
        if (this.boolExpanded) {
            int nOffsetX = this.boolVisible ? 10 + this.nWidthImage / 2 : 0;
            int nOffsetY = this.rectElement.height;
            Rectangle rectSubElement = new Rectangle(rect);
            rectSubElement.x += nOffsetX;
            rectSubElement.y += nOffsetY;
            int nSize = this.getImmediateSubElementsCount();
            int i2 = 0;
            while (i2 < nSize) {
                TreeNode node = this.getSubElement(i2);
                rectSubElement = node.recomputeLayout(rectSubElement, fontMetrics);
                this.rectElementFull.height += rectSubElement.height;
                rectSubElement.y += rectSubElement.height;
                if (this.rectElementFull.width < nOffsetX + rectSubElement.width) {
                    this.rectElementFull.width = nOffsetX + rectSubElement.width;
                }
                ++i2;
            }
        }
        return new Rectangle(this.rectElementFull);
    }

    public void addToTreeElList(Vector cw_vectorTreeElList) {
        if (this.boolVisible) {
            cw_vectorTreeElList.addElement(this);
        }
        if (!this.boolExpanded) {
            return;
        }
        int nSize = this.getImmediateSubElementsCount();
        int i2 = 0;
        while (i2 < nSize) {
            TreeNode node = this.getSubElement(i2);
            node.addToTreeElList(cw_vectorTreeElList);
            ++i2;
        }
    }

    private boolean hasOwnerFocus() {
        boolean boolResult = false;
        if (this.componentOwner == null) {
            return false;
        }
        Component component = this.componentOwner;
        while (component != null) {
            if (component instanceof Window) {
                boolResult = ((Window)component).getFocusOwner() == this.componentOwner;
                break;
            }
            component = component.getParent();
        }
        return boolResult;
    }

    private void fireActionEvent(ActionEvent event) {
        int nCount = this.vectorActionListeners.size();
        int i2 = 0;
        while (i2 < nCount) {
            ActionListener listener = (ActionListener)this.vectorActionListeners.elementAt(i2);
            listener.actionPerformed(event);
            ++i2;
        }
    }

    static {
        MARGIN_HORZ = 6;
        MARGIN_VERT = 2;
        BOXSIZE = 8;
        ACTION_NODE_ADDED = ACTION_NODE_ADDED;
        ACTION_NODE_REMOVED = ACTION_NODE_REMOVED;
        ACTION_NODE_EXPANDED = ACTION_NODE_EXPANDED;
        ACTION_NODE_COLLAPSED = ACTION_NODE_COLLAPSED;
        ACTION_NODE_SETCURRENT = ACTION_NODE_SETCURRENT;
        ACTION_NODE_RESETCURRENT = ACTION_NODE_RESETCURRENT;
        colorBg = Color.lightGray;
        colorCurBg = new Color(0, 0, 128);
        colorFg = Color.black;
        colorCurFg = Color.yellow;
        colorLines = Color.darkGray;
    }
}

