/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.History;
import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.gui.PlotWindow;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.io.ImportDialog;
import ij.io.OpenDialog;
import ij.plugin.Animator;
import ij.plugin.JpegWriter;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.ParticleAnalyzer;
import ij.process.FloatBlitter;
import ij.util.Tools;
import java.applet.Applet;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class Prefs {
    public static final String PROPS_NAME = "EUHOUProps";
    public static final String PREFS_NAME = "EUHOUPrefs.txt";
    public static final String DIR_IMAGE = "dir.image";
    public static final String KEY_NB_FILES_HISTORY = "files_history";
    public static final String FCOLOR = "fcolor";
    public static final String BCOLOR = "bcolor";
    public static final String ROICOLOR = "roicolor";
    public static final String JPEG = "jpeg";
    public static final String FPS = "fps";
    public static final String DIV_BY_ZERO_VALUE = "div-by-zero";
    private static final int USE_POINTER = 1;
    private static final int ANTIALIASING = 2;
    private static final int INTERPOLATE = 4;
    private static final int ONE_HUNDRED_PERCENT = 8;
    private static final int JFILE_CHOOSER = 16;
    public static final String OPTIONS = "prefs.options";
    public static String separator = System.getProperty("file.separator");
    public static boolean usePointerCursor;
    public static boolean antialiasedText;
    public static boolean useJFileChooser;
    public static boolean interpolateScaledImages;
    public static boolean open100Percent;
    static Properties prefs;
    static Properties props;
    static String prefsDir;
    static String imagesURL;
    static String homeDir;
    static String pluginsDir;

    public static String load(Object ij, Applet applet) {
        Locale lang = ((ImageJ)ij).getLocale();
        ResourceBundle table = null;
        try {
            table = ResourceBundle.getBundle("ij/EUHOUProps", lang);
        }
        catch (Exception e) {
            IJ.error("PROPS NOT LOADED");
        }
        if (applet != null) {
            return Prefs.loadAppletProps(table, applet);
        }
        homeDir = System.getProperty("user.dir");
        String userHome = System.getProperty("user.home");
        String osName = System.getProperty("os.name");
        prefsDir = osName.indexOf("Windows", 0) > -1 ? homeDir : userHome;
        if (table == null) {
            try {
                table = ResourceBundle.getBundle(homeDir + "/" + PROPS_NAME);
            }
            catch (Exception e) {
                table = null;
            }
        }
        if (table == null) {
            return "EUHOUProps not found in Eu-hou.jar or in " + homeDir;
        }
        Enumeration<String> e = table.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String val = table.getString(key);
            props.setProperty(key, val);
        }
        imagesURL = props.getProperty("images.location");
        Prefs.loadPreferences();
        History.setNumberOfFilesInHistory(Integer.decode(prefs.getProperty(KEY_NB_FILES_HISTORY, "10")));
        Prefs.loadOptions();
        return null;
    }

    static String loadAppletProps(ResourceBundle f, Applet applet) {
        if (f == null) {
            return "EUHOUProps not found in Eu-hou.jar";
        }
        Enumeration<String> e = f.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String val = f.getString(key);
            props.setProperty(key, val);
        }
        try {
            URL url = new URL(applet.getDocumentBase(), "images/");
            imagesURL = url.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getImagesURL() {
        return imagesURL;
    }

    public static String getHomeDir() {
        return homeDir;
    }

    public static String getPluginsDir() {
        return pluginsDir;
    }

    public static String getString(String key) {
        return props.getProperty(key);
    }

    public static String getCommand(String key) {
        String res = Prefs.getString(key);
        int ind0 = res.indexOf(34);
        int ind = res.indexOf(44);
        if (ind == -1) {
            return ind0 == -1 ? res : res.substring(1, ind - 1);
        }
        return ind0 == -1 ? res.substring(0, ind) : res.substring(1, ind - 1);
    }

    public static String getShortCommand(String key) {
        String res = Prefs.getCommand(key);
        int ind = res.indexOf(91);
        if (ind != -1) {
            return res;
        }
        res = res.substring(0, ind - 2);
        return res;
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String s = props.getProperty(key);
        if (s == null) {
            return defaultValue;
        }
        return s.equals("true");
    }

    public static int getInt(String key, int defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String s = props.getProperty(key);
        if (s != null) {
            try {
                return Integer.decode(s);
            }
            catch (NumberFormatException e) {
                IJ.write("" + e);
            }
        }
        return defaultValue;
    }

    public static double getDouble(String key, double defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String s = props.getProperty(key);
        Double d = null;
        if (s != null) {
            try {
                d = new Double(s);
            }
            catch (NumberFormatException e) {
                d = null;
            }
            if (d != null) {
                return d;
            }
        }
        return defaultValue;
    }

    public static Color getColor(String key, Color defaultColor) {
        int i = Prefs.getInt(key, 2730);
        if (i == 2730) {
            return defaultColor;
        }
        return new Color(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF);
    }

    public static String getFileSeparator() {
        return separator;
    }

    static void loadPreferences() {
        String path = prefsDir + separator + PREFS_NAME;
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(path));
            prefs.load(is);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            return;
        }
    }

    static void savePreferences() {
        try {
            Properties prefs = new Properties();
            String dir = OpenDialog.getDefaultDirectory();
            if (dir != null) {
                prefs.put(DIR_IMAGE, Prefs.escapeBackSlashes(dir));
            }
            prefs.put(KEY_NB_FILES_HISTORY, Integer.toString(History.getNumberOfFilesInHistory()));
            prefs.put(ROICOLOR, Tools.c2hex(Roi.getColor()));
            prefs.put(FCOLOR, Tools.c2hex(Toolbar.getForegroundColor()));
            prefs.put(BCOLOR, Tools.c2hex(Toolbar.getBackgroundColor()));
            prefs.put(JPEG, Integer.toString(JpegWriter.getQuality()));
            prefs.put(FPS, Double.toString(Animator.getFrameRate()));
            prefs.put(DIV_BY_ZERO_VALUE, Double.toString(FloatBlitter.divideByZeroValue));
            Prefs.saveOptions(prefs);
            IJ.getInstance().savePreferences(prefs);
            Menus.savePreferences(prefs);
            ParticleAnalyzer.savePreferences(prefs);
            Analyzer.savePreferences(prefs);
            ImportDialog.savePreferences(prefs);
            PlotWindow.savePreferences(prefs);
            String path = prefsDir + separator + PREFS_NAME;
            Prefs.savePrefs(prefs, path);
        }
        catch (Exception e) {
            IJ.write("<<Unable to save preferences>>");
            IJ.wait(2000);
        }
    }

    static void loadOptions() {
        int options = Prefs.getInt(OPTIONS, 2);
        usePointerCursor = (options & 1) != 0;
        antialiasedText = (options & 2) != 0;
        interpolateScaledImages = (options & 4) != 0;
        open100Percent = (options & 8) != 0;
        useJFileChooser = (options & 0x10) != 0;
    }

    static void saveOptions(Properties prefs) {
        int options = (usePointerCursor ? 1 : 0) + (antialiasedText ? 2 : 0) + (interpolateScaledImages ? 4 : 0) + (open100Percent ? 8 : 0) + (useJFileChooser ? 16 : 0);
        prefs.put(OPTIONS, Integer.toString(options));
    }

    static void savePrefs(Properties prefs, String path) throws IOException {
        FileOutputStream fos = new FileOutputStream(path);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        PrintWriter pw = new PrintWriter(bos);
        pw.println("# Eu-Hou 1.1 Preferences");
        pw.println("# " + new Date());
        pw.println("");
        Enumeration<Object> e = prefs.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            pw.print(key);
            pw.write(61);
            pw.println((String)prefs.get(key));
        }
        pw.close();
    }

    static String escapeBackSlashes(String s) {
        StringBuffer sb = new StringBuffer(s.length() + 10);
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            sb.append(chars[i]);
            if (chars[i] != '\\') continue;
            sb.append('\\');
        }
        return sb.toString();
    }

    static {
        prefs = new Properties();
        props = new Properties(prefs);
    }
}

