/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Undo;
import ij.gui.EuHouToolbar;
import ij.gui.ImageWindow;
import ij.plugin.Converter;
import ij.plugin.frame.Recorder;
import ij.process.Photometer;
import java.awt.CheckboxMenuItem;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Vector;

public class WindowManager {
    private static Vector imageList = new Vector();
    private static Vector nonImageList = new Vector();
    private static Vector winList = new Vector();
    private static ImageWindow currentWindow;
    private static Frame frontWindow;
    private static ImagePlus tempCurrentImage;
    static /* synthetic */ Class class$java$awt$event$WindowListener;

    public static synchronized void setCurrentWindow(ImageWindow win) {
        WindowManager.setCurrentWindow(win, false);
    }

    public static synchronized void setCurrentWindow(ImageWindow win, boolean refresh) {
        ImagePlus imp;
        WindowManager.setWindow(win);
        tempCurrentImage = null;
        if (win == currentWindow || win == null || imageList.size() == 0) {
            return;
        }
        if (currentWindow != null && (imp = currentWindow.getImagePlus()) != null && imp.lockSilently()) {
            imp.trimProcessor();
            Image img = imp.getImage();
            if (!Converter.newWindowCreated) {
                imp.saveRoi();
            }
            Converter.newWindowCreated = false;
            imp.unlock();
        }
        Undo.reset();
        for (int i = 0; i < winList.size(); ++i) {
            if (!((Frame)winList.elementAt(i)).getTitle().equals(win.getTitle())) continue;
            winList.removeElementAt(i);
            winList.addElement(win);
        }
        currentWindow = !win.isClosed() && win.getImagePlus() != null ? (win.isPublicImage() ? win : null) : null;
        if (!refresh) {
            ImageJ.TMS = System.currentTimeMillis();
            win.toFront();
        } else if (System.currentTimeMillis() - ImageJ.TMS > 1024L) {
            ImageJ.TMS = System.currentTimeMillis();
            WindowManager.allToFront(true);
        }
        Menus.updateMenus();
    }

    public static ImageWindow getCurrentWindow() {
        return currentWindow;
    }

    static int getCurrentIndex() {
        return imageList.indexOf(currentWindow);
    }

    public static synchronized ImagePlus getCurrentImage() {
        Object imp = null;
        if (tempCurrentImage != null) {
            return tempCurrentImage;
        }
        if (currentWindow != null && currentWindow.isPublicImage()) {
            return currentWindow.getImagePlus();
        }
        if (imageList.size() - 1 >= 0) {
            return ((ImageWindow)imageList.elementAt(imageList.size() - 1)).getImagePlus();
        }
        return null;
    }

    public static int getWindowCount() {
        return imageList.size();
    }

    public static Frame getFrontWindow() {
        return frontWindow;
    }

    public static synchronized int[] getIDList() {
        int nWindows = imageList.size();
        if (nWindows == 0) {
            return null;
        }
        int[] list = new int[nWindows];
        for (int i = 0; i < nWindows; ++i) {
            ImageWindow win = (ImageWindow)imageList.elementAt(i);
            list[i] = win.getImagePlus().getID();
        }
        return list;
    }

    public static synchronized ImagePlus getImage(int imageID) {
        if (imageID == 0) {
            return null;
        }
        int nImages = imageList.size();
        if (nImages == 0) {
            return null;
        }
        if (imageID > 0) {
            if (imageID > nImages) {
                return null;
            }
            ImageWindow win = (ImageWindow)imageList.elementAt(imageID - 1);
            if (win != null) {
                return win.getImagePlus();
            }
            return null;
        }
        ImagePlus imp = null;
        for (int i = 0; i < imageList.size(); ++i) {
            ImageWindow win = (ImageWindow)imageList.elementAt(i);
            ImagePlus imp2 = win.getImagePlus();
            if (imageID != imp2.getID()) continue;
            imp = imp2;
            break;
        }
        return imp;
    }

    public static synchronized void addWindow(Frame win) {
        ImageJ ij = IJ.getInstance();
        if (win == null) {
            return;
        }
        if (win instanceof ImageWindow && ((ImageWindow)win).isPublicImage()) {
            WindowManager.addImageWindow((ImageWindow)win);
            winList.addElement(win);
            return;
        }
        Menus.insertWindowMenuItem(win);
        nonImageList.addElement(win);
        winList.addElement(win);
    }

    private static void addImageWindow(ImageWindow win) {
        imageList.addElement(win);
        Menus.addWindowMenuItem(win.getImagePlus());
        WindowManager.setCurrentWindow(win);
        if (EuHouToolbar.photometerSelected()) {
            win.getCanvas().addMouseListener(EuHouToolbar.getPhotometer());
        }
    }

    public static synchronized void removeWindow(Frame win) {
        if (win == null) {
            return;
        }
        for (int i = 0; i < winList.size(); ++i) {
            if (!((Frame)winList.elementAt(i)).getTitle().equals(win.getTitle())) continue;
            winList.removeElementAt(i);
            break;
        }
        WindowManager.setWindow(null);
        if (win instanceof ImageWindow && ((ImageWindow)win).isPublicImage()) {
            WindowManager.removeImageWindow((ImageWindow)win);
            return;
        }
        int index = nonImageList.indexOf(win);
        if (index >= 0) {
            Menus.removeWindowMenuItem(index);
            nonImageList.removeElement(win);
        }
    }

    private static void removeImageWindow(ImageWindow win) {
        int index = imageList.indexOf(win);
        if (index == -1) {
            return;
        }
        if (imageList.size() > 1) {
            int newIndex = index - 1;
            if (newIndex < 0) {
                newIndex = imageList.size() - 1;
            }
            WindowManager.setCurrentWindow((ImageWindow)imageList.elementAt(newIndex));
        } else {
            currentWindow = null;
        }
        imageList.removeElementAt(index);
        int nonImageCount = nonImageList.size();
        if (nonImageCount > 0) {
            ++nonImageCount;
        }
        Menus.removeWindowMenuItem(nonImageCount + index);
        Menus.updateMenus();
        Undo.reset();
    }

    public static void setWindow(Frame win) {
        frontWindow = win;
    }

    public static synchronized boolean closeAllWindows() {
        if (EuHouToolbar.photometerSelected()) {
            Photometer.getInstance().close();
        }
        Enumeration e = nonImageList.elements();
        while (e.hasMoreElements()) {
            Frame f = (Frame)e.nextElement();
            WindowManager.removeWindow(f);
            f.setVisible(false);
            f.dispose();
        }
        while (imageList.size() > 0) {
            if (!((ImageWindow)imageList.elementAt(0)).close()) {
                return false;
            }
            IJ.wait(100);
        }
        return true;
    }

    public static void putBehind() {
        if (IJ.debugMode) {
            IJ.log("putBehind");
        }
        if (imageList.size() < 1 || currentWindow == null) {
            return;
        }
        int index = imageList.indexOf(currentWindow);
        if (--index < 0) {
            index = imageList.size() - 1;
        }
        ImageWindow win = (ImageWindow)imageList.elementAt(index);
        WindowManager.setCurrentWindow(win);
        win.toFront();
        Menus.updateMenus();
    }

    static void prepareExit() {
        for (int i = 0; i < winList.size(); ++i) {
            try {
                WindowListener[] l = (WindowListener[])((Frame)winList.elementAt(i)).getListeners(class$java$awt$event$WindowListener == null ? WindowManager.class$("java.awt.event.WindowListener") : class$java$awt$event$WindowListener);
                for (int j = 0; j < l.length; ++j) {
                    ((Frame)winList.elementAt(i)).removeWindowListener(l[j]);
                }
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public static void setTempCurrentImage(ImagePlus imp) {
        tempCurrentImage = imp;
    }

    public static Frame getFrame(String title) {
        for (int i = 0; i < nonImageList.size(); ++i) {
            Frame frame = (Frame)nonImageList.elementAt(i);
            if (!title.equals(frame.getTitle())) continue;
            return frame;
        }
        return null;
    }

    public static Vector getWindows() {
        return winList;
    }

    public static Vector getImageWindows() {
        return imageList;
    }

    public static synchronized void allToFront(boolean lastalso) {
        if (winList == null) {
            return;
        }
        if (winList.size() == 0) {
            return;
        }
        ImageJ.TMS = System.currentTimeMillis();
        for (int i = 0; i < winList.size() - (lastalso ? 0 : 1); ++i) {
            ((Frame)winList.get(i)).toFront();
        }
    }

    static synchronized void activateWindow(String menuItemLabel, MenuItem item) {
        for (int i = 0; i < nonImageList.size(); ++i) {
            Frame win = (Frame)nonImageList.elementAt(i);
            String title = win.getTitle();
            if (!menuItemLabel.equals(title)) continue;
            for (int j = 0; j < winList.size(); ++j) {
                if (!((Frame)winList.elementAt(j)).getTitle().equals(menuItemLabel)) continue;
                winList.removeElementAt(j);
                winList.addElement(win);
            }
            WindowManager.allToFront(true);
            ((CheckboxMenuItem)item).setState(false);
            if (Recorder.record) {
                Recorder.record("selectWindow", title);
            }
            return;
        }
        int lastSpace = menuItemLabel.lastIndexOf(32);
        if (lastSpace > 0) {
            menuItemLabel = menuItemLabel.substring(0, lastSpace);
        }
        for (int i = 0; i < imageList.size(); ++i) {
            int start;
            ImageWindow win = (ImageWindow)imageList.elementAt(i);
            String title = win.getImagePlus().getTitle();
            if (!menuItemLabel.equals(title)) continue;
            for (int j = 1; j < winList.size(); ++j) {
                if (!((Frame)winList.elementAt(j)).getTitle().equals(menuItemLabel)) continue;
                winList.removeElementAt(j);
                winList.addElement(win);
            }
            WindowManager.setCurrentWindow(win);
            int index = imageList.indexOf(win);
            int n = Menus.window.getItemCount();
            for (int j = start = 5 + Menus.windowMenuItems2; j < n; ++j) {
                MenuItem mi = Menus.window.getItem(j);
                ((CheckboxMenuItem)mi).setState(j - start == index);
            }
            if (!Recorder.record) break;
            Recorder.record("selectWindow", title);
            break;
        }
    }

    public static synchronized void activateWindow(String title) {
        for (int j = 4; j < Menus.window.getItemCount(); ++j) {
            try {
                if (!((CheckboxMenuItem)Menus.window.getItem(j)).getState()) continue;
                WindowManager.activateWindow(title, Menus.window.getItem(j));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static synchronized void repaintImageWindows() {
        int[] list = WindowManager.getIDList();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            ImageWindow win;
            ImagePlus imp2 = WindowManager.getImage(list[i]);
            if (imp2 == null || (win = imp2.getWindow()) == null) continue;
            win.repaint();
        }
    }

    static void showList() {
        if (IJ.debugMode) {
            for (int i = 0; i < imageList.size(); ++i) {
                ImageWindow win = (ImageWindow)imageList.elementAt(i);
                ImagePlus imp = win.getImagePlus();
                IJ.log(i + " " + imp.getTitle() + (win == currentWindow ? "*" : ""));
            }
            IJ.log(" ");
        }
    }
}

