/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.FolderOpenerDialog;
import ij.plugin.PlugIn;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import java.awt.image.ColorModel;
import java.io.File;

public class FolderOpener
implements PlugIn {
    private static boolean grayscale;
    private static boolean halfSize;
    private int n;
    private int start;
    private int increment;
    private String filter;
    private FileInfo fi;
    private String info1;

    public void run(String arg) {
        OpenDialog od = new OpenDialog(IJ.getPluginBundle().getString("FoldOpenTitle"), arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String[] list = new File(directory).list();
        if (list == null) {
            return;
        }
        IJ.register(FolderOpener.class);
        StringSorter.sort(list);
        if (IJ.debugMode) {
            IJ.log("FolderOpener: " + directory + " (" + list.length + " files)");
        }
        int width = 0;
        int height = 0;
        int type = 0;
        ImageStack stack = null;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        try {
            for (int i = 0; i < list.length; ++i) {
                ImagePlus imp;
                if (list[i].endsWith(".txt") || list[i].endsWith(".dat") || (imp = new Opener().openImage(directory, list[i])) == null) continue;
                width = imp.getWidth();
                height = imp.getHeight();
                type = imp.getType();
                this.fi = imp.getOriginalFileInfo();
                if (this.showDialog(imp, list)) break;
                return;
            }
            if (width == 0) {
                IJ.showMessage(IJ.getPluginBundle().getString("FoldOpenErrTitle"), IJ.getPluginBundle().getString("FoldOpenErr1"));
                return;
            }
            if (this.n < 1) {
                this.n = list.length;
            }
            if (this.start < 1 || this.start > list.length) {
                this.start = 1;
            }
            if (this.start + this.n - 1 > list.length) {
                this.n = list.length - this.start + 1;
            }
            int filteredImages = this.n;
            if (this.filter != null && (this.filter.equals("") || this.filter.equals("*"))) {
                this.filter = null;
            }
            if (this.filter != null) {
                filteredImages = 0;
                for (int i = this.start - 1; i < this.start - 1 + this.n; ++i) {
                    if (list[i].indexOf(this.filter) < 0) continue;
                    ++filteredImages;
                }
                if (filteredImages == 0) {
                    IJ.error(IJ.getPluginBundle().getString("FoldOpenErr2") + " " + this.n + "\n" + IJ.getPluginBundle().getString("FoldOpenErr3") + " " + this.filter);
                    return;
                }
            }
            this.n = filteredImages;
            int count = 0;
            int counter = 0;
            for (int i = this.start - 1; i < list.length; ++i) {
                if (list[i].endsWith(".txt") || this.filter != null && list[i].indexOf(this.filter) < 0 || counter++ % this.increment != 0) continue;
                ImagePlus imp = new Opener().openImage(directory, list[i]);
                if (imp != null && stack == null) {
                    width = imp.getWidth();
                    height = imp.getHeight();
                    type = imp.getType();
                    ColorModel cm = imp.getProcessor().getColorModel();
                    stack = halfSize ? new ImageStack(width / 2, height / 2, cm) : new ImageStack(width, height, cm);
                    this.info1 = (String)imp.getProperty("Info");
                }
                if (imp == null) {
                    if (!list[i].startsWith(".")) {
                        IJ.log(list[i] + IJ.getPluginBundle().getString("FoldOpenErr6"));
                    }
                } else if (imp.getWidth() != width || imp.getHeight() != height) {
                    IJ.log(list[i] + IJ.getPluginBundle().getString("FoldOpenErr4"));
                } else if (imp.getType() != type) {
                    IJ.log(list[i] + IJ.getPluginBundle().getString("FoldOpenErr5"));
                } else {
                    count = stack.getSize() + 1;
                    IJ.showStatus(count + "/" + this.n);
                    IJ.showProgress((double)count / (double)this.n);
                    ImageProcessor ip = imp.getProcessor();
                    if (grayscale) {
                        ImageConverter ic = new ImageConverter(imp);
                        ic.convertToGray8();
                        ip = imp.getProcessor();
                    }
                    if (halfSize) {
                        ip = ip.resize(width / 2, height / 2);
                    }
                    if (ip.getMin() < min) {
                        min = ip.getMin();
                    }
                    if (ip.getMax() > max) {
                        max = ip.getMax();
                    }
                    String label = imp.getTitle();
                    String info = (String)imp.getProperty("Info");
                    if (info != null) {
                        label = label + "\n" + info;
                    }
                    stack.addSlice(label, ip);
                }
                if (count < this.n) {
                    continue;
                }
                break;
            }
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory("Import");
            stack.trim();
        }
        if (stack != null && stack.getSize() > 0) {
            ImagePlus imp2 = new ImagePlus(IJ.getPluginBundle().getString("StackTitle"), stack);
            if (imp2.getType() == 1 || imp2.getType() == 2) {
                imp2.getProcessor().setMinAndMax(min, max);
            }
            imp2.setFileInfo(this.fi);
            if (imp2.getStackSize() == 1 && this.info1 != null) {
                imp2.setProperty("Info", this.info1);
            }
            imp2.show();
        }
        IJ.showProgress(1.0);
    }

    boolean showDialog(ImagePlus imp, String[] list) {
        int fileCount = list.length;
        FolderOpenerDialog gd = new FolderOpenerDialog(IJ.getPluginBundle().getString("FoldOptTitle"), imp, list);
        gd.addNumericField(IJ.getPluginBundle().getString("FoldOpt1") + ": ", fileCount, 0);
        gd.addNumericField(IJ.getPluginBundle().getString("FoldOpt2") + ": ", 1.0, 0);
        gd.addNumericField(IJ.getPluginBundle().getString("FoldOpt3") + ": ", 1.0, 0);
        gd.addStringField(IJ.getPluginBundle().getString("FoldOpt4") + ": ", "");
        gd.addCheckbox(IJ.getPluginBundle().getString("FoldOpt5"), grayscale);
        gd.addCheckbox(IJ.getPluginBundle().getString("FoldOpt6"), halfSize);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.n = (int)gd.getNextNumber();
        this.start = (int)gd.getNextNumber();
        this.increment = (int)gd.getNextNumber();
        if (this.increment < 1) {
            this.increment = 1;
        }
        this.filter = gd.getNextString();
        grayscale = gd.getNextBoolean();
        halfSize = gd.getNextBoolean();
        return true;
    }
}

