/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.io.FileInfo;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class RB_FITS_Writer
implements PlugIn {
    private int largeur;
    private int hauteur;

    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        this.largeur = imp.getWidth();
        this.hauteur = imp.getHeight();
        String directory = "";
        String name = "";
        if (arg == null || arg == "") {
            SaveDialog sd = new SaveDialog("Save as FITS", imp.getTitle(), ".fit");
            directory = sd.getDirectory();
            name = sd.getFileName();
        } else {
            File file = new File(arg);
            if (file.isDirectory()) {
                directory = arg;
                name = imp.getTitle();
            } else {
                directory = file.getParent();
                name = file.getName();
            }
        }
        if (name == null || name == "") {
            return;
        }
        this.save(imp, directory, name);
        IJ.showStatus("");
    }

    public void save(ImagePlus imp, String directory, String name) {
        boolean isAlreadyFits = false;
        FileInfo fi = imp.getOriginalFileInfo();
        FileInfo fi_current = imp.getFileInfo();
        if (fi != null && (fi.fileName.endsWith(".fts") || fi.fileName.endsWith(".fits") || fi.fileName.endsWith(".fit"))) {
            isAlreadyFits = true;
        }
        if (name == null) {
            return;
        }
        if (name.endsWith(".fts")) {
            name = name.substring(0, name.length() - 4);
        }
        if (name.endsWith(".fits")) {
            name = name.substring(0, name.length() - 5);
        }
        if (name.endsWith(".fit")) {
            name = name.substring(0, name.length() - 4);
        }
        if (directory != null && !directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        IJ.showStatus("Saving as FITS: " + directory + name);
        try {
            String fileName = directory + name + ".fit";
            if (!isAlreadyFits || fi.fileType != fi_current.fileType) {
                this.writeHeader(imp, fileName);
            } else {
                RB_FITS_Writer.copyHeader(imp, fileName);
            }
        }
        catch (IOException e) {
            IJ.write("FileSaver: " + e.getMessage());
        }
    }

    private static void ecrirePixels(ImagePlus imp, DataOutputStream sortie) throws IOException {
        ImageProcessor ip = imp.getProcessor();
        FileInfo fi = imp.getFileInfo();
        ip.flipVertical();
        if (fi.fileType == 0) {
            byte[] lesPixels = (byte[])ip.getPixels();
            sortie.write(lesPixels, 0, lesPixels.length);
        } else if (fi.fileType == 2 || fi.fileType == 1) {
            short[] Pixl = (short[])ip.getPixels();
            int taille = 2 * Pixl.length;
            int q = taille / 2880;
            int r = taille % 2880;
            ++q;
            byte[] lesPixels = new byte[q *= 2880];
            int hh = 0;
            for (int kk = 0; kk < Pixl.length; ++kk) {
                lesPixels[hh++] = (byte)((Pixl[kk] & 0xFF00) >> 8);
                lesPixels[hh++] = (byte)(Pixl[kk] & 0xFF);
            }
            sortie.write(lesPixels, 0, lesPixels.length);
        } else if (fi.fileType == 4) {
            float[] Pixl = (float[])ip.getPixels();
            int taille = 4 * Pixl.length;
            int q = taille / 2880;
            int r = taille % 2880;
            ++q;
            byte[] lesPixels = new byte[q *= 2880];
            boolean hh = false;
            for (int kk = 0; kk < Pixl.length; ++kk) {
                sortie.writeFloat(Pixl[kk]);
            }
        }
        ip.flipVertical();
    }

    private void writeHeader(ImagePlus imp, String hdrfile) throws IOException {
        FileOutputStream fileout = new FileOutputStream(hdrfile);
        DataOutputStream output = new DataOutputStream(fileout);
        FileInfo fi = imp.getFileInfo();
        ImageConverter z = new ImageConverter(imp);
        if (imp.getType() != 1 & imp.getType() != 2 & imp.getType() != 0) {
            try {
                z.convertToGray16();
            }
            catch (Exception e) {
                IJ.error("Save Failed (conversion)");
                return;
            }
        }
        String type = "";
        if (fi.fileType == 0) {
            type = "8";
        } else if (fi.fileType == 2) {
            type = "-16";
        } else if (fi.fileType == 1) {
            type = "16";
        } else if (fi.fileType == 3) {
            type = "32";
        } else if (fi.fileType == 4) {
            type = "-32";
        }
        byte[] entete = new byte[2880];
        int compteur = 0;
        for (int j = 0; j < entete.length; ++j) {
            entete[j] = 32;
        }
        RB_FITS_Writer.ecrireG("SIMPLE  =", compteur, entete);
        RB_FITS_Writer.ecrireD("T", compteur + 29, entete);
        RB_FITS_Writer.ecrireG("BITPIX  =", compteur += 80, entete);
        RB_FITS_Writer.ecrireD(type, compteur + 29, entete);
        RB_FITS_Writer.ecrireG("NAXIS   =", compteur += 80, entete);
        RB_FITS_Writer.ecrireD("2", compteur + 29, entete);
        String lg = "" + this.largeur;
        RB_FITS_Writer.ecrireG("NAXIS1  =", compteur += 80, entete);
        RB_FITS_Writer.ecrireD(lg, compteur + 29, entete);
        String ht = "" + this.hauteur;
        RB_FITS_Writer.ecrireG("NAXIS2  =", compteur += 80, entete);
        RB_FITS_Writer.ecrireD(ht, compteur + 29, entete);
        compteur += 80;
        RB_FITS_Writer.ecrireG("END", 2800, entete);
        output.write(entete, 0, 2880);
        RB_FITS_Writer.ecrirePixels(imp, output);
        output.close();
        fileout.close();
    }

    private void writeInt(DataOutputStream input, int value) throws IOException {
        input.writeInt(value);
    }

    private void writeShort(DataOutputStream input, short value) throws IOException {
        byte b1 = (byte)(value & 0xFF);
        byte b2 = (byte)(value >> 8 & 0xFF);
        input.writeByte(b2);
        input.writeByte(b1);
    }

    private void writeFloat(DataOutputStream input, float value) throws IOException {
        this.writeInt(input, Float.floatToIntBits(value));
    }

    boolean isSigned16Bit(ImagePlus imp) {
        if (imp.getType() != 1) {
            return false;
        }
        return imp.getCalibration().getCValue(0) == -32768.0;
    }

    void add(ImagePlus imp, int value) {
        ImageStack stack = imp.getStack();
        for (int slice = 1; slice <= stack.getSize(); ++slice) {
            ImageProcessor ip = stack.getProcessor(slice);
            short[] pixels = (short[])ip.getPixels();
            for (int i = 0; i < pixels.length; ++i) {
                pixels[i] = (short)((pixels[i] & 0xFFFF) + value);
            }
        }
    }

    private static void ecrireG(String ph, int decal, byte[] tab) {
        byte[] auxi = new byte[ph.length()];
        auxi = ph.getBytes();
        for (int k = 0; k < auxi.length; ++k) {
            tab[decal + k] = auxi[k];
        }
    }

    private static void ecrireD(String ph, int decal, byte[] tab) {
        byte[] auxi = new byte[ph.length()];
        auxi = ph.getBytes();
        for (int k = 0; k < auxi.length; ++k) {
            tab[decal - auxi.length + 1 + k] = auxi[k];
        }
    }

    public static void addKeyword(String keywordName, String keywordValue, String path) throws IOException {
        ImagePlus imp = new ImagePlus(path);
        FileInfo fi = imp.getFileInfo();
        ImageProcessor ip = imp.getProcessor();
        File file = new File(path);
        RandomAccessFile f = new RandomAccessFile(file, "rw");
        int compteur = 0;
        int nbWord = 1;
        String s = RB_FITS_Writer.getString(80, f);
        while (!s.startsWith("END")) {
            s = RB_FITS_Writer.getString(80, f);
            ++nbWord;
        }
        int tailleHeader = 80 * nbWord;
        byte[] entete = new byte[tailleHeader];
        for (int j = 0; j < entete.length; ++j) {
            entete[j] = 32;
        }
        f.seek(0L);
        s = RB_FITS_Writer.getString(80, f);
        RB_FITS_Writer.ecrireG(s, compteur, entete);
        compteur += 80;
        if (!s.startsWith("SIMPLE")) {
            f.close();
            return;
        }
        RB_FITS_Writer.ecrireG(s, compteur, entete);
        while (!s.startsWith(" ") && !s.startsWith("END")) {
            s = RB_FITS_Writer.getString(80, f);
            if (s.startsWith(" ")) continue;
            RB_FITS_Writer.ecrireG(s, compteur, entete);
            compteur += 80;
        }
        String ht = "" + keywordValue;
        RB_FITS_Writer.ecrireG(keywordName + "=", compteur, entete);
        RB_FITS_Writer.ecrireD(ht, compteur + 29, entete);
        compteur += 80;
        RB_FITS_Writer.ecrireG("END", tailleHeader - 80, entete);
        f.seek(tailleHeader);
        long taille = f.length() - (long)tailleHeader;
        byte[] b = new byte[(int)taille];
        f.read(b);
        f.close();
        FileOutputStream fileout = new FileOutputStream(path);
        DataOutputStream output = new DataOutputStream(fileout);
        output.write(entete, 0, tailleHeader);
        output.write(b, 0, (int)taille);
        output.close();
        fileout.close();
    }

    public static void copyHeader(ImagePlus imp, String path) throws IOException {
        FileInfo fi = imp.getOriginalFileInfo();
        ImageProcessor ip = imp.getProcessor();
        File file = new File(fi.directory + fi.fileName);
        RandomAccessFile f = new RandomAccessFile(file, "r");
        long taille = f.length();
        byte[] b = new byte[(int)taille];
        f.read(b);
        f.close();
        FileOutputStream fileout = new FileOutputStream(path);
        DataOutputStream output = new DataOutputStream(fileout);
        output.write(b, 0, (int)taille);
        output.close();
        fileout.close();
    }

    static String getString(int length, RandomAccessFile f) throws IOException {
        byte[] b = new byte[length];
        f.read(b);
        return new String(b);
    }

    static int getInteger(String s, RandomAccessFile f) {
        s = s.substring(10, 30);
        s = s.trim();
        return Integer.parseInt(s);
    }

    static double getFloat(String s, RandomAccessFile f) {
        Double d;
        s = s.substring(10, 30);
        s = s.trim();
        try {
            d = new Double(s);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }
}

