/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.util.Properties;

public class Printer
implements PlugInFilter {
    private ImagePlus imp;
    private static double scaling = 100.0;
    private static boolean drawBorder = false;
    private static boolean center = true;
    private static boolean label = false;
    private static Properties printPrefs = new Properties();

    public int setup(String arg, ImagePlus imp) {
        if (arg.equals("setup")) {
            this.pageSetup();
            return 4096;
        }
        this.imp = imp;
        IJ.register(Printer.class);
        return 159;
    }

    public void run(ImageProcessor ip) {
        this.print(this.imp);
    }

    void pageSetup() {
        GenericDialog gd = new GenericDialog(IJ.getPluginBundle().getString("PageSetup"));
        gd.addNumericField(IJ.getPluginBundle().getString("PrintScaling") + "(5-500%):", scaling, 0);
        gd.addCheckbox(IJ.getPluginBundle().getString("PrintBorder"), drawBorder);
        gd.addCheckbox(IJ.getPluginBundle().getString("PrintCenter"), center);
        gd.addCheckbox(IJ.getPluginBundle().getString("PrintTitle"), label);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        scaling = gd.getNextNumber();
        if (scaling < 5.0) {
            scaling = 5.0;
        }
        drawBorder = gd.getNextBoolean();
        center = gd.getNextBoolean();
        label = gd.getNextBoolean();
    }

    void print(ImagePlus imp) {
        ImageWindow win = imp.getWindow();
        if (win == null) {
            return;
        }
        ImageCanvas ic = win.getCanvas();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        PrintJob job = toolkit.getPrintJob(win, imp.getTitle(), printPrefs);
        if (job == null) {
            return;
        }
        imp.startTiming();
        Graphics g = job.getGraphics();
        if (g == null) {
            return;
        }
        Dimension pageSize = job.getPageDimension();
        if (IJ.debugMode) {
            IJ.log("pageSize: " + pageSize);
        }
        double scale = scaling / 100.0;
        int width = imp.getWidth();
        int height = imp.getHeight();
        int printWidth = (int)((double)width * scale);
        int printHeight = (int)((double)height * scale);
        int margin = 20;
        int labelHeight = 0;
        int maxWidth = pageSize.width - margin * 2;
        int maxHeight = pageSize.height - (margin + labelHeight) * 2;
        g.setColor(Color.black);
        if (label) {
            labelHeight = 15;
            g.setFont(new Font("SanSerif", 0, 12));
            g.drawString(imp.getTitle(), margin + 5, margin + labelHeight - 3);
        }
        Image img = imp.getImage();
        if (width > maxWidth || height > maxHeight) {
            double hscale = (double)maxWidth / (double)width;
            double vscale = (double)maxHeight / (double)height;
            scale = hscale <= vscale ? hscale : vscale;
            printWidth = (int)((double)width * scale);
            printHeight = (int)((double)height * scale);
            if (System.getProperty("os.name").startsWith("Windows") && System.getProperty("java.version").startsWith("1.3.1")) {
                ImageProcessor ip = imp.getProcessor();
                ip.setInterpolate(true);
                img = ip.resize(printWidth, printHeight).createImage();
            }
        }
        if (center && width < maxWidth && height < maxHeight) {
            g.translate((pageSize.width - width) / 2, labelHeight + (pageSize.height - height) / 2);
        } else {
            g.translate(margin, margin + labelHeight);
        }
        if (drawBorder) {
            g.drawRect(-1, -1, printWidth + 1, printHeight + 1);
        }
        g.drawImage(img, 0, 0, printWidth, printHeight, null);
        g.dispose();
        job.end();
    }
}

