/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.TextRoi;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;

public class Fonts
extends PlugInFrame
implements PlugIn,
ItemListener {
    private static String[] sizes = new String[]{"8", "9", "10", "12", "14", "18", "24", "28", "36", "48", "60", "72"};
    private static int[] isizes = new int[]{8, 9, 10, 12, 14, 18, 24, 28, 36, 48, 60, 72};
    private Panel panel;
    private Choice font;
    private Choice size;
    private Choice style;
    private static Frame instance;

    public Fonts() {
        super(IJ.getPluginBundle().getString("FontsTitle"));
        int i;
        if (instance != null) {
            instance.toFront();
            return;
        }
        WindowManager.addWindow(this);
        instance = this;
        this.setLayout(new FlowLayout(1, 10, 5));
        this.font = new Choice();
        String[] fonts = Toolkit.getDefaultToolkit().getFontList();
        for (i = 0; i < fonts.length; ++i) {
            this.font.add(fonts[i]);
        }
        this.font.select(TextRoi.getFont());
        this.font.addItemListener(this);
        this.add(this.font);
        this.size = new Choice();
        for (i = 0; i < sizes.length; ++i) {
            this.size.add(sizes[i]);
        }
        this.size.select(this.getSizeIndex());
        this.size.addItemListener(this);
        this.add(this.size);
        this.style = new Choice();
        this.style.add(IJ.getPluginBundle().getString("FontPlain"));
        this.style.add(IJ.getPluginBundle().getString("FontBold"));
        this.style.add(IJ.getPluginBundle().getString("FontIt"));
        this.style.add(IJ.getPluginBundle().getString("FontBoldIt"));
        i = TextRoi.getStyle();
        String s = IJ.getPluginBundle().getString("FontPlain");
        if (i == 1) {
            s = IJ.getPluginBundle().getString("FontBold");
        } else if (i == 2) {
            s = IJ.getPluginBundle().getString("FontIt");
        } else if (i == 3) {
            s = IJ.getPluginBundle().getString("FontBoldIt");
        }
        this.style.select(s);
        this.style.addItemListener(this);
        this.add(this.style);
        this.pack();
        GUI.center(this);
        this.show();
        IJ.register(Fonts.class);
    }

    int getSizeIndex() {
        int size = TextRoi.getSize();
        int index = 0;
        for (int i = 0; i < isizes.length; ++i) {
            if (size < isizes[i]) continue;
            index = i;
        }
        return index;
    }

    public void itemStateChanged(ItemEvent e) {
        String fontName = this.font.getSelectedItem();
        int fontSize = Integer.parseInt(this.size.getSelectedItem());
        String styleName = this.style.getSelectedItem();
        int fontStyle = 0;
        if (styleName.equals(IJ.getPluginBundle().getString("FontBold"))) {
            fontStyle = 1;
        } else if (styleName.equals(IJ.getPluginBundle().getString("FontIt"))) {
            fontStyle = 2;
        } else if (styleName.equals(IJ.getPluginBundle().getString("FontBoldIt"))) {
            fontStyle = 3;
        }
        TextRoi.setFont(fontName, fontSize, fontStyle);
        IJ.showStatus(fontSize + " " + IJ.getPluginBundle().getString("FontPoint") + " " + fontName + " " + styleName);
    }

    public void windowClosing(WindowEvent e) {
        super.windowClosing(e);
        instance = null;
    }
}

