/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.font.ScriptRunData;

public final class ScriptRun {
    private char[] text;
    private int textStart;
    private int textLimit;
    private int scriptStart;
    private int scriptLimit;
    private int scriptCode;
    private int[] stack;
    private int parenSP;
    static final int SURROGATE_START = 65536;
    static final int LEAD_START = 55296;
    static final int LEAD_LIMIT = 56320;
    static final int TAIL_START = 56320;
    static final int TAIL_LIMIT = 57344;
    static final int LEAD_SURROGATE_SHIFT = 10;
    static final int SURROGATE_OFFSET = -56613888;
    static final int DONE = -1;
    private static int[] pairedChars = new int[]{40, 41, 60, 62, 91, 93, 123, 125, 171, 187, 8216, 8217, 8220, 8221, 8249, 8250, 12296, 12297, 12298, 12299, 12300, 12301, 12302, 12303, 12304, 12305, 12308, 12309, 12310, 12311, 12312, 12313, 12314, 12315};
    private static final int pairedCharPower = 1 << ScriptRun.highBit(pairedChars.length);
    private static final int pairedCharExtra = pairedChars.length - pairedCharPower;

    public ScriptRun() {
    }

    public ScriptRun(char[] cArray, int n2, int n3) {
        this.init(cArray, n2, n3);
    }

    public void init(char[] cArray, int n2, int n3) {
        if (cArray == null || n2 < 0 || n3 < 0 || n3 > cArray.length - n2) {
            throw new IllegalArgumentException();
        }
        this.text = cArray;
        this.textStart = n2;
        this.textLimit = n2 + n3;
        this.scriptStart = this.textStart;
        this.scriptLimit = this.textStart;
        this.scriptCode = -1;
        this.parenSP = 0;
    }

    public final int getScriptStart() {
        return this.scriptStart;
    }

    public final int getScriptLimit() {
        return this.scriptLimit;
    }

    public final int getScriptCode() {
        return this.scriptCode;
    }

    public final boolean next() {
        int n2;
        int n3 = this.parenSP;
        if (this.scriptLimit >= this.textLimit) {
            return false;
        }
        this.scriptCode = 0;
        this.scriptStart = this.scriptLimit;
        while ((n2 = this.nextCodePoint()) != -1) {
            int n4;
            int n5 = ScriptRunData.getScript(n2);
            int n6 = n4 = n5 == 0 ? ScriptRun.getPairIndex(n2) : -1;
            if (n4 >= 0) {
                if ((n4 & 1) == 0) {
                    if (this.stack == null) {
                        this.stack = new int[32];
                    } else if (this.parenSP == this.stack.length) {
                        int[] nArray = new int[this.stack.length + 32];
                        System.arraycopy(this.stack, 0, nArray, 0, this.stack.length);
                        this.stack = nArray;
                    }
                    this.stack[this.parenSP++] = n4;
                    this.stack[this.parenSP++] = this.scriptCode;
                } else if (this.parenSP > 0) {
                    int n7 = n4 & 0xFFFFFFFE;
                    while ((this.parenSP -= 2) >= 0 && this.stack[this.parenSP] != n7) {
                    }
                    if (this.parenSP >= 0) {
                        n5 = this.stack[this.parenSP + 1];
                    } else {
                        this.parenSP = 0;
                    }
                    if (this.parenSP < n3) {
                        n3 = this.parenSP;
                    }
                }
            }
            if (ScriptRun.sameScript(this.scriptCode, n5)) {
                if (this.scriptCode <= 1 && n5 > 1) {
                    this.scriptCode = n5;
                    while (n3 < this.parenSP) {
                        this.stack[n3 + 1] = this.scriptCode;
                        n3 += 2;
                    }
                }
                if (n4 <= 0 || (n4 & 1) == 0 || this.parenSP <= 0) continue;
                this.parenSP -= 2;
                continue;
            }
            this.pushback(n2);
            break;
        }
        return true;
    }

    private final int nextCodePoint() {
        char c2;
        int n2;
        if (this.scriptLimit >= this.textLimit) {
            return -1;
        }
        if ((n2 = this.text[this.scriptLimit++]) >= 55296 && n2 < 56320 && this.scriptLimit < this.textLimit && (c2 = this.text[this.scriptLimit]) >= '\udc00' && c2 < '\ue000') {
            ++this.scriptLimit;
            n2 = (n2 << 10) + c2 + -56613888;
        }
        return n2;
    }

    private final void pushback(int n2) {
        if (n2 >= 0) {
            this.scriptLimit = n2 >= 65536 ? (this.scriptLimit -= 2) : --this.scriptLimit;
        }
    }

    private static boolean sameScript(int n2, int n3) {
        return n2 == n3 || n2 <= 1 || n3 <= 1;
    }

    private static final byte highBit(int n2) {
        if (n2 <= 0) {
            return -32;
        }
        byte by = 0;
        if (n2 >= 65536) {
            n2 >>= 16;
            by = (byte)(by + 16);
        }
        if (n2 >= 256) {
            n2 >>= 8;
            by = (byte)(by + 8);
        }
        if (n2 >= 16) {
            n2 >>= 4;
            by = (byte)(by + 4);
        }
        if (n2 >= 4) {
            n2 >>= 2;
            by = (byte)(by + 2);
        }
        if (n2 >= 2) {
            n2 >>= 1;
            by = (byte)(by + 1);
        }
        return by;
    }

    private static int getPairIndex(int n2) {
        int n3 = pairedCharPower;
        int n4 = 0;
        if (n2 >= pairedChars[pairedCharExtra]) {
            n4 = pairedCharExtra;
        }
        while (n3 > 1) {
            if (n2 < pairedChars[n4 + (n3 >>= 1)]) continue;
            n4 += n3;
        }
        if (pairedChars[n4] != n2) {
            n4 = -1;
        }
        return n4;
    }
}

