/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import sun.nio.ch.IOUtil;
import sun.nio.ch.SinkChannelImpl;
import sun.nio.ch.SourceChannelImpl;
import sun.nio.ch.Util;

class PipeImpl
extends Pipe {
    private Pipe.SourceChannel source;
    private Pipe.SinkChannel sink;
    private static final Random rnd;

    PipeImpl(SelectorProvider selectorProvider) throws IOException {
        try {
            AccessController.doPrivileged(new Initializer(selectorProvider));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public Pipe.SourceChannel source() {
        return this.source;
    }

    public Pipe.SinkChannel sink() {
        return this.sink;
    }

    static {
        Util.load();
        byte[] byArray = new byte[8];
        boolean bl2 = IOUtil.randomBytes(byArray);
        rnd = bl2 ? new Random(ByteBuffer.wrap(byArray).getLong()) : new Random();
    }

    private class Initializer
    implements PrivilegedExceptionAction {
        private final SelectorProvider sp;

        private Initializer(SelectorProvider selectorProvider) {
            this.sp = selectorProvider;
        }

        public Object run() throws IOException {
            ServerSocketChannel serverSocketChannel = null;
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            AbstractInterruptibleChannel abstractInterruptibleChannel2 = null;
            try {
                InetAddress inetAddress = InetAddress.getByName("127.0.0.1");
                assert (inetAddress.isLoopbackAddress());
                serverSocketChannel = ServerSocketChannel.open();
                serverSocketChannel.socket().bind(new InetSocketAddress(inetAddress, 0));
                InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, serverSocketChannel.socket().getLocalPort());
                abstractInterruptibleChannel = SocketChannel.open(inetSocketAddress);
                ByteBuffer byteBuffer = ByteBuffer.allocate(8);
                long l2 = rnd.nextLong();
                byteBuffer.putLong(l2).flip();
                ((SocketChannel)abstractInterruptibleChannel).write(byteBuffer);
                while (true) {
                    abstractInterruptibleChannel2 = serverSocketChannel.accept();
                    byteBuffer.clear();
                    ((SocketChannel)abstractInterruptibleChannel2).read(byteBuffer);
                    byteBuffer.rewind();
                    if (byteBuffer.getLong() == l2) break;
                    abstractInterruptibleChannel2.close();
                }
                PipeImpl.this.source = new SourceChannelImpl(this.sp, (SocketChannel)abstractInterruptibleChannel);
                PipeImpl.this.sink = new SinkChannelImpl(this.sp, (SocketChannel)abstractInterruptibleChannel2);
            }
            catch (IOException iOException) {
                try {
                    if (abstractInterruptibleChannel != null) {
                        abstractInterruptibleChannel.close();
                    }
                    if (abstractInterruptibleChannel2 != null) {
                        abstractInterruptibleChannel2.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                IOException iOException3 = new IOException("Unable to establish loopback connection");
                iOException3.initCause(iOException);
                throw iOException3;
            }
            finally {
                try {
                    if (serverSocketChannel != null) {
                        serverSocketChannel.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }
}

