/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import sun.tools.java.BinaryConstantPool;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;

public final class BinaryAttribute
implements Constants {
    Identifier name;
    byte[] data;
    BinaryAttribute next;

    BinaryAttribute(Identifier identifier, byte[] byArray, BinaryAttribute binaryAttribute) {
        this.name = identifier;
        this.data = byArray;
        this.next = binaryAttribute;
    }

    public static BinaryAttribute load(DataInputStream dataInputStream, BinaryConstantPool binaryConstantPool, int n) throws IOException {
        BinaryAttribute binaryAttribute = null;
        int n2 = dataInputStream.readUnsignedShort();
        for (int i = 0; i < n2; ++i) {
            Identifier identifier = binaryConstantPool.getIdentifier(dataInputStream.readUnsignedShort());
            int n3 = dataInputStream.readInt();
            if (identifier.equals(idCode) && (n & 2) == 0) {
                dataInputStream.skipBytes(n3);
                continue;
            }
            byte[] byArray = new byte[n3];
            dataInputStream.readFully(byArray);
            binaryAttribute = new BinaryAttribute(identifier, byArray, binaryAttribute);
        }
        return binaryAttribute;
    }

    static void write(BinaryAttribute binaryAttribute, DataOutputStream dataOutputStream, BinaryConstantPool binaryConstantPool, Environment environment) throws IOException {
        int n = 0;
        BinaryAttribute binaryAttribute2 = binaryAttribute;
        while (binaryAttribute2 != null) {
            ++n;
            binaryAttribute2 = binaryAttribute2.next;
        }
        dataOutputStream.writeShort(n);
        binaryAttribute2 = binaryAttribute;
        while (binaryAttribute2 != null) {
            Identifier identifier = binaryAttribute2.name;
            byte[] byArray = binaryAttribute2.data;
            dataOutputStream.writeShort(binaryConstantPool.indexString(identifier.toString(), environment));
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray, 0, byArray.length);
            binaryAttribute2 = binaryAttribute2.next;
        }
    }

    public Identifier getName() {
        return this.name;
    }

    public byte[] getData() {
        return this.data;
    }

    public BinaryAttribute getNextAttribute() {
        return this.next;
    }
}

