/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.ByteBandedRaster;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.BytePackedRaster;
import sun.awt.image.IntegerInterleavedRaster;
import sun.awt.image.ShortBandedRaster;
import sun.awt.image.ShortInterleavedRaster;
import sun.awt.image.SunWritableRaster;

public class Raster {
    protected SampleModel sampleModel;
    protected DataBuffer dataBuffer;
    protected int minX;
    protected int minY;
    protected int width;
    protected int height;
    protected int sampleModelTranslateX;
    protected int sampleModelTranslateY;
    protected int numBands;
    protected int numDataElements;
    protected Raster parent;

    private static native void initIDs();

    public static WritableRaster createInterleavedRaster(int n2, int n3, int n4, int n5, Point point) {
        int[] nArray = new int[n5];
        for (int i2 = 0; i2 < n5; ++i2) {
            nArray[i2] = i2;
        }
        return Raster.createInterleavedRaster(n2, n3, n4, n3 * n5, n5, nArray, point);
    }

    public static WritableRaster createInterleavedRaster(int n2, int n3, int n4, int n5, int n6, int[] nArray, Point point) {
        DataBuffer dataBuffer;
        int n7;
        int n8 = nArray.length;
        int n9 = nArray[0];
        for (n7 = 1; n7 < n8; ++n7) {
            if (nArray[n7] <= n9) continue;
            n9 = nArray[n7];
        }
        n7 = n9 + n5 * (n4 - 1) + n6 * (n3 - 1) + 1;
        switch (n2) {
            case 0: {
                dataBuffer = new DataBufferByte(n7);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n7);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type " + n2);
            }
        }
        SunWritableRaster sunWritableRaster = (SunWritableRaster)Raster.createInterleavedRaster(dataBuffer, n3, n4, n5, n6, nArray, point);
        sunWritableRaster.setStolen(false);
        return sunWritableRaster;
    }

    public static WritableRaster createBandedRaster(int n2, int n3, int n4, int n5, Point point) {
        if (n5 < 1) {
            throw new ArrayIndexOutOfBoundsException("Number of bands (" + n5 + ") must" + " be greater than 0");
        }
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        for (int i2 = 0; i2 < n5; ++i2) {
            nArray[i2] = i2;
            nArray2[i2] = 0;
        }
        return Raster.createBandedRaster(n2, n3, n4, n3, nArray, nArray2, point);
    }

    public static WritableRaster createBandedRaster(int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2, Point point) {
        DataBuffer dataBuffer;
        int n6;
        int n7 = nArray2.length;
        if (nArray == null) {
            throw new ArrayIndexOutOfBoundsException("Bank indices array is null");
        }
        if (nArray2 == null) {
            throw new ArrayIndexOutOfBoundsException("Band offsets array is null");
        }
        int n8 = nArray[0];
        int n9 = nArray2[0];
        for (n6 = 1; n6 < n7; ++n6) {
            if (nArray[n6] > n8) {
                n8 = nArray[n6];
            }
            if (nArray2[n6] <= n9) continue;
            n9 = nArray2[n6];
        }
        n6 = n8 + 1;
        int n10 = n9 + n5 * (n4 - 1) + (n3 - 1) + 1;
        switch (n2) {
            case 0: {
                dataBuffer = new DataBufferByte(n10, n6);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n10, n6);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n10, n6);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type " + n2);
            }
        }
        SunWritableRaster sunWritableRaster = (SunWritableRaster)Raster.createBandedRaster(dataBuffer, n3, n4, n5, nArray, nArray2, point);
        sunWritableRaster.setStolen(false);
        return sunWritableRaster;
    }

    public static WritableRaster createPackedRaster(int n2, int n3, int n4, int[] nArray, Point point) {
        DataBuffer dataBuffer;
        switch (n2) {
            case 0: {
                dataBuffer = new DataBufferByte(n3 * n4);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n3 * n4);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n3 * n4);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type " + n2);
            }
        }
        SunWritableRaster sunWritableRaster = (SunWritableRaster)Raster.createPackedRaster(dataBuffer, n3, n4, n3, nArray, point);
        sunWritableRaster.setStolen(false);
        return sunWritableRaster;
    }

    public static WritableRaster createPackedRaster(int n2, int n3, int n4, int n5, int n6, Point point) {
        DataBuffer dataBuffer;
        if (n5 <= 0) {
            throw new IllegalArgumentException("Number of bands (" + n5 + ") must be greater than 0");
        }
        if (n6 <= 0) {
            throw new IllegalArgumentException("Bits per band (" + n6 + ") must be greater than 0");
        }
        if (n5 != 1) {
            int[] nArray = new int[n5];
            int n7 = (1 << n6) - 1;
            int n8 = (n5 - 1) * n6;
            if (n8 + n6 > DataBuffer.getDataTypeSize(n2)) {
                throw new IllegalArgumentException("bitsPerBand(" + n6 + ") * bands is " + " greater than data type " + "size.");
            }
            switch (n2) {
                case 0: 
                case 1: 
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported data type " + n2);
                }
            }
            for (int i2 = 0; i2 < n5; ++i2) {
                nArray[i2] = n7 << n8;
                n8 -= n6;
            }
            return Raster.createPackedRaster(n2, n3, n4, nArray, point);
        }
        double d2 = n3;
        switch (n2) {
            case 0: {
                dataBuffer = new DataBufferByte((int)Math.ceil(d2 / (double)(8 / n6)) * n4);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort((int)Math.ceil(d2 / (double)(16 / n6)) * n4);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt((int)Math.ceil(d2 / (double)(32 / n6)) * n4);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type " + n2);
            }
        }
        SunWritableRaster sunWritableRaster = (SunWritableRaster)Raster.createPackedRaster(dataBuffer, n3, n4, n6, point);
        sunWritableRaster.setStolen(false);
        return sunWritableRaster;
    }

    public static WritableRaster createInterleavedRaster(DataBuffer dataBuffer, int n2, int n3, int n4, int n5, int[] nArray, Point point) {
        if (dataBuffer == null) {
            throw new NullPointerException("DataBuffer cannot be null");
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        int n6 = dataBuffer.getDataType();
        PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(n6, n2, n3, n5, n4, nArray);
        switch (n6) {
            case 0: {
                return new ByteInterleavedRaster(pixelInterleavedSampleModel, dataBuffer, point);
            }
            case 1: {
                return new ShortInterleavedRaster(pixelInterleavedSampleModel, dataBuffer, point);
            }
        }
        throw new IllegalArgumentException("Unsupported data type " + n6);
    }

    public static WritableRaster createBandedRaster(DataBuffer dataBuffer, int n2, int n3, int n4, int[] nArray, int[] nArray2, Point point) {
        if (dataBuffer == null) {
            throw new NullPointerException("DataBuffer cannot be null");
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        int n5 = dataBuffer.getDataType();
        int n6 = nArray.length;
        if (nArray2.length != n6) {
            throw new IllegalArgumentException("bankIndices.length != bandOffsets.length");
        }
        BandedSampleModel bandedSampleModel = new BandedSampleModel(n5, n2, n3, n4, nArray, nArray2);
        switch (n5) {
            case 0: {
                return new ByteBandedRaster(bandedSampleModel, dataBuffer, point);
            }
            case 1: {
                return new ShortBandedRaster(bandedSampleModel, dataBuffer, point);
            }
            case 3: {
                return new SunWritableRaster(bandedSampleModel, dataBuffer, point);
            }
        }
        throw new IllegalArgumentException("Unsupported data type " + n5);
    }

    public static WritableRaster createPackedRaster(DataBuffer dataBuffer, int n2, int n3, int n4, int[] nArray, Point point) {
        if (dataBuffer == null) {
            throw new NullPointerException("DataBuffer cannot be null");
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        int n5 = dataBuffer.getDataType();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(n5, n2, n3, n4, nArray);
        switch (n5) {
            case 0: {
                return new ByteInterleavedRaster(singlePixelPackedSampleModel, dataBuffer, point);
            }
            case 1: {
                return new ShortInterleavedRaster(singlePixelPackedSampleModel, dataBuffer, point);
            }
            case 3: {
                return new IntegerInterleavedRaster(singlePixelPackedSampleModel, dataBuffer, point);
            }
        }
        throw new IllegalArgumentException("Unsupported data type " + n5);
    }

    public static WritableRaster createPackedRaster(DataBuffer dataBuffer, int n2, int n3, int n4, Point point) {
        int n5;
        if (dataBuffer == null) {
            throw new NullPointerException("DataBuffer cannot be null");
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        if ((n5 = dataBuffer.getDataType()) != 0 && n5 != 1 && n5 != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n5);
        }
        if (dataBuffer.getNumBanks() != 1) {
            throw new RasterFormatException("DataBuffer for packed Rasters must only have 1 bank.");
        }
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(n5, n2, n3, n4);
        if (n5 == 0 && (n4 == 1 || n4 == 2 || n4 == 4)) {
            return new BytePackedRaster(multiPixelPackedSampleModel, dataBuffer, point);
        }
        return new SunWritableRaster(multiPixelPackedSampleModel, dataBuffer, point);
    }

    public static Raster createRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        if (sampleModel == null || dataBuffer == null) {
            throw new NullPointerException("SampleModel and DataBuffer cannot be null");
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        int n2 = sampleModel.getDataType();
        if (sampleModel instanceof PixelInterleavedSampleModel) {
            switch (n2) {
                case 0: {
                    return new ByteInterleavedRaster(sampleModel, dataBuffer, point);
                }
                case 1: {
                    return new ShortInterleavedRaster(sampleModel, dataBuffer, point);
                }
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            switch (n2) {
                case 0: {
                    return new ByteInterleavedRaster(sampleModel, dataBuffer, point);
                }
                case 1: {
                    return new ShortInterleavedRaster(sampleModel, dataBuffer, point);
                }
                case 3: {
                    return new IntegerInterleavedRaster(sampleModel, dataBuffer, point);
                }
            }
        } else if (sampleModel instanceof MultiPixelPackedSampleModel && n2 == 0 && sampleModel.getSampleSize(0) < 8) {
            return new BytePackedRaster(sampleModel, dataBuffer, point);
        }
        return new Raster(sampleModel, dataBuffer, point);
    }

    public static WritableRaster createWritableRaster(SampleModel sampleModel, Point point) {
        if (point == null) {
            point = new Point(0, 0);
        }
        SunWritableRaster sunWritableRaster = (SunWritableRaster)Raster.createWritableRaster(sampleModel, sampleModel.createDataBuffer(), point);
        sunWritableRaster.setStolen(false);
        return sunWritableRaster;
    }

    public static WritableRaster createWritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        if (sampleModel == null || dataBuffer == null) {
            throw new NullPointerException("SampleModel and DataBuffer cannot be null");
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        int n2 = sampleModel.getDataType();
        if (sampleModel instanceof PixelInterleavedSampleModel) {
            switch (n2) {
                case 0: {
                    return new ByteInterleavedRaster(sampleModel, dataBuffer, point);
                }
                case 1: {
                    return new ShortInterleavedRaster(sampleModel, dataBuffer, point);
                }
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            switch (n2) {
                case 0: {
                    return new ByteInterleavedRaster(sampleModel, dataBuffer, point);
                }
                case 1: {
                    return new ShortInterleavedRaster(sampleModel, dataBuffer, point);
                }
                case 3: {
                    return new IntegerInterleavedRaster(sampleModel, dataBuffer, point);
                }
            }
        } else if (sampleModel instanceof MultiPixelPackedSampleModel && n2 == 0 && sampleModel.getSampleSize(0) < 8) {
            return new BytePackedRaster(sampleModel, dataBuffer, point);
        }
        return new SunWritableRaster(sampleModel, dataBuffer, point);
    }

    protected Raster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    protected Raster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    protected Raster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, Raster raster) {
        if (sampleModel == null || dataBuffer == null || rectangle == null || point == null) {
            throw new NullPointerException("SampleModel, dataBuffer, aRegion and sampleModelTranslate cannot be null");
        }
        this.sampleModel = sampleModel;
        this.dataBuffer = dataBuffer;
        this.minX = rectangle.x;
        this.minY = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        if (this.width <= 0 || this.height <= 0) {
            throw new RasterFormatException("negative or zero " + (this.width <= 0 ? "width" : "height"));
        }
        if (this.minX + this.width < this.minX) {
            throw new RasterFormatException("overflow condition for X coordinates of Raster");
        }
        if (this.minY + this.height < this.minY) {
            throw new RasterFormatException("overflow condition for Y coordinates of Raster");
        }
        this.sampleModelTranslateX = point.x;
        this.sampleModelTranslateY = point.y;
        this.numBands = sampleModel.getNumBands();
        this.numDataElements = sampleModel.getNumDataElements();
        this.parent = raster;
    }

    public Raster getParent() {
        return this.parent;
    }

    public final int getSampleModelTranslateX() {
        return this.sampleModelTranslateX;
    }

    public final int getSampleModelTranslateY() {
        return this.sampleModelTranslateY;
    }

    public WritableRaster createCompatibleWritableRaster() {
        return new SunWritableRaster(this.sampleModel, new Point(0, 0));
    }

    public WritableRaster createCompatibleWritableRaster(int n2, int n3) {
        if (n2 <= 0 || n3 <= 0) {
            throw new RasterFormatException("negative " + (n2 <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n2, n3);
        return new SunWritableRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createCompatibleWritableRaster(Rectangle rectangle) {
        if (rectangle == null) {
            throw new NullPointerException("Rect cannot be null");
        }
        return this.createCompatibleWritableRaster(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public WritableRaster createCompatibleWritableRaster(int n2, int n3, int n4, int n5) {
        WritableRaster writableRaster = this.createCompatibleWritableRaster(n4, n5);
        return writableRaster.createWritableChild(0, 0, n4, n5, n2, n3, null);
    }

    public Raster createTranslatedChild(int n2, int n3) {
        return this.createChild(this.minX, this.minY, this.width, this.height, n2, n3, null);
    }

    public Raster createChild(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (n2 < this.minX) {
            throw new RasterFormatException("parentX lies outside raster");
        }
        if (n3 < this.minY) {
            throw new RasterFormatException("parentY lies outside raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.width + this.minX) {
            throw new RasterFormatException("(parentX + width) is outside raster");
        }
        if (n3 + n5 < n3 || n3 + n5 > this.height + this.minY) {
            throw new RasterFormatException("(parentY + height) is outside raster");
        }
        SampleModel sampleModel = nArray == null ? this.sampleModel : this.sampleModel.createSubsetSampleModel(nArray);
        int n8 = n6 - n2;
        int n9 = n7 - n3;
        return new Raster(sampleModel, this.getDataBuffer(), new Rectangle(n6, n7, n4, n5), new Point(this.sampleModelTranslateX + n8, this.sampleModelTranslateY + n9), this);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.minX, this.minY, this.width, this.height);
    }

    public final int getMinX() {
        return this.minX;
    }

    public final int getMinY() {
        return this.minY;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getNumBands() {
        return this.numBands;
    }

    public final int getNumDataElements() {
        return this.sampleModel.getNumDataElements();
    }

    public final int getTransferType() {
        return this.sampleModel.getTransferType();
    }

    public DataBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public Object getDataElements(int n2, int n3, Object object) {
        return this.sampleModel.getDataElements(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, object, this.dataBuffer);
    }

    public Object getDataElements(int n2, int n3, int n4, int n5, Object object) {
        return this.sampleModel.getDataElements(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, n5, object, this.dataBuffer);
    }

    public int[] getPixel(int n2, int n3, int[] nArray) {
        return this.sampleModel.getPixel(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, nArray, this.dataBuffer);
    }

    public float[] getPixel(int n2, int n3, float[] fArray) {
        return this.sampleModel.getPixel(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, fArray, this.dataBuffer);
    }

    public double[] getPixel(int n2, int n3, double[] dArray) {
        return this.sampleModel.getPixel(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, dArray, this.dataBuffer);
    }

    public int[] getPixels(int n2, int n3, int n4, int n5, int[] nArray) {
        return this.sampleModel.getPixels(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, n5, nArray, this.dataBuffer);
    }

    public float[] getPixels(int n2, int n3, int n4, int n5, float[] fArray) {
        return this.sampleModel.getPixels(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, n5, fArray, this.dataBuffer);
    }

    public double[] getPixels(int n2, int n3, int n4, int n5, double[] dArray) {
        return this.sampleModel.getPixels(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, n5, dArray, this.dataBuffer);
    }

    public int getSample(int n2, int n3, int n4) {
        return this.sampleModel.getSample(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, this.dataBuffer);
    }

    public float getSampleFloat(int n2, int n3, int n4) {
        return this.sampleModel.getSampleFloat(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, this.dataBuffer);
    }

    public double getSampleDouble(int n2, int n3, int n4) {
        return this.sampleModel.getSampleDouble(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, this.dataBuffer);
    }

    public int[] getSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        return this.sampleModel.getSamples(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, n5, n6, nArray, this.dataBuffer);
    }

    public float[] getSamples(int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        return this.sampleModel.getSamples(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, n5, n6, fArray, this.dataBuffer);
    }

    public double[] getSamples(int n2, int n3, int n4, int n5, int n6, double[] dArray) {
        return this.sampleModel.getSamples(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, n5, n6, dArray, this.dataBuffer);
    }

    static {
        ColorModel.loadLibraries();
        Raster.initIDs();
    }
}

