/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Long
extends Number
implements Comparable<Long> {
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class<Long> TYPE = Class.getPrimitiveClass("long");
    private final long value;
    public static final int SIZE = 64;
    private static final long serialVersionUID = 4290774380558885855L;

    public static String toString(long l2, int n2) {
        boolean bl2;
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        if (n2 == 10) {
            return Long.toString(l2);
        }
        char[] cArray = new char[65];
        int n3 = 64;
        boolean bl3 = bl2 = l2 < 0L;
        if (!bl2) {
            l2 = -l2;
        }
        while (l2 <= (long)(-n2)) {
            cArray[n3--] = Integer.digits[(int)(-(l2 % (long)n2))];
            l2 /= (long)n2;
        }
        cArray[n3] = Integer.digits[(int)(-l2)];
        if (bl2) {
            cArray[--n3] = 45;
        }
        return new String(cArray, n3, 65 - n3);
    }

    public static String toHexString(long l2) {
        return Long.toUnsignedString(l2, 4);
    }

    public static String toOctalString(long l2) {
        return Long.toUnsignedString(l2, 3);
    }

    public static String toBinaryString(long l2) {
        return Long.toUnsignedString(l2, 1);
    }

    private static String toUnsignedString(long l2, int n2) {
        char[] cArray = new char[64];
        int n3 = 64;
        int n4 = 1 << n2;
        long l3 = n4 - 1;
        do {
            cArray[--n3] = Integer.digits[(int)(l2 & l3)];
        } while ((l2 >>>= n2) != 0L);
        return new String(cArray, n3, 64 - n3);
    }

    public static String toString(long l2) {
        if (l2 == Long.MIN_VALUE) {
            return "-9223372036854775808";
        }
        int n2 = l2 < 0L ? Long.stringSize(-l2) + 1 : Long.stringSize(l2);
        char[] cArray = new char[n2];
        Long.getChars(l2, n2, cArray);
        return new String(0, n2, cArray);
    }

    static void getChars(long l2, int n2, char[] cArray) {
        int n3;
        int n4;
        int n5 = n2;
        int n6 = 0;
        if (l2 < 0L) {
            n6 = 45;
            l2 = -l2;
        }
        while (l2 > Integer.MAX_VALUE) {
            long l3 = l2 / 100L;
            n4 = (int)(l2 - ((l3 << 6) + (l3 << 5) + (l3 << 2)));
            l2 = l3;
            cArray[--n5] = Integer.DigitOnes[n4];
            cArray[--n5] = Integer.DigitTens[n4];
        }
        int n7 = (int)l2;
        while (n7 >= 65536) {
            n3 = n7 / 100;
            n4 = n7 - ((n3 << 6) + (n3 << 5) + (n3 << 2));
            n7 = n3;
            cArray[--n5] = Integer.DigitOnes[n4];
            cArray[--n5] = Integer.DigitTens[n4];
        }
        do {
            n3 = n7 * 52429 >>> 19;
            n4 = n7 - ((n3 << 3) + (n3 << 1));
            cArray[--n5] = Integer.digits[n4];
        } while ((n7 = n3) != 0);
        if (n6 != 0) {
            cArray[--n5] = n6;
        }
    }

    static int stringSize(long l2) {
        long l3 = 10L;
        for (int i2 = 1; i2 < 19; ++i2) {
            if (l2 < l3) {
                return i2;
            }
            l3 = 10L * l3;
        }
        return 19;
    }

    public static long parseLong(String string, int n2) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        if (n2 < 2) {
            throw new NumberFormatException("radix " + n2 + " less than Character.MIN_RADIX");
        }
        if (n2 > 36) {
            throw new NumberFormatException("radix " + n2 + " greater than Character.MAX_RADIX");
        }
        long l2 = 0L;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = string.length();
        if (n4 > 0) {
            int n5;
            long l3;
            if (string.charAt(0) == '-') {
                bl2 = true;
                l3 = Long.MIN_VALUE;
                ++n3;
            } else {
                l3 = -9223372036854775807L;
            }
            long l4 = l3 / (long)n2;
            if (n3 < n4) {
                if ((n5 = Character.digit(string.charAt(n3++), n2)) < 0) {
                    throw NumberFormatException.forInputString(string);
                }
                l2 = -n5;
            }
            while (n3 < n4) {
                if ((n5 = Character.digit(string.charAt(n3++), n2)) < 0) {
                    throw NumberFormatException.forInputString(string);
                }
                if (l2 < l4) {
                    throw NumberFormatException.forInputString(string);
                }
                if ((l2 *= (long)n2) < l3 + (long)n5) {
                    throw NumberFormatException.forInputString(string);
                }
                l2 -= (long)n5;
            }
        } else {
            throw NumberFormatException.forInputString(string);
        }
        if (bl2) {
            if (n3 > 1) {
                return l2;
            }
            throw NumberFormatException.forInputString(string);
        }
        return -l2;
    }

    public static long parseLong(String string) throws NumberFormatException {
        return Long.parseLong(string, 10);
    }

    public static Long valueOf(String string, int n2) throws NumberFormatException {
        return new Long(Long.parseLong(string, n2));
    }

    public static Long valueOf(String string) throws NumberFormatException {
        return new Long(Long.parseLong(string, 10));
    }

    public static Long valueOf(long l2) {
        if (l2 >= -128L && l2 <= 127L) {
            return LongCache.cache[(int)l2 + 128];
        }
        return new Long(l2);
    }

    public static Long decode(String string) throws NumberFormatException {
        Long l2;
        int n2 = 10;
        int n3 = 0;
        boolean bl2 = false;
        if (string.startsWith("-")) {
            bl2 = true;
            ++n3;
        }
        if (string.startsWith("0x", n3) || string.startsWith("0X", n3)) {
            n3 += 2;
            n2 = 16;
        } else if (string.startsWith("#", n3)) {
            ++n3;
            n2 = 16;
        } else if (string.startsWith("0", n3) && string.length() > 1 + n3) {
            ++n3;
            n2 = 8;
        }
        if (string.startsWith("-", n3)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        try {
            l2 = Long.valueOf(string.substring(n3), n2);
            l2 = bl2 ? new Long(-l2.longValue()) : l2;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = bl2 ? new String("-" + string.substring(n3)) : string.substring(n3);
            l2 = Long.valueOf(string2, n2);
        }
        return l2;
    }

    public Long(long l2) {
        this.value = l2;
    }

    public Long(String string) throws NumberFormatException {
        this.value = Long.parseLong(string, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object object) {
        if (object instanceof Long) {
            return this.value == (Long)object;
        }
        return false;
    }

    public static Long getLong(String string) {
        return Long.getLong(string, null);
    }

    public static Long getLong(String string, long l2) {
        Long l3 = Long.getLong(string, null);
        return l3 == null ? new Long(l2) : l3;
    }

    public static Long getLong(String string, Long l2) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string2 != null) {
            try {
                return Long.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l2;
    }

    @Override
    public int compareTo(Long l2) {
        long l3 = this.value;
        long l4 = l2.value;
        return l3 < l4 ? -1 : (l3 == l4 ? 0 : 1);
    }

    public static long highestOneBit(long l2) {
        l2 |= l2 >> 1;
        l2 |= l2 >> 2;
        l2 |= l2 >> 4;
        l2 |= l2 >> 8;
        l2 |= l2 >> 16;
        l2 |= l2 >> 32;
        return l2 - (l2 >>> 1);
    }

    public static long lowestOneBit(long l2) {
        return l2 & -l2;
    }

    public static int numberOfLeadingZeros(long l2) {
        if (l2 == 0L) {
            return 64;
        }
        int n2 = 1;
        int n3 = (int)(l2 >>> 32);
        if (n3 == 0) {
            n2 += 32;
            n3 = (int)l2;
        }
        if (n3 >>> 16 == 0) {
            n2 += 16;
            n3 <<= 16;
        }
        if (n3 >>> 24 == 0) {
            n2 += 8;
            n3 <<= 8;
        }
        if (n3 >>> 28 == 0) {
            n2 += 4;
            n3 <<= 4;
        }
        if (n3 >>> 30 == 0) {
            n2 += 2;
            n3 <<= 2;
        }
        return n2 -= n3 >>> 31;
    }

    public static int numberOfTrailingZeros(long l2) {
        int n2;
        if (l2 == 0L) {
            return 64;
        }
        int n3 = 63;
        int n4 = (int)l2;
        if (n4 != 0) {
            n3 -= 32;
            n2 = n4;
        } else {
            n2 = (int)(l2 >>> 32);
        }
        n4 = n2 << 16;
        if (n4 != 0) {
            n3 -= 16;
            n2 = n4;
        }
        if ((n4 = n2 << 8) != 0) {
            n3 -= 8;
            n2 = n4;
        }
        if ((n4 = n2 << 4) != 0) {
            n3 -= 4;
            n2 = n4;
        }
        if ((n4 = n2 << 2) != 0) {
            n3 -= 2;
            n2 = n4;
        }
        return n3 - (n2 << 1 >>> 31);
    }

    public static int bitCount(long l2) {
        l2 -= l2 >>> 1 & 0x5555555555555555L;
        l2 = (l2 & 0x3333333333333333L) + (l2 >>> 2 & 0x3333333333333333L);
        l2 = l2 + (l2 >>> 4) & 0xF0F0F0F0F0F0F0FL;
        l2 += l2 >>> 8;
        l2 += l2 >>> 16;
        l2 += l2 >>> 32;
        return (int)l2 & 0x7F;
    }

    public static long rotateLeft(long l2, int n2) {
        return l2 << n2 | l2 >>> -n2;
    }

    public static long rotateRight(long l2, int n2) {
        return l2 >>> n2 | l2 << -n2;
    }

    public static long reverse(long l2) {
        l2 = (l2 & 0x5555555555555555L) << 1 | l2 >>> 1 & 0x5555555555555555L;
        l2 = (l2 & 0x3333333333333333L) << 2 | l2 >>> 2 & 0x3333333333333333L;
        l2 = (l2 & 0xF0F0F0F0F0F0F0FL) << 4 | l2 >>> 4 & 0xF0F0F0F0F0F0F0FL;
        l2 = (l2 & 0xFF00FF00FF00FFL) << 8 | l2 >>> 8 & 0xFF00FF00FF00FFL;
        l2 = l2 << 48 | (l2 & 0xFFFF0000L) << 16 | l2 >>> 16 & 0xFFFF0000L | l2 >>> 48;
        return l2;
    }

    public static int signum(long l2) {
        return (int)(l2 >> 63 | -l2 >>> 63);
    }

    public static long reverseBytes(long l2) {
        l2 = (l2 & 0xFF00FF00FF00FFL) << 8 | l2 >>> 8 & 0xFF00FF00FF00FFL;
        return l2 << 48 | (l2 & 0xFFFF0000L) << 16 | l2 >>> 16 & 0xFFFF0000L | l2 >>> 48;
    }

    private static class LongCache {
        static final Long[] cache = new Long[256];

        private LongCache() {
        }

        static {
            for (int i2 = 0; i2 < cache.length; ++i2) {
                LongCache.cache[i2] = new Long(i2 - 128);
            }
        }
    }
}

