/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueuedSynchronizer
implements Serializable {
    private static final long serialVersionUID = 7373984972572414691L;
    private volatile transient Node head;
    private volatile transient Node tail;
    private volatile int state;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long stateOffset;
    private static final long headOffset;
    private static final long tailOffset;
    private static final long waitStatusOffset;

    protected AbstractQueuedSynchronizer() {
    }

    protected final int getState() {
        return this.state;
    }

    protected final void setState(int n2) {
        this.state = n2;
    }

    protected final boolean compareAndSetState(int n2, int n3) {
        return unsafe.compareAndSwapInt(this, stateOffset, n2, n3);
    }

    private Node enq(Node node) {
        Node node2;
        while (true) {
            if ((node2 = this.tail) == null) {
                Node node3 = new Node();
                node3.next = node;
                node.prev = node3;
                if (!this.compareAndSetHead(node3)) continue;
                this.tail = node;
                return node3;
            }
            node.prev = node2;
            if (this.compareAndSetTail(node2, node)) break;
        }
        node2.next = node;
        return node2;
    }

    private Node addWaiter(Node node) {
        Node node2 = new Node(Thread.currentThread(), node);
        Node node3 = this.tail;
        if (node3 != null) {
            node2.prev = node3;
            if (this.compareAndSetTail(node3, node2)) {
                node3.next = node2;
                return node2;
            }
        }
        this.enq(node2);
        return node2;
    }

    private void setHead(Node node) {
        this.head = node;
        node.thread = null;
        node.prev = null;
    }

    private void unparkSuccessor(Node node) {
        Thread thread;
        AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, -1, 0);
        Node node2 = node.next;
        if (node2 != null && node2.waitStatus <= 0) {
            thread = node2.thread;
        } else {
            thread = null;
            node2 = this.tail;
            while (node2 != null && node2 != node) {
                if (node2.waitStatus <= 0) {
                    thread = node2.thread;
                }
                node2 = node2.prev;
            }
        }
        LockSupport.unpark(thread);
    }

    private void setHeadAndPropagate(Node node, int n2) {
        Node node2;
        this.setHead(node);
        if (n2 > 0 && node.waitStatus != 0 && ((node2 = node.next) == null || node2.isShared())) {
            this.unparkSuccessor(node);
        }
    }

    private void cancelAcquire(Node node) {
        if (node != null) {
            node.thread = null;
            node.waitStatus = 1;
            this.unparkSuccessor(node);
        }
    }

    private static boolean shouldParkAfterFailedAcquire(Node node, Node node2) {
        int n2 = node.waitStatus;
        if (n2 < 0) {
            return true;
        }
        if (n2 > 0) {
            node2.prev = node.prev;
        } else {
            AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, 0, -1);
        }
        return false;
    }

    private static void selfInterrupt() {
        Thread.currentThread().interrupt();
    }

    private static boolean parkAndCheckInterrupt() {
        LockSupport.park();
        return Thread.interrupted();
    }

    final boolean acquireQueued(Node node, int n2) {
        try {
            boolean bl2 = false;
            while (true) {
                Node node2;
                if ((node2 = node.predecessor()) == this.head && this.tryAcquire(n2)) {
                    this.setHead(node);
                    node2.next = null;
                    return bl2;
                }
                if (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !AbstractQueuedSynchronizer.parkAndCheckInterrupt()) continue;
                bl2 = true;
            }
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node);
            throw runtimeException;
        }
    }

    private void doAcquireInterruptibly(int n2) throws InterruptedException {
        Node node = this.addWaiter(Node.EXCLUSIVE);
        try {
            Node node2;
            do {
                if ((node2 = node.predecessor()) != this.head || !this.tryAcquire(n2)) continue;
                this.setHead(node);
                node2.next = null;
                return;
            } while (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !AbstractQueuedSynchronizer.parkAndCheckInterrupt());
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node);
            throw runtimeException;
        }
        this.cancelAcquire(node);
        throw new InterruptedException();
    }

    private boolean doAcquireNanos(int n2, long l2) throws InterruptedException {
        long l3 = System.nanoTime();
        Node node = this.addWaiter(Node.EXCLUSIVE);
        try {
            while (true) {
                Node node2;
                if ((node2 = node.predecessor()) == this.head && this.tryAcquire(n2)) {
                    this.setHead(node);
                    node2.next = null;
                    return true;
                }
                if (l2 <= 0L) {
                    this.cancelAcquire(node);
                    return false;
                }
                if (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node)) continue;
                LockSupport.parkNanos(l2);
                if (!Thread.interrupted()) {
                    long l4 = System.nanoTime();
                    l2 -= l4 - l3;
                    l3 = l4;
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node);
            throw runtimeException;
        }
        this.cancelAcquire(node);
        throw new InterruptedException();
    }

    private void doAcquireShared(int n2) {
        Node node = this.addWaiter(Node.SHARED);
        try {
            boolean bl2 = false;
            while (true) {
                int n3;
                Node node2;
                if ((node2 = node.predecessor()) == this.head && (n3 = this.tryAcquireShared(n2)) >= 0) {
                    this.setHeadAndPropagate(node, n3);
                    node2.next = null;
                    if (bl2) {
                        AbstractQueuedSynchronizer.selfInterrupt();
                    }
                    return;
                }
                if (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !AbstractQueuedSynchronizer.parkAndCheckInterrupt()) continue;
                bl2 = true;
            }
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node);
            throw runtimeException;
        }
    }

    private void doAcquireSharedInterruptibly(int n2) throws InterruptedException {
        Node node = this.addWaiter(Node.SHARED);
        try {
            Node node2;
            do {
                int n3;
                if ((node2 = node.predecessor()) != this.head || (n3 = this.tryAcquireShared(n2)) < 0) continue;
                this.setHeadAndPropagate(node, n3);
                node2.next = null;
                return;
            } while (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !AbstractQueuedSynchronizer.parkAndCheckInterrupt());
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node);
            throw runtimeException;
        }
        this.cancelAcquire(node);
        throw new InterruptedException();
    }

    private boolean doAcquireSharedNanos(int n2, long l2) throws InterruptedException {
        long l3 = System.nanoTime();
        Node node = this.addWaiter(Node.SHARED);
        try {
            while (true) {
                int n3;
                Node node2;
                if ((node2 = node.predecessor()) == this.head && (n3 = this.tryAcquireShared(n2)) >= 0) {
                    this.setHeadAndPropagate(node, n3);
                    node2.next = null;
                    return true;
                }
                if (l2 <= 0L) {
                    this.cancelAcquire(node);
                    return false;
                }
                if (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node)) continue;
                LockSupport.parkNanos(l2);
                if (!Thread.interrupted()) {
                    long l4 = System.nanoTime();
                    l2 -= l4 - l3;
                    l3 = l4;
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node);
            throw runtimeException;
        }
        this.cancelAcquire(node);
        throw new InterruptedException();
    }

    protected boolean tryAcquire(int n2) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryRelease(int n2) {
        throw new UnsupportedOperationException();
    }

    protected int tryAcquireShared(int n2) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryReleaseShared(int n2) {
        throw new UnsupportedOperationException();
    }

    protected boolean isHeldExclusively() {
        throw new UnsupportedOperationException();
    }

    public final void acquire(int n2) {
        if (!this.tryAcquire(n2) && this.acquireQueued(this.addWaiter(Node.EXCLUSIVE), n2)) {
            AbstractQueuedSynchronizer.selfInterrupt();
        }
    }

    public final void acquireInterruptibly(int n2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.tryAcquire(n2)) {
            this.doAcquireInterruptibly(n2);
        }
    }

    public final boolean tryAcquireNanos(int n2, long l2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryAcquire(n2) || this.doAcquireNanos(n2, l2);
    }

    public final boolean release(int n2) {
        if (this.tryRelease(n2)) {
            Node node = this.head;
            if (node != null && node.waitStatus != 0) {
                this.unparkSuccessor(node);
            }
            return true;
        }
        return false;
    }

    public final void acquireShared(int n2) {
        if (this.tryAcquireShared(n2) < 0) {
            this.doAcquireShared(n2);
        }
    }

    public final void acquireSharedInterruptibly(int n2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.tryAcquireShared(n2) < 0) {
            this.doAcquireSharedInterruptibly(n2);
        }
    }

    public final boolean tryAcquireSharedNanos(int n2, long l2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryAcquireShared(n2) >= 0 || this.doAcquireSharedNanos(n2, l2);
    }

    public final boolean releaseShared(int n2) {
        if (this.tryReleaseShared(n2)) {
            Node node = this.head;
            if (node != null && node.waitStatus != 0) {
                this.unparkSuccessor(node);
            }
            return true;
        }
        return false;
    }

    public final boolean hasQueuedThreads() {
        return this.head != this.tail;
    }

    public final boolean hasContended() {
        return this.head != null;
    }

    public final Thread getFirstQueuedThread() {
        return this.head == this.tail ? null : this.fullGetFirstQueuedThread();
    }

    private Thread fullGetFirstQueuedThread() {
        Object object;
        while (true) {
            Object object2;
            Node node;
            if ((node = this.head) == null) {
                return null;
            }
            Node node2 = node.next;
            if (node2 != null) {
                object2 = node2.thread;
                object = node2.prev;
                if (object2 != null && object == this.head) {
                    return object2;
                }
            }
            if ((object2 = this.tail) == node) {
                return null;
            }
            if (object2 == null) continue;
            object = ((Node)object2).thread;
            Node node3 = ((Node)object2).prev;
            if (object != null && node3 == this.head) break;
        }
        return object;
    }

    public final boolean isQueued(Thread thread) {
        if (thread == null) {
            throw new NullPointerException();
        }
        Node node = this.tail;
        while (node != null) {
            if (node.thread == thread) {
                return true;
            }
            node = node.prev;
        }
        return false;
    }

    public final int getQueueLength() {
        int n2 = 0;
        Node node = this.tail;
        while (node != null) {
            if (node.thread != null) {
                ++n2;
            }
            node = node.prev;
        }
        return n2;
    }

    public final Collection<Thread> getQueuedThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node = this.tail;
        while (node != null) {
            Thread thread = node.thread;
            if (thread != null) {
                arrayList.add(thread);
            }
            node = node.prev;
        }
        return arrayList;
    }

    public final Collection<Thread> getExclusiveQueuedThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node = this.tail;
        while (node != null) {
            Thread thread;
            if (!node.isShared() && (thread = node.thread) != null) {
                arrayList.add(thread);
            }
            node = node.prev;
        }
        return arrayList;
    }

    public final Collection<Thread> getSharedQueuedThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node = this.tail;
        while (node != null) {
            Thread thread;
            if (node.isShared() && (thread = node.thread) != null) {
                arrayList.add(thread);
            }
            node = node.prev;
        }
        return arrayList;
    }

    public String toString() {
        int n2 = this.getState();
        String string = this.hasQueuedThreads() ? "non" : "";
        return super.toString() + "[State = " + n2 + ", " + string + "empty queue]";
    }

    final boolean isOnSyncQueue(Node node) {
        if (node.waitStatus == -2 || node.prev == null) {
            return false;
        }
        if (node.next != null) {
            return true;
        }
        return this.findNodeFromTail(node);
    }

    private boolean findNodeFromTail(Node node) {
        Node node2 = this.tail;
        while (node2 != node) {
            if (node2 == null) {
                return false;
            }
            node2 = node2.prev;
        }
        return true;
    }

    final boolean transferForSignal(Node node) {
        if (!AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, -2, 0)) {
            return false;
        }
        Node node2 = this.enq(node);
        int n2 = node2.waitStatus;
        if (n2 > 0 || !AbstractQueuedSynchronizer.compareAndSetWaitStatus(node2, n2, -1)) {
            LockSupport.unpark(node.thread);
        }
        return true;
    }

    final boolean transferAfterCancelledWait(Node node) {
        if (AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, -2, 0)) {
            this.enq(node);
            return true;
        }
        while (!this.isOnSyncQueue(node)) {
            Thread.yield();
        }
        return false;
    }

    final int fullyRelease(Node node) {
        try {
            int n2 = this.getState();
            if (this.release(n2)) {
                return n2;
            }
        }
        catch (RuntimeException runtimeException) {
            node.waitStatus = 1;
            throw runtimeException;
        }
        node.waitStatus = 1;
        throw new IllegalMonitorStateException();
    }

    public final boolean owns(ConditionObject conditionObject) {
        if (conditionObject == null) {
            throw new NullPointerException();
        }
        return conditionObject.isOwnedBy(this);
    }

    public final boolean hasWaiters(ConditionObject conditionObject) {
        if (!this.owns(conditionObject)) {
            throw new IllegalArgumentException("Not owner");
        }
        return conditionObject.hasWaiters();
    }

    public final int getWaitQueueLength(ConditionObject conditionObject) {
        if (!this.owns(conditionObject)) {
            throw new IllegalArgumentException("Not owner");
        }
        return conditionObject.getWaitQueueLength();
    }

    public final Collection<Thread> getWaitingThreads(ConditionObject conditionObject) {
        if (!this.owns(conditionObject)) {
            throw new IllegalArgumentException("Not owner");
        }
        return conditionObject.getWaitingThreads();
    }

    private final boolean compareAndSetHead(Node node) {
        return unsafe.compareAndSwapObject(this, headOffset, null, node);
    }

    private final boolean compareAndSetTail(Node node, Node node2) {
        return unsafe.compareAndSwapObject(this, tailOffset, node, node2);
    }

    private static final boolean compareAndSetWaitStatus(Node node, int n2, int n3) {
        return unsafe.compareAndSwapInt(node, waitStatusOffset, n2, n3);
    }

    static {
        try {
            stateOffset = unsafe.objectFieldOffset(AbstractQueuedSynchronizer.class.getDeclaredField("state"));
            headOffset = unsafe.objectFieldOffset(AbstractQueuedSynchronizer.class.getDeclaredField("head"));
            tailOffset = unsafe.objectFieldOffset(AbstractQueuedSynchronizer.class.getDeclaredField("tail"));
            waitStatusOffset = unsafe.objectFieldOffset(Node.class.getDeclaredField("waitStatus"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConditionObject
    implements Condition,
    Serializable {
        private static final long serialVersionUID = 1173984872572414699L;
        private transient Node firstWaiter;
        private transient Node lastWaiter;
        private static final int REINTERRUPT = 1;
        private static final int THROW_IE = -1;

        private Node addConditionWaiter() {
            Node node = new Node(Thread.currentThread(), -2);
            Node node2 = this.lastWaiter;
            if (node2 == null) {
                this.firstWaiter = node;
            } else {
                node2.nextWaiter = node;
            }
            this.lastWaiter = node;
            return node;
        }

        private void doSignal(Node node) {
            do {
                if ((this.firstWaiter = node.nextWaiter) == null) {
                    this.lastWaiter = null;
                }
                node.nextWaiter = null;
            } while (!AbstractQueuedSynchronizer.this.transferForSignal(node) && (node = this.firstWaiter) != null);
        }

        private void doSignalAll(Node node) {
            Node node2;
            this.firstWaiter = null;
            this.lastWaiter = null;
            do {
                node2 = node.nextWaiter;
                node.nextWaiter = null;
                AbstractQueuedSynchronizer.this.transferForSignal(node);
            } while ((node = node2) != null);
        }

        @Override
        public final void signal() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node node = this.firstWaiter;
            if (node != null) {
                this.doSignal(node);
            }
        }

        @Override
        public final void signalAll() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node node = this.firstWaiter;
            if (node != null) {
                this.doSignalAll(node);
            }
        }

        @Override
        public final void awaitUninterruptibly() {
            Node node = this.addConditionWaiter();
            int n2 = AbstractQueuedSynchronizer.this.fullyRelease(node);
            boolean bl2 = false;
            while (!AbstractQueuedSynchronizer.this.isOnSyncQueue(node)) {
                LockSupport.park();
                if (!Thread.interrupted()) continue;
                bl2 = true;
            }
            if (AbstractQueuedSynchronizer.this.acquireQueued(node, n2) || bl2) {
                AbstractQueuedSynchronizer.selfInterrupt();
            }
        }

        private int checkInterruptWhileWaiting(Node node) {
            return Thread.interrupted() ? (AbstractQueuedSynchronizer.this.transferAfterCancelledWait(node) ? -1 : 1) : 0;
        }

        private void reportInterruptAfterWait(int n2) throws InterruptedException {
            if (n2 == -1) {
                throw new InterruptedException();
            }
            if (n2 == 1) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public final void await() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node = this.addConditionWaiter();
            int n2 = AbstractQueuedSynchronizer.this.fullyRelease(node);
            int n3 = 0;
            while (!AbstractQueuedSynchronizer.this.isOnSyncQueue(node)) {
                LockSupport.park();
                n3 = this.checkInterruptWhileWaiting(node);
                if (n3 == 0) continue;
            }
            if (AbstractQueuedSynchronizer.this.acquireQueued(node, n2) && n3 != -1) {
                n3 = 1;
            }
            if (n3 != 0) {
                this.reportInterruptAfterWait(n3);
            }
        }

        @Override
        public final long awaitNanos(long l2) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node = this.addConditionWaiter();
            int n2 = AbstractQueuedSynchronizer.this.fullyRelease(node);
            long l3 = System.nanoTime();
            int n3 = 0;
            while (!AbstractQueuedSynchronizer.this.isOnSyncQueue(node)) {
                if (l2 <= 0L) {
                    AbstractQueuedSynchronizer.this.transferAfterCancelledWait(node);
                    break;
                }
                LockSupport.parkNanos(l2);
                n3 = this.checkInterruptWhileWaiting(node);
                if (n3 != 0) break;
                long l4 = System.nanoTime();
                l2 -= l4 - l3;
                l3 = l4;
            }
            if (AbstractQueuedSynchronizer.this.acquireQueued(node, n2) && n3 != -1) {
                n3 = 1;
            }
            if (n3 != 0) {
                this.reportInterruptAfterWait(n3);
            }
            return l2 - (System.nanoTime() - l3);
        }

        @Override
        public final boolean awaitUntil(Date date) throws InterruptedException {
            if (date == null) {
                throw new NullPointerException();
            }
            long l2 = date.getTime();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node = this.addConditionWaiter();
            int n2 = AbstractQueuedSynchronizer.this.fullyRelease(node);
            boolean bl2 = false;
            int n3 = 0;
            while (!AbstractQueuedSynchronizer.this.isOnSyncQueue(node)) {
                if (System.currentTimeMillis() > l2) {
                    bl2 = AbstractQueuedSynchronizer.this.transferAfterCancelledWait(node);
                    break;
                }
                LockSupport.parkUntil(l2);
                n3 = this.checkInterruptWhileWaiting(node);
                if (n3 == 0) continue;
            }
            if (AbstractQueuedSynchronizer.this.acquireQueued(node, n2) && n3 != -1) {
                n3 = 1;
            }
            if (n3 != 0) {
                this.reportInterruptAfterWait(n3);
            }
            return !bl2;
        }

        @Override
        public final boolean await(long l2, TimeUnit timeUnit) throws InterruptedException {
            if (timeUnit == null) {
                throw new NullPointerException();
            }
            long l3 = timeUnit.toNanos(l2);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node = this.addConditionWaiter();
            int n2 = AbstractQueuedSynchronizer.this.fullyRelease(node);
            long l4 = System.nanoTime();
            boolean bl2 = false;
            int n3 = 0;
            while (!AbstractQueuedSynchronizer.this.isOnSyncQueue(node)) {
                if (l3 <= 0L) {
                    bl2 = AbstractQueuedSynchronizer.this.transferAfterCancelledWait(node);
                    break;
                }
                LockSupport.parkNanos(l3);
                n3 = this.checkInterruptWhileWaiting(node);
                if (n3 != 0) break;
                long l5 = System.nanoTime();
                l3 -= l5 - l4;
                l4 = l5;
            }
            if (AbstractQueuedSynchronizer.this.acquireQueued(node, n2) && n3 != -1) {
                n3 = 1;
            }
            if (n3 != 0) {
                this.reportInterruptAfterWait(n3);
            }
            return !bl2;
        }

        final boolean isOwnedBy(AbstractQueuedSynchronizer abstractQueuedSynchronizer) {
            return abstractQueuedSynchronizer == AbstractQueuedSynchronizer.this;
        }

        protected final boolean hasWaiters() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node node = this.firstWaiter;
            while (node != null) {
                if (node.waitStatus == -2) {
                    return true;
                }
                node = node.nextWaiter;
            }
            return false;
        }

        protected final int getWaitQueueLength() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            int n2 = 0;
            Node node = this.firstWaiter;
            while (node != null) {
                if (node.waitStatus == -2) {
                    ++n2;
                }
                node = node.nextWaiter;
            }
            return n2;
        }

        protected final Collection<Thread> getWaitingThreads() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            ArrayList<Thread> arrayList = new ArrayList<Thread>();
            Node node = this.firstWaiter;
            while (node != null) {
                Thread thread;
                if (node.waitStatus == -2 && (thread = node.thread) != null) {
                    arrayList.add(thread);
                }
                node = node.nextWaiter;
            }
            return arrayList;
        }
    }

    static final class Node {
        static final int CANCELLED = 1;
        static final int SIGNAL = -1;
        static final int CONDITION = -2;
        static final Node SHARED = new Node();
        static final Node EXCLUSIVE = null;
        volatile int waitStatus;
        volatile Node prev;
        volatile Node next;
        volatile Thread thread;
        Node nextWaiter;

        final boolean isShared() {
            return this.nextWaiter == SHARED;
        }

        final Node predecessor() throws NullPointerException {
            Node node = this.prev;
            if (node == null) {
                throw new NullPointerException();
            }
            return node;
        }

        Node() {
        }

        Node(Thread thread, Node node) {
            this.nextWaiter = node;
            this.thread = thread;
        }

        Node(Thread thread, int n2) {
            this.waitStatus = n2;
            this.thread = thread;
        }
    }
}

