/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.GraphicsConfiguration;
import java.awt.image.ColorModel;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11SurfaceData;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.VolatileSurfaceManager;
import sun.java2d.SurfaceData;

public class X11VolatileSurfaceManager
extends VolatileSurfaceManager {
    private boolean accelerationEnabled;

    public X11VolatileSurfaceManager(SunVolatileImage sunVolatileImage, Object object) {
        super(sunVolatileImage, object);
        boolean bl2 = this.accelerationEnabled = X11SurfaceData.isAccelerationEnabled() && sunVolatileImage.getTransparency() == 1;
        if (object != null && !this.accelerationEnabled) {
            this.sdCurrent = this.sdAccel = this.initAcceleratedSurface();
            if (this.sdBackup != null) {
                this.sdBackup = null;
            }
        }
    }

    protected boolean isAccelerationEnabled() {
        return this.accelerationEnabled;
    }

    protected SurfaceData initAcceleratedSurface() {
        X11SurfaceData.X11PixmapSurfaceData x11PixmapSurfaceData;
        try {
            X11GraphicsConfig x11GraphicsConfig = (X11GraphicsConfig)this.vImg.getGraphicsConfig();
            ColorModel colorModel = x11GraphicsConfig.getColorModel();
            long l2 = 0L;
            if (this.context instanceof Long) {
                l2 = (Long)this.context;
            }
            x11PixmapSurfaceData = X11SurfaceData.createData(x11GraphicsConfig, this.vImg.getWidth(), this.vImg.getHeight(), colorModel, this.vImg, l2, 0);
        }
        catch (NullPointerException nullPointerException) {
            x11PixmapSurfaceData = null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            x11PixmapSurfaceData = null;
        }
        return x11PixmapSurfaceData;
    }

    protected boolean isConfigValid(GraphicsConfiguration graphicsConfiguration) {
        return graphicsConfiguration == null || graphicsConfiguration == this.vImg.getGraphicsConfig();
    }
}

