/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.PKIXExtensions;

public class SubjectKeyIdentifierExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.SubjectKeyIdentifier";
    public static final String NAME = "SubjectKeyIdentifier";
    public static final String KEY_ID = "key_id";
    private KeyIdentifier id = null;

    private void encodeThis() throws IOException {
        if (this.id == null) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        this.id.encode(derOutputStream);
        this.extensionValue = derOutputStream.toByteArray();
    }

    public SubjectKeyIdentifierExtension(byte[] byArray) throws IOException {
        this.id = new KeyIdentifier(byArray);
        this.extensionId = PKIXExtensions.SubjectKey_Id;
        this.critical = false;
        this.encodeThis();
    }

    public SubjectKeyIdentifierExtension(Boolean bl2, Object object) throws IOException {
        this.extensionId = PKIXExtensions.SubjectKey_Id;
        this.critical = bl2;
        this.extensionValue = (byte[])object;
        DerValue derValue = new DerValue(this.extensionValue);
        this.id = new KeyIdentifier(derValue);
    }

    public String toString() {
        return super.toString() + "SubjectKeyIdentifier [\n" + String.valueOf(this.id) + "]\n";
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.SubjectKey_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(KEY_ID)) {
            if (!(object instanceof KeyIdentifier)) {
                throw new IOException("Attribute value should be of type KeyIdentifier.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:SubjectKeyIdentifierExtension.");
        }
        this.id = (KeyIdentifier)object;
        this.encodeThis();
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(KEY_ID)) {
            return this.id;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:SubjectKeyIdentifierExtension.");
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(KEY_ID)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:SubjectKeyIdentifierExtension.");
        }
        this.id = null;
        this.encodeThis();
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(KEY_ID);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }
}

